/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtIntervalId
 *   XtAppAddTimeOut()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(1, 1);
	exit(0);
}

char *client_stuff = "once upon a time";

void XtTMO_Proc2(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(1, 1);
	tet_infoline("TEST: client_data passed to procedure");
	if (client_data == NULL) {
		tet_infoline("ERROR: client_data is NULL");
		tet_result(TET_FAIL);
		exit(0);
	}
	if (strcmp((char *)client_data, client_stuff) != 0) {
		sprintf(ebuf, "ERROR: expected client_data of \"%s\", is\"%s\"", client_stuff, client_data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}
void XtTMO_Proc3(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	avs_set_event(2, 1);
	exit(0);
}
void XtTMO_Proc4(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT+2, XtTMO_Proc3, topLevel);
	avs_set_event(1, avs_get_event(1)+1);
}


#define T_XtAppAddTimeOut	1
char    *TestName = "XtAppAddTimeOut";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

pid_t pid2;
int status = 0;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppAddTimeOut-1.(A)");
	report_assertion("A successful call to XtIntervalId");
	report_assertion("XtAppAddTimeOut(app_context, interval, proc, client_data)");
	report_assertion("shall register proc as the procedure that will be called for");
	report_assertion("the application context app_context when the next call to");
	report_assertion("XtAppNextEvent is made after interval milliseconds have");
	report_assertion("elapsed.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapatmout1", "XtAppAddTimeOut");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("TEST: Timeout procedure is invoked");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(1, status, "XtTMO_Proc invoked status");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11378 */
/* End of included file Mdefcode.tmc.11378 */

static void t002(){

pid_t pid2;
int status = 0;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppAddTimeOut-2.(A)");
	report_assertion("The timeout registered by a call to XtIntervalId");
	report_assertion("XtAppAddTimeOut(app_context, interval, proc, client_data)");
	report_assertion("shall be removed after the first invocation of the timeout");
	report_assertion("procedure.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapatmout1", "XtAppAddTimeOut");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc4, topLevel);
	tet_infoline("TEST: Timeout procedure is invoked only once");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(1, status, "timeout procedure invocation count");
	status = avs_get_event(2);
	check_dec(1, status, "second timeout procedure invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11378 */
/* End of included file Mdefcode.tmc.11378 */

static void t003(){

pid_t pid2;
int status = 0;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppAddTimeOut-3.(A)");
	report_assertion("A successful call to XtIntervalId");
	report_assertion("XtAppAddTimeOut(app_context, interval, proc, client_data)");
	report_assertion("shall cause client_data to be passed to proc when it is");
	report_assertion("invoked.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tapatmout1", "XtAppAddTimeOut");
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("PREP: Register timeout procedure");
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc2, client_stuff);
	tet_infoline("TEST: Timeout procedure is invoked");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	status = avs_get_event(1);
	check_dec(1, status, "XtTMO_Proc2 invocation count");
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11378 */
/* End of included file Mdefcode.tmc.11378 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
