/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Status
 *   XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return)
 *   Display *display;
 *   Colormap colormap;
 *   Bool contig;
 *   unsigned long *pixels_return;
 *   int ncolors;
 *   int nreds;
 *   int ngreens;
 *   int nblues;
 *   unsigned long *rmask_return;
 *   unsigned long *gmask_return;
 *   unsigned long *bmask_return;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XAllocColorPlanes	1
char    *TestName = "XAllocColorPlanes";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_COLORMAP colormap


/*
 * Arguments to the XAllocColorPlanes function
 */
static Display *display;
static Colormap colormap;
static Bool contig;
static unsigned long *pixels_return;
static int ncolors;
static int nreds;
static int ngreens;
static int nblues;
static unsigned long *rmask_return;
static unsigned long *gmask_return;
static unsigned long *bmask_return;


static int 	StatusReturn;

static unsigned long dummy;

static int contiguous(mask)
unsigned long mask;
{
	if(!mask)
		return(0L);

	while((mask&1) == 0L)
		mask>>=1;
	mask++;
	return( bitcount(mask) == 1);
}

static int maskshift(mask)
unsigned long mask;
{
	int	i = 0;

	if(!mask)
		return(0);

	while((mask&1) == 0L) {
		mask>>=1;
		i++;
	}
	return(i);
}



/* Value list for use in test t007 */
static int 	contigvallist[] = {
	True,
	False,
};


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	colormap = DefaultColormap(display, DefaultScreen(display));
	contig = 0;
	pixels_return = &dummy;
	ncolors = 1;
	nreds = 0;
	ngreens = 0;
	nblues = 0;
	rmask_return = &dummy;
	gmask_return = &dummy;
	bmask_return = &dummy;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

XVisualInfo	*vp;
unsigned long	vmask = (1<<DirectColor);
unsigned long	rm, gm, bm, pm, rgbmask, pixel, r, g, b;
XColor 		color, qcolor;
Status		status;
int		cells;
int		rshift, gshift, bshift;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XAllocColorPlanes-1.(A)");
	report_assertion("A call to XAllocColorPlanes allocates");
	report_assertion("ncolors*2pow(nreds+ngreens+nblues) read/write colourmap");
	report_assertion("entries whose indices in the colourmap are obtained by ORing");
	report_assertion("each pixel value returned in the pixels_return argument with");
	report_assertion("zero or more of the planes obtained by ORing the masks");
	report_assertion("returned in the rmask_return, gmask_return and bmask_return");
	report_assertion("arguments.");

	report_strategy("For visual class DirectColor:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Allocate one colour and all planes with XAllocColorPlanes.");
	report_strategy("  Verify that the function did not return zero.");
	report_strategy("  Verify the correct number of cells have been allocated by initialising");
	report_strategy("    them with XStoreColors, and reading them with XQueryColors.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		tet_result(TET_UNSUPPORTED);
		return;
	}

	resetsupvis(vmask);
	nextsupvis(&vp);
		
	colormap = makecolmap(display, vp->visual, AllocNone);
	ncolors = 1;
	nreds = bitcount(vp->red_mask);
	ngreens = bitcount(vp->green_mask);
	nblues = bitcount(vp->blue_mask);
	cells = ncolors * (1 << (nreds+ngreens+nblues));
	contig = False;
	pixels_return = &pm;
	rmask_return = &rm;
	gmask_return = &gm;
	bmask_return = &bm;

	startcall(display);
	if (isdeleted())
		return;
	status = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status == (Status) 0) {
		report("%s failed to return non-zero", TestName);
		FAIL;
	} else {
		trace("%d cells allocated in the colormap", cells);
		CHECK;
	}

	rgbmask = rm | gm | bm ;
	rshift = maskshift(rm);
	gshift = maskshift(gm);
	bshift = maskshift(bm);
	trace("rgbmask is %x", rgbmask);
	trace("red shift is %d", rshift);
	trace("green shift is %d", gshift);
	trace("blue shift is %d", bshift);

	/* 
	 * The following code works on the assumption that for each subfield, 
	 * all planes in the subfield mask are allocated (so are contiguous).
	 *
	 * (It does not assume the subfields are adjacent)
	 */

	for(r = 0; r<(1<<nreds); r++) {
		pixel = (r<<rshift) | pm;
		debug(1, "pixel value %x", pixel);
		color.pixel = pixel;
		color.flags =DoRed;
		color.red = 0xffff;

		startcall(display);
		XStoreColor(display, colormap, &color);
		endcall(display);

		if(geterr() != Success) {
			report("XStoreColor() failed with pixel value %lu", pixel);
			FAIL;
		} else {
			qcolor.pixel = pixel;
			startcall(display);
			XQueryColor(display, colormap, &qcolor);
			endcall(display);
		if(geterr() != Success) {
			report("XQueryColor() failed with pixel value %lu", pixel);
			FAIL;
		} else
			CHECK;
		}
	}

	for(g = 0; g<(1<<ngreens); g++) {
		pixel = (g<<gshift) | pm;
		debug(1, "pixel value %x", pixel);
		color.pixel = pixel;
		color.flags =DoGreen;
		color.green = 0xffff;

		startcall(display);
		XStoreColor(display, colormap, &color);
		endcall(display);

		if(geterr() != Success) {
			report("XStoreColor() failed with pixel value %lu", pixel);
			FAIL;
		} else {
			qcolor.pixel = pixel;
			startcall(display);
			XQueryColor(display, colormap, &qcolor);
			endcall(display);
			if(geterr() != Success) {
				report("XQueryColor() failed with pixel value %lu", pixel);
				FAIL;
			} else
				CHECK;
		}
	}

	for(b = 0; b<(1<<nblues); b++) {
		pixel = (b<<bshift) | pm;
		debug(1, "pixel value %x", pixel);
		color.pixel = pixel;
		color.flags =DoBlue;
		color.blue = 0xffff;

		startcall(display);
		XStoreColor(display, colormap, &color);
		endcall(display);

		if(geterr() != Success) {
			report("XStoreColor() failed with pixel value %lu", pixel);
			FAIL;
		} else {
			qcolor.pixel = pixel;
			startcall(display);
			XQueryColor(display, colormap, &qcolor);
			endcall(display);
			if(geterr() != Success) {
				report("XQueryColor() failed with pixel value %lu", pixel);
				FAIL;
			} else
				CHECK;
		}
	}

	CHECKPASS(1 + (1<<nreds) + (1<<ngreens) + (1<<nblues));
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

XVisualInfo	*vp;
unsigned long	vmask = (1<<DirectColor);
unsigned long	rm, gm, bm, pm, rgbmask;
unsigned long	pm_array[3], i;
Status		status;
int		cells, rnreds, rngreens, rnblues;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XAllocColorPlanes-2.(A)");
	report_assertion("A call to XAllocColorPlanes sets nreds bits to one in the");
	report_assertion("mask named by rmask_return, ngreens bits to one in the mask");
	report_assertion("named by gmask_return, and nblues bits to one in the mask");
	report_assertion("named by bmask_return and returns ncolors pixels values in");
	report_assertion("the pixels_return argument such that no mask has a bit set");
	report_assertion("in common with any other mask or with any of the pixels.");

	report_strategy("For the visual class DirectColor:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Allocate one colour and all planes with XAllocColorPlanes.");
	report_strategy("  Verify the bitcount of the OR of the colourplane masks equals the ");
	report_strategy("    sum of the individual bitcounts.");
	report_strategy("  Verify that the AND of the pixel and the OR of the colourplane masks is zero.");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Allocate 3 colours and 3 planes with XAllocColorPlanes.");
	report_strategy("  Verify the bitcount of the OR of the colourplane masks equals the ");
	report_strategy("    sum of the individual bitcounts.");
	report_strategy("  Verify that the AND of each pixel and the OR of the colourplane masks is zero.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		tet_result(TET_UNSUPPORTED);
		return;
	}

	resetsupvis(vmask);
	nextsupvis(&vp);
		
	colormap = makecolmap(display, vp->visual, AllocNone);
	ncolors = 1;
	nreds = bitcount(vp->red_mask);
	ngreens = bitcount(vp->green_mask);
	nblues = bitcount(vp->blue_mask);
	cells = ncolors * (1 << (nreds+ngreens+nblues));
	contig = False;
	pixels_return = &pm;
	rmask_return = &rm;
	gmask_return = &gm;
	bmask_return = &bm;

	startcall(display);
	if (isdeleted())
		return;
	status = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status == (Status) 0) {
		report("%s failed to return non-zero", TestName);
		FAIL;
	} else {
		trace("%d cells allocated in the colormap", cells);
		CHECK;
	}

	rnreds = bitcount(rm);
	rngreens = bitcount(gm);
	rnblues = bitcount(bm);

	if( (rnreds != nreds) || (rngreens != ngreens) || (rnblues != nblues) ) {
		report("Request for %d reds %d greens %d blues returned %d reds %d greens %d blues.",
			  nreds, ngreens, nblues, rnreds, rngreens, rnblues);
		FAIL;
	} else
		CHECK;

	rgbmask = rm | gm | bm ;
	
	if( bitcount(rgbmask) != rnreds + rnblues + rngreens) {
		report("The returned colourplane  masks had at least one shared bit.");
		FAIL;
	} else
		CHECK;

	if( (rgbmask & pm) != 0L) {
		report("A pixel shared at least one bit with a colourplane.");
		FAIL;
	} else
		CHECK;

	/*
	 * Repeat requesting a number of colours and fewer planes.
	 */
	colormap = makecolmap(display, vp->visual, AllocNone);

	ncolors = 3;
	/* Make sure that this visual is big enough to support so many colours */
	if (ncolors > bitcount(vp->blue_mask))
		ncolors = bitcount(vp->blue_mask);
	if (ncolors > bitcount(vp->green_mask))
		ncolors = bitcount(vp->green_mask);
	if (ncolors > bitcount(vp->red_mask))
		ncolors = bitcount(vp->red_mask);
	debug(1, "ncolors = %d", ncolors);

	nreds = 1;
	ngreens = 1;
	nblues = 1;
	cells = ncolors * (1 << (nreds+ngreens+nblues));
	contig = False;
	pixels_return = &pm_array[0];
	rmask_return = &rm;
	gmask_return = &gm;
	bmask_return = &bm;

	startcall(display);
	if (isdeleted())
		return;
	status = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status == (Status) 0) {
		report("%s failed to return non-zero", TestName);
		FAIL;
	} else {
		trace("%d cells allocated in the colormap", cells);
		CHECK;
	}

	rnreds = bitcount(rm);
	rngreens = bitcount(gm);
	rnblues = bitcount(bm);

	if( (rnreds != nreds) || (rngreens != ngreens) || (rnblues != nblues) ) {
		report("Request for %d reds %d greens %d blues returned %d reds %d greens %d blues.",
			  nreds, ngreens, nblues, rnreds, rngreens, rnblues);
		FAIL;
	} else
		CHECK;

	rgbmask = rm | gm | bm ;
	
	if( bitcount(rgbmask) != rnreds + rnblues + rngreens) {
		report("The returned colourplane  masks had at least one shared bit.");
		FAIL;
	} else
		CHECK;

	for (i = 0; i < ncolors; i++) {
		pm = pm_array[i];
		trace("pixel value of 0x%lx", pm);
		if( (rgbmask & pm) != 0L) {
			report("pixel value %ld shared at least one bit with a colourplane.", pm);
			FAIL;
		} else
			CHECK;
		if ((pm & ~DEPTHMASK(vp->depth)) != 0L) {
			report("pixel value 0x%lx contained bits outside the depth", pm);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(7+2*ncolors);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

XVisualInfo	*vp;
unsigned long	vmask = (1<<DirectColor);
unsigned long	rm, gm, bm, pm;
Status		status;
int		cells;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XAllocColorPlanes-3.(A)");
	report_assertion("If the visual class DirectColor is supported: When the");
	report_assertion("visual type of the colormap argument is DirectColor, then");
	report_assertion("rmask_return lies within the red pixel subfield and the");
	report_assertion("gmask_return lies within the green pixel subfield and the");
	report_assertion("bmask_return lies within the blue pixel subfield.");

	report_strategy("For the visual class DirectColor:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Allocate one colour and all planes with XAllocColorPlanes.");
	report_strategy("  Verify that the returned masks and the colour subfield masks are identical.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		tet_result(TET_UNSUPPORTED);
		return;
	}

	resetsupvis(vmask);
	nextsupvis(&vp);
		
	colormap = makecolmap(display, vp->visual, AllocNone);
	ncolors = 1;
	nreds = bitcount(vp->red_mask);
	ngreens = bitcount(vp->green_mask);
	nblues = bitcount(vp->blue_mask);
	cells = ncolors * (1 << (nreds+ngreens+nblues));
	contig = False;
	pixels_return = &pm;
	rmask_return = &rm;
	gmask_return = &gm;
	bmask_return = &bm;

	startcall(display);
	if (isdeleted())
		return;
	status = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status == (Status) 0) {
		report("%s failed to return non-zero", TestName);
		FAIL;
	} else {
		trace("%d cells allocated in the colormap", cells);
		CHECK;
	}

	/*
	 * We can check the mask returned matches the pixel subfield exactly
	 * since we requested all planes to be allocated.
	 */
	if( (vp->red_mask != rm) ) {
		report("Returned red mask not contained in red pixel subfield");
		FAIL;
	} else
		CHECK;
	if( (vp->green_mask != gm) ) {
		report("Returned green mask not contained in green pixel subfield");
		FAIL;
	} else
		CHECK;
	if( (vp->blue_mask != bm) ) {
		report("Returned blue mask not contained in blue pixel subfield");
		FAIL;
	} else
		CHECK;

	CHECKPASS(4);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo	*vp;
unsigned long	vmask = (1<<DirectColor);
unsigned long	rm, gm, bm, pm;
Status		status;
int		cells;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XAllocColorPlanes-4.(A)");
	report_assertion("When the contig argument is True, then rmask_return,");
	report_assertion("gmask_return and bmask_return each contains a contiguous set");
	report_assertion("of bits set to one.");

	report_strategy("For the visual class DirectColor:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Allocate one colour and some planes with XAllocColorPlanes and contig = True.");
	report_strategy("  Verify that the returned masks were contiguous.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		tet_result(TET_UNSUPPORTED);
		return;
	}

	resetsupvis(vmask);
	nextsupvis(&vp);
		
	colormap = makecolmap(display, vp->visual, AllocNone);
	ncolors = 1;
	nreds = bitcount(vp->red_mask);
	ngreens = bitcount(vp->green_mask);
	nblues = bitcount(vp->blue_mask);
	cells = ncolors * (1 << (nreds+ngreens+nblues));
	contig = True;
	pixels_return = &pm;
	rmask_return = &rm;
	gmask_return = &gm;
	bmask_return = &bm;

	/* 
	 * Just ask for a small number of planes if more was possible.
	 * Originally this test requested all planes - but of course this
	 * gave little scope for contig to make any difference.
	 */
	if(nreds > 2)
		nreds = 2;
	if(ngreens > 2)
		ngreens = 2;
	if(nblues > 2)
		nblues = 2;
	trace("test with %d reds %d greens %d blues", nreds, ngreens, nblues);

	startcall(display);
	if (isdeleted())
		return;
	status = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if(status == (Status) 0) {
		report("%s failed to return non-zero", TestName);
		FAIL;
	} else {
		trace("%d cells allocated in the colormap", cells);
		CHECK;
	}

	if((contiguous(rm) && contiguous(gm) && contiguous(bm)) == 0) {
		report("Returned colourplane masks were not contiguous");
		FAIL;
	} else
		CHECK;

	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/ECol.mc */
/* End of included file error/ECol.mc */

/* Including from file error/ECol.mc */
static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XAllocColorPlanes-5.(A)");
	report_assertion("When a colourmap argument does not name a valid colourmap,");
	report_assertion("then a BadColor error occurs.");

	report_strategy("Create a bad colourmap by creating and freeing a colourmap.");
	report_strategy("Call test function using bad colourmap as the colourmap argument.");
	report_strategy("Verify that a BadColor error occurs.");

	tpstartup();
	setargs();
	A_COLORMAP = badcolormap(A_DISPLAY, DRW(A_DISPLAY));
	startcall(display);
	if (isdeleted())
		return;
	StatusReturn = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
	endcall(display);
	if (StatusReturn != 0) {
		report("Status returned was %d", StatusReturn);
		FAIL;
	}
	if (geterr() != BadColor) {
		report("Got %s, Expecting BadColor", errorname(geterr()));
		FAIL;
	}
	if(geterr() == BadColor)
		PASS;
	else 
		FAIL;
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/ECol.mc */

static void t006(){

XVisualInfo *vp;
unsigned long vmask = (1<<DirectColor);
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XAllocColorPlanes-6.(A)");
	report_assertion("When the ncolors argument is zero, then a BadValue error");
	report_assertion("occurs.");

	report_strategy("For all supported visual classes:");
	report_strategy("  Create a colormap with alloc set to AllocNone.");
	report_strategy("  Call XAllocColorPlanes with ncolors = 0.");

	tpstartup();
	setargs();
	if( (vmask = visualsupported(display, vmask)) == 0L) {
		tet_result(TET_UNSUPPORTED);
		return;
	}

	for(resetsupvis(vmask); nextsupvis(&vp); ) {
		colormap = makecolmap(display, vp->visual, AllocNone);
		ncolors = 0;
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
		endcall(display);
		if (StatusReturn != 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}
		if(geterr() == BadValue)
			CHECK;
	}

	CHECKPASS(nsupvis());

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file Mval.tmc.7823 */
/* End of included file Mval.tmc.7823 */

/* Including from file error/EVal.mc */
static void t007(){

#undef	VALUE_ARG
#define	VALUE_ARG contig
#undef	VALUE_LIST
#define	VALUE_LIST contigvallist
#undef NOTMEMTYPE
#define NOTMEMTYPE 
#undef	NOTMEMBER
#define	NOTMEMBER notmember
int 	i;
int 	n;
NOTMEMTYPE
long	vals[NM_LEN];
int 	pass = 0, fail = 0;

 	report_purpose(7);

	report_assertion("Assertion XAllocColorPlanes-7.(A)");
	report_assertion("When the value of contig is other than True or False, then");
	report_assertion("a BadValue error occurs.");

	report_strategy("Obtain a sequence of values which are not in the list specified by VALUE_LIST.");
	report_strategy("For each value:");
	report_strategy("  Call test function with this value in the VALUE_ARG argument.");
	report_strategy("  Verify that a BadValue error occurs.");

	tpstartup();
	setargs();
	seterrdef();

	n = NOTMEMBER(VALUE_LIST, NELEM(VALUE_LIST), vals);

	for (i = 0; i < n; i++) {

		debug(1, "Trying arg of %d", vals[i]);

		VALUE_ARG = vals[i];
		startcall(display);
		if (isdeleted())
			return;
		StatusReturn = XAllocColorPlanes(display, colormap, contig, pixels_return, ncolors, nreds, ngreens, nblues, rmask_return, gmask_return, bmask_return);
		endcall(display);
		if (StatusReturn != 0) {
			report("Status returned was %d", StatusReturn);
			FAIL;
		}
		if (geterr() != BadValue) {
			report("Got %s, Expecting BadValue", errorname(geterr()));
			FAIL;
		}

		if (geterr() == BadValue)
			CHECK;
		else {
			trace("Value of %d did not give BadValue", vals[i]);
			FAIL;
		}
	}

	CHECKPASS(n);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EVal.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
