/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   Bool
 *   XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return)
 *   Display	*display;
 *   Window	src_w;
 *   Window	dest_w;
 *   int	src_x;
 *   int	src_y;
 *   int	*dest_x_return	;
 *   int	*dest_y_return	;
 *   Window	*child_return	;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XTranslateCoordinates	1
char    *TestName = "XTranslateCoordinates";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW src_w
#define A_DRAWABLE src_w
#define A_WINDOW2 dest_w
#define A_DRAWABLE2 dest_w


/*
 * Arguments to the XTranslateCoordinates function
 */
static Display	*display;
static Window	src_w;
static Window	dest_w;
static int	src_x;
static int	src_y;
static int	*dest_x_return	;
static int	*dest_y_return	;
static Window	*child_return	;


static	struct	area	c_ap;
static	int	dest_x;
static	int	dest_y;
static	Window	child;

void transinit()
{
	tpstartup();

/* struct area of the child window */
	c_ap.x = 50;
	c_ap.y = 60;
	c_ap.width = 20;
	c_ap.height= 17;

	dest_x = -1;
	dest_y = -1;
	child  = ~0;
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	src_w = 0;
	dest_w = 0;
	src_x = c_ap.x + 10;
	src_y = c_ap.y + 8;
	dest_x_return = &dest_x;
	dest_y_return = &dest_y;
	child_return = &child;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	src_w = ErrdefWindow;
	dest_w = ErrdefWindow;
}

static void t001(){

Bool	ret;
int	exp_x, exp_y;
int	border_width;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XTranslateCoordinates-1.(A)");
	report_assertion("A call to XTranslateCoordinates takes the src_x and src_y");
	report_assertion("coordinates relative to the source window's origin and");
	report_assertion("converts them to be relative to the destination window's");
	report_assertion("origin and returns these translated coordinates in");
	report_assertion("dest_x_return and dest_y_return.");

	report_strategy("For some values of border_width:");
	report_strategy("	Create a window to be the source window.");
	report_strategy("	Create a child window to be the destination window.");
	report_strategy("	Map both windows.");
	report_strategy("	Translate coordinates of the parent window to the child using XTranslateCoordinates.");
	report_strategy("	Verify the returned coordinates were as expected.");

	transinit();
	setargs();
/* Set up child window position coordinates */

	for(border_width = 0; border_width < 5; border_width++) {
		src_w = defdraw(display, VI_WIN);
		XMapWindow(display, src_w);

	/* Child window: visual = CopyFromParent, and is mapped */
		dest_w = crechild(display, src_w, &c_ap);
		XSetWindowBorderWidth(display, dest_w, border_width);
		XSetWindowBorder(display, dest_w, W_FG);
		XMapWindow(display, dest_w);

/* Calculate expected return values */
		exp_x = src_x - c_ap.x - border_width;
		exp_y = src_y - c_ap.y - border_width;

		startcall(display);
		if (isdeleted())
			return;
		ret = XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (ret == False)
		{
			report("%s returned False when expecting True.",
				TestName);
			report("src_x=%d", src_x); delete("src_y=%d", src_y);
			report("exp_x=%d", exp_x); delete("exp_y=%d", exp_y);
			report("border_width=%d", border_width);
			FAIL;
		} else
		if ((dest_x != exp_x) || (dest_y != exp_y)) {
			report("%s did not return expected coordinates",
				TestName);
			report("Expected: (*dest_x_return)=%d, (*dest_y_return)=%d",
				exp_x, exp_y);
			report("Got: (*dest_x_return)=%d, (*dest_y_return)=%d",
				dest_x, dest_y);
			if( (dest_x == -1) || (dest_y == -1) )
				report("(*dest_x_return) and (*dest_y_return) were probably not set");

			FAIL;
		} else
			CHECK;

	}

	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int	ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XTranslateCoordinates-2.(C)");
	report_assertion("When src_w and dest_w were not created on the same screen,");
	report_assertion("then a call to XTranslateCoordinates returns zero and");
	report_assertion("dest_x_return and dest_y_return are set to zero.");

	report_strategy("If an alternate screen is supported:");
	report_strategy("	Create a mapped window on the default screen.");
	report_strategy("	Create a mapped window on the alternate screen.");
	report_strategy("	Verify XTranslateCoordinates returns zero.");
	report_strategy("	Verify that *dest_x_return is zero.");
	report_strategy("	Verify that *dest_y_return is zero.");

	transinit();
	setargs();
        if (config.alt_screen == -1) {
                unsupported("No alternate screen supported");
                return;
        }

	src_w  = defdraw(display, VI_WIN);
	XMapWindow(display, src_w);
	dest_w = defdraw(display, VI_ALT_WIN);
	XMapWindow(display, dest_w);

	startcall(display);
	if (isdeleted())
		return;
	ret = XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret != 0)
	{
		report("%s did not return zero when", TestName);
		report("src_w and dest_w were on different screens.");
		report("Expecting: 0");
		report("Returned : %d", ret);
		FAIL;
	}
	else
		CHECK;

	if ( dest_x != 0  || dest_y != 0 )
	{
		report("%s did not set the dest_x and dest_y as expected.",
				TestName);
		report("Expecting: (*dest_x_return)=0, (*dest_y_return)=0");
		report("Returned : (*dest_x_return)=%d, (*dest_y_return)=%d",
			dest_x, dest_y);
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

Window	exp_w;
Bool	ret;
int	border_width;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XTranslateCoordinates-3.(A)");
	report_assertion("When the coordinates are contained in a mapped child of");
	report_assertion("dest_w, then that child is returned in child_return.");

	report_strategy("For some values of border_width:");
	report_strategy("	Create a window to be the source and destination windows.");
	report_strategy("	Create a sub window.");
	report_strategy("	Map both windows.");
	report_strategy("	Translate coordinates of the window to the child using XTranslateCoordinates.");
	report_strategy("	Verify the child_return window was the sub window.");

	transinit();
	setargs();
/* Set up child window position coordinates */

	for(border_width = 0; border_width < 5; border_width++) {
		src_w = defdraw(display, VI_WIN);
		XMapWindow(display, src_w);

		dest_w = src_w;

		exp_w = crechild(display, src_w, &c_ap);

		XSetWindowBorderWidth(display, exp_w, border_width); 
		XSetWindowBorder(display, exp_w, W_FG);
		XMapWindow(display, exp_w);

/* Calculate expected return values */
		startcall(display);
		if (isdeleted())
			return;
		ret = XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
		endcall(display);
		if (geterr() != Success) {
			report("Got %s, Expecting Success", errorname(geterr()));
			FAIL;
		}

		if (ret == False)
		{
			report("%s returned False when expecting True.",
				TestName);
			report("border_width=%d", border_width);
			FAIL;
		} else
		if (child != exp_w)
		{
			report("%s did not return the expected window in (*child_return)",
				TestName);
			report("(*child_return) = %0x", child);
			report("expected window = %0x", exp_w);
			report("border_width=%d", border_width);
			FAIL;
		}
		else
			CHECK;

	}

	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

XVisualInfo 	*vp;
XWindowAttributes	winatt;
Window	exp_w;
Bool	ret;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XTranslateCoordinates-4.(A)");
	report_assertion("When the coordinates are not contained in a mapped child of");
	report_assertion("dest_w, then child_return is set to None.");

	report_strategy("Create a mapped window to be the source and destination windows.");
	report_strategy("Create an overlapping mapped sibling window.");
	report_strategy("Translate coordinates of the window using XTranslateCoordinates.");
	report_strategy("Verify the child_return window was None.");
	report_strategy("Verify the returned coordinates were as expected.");

	transinit();
	setargs();
	src_w = defdraw(display, VI_WIN);
	XMapWindow(display, src_w);
	dest_w = src_w;

/* Get the root window relative postion of the first window */
	XGetWindowAttributes(display, src_w, &winatt);

/* Set the coordinates of the sibling window */
	c_ap.x += winatt.x;
	c_ap.y += winatt.y;

/* Make sibling window: mapped */
	resetvinf(VI_WIN); nextvinf(&vp);
	exp_w = makewinpos(display, vp,  c_ap.x, c_ap.y);

	startcall(display);
	if (isdeleted())
		return;
	ret = XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == False)
	{
		report("%s returned False when expecting True.",
			TestName);
		FAIL;
	} else
	if (child != None)
	{
		report("When the source coordinates refered to a sibling window");
		report("%s did not set child_return to None",
			TestName);
		report("Window id returned: %0x", child);
		report("Source/Dest window: %0x", src_w);
		report("Sibling window    : %0x", exp_w);
		FAIL;
	}
	else
		CHECK;

/* Now test for a point on dest_w itself */
	src_x = 5;
	src_y = 5;
	child = ~0;	/* We must make sure xname actually sets this */

	startcall(display);
	if (isdeleted())
		return;
	ret = XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	if (ret == False)
	{
		report("%s returned False when expecting True.",
			TestName);
		FAIL;
	} else
	if (child != None)
	{
		report("When the source coordinates refered to the dest_w");
		report("%s did not set child_return to None",
			TestName);
		report("child_return      : %0x", child);
		report("Source/Dest window: %0x", src_w);
		report("Sibling window    : %0x", exp_w);
		FAIL;
	}
	else
		CHECK;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window	goodwin;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XTranslateCoordinates-5.(A)");
	report_assertion("When a window argument does not name a valid window, then a");
	report_assertion("BadWindow error occurs.");

	report_strategy("For src_w and dest_w:");
	report_strategy("	Set the argument to a bad window.");
	report_strategy("	Verify a BadWindow error occurs.");

	transinit();
	setargs();
	seterrdef();
	
	goodwin = defdraw(display, VI_WIN);

	src_w	= badwin(display);
	dest_w	= goodwin;
	startcall(display);
	if (isdeleted())
		return;
	XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadWindow)
		CHECK;
	else
		FAIL;

	src_w	= goodwin;
	dest_w	= badwin(display);
	startcall(display);
	if (isdeleted())
		return;
	XTranslateCoordinates(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadWindow)
		CHECK;
	else
		FAIL;

	CHECKPASS(2);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
