/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XRestackWindows(display, windows, nwindows)
 *   Display	*display;
 *   Window	*windows;
 *   int	nwindows;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XRestackWindows	1
char    *TestName = "XRestackWindows";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XRestackWindows function
 */
static Display	*display;
static Window	*windows;
static int	nwindows;



static Window	array[8];

static char	*SimpleTemplate[] = {
	".",
	"zero . (10,10) 30x30",
	"one . (35,35) 30x30",
	"two . (10,35) 30x30",
	"three . (35,10) 30x30",
	"other1 . (75,10) 15x70",
	"other2 other1 (5,5) 5x10",
	"other3 . (80,40) 5x20",
};
static int	NSimpleTemplate = NELEM(SimpleTemplate);


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	windows = array;
	nwindows = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

struct	buildtree	*tree;
Window	parent, zero, one, two, three ;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XRestackWindows-1.(A)");
	report_assertion("A call to XRestackWindows restacks the windows in the");
	report_assertion("windows array in the order specified, from top to bottom.");

	report_strategy("Create a window hierarchy.");
	report_strategy("Assign members of the window array");
	report_strategy("Call XRestackWindows to restack the windows");
	report_strategy("Verify that the windows were restacked in the order two, one, zero, three using pixchecking");

	tpstartup();
	setargs();
/* Create a window hierarchy. */
	parent = defwin(display);
	tree = buildtree(display, parent, SimpleTemplate, NSimpleTemplate);
	zero = btntow(tree, "zero");
	one = btntow(tree, "one");
	two = btntow(tree, "two");
	three = btntow(tree, "three");

/* Assign members of the window array */
	array[0] = two;	/* top window */
	array[1] = one;
	array[2] = zero;
	array[3] = three;

/* Call xname to restack the windows */
	nwindows = 4;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the windows were restacked in the order two, one, zero, three using pixchecking */
	PIXCHECK(display, parent);
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

struct	buildtree	*tree;
Window	parent, one, three ;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XRestackWindows-2.(A)");
	report_assertion("The stacking order of the first window in the windows array");
	report_assertion("is unaffected with respect to other windows not in the");
	report_assertion("array.");

	report_strategy("Create a window hierarchy.");
	report_strategy("Assign members of the window array");
	report_strategy("Call XRestackWindows to restack the windows");
	report_strategy("Verify that the windows were restacked such that the order became two, one, three, zero by pixchecking");

	tpstartup();
	setargs();
/* Create a window hierarchy. */
	parent = defwin(display);
	tree = buildtree(display, parent, SimpleTemplate, NSimpleTemplate);
	one = btntow(tree, "one");
	three = btntow(tree, "three");

/* Assign members of the window array */
	array[0] = one;
	array[1] = three;

/* Call xname to restack the windows */
	nwindows = 2;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the windows were restacked such that the order became two, one, three, zero by pixchecking */
	PIXCHECK(display, parent);
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

struct	buildtree	*tree;
Window	parent, other1, other3;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XRestackWindows-3.(A)");
	report_assertion("The stacking order of any windows not in the windows array");
	report_assertion("is not affected.");

	report_strategy("Create a window hierarchy.");
	report_strategy("Assign members of the window array");
	report_strategy("Call XRestackWindows to restack the windows");
	report_strategy("Verify that the windows were restacked such that the windows zero, one, two and three were unaffected");

	tpstartup();
	setargs();
/* Create a window hierarchy. */
	parent = defwin(display);
	tree = buildtree(display, parent, SimpleTemplate, NSimpleTemplate);
	other1= btntow(tree, "other1");
	other3= btntow(tree, "other3");

/* Assign members of the window array */
	array[0] = other3;
	array[1] = other1;

/* Call xname to restack the windows */
	nwindows = 2;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that the windows were restacked such that the windows zero, one, two and three were unaffected */
	PIXCHECK(display, parent);
	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

Display	*client1, *client2;
Window	parent, zero, one, two, three; 
struct	buildtree	*c1tree;
XImage	*image;
XSetWindowAttributes	attr;
XEvent	ev;
int	numevent;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XRestackWindows-4.(A)");
	report_assertion("When the override-redirect attribute of a window in the");
	report_assertion("windows array is False and some other client has selected");
	report_assertion("SubstructureRedirectMask on the parent window, then a");
	report_assertion("ConfigureRequest event is generated for each such window and");
	report_assertion("no further processing is performed on that window.");

	report_strategy("Create client1 and client2.");
	report_strategy("Create a window hierarchy for client1.");
	report_strategy("Save parent window image as reference image.");
	report_strategy("Ensure override-redirect on window one is False.");
	report_strategy("Select SubstructureRedirectMask events on the parent window for client2.");
	report_strategy("Call XRestackWindows to restack window one.");
	report_strategy("Verify that no events were delivered to client1.");
	report_strategy("Verify that a correct ConfigureRequest event was delivered to client2.");
	report_strategy("Verify that no further processing occurred by comparing the window to our reference window.");

	tpstartup();
	setargs();
/* Create client1 and client2. */
	client1 = opendisplay();
	if (client1 == NULL) {
		delete("could not create client1");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == NULL) {
		delete("could not create client2");
		return;
	}
	else
		CHECK;

/* Create a window hierarchy for client1. */
	parent = defwin(client1); trace("window parent %d", parent);
	c1tree = buildtree(client1, parent, SimpleTemplate, NSimpleTemplate);
	zero= btntow(c1tree, "zero"); trace("window zero %d", zero);
	one = btntow(c1tree, "one"); trace("window one  %d", one);
	two = btntow(c1tree, "two"); trace("window two  %d", two);
	three=btntow(c1tree, "three"); trace("window three %d", three);

/* Save parent window image as reference image. */
	image = savimage(client1, parent);

/* Ensure override-redirect on window one is False. */
	attr.override_redirect = False;
	XChangeWindowAttributes(client1, one, CWOverrideRedirect, &attr);

/* Select SubstructureRedirectMask events on the parent window for client2. */
	XSelectInput(client2, parent, SubstructureRedirectMask);
	XSync(client2, True);

/* Call xname to restack window one. */
	array[0] = zero;
	array[1] = one;
	nwindows = 2;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	XSync(client2, False);

/* Verify that no events were delivered to client1. */
	numevent = getevent(client1, &ev);
	if (numevent != 0) {
		FAIL;
		report("%d unexpected %s delivered to client1",
			numevent, (numevent==1)?"event was":"events were");
		report("%sevent was %s", (numevent!=1)?"first ":"",
			eventname(ev.type));
		trace("Window field was %d", ev.xany.window);
		while(getevent(client1, &ev) != 0) {
			report("next event was %s", eventname(ev.type));
			trace("Window field was %d", ev.xany.window);
		}
	} else
		CHECK;

/* Verify that a correct ConfigureRequest event was delivered to client2. */
	numevent = getevent(client2, &ev);
	if (numevent != 1) {
		FAIL;
		report("Expecting a single ConfigureRequest event");
		report("Received %d events", numevent);
		if (numevent != 0) {
			report("First event was %s", eventname(ev.type));
			trace("Window field was %d", ev.xany.window);
			while(getevent(client2, &ev) != 0) {
				report("next event was %s", eventname(ev.type));
				trace("Window field was %d", ev.xany.window);
			}
		}
	} else	{
		XConfigureRequestEvent	good;

		good.type = ConfigureRequest;
		good.serial = 0;
		good.send_event = False;
		good.display = client2;
		good.parent = parent;
		good.window = one;
		good.x	= ev.xconfigure.x;
		good.y  = ev.xconfigure.y;
		good.width = ev.xconfigure.width;
		good.height = ev.xconfigure.height;
		good.border_width = ev.xconfigure.border_width;
		good.above = zero;
		good.detail= Below;
		good.value_mask = CWStackMode | CWSibling;

		if ( checkevent((XEvent *)&good, &ev) )
			FAIL;
		else
			CHECK;
	}

/* Verify that no further processing occurred by comparing the window to our reference window. */
	if (!compsavimage(client1, parent, image)) {
		FAIL;
	} else
		CHECK;
	
	CHECKPASS(5);
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

struct	buildtree	*tree;
Window	parent, one, two, three, other1, other2, parent2;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XRestackWindows-5.(A)");
	report_assertion("When a window in the windows array is not a sibling of the");
	report_assertion("previous window in the array, then for each such pair of");
	report_assertion("windows a BadMatch error occurs.");

	report_strategy("Create two window hierarchies");
	report_strategy("Assign members of the windows array, with one element not a sibling");
	report_strategy("Verify that a BadMatch error occurred.");
	report_strategy("Assign members of the windows array, with an element as the parent window");
	report_strategy("Verify that a BadMatch error occurred.");
	report_strategy("Assign members of the windows array, with an element as an unrelated window");
	report_strategy("Verify that a BadMatch error occurred.");

	tpstartup();
	setargs();
/* Create two window hierarchies */
	parent = defwin(display);
	tree = buildtree(display, parent, SimpleTemplate, NSimpleTemplate);
	one = btntow(tree, "one");
	two = btntow(tree, "two");
	three = btntow(tree, "three");
	other1 = btntow(tree, "other1");
	other2 = btntow(tree, "other2");

	parent2 = defwin(display);

/* Assign members of the windows array, with one element not a sibling */
	array[0] = one;
	array[1] = other1;
	array[2] = other2;	/* This is a child of other1, not a sibling */
	array[3] = two;
	array[4] = three;

/* Verify that a BadMatch error occurred. */
	nwindows = 5;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	if (geterr() != BadMatch)
	{
		FAIL;
		report("child window of previous member window did not cause a BadMatch");
	} else
		CHECK;

/* Assign members of the windows array, with an element as the parent window */
	array[0] = one;
	array[1] = other1;
	array[2] = parent;	/* this is the parent window */
	array[3] = two;
	array[4] = three;

/* Verify that a BadMatch error occurred. */
	nwindows = 5;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	if (geterr() != BadMatch)
	{
		FAIL;
		report("parent window of a previous window did not cause a BadMatch");
	} else
		CHECK;

/* Assign members of the windows array, with an element as an unrelated window */
	array[0] = one;
	array[1] = other1;
	array[2] = parent2;	/* this is an unrelated window */
	array[3] = two;
	array[4] = three;

/* Verify that a BadMatch error occurred. */
	nwindows = 5;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}
	if (geterr() != BadMatch)
	{
		FAIL;
		report("unrelated window of a previous window did not cause a BadMatch");
	}
	else
		CHECK;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

static void t006(){

struct	buildtree	*tree;
Window	parent, zero, one, two, three ;
int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XRestackWindows-6.(A)");
	report_assertion("When one or more entries in the windows array do not name");
	report_assertion("valid windows, then a BadWindow error occurs for each such");
	report_assertion("window.");

	report_strategy("Create a window hierarchy.");
	report_strategy("Assign members of the windows array, with one element as a bad window id.");
	report_strategy("Verify that a BadWindow error occurred.");

	tpstartup();
	setargs();
/* Create a window hierarchy. */
	parent = defwin(display);
	tree = buildtree(display, parent, SimpleTemplate, NSimpleTemplate);
	zero = btntow(tree, "zero");
	one = btntow(tree, "one");
	two = btntow(tree, "two");
	three = btntow(tree, "three");

/* Assign members of the windows array, with one element as a bad window id. */
	array[0] = zero;
	array[1] = three;
	array[2] = badwin(display);
	array[3] = one;
	array[4] = two;

/* Verify that a BadWindow error occurred. */
	nwindows = 5;
	startcall(display);
	if (isdeleted())
		return;
	XRestackWindows(display, windows, nwindows);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() != BadWindow)
		FAIL;
	else
		CHECK;
	CHECKPASS(1);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
