/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 1999 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   XtInputId
 *   XtAppAddInput()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

/* procedure XtTMO_Proc */
void XtTMO_Proc(client_data, id)
XtPointer client_data;
XtIntervalId *id;
{
	XtDestroyWidget(topLevel);
	exit(0);
}
XtInputId input_ret;
char *msg = "Hello World";
FILE *fid;
/* Procedure XtIOP_Proc */
void XtIOP_Proc(client_data, source, id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	avs_set_event(1,1);
	tet_infoline("TEST: InputID passed to procedure matches return from XtAddInput");
	if (*id != input_ret) {
		sprintf(ebuf, "ERROR: InputId passed to procedure was %#x, InputId returned by XtAddInput was %#x, should be identical", id, input_ret);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Source passed to procedure matches that passed to XtAddInput");
	if (*source != fileno(fid)) {
		sprintf(ebuf, "ERROR: Source passed to procedure was %#x, source passed to XtAddInput was %#x, should be identical", *source, fileno(fid));
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("TEST: Client data passed to procedure matches that passed to XtAddInput");
	if (strncmp(client_data, msg, sizeof(msg)) != 0) {
		sprintf(ebuf, "ERROR: Client_data passed to procedure was %s, client_data passed to XtAddInput was %s, should be identical", client_data, msg);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	exit(0);
}


#define T_XtAppAddInput	1
char    *TestName = "XtAppAddInput";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

char *data;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtAppAddInput-1.(C)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAppAddInput(app_context, sources, condition,");
	report_assertion("proc, client_data) when condition is XtInputReadMask shall");
	report_assertion("register proc as the procedure that will be called for the");
	report_assertion("application context app_context when the file descriptor");
	report_assertion("source has data to be read and return an identifier for it.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	data = "tapaddinp.dat";
	FORK(pid2);
	avs_xt_hier("Tapaddinp1", "XtAppAddInput");
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Input procedure is invoked");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	unlink(data);
	status = avs_get_event(1);
	check_dec(1, status, "XtIOP_Proc invoked status");
	tet_result(TET_PASS);
}else {
	tet_infoline("INFO: Not configured as a POSIX system");
	tet_result(TET_UNSUPPORTED);
}


	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11376 */
/* End of included file Mdefcode.tmc.11376 */

static void t002(){

char *data;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtAppAddInput-2.(C)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAppAddInput(app_context, sources, condition,");
	report_assertion("proc, client_data) when condition is XtInputWriteMask shall");
	report_assertion("register proc as the procedure that will be called for the");
	report_assertion("application context app_context when the file descriptor");
	report_assertion("source is ready for writing.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	avs_xt_hier("Tapaddinp1", "XtAppAddInput");
	data = "tapaddinp.dat";
	FORK(pid2);
	sprintf(ebuf, "PREP: Open file %s for write", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputWriteMask, XtIOP_Proc, (XtPointer)msg);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Input procedure is invoked");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	unlink(data);
	status = avs_get_event(1);
	check_dec(1, status, "XtIOP_Proc invoked status");
	tet_result(TET_PASS);
}else {
	tet_infoline("INFO: Not configured as a POSIX system");
	tet_result(TET_UNSUPPORTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11376 */
/* End of included file Mdefcode.tmc.11376 */

/* Including from file Mdefcode.tmc.11376 */
static void t003(){

pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtAppAddInput-3.(D)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAppAddInput(app_context, sources, condition,");
	report_assertion("proc, client_data) when condition is XtInputExceptMask shall");
	report_assertion("register proc as the procedure that will be called for the");
	report_assertion("application context app_context when the file descriptor");
	report_assertion("source has exception data.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11376 */

/* Including from file Mdefcode.tmc.11376 */
static void t004(){

pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtAppAddInput-4.(D)");
	report_assertion("If the implementation is POSIX-based: A call to XtInputId");
	report_assertion("XtAppAddInput(app_context, sources, condition, proc,");
	report_assertion("client_data) when condition is some combination of");
	report_assertion("XtInputReadMask, XtInputWriteMask, and XtInputExceptMask");
	report_assertion("shall be the equivalent of separate calls to XtAppAddInput");
	report_assertion("for each option specified in condition.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11376 */

static void t005(){

char *data;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtAppAddInput-5.(C)");
	report_assertion("If the implementation is POSIX-based: A successful call to");
	report_assertion("XtInputId XtAppAddInput(app_context, sources, condition,");
	report_assertion("proc, client_data) shall cause client_data to be passed to");
	report_assertion("proc when it is invoked.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

if (config.posix_system != 0) {
	avs_xt_hier("Tapaddinp1", "XtAppAddInput");
	data = "tapaddinp.dat";
	FORK(pid2);
	sprintf(ebuf, "PREP: Open file %s for read", data);
	tet_infoline(ebuf);
	if ((fid = (FILE *)fopen(data, "w+")) == NULL) {
		sprintf(ebuf, "ERROR: Could not open file %s", data);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}
	tet_infoline("PREP: Register the file as input source");
	input_ret = XtAppAddInput(app_ctext, fileno(fid), (XtPointer)XtInputReadMask, XtIOP_Proc, (XtPointer)msg);
	XtAppAddTimeOut(app_ctext, AVSXTLOOPTIMEOUT, XtTMO_Proc, topLevel);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Input procedure is invoked");
	XtAppMainLoop(app_ctext);
	KROF(pid2);
	unlink(data);
	status = avs_get_event(1);
	check_dec(1, status, "XtIOP_Proc invoked status");
	tet_result(TET_PASS);
}else {
	tet_infoline("INFO: Not configured as a POSIX system");
	tet_result(TET_UNSUPPORTED);
}

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11376 */
/* End of included file Mdefcode.tmc.11376 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
