/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XCopyGC(display, src, valuemask, dest)
 *   Display *display;
 *   GC src;
 *   unsigned long valuemask;
 *   GC dest;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XCopyGC	1
char    *TestName = "XCopyGC";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_GC src


/*
 * Arguments to the XCopyGC function
 */
static Display *display;
static GC src;
static unsigned long valuemask;
static GC dest;


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	src = 0;
	valuemask = 0;
	dest = 0;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	src = ErrdefGC;
	dest = ErrdefGC;
}

static void t001(){

XVisualInfo	*vp;
Window w;
XGCValues srcgcv, destgcv;
unsigned long vm =  (unsigned long)GCFunction | GCPlaneMask | GCForeground |
		GCBackground | GCLineWidth | GCLineStyle | GCCapStyle |
		GCJoinStyle | GCFillStyle | GCFillRule |
		GCTileStipXOrigin | GCTileStipYOrigin |
		GCSubwindowMode | GCGraphicsExposures | GCClipXOrigin |
		GCClipYOrigin | GCDashOffset | GCArcMode;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XCopyGC-1.(A)");
	report_assertion("A call to XCopyGC copies the components specified by the");
	report_assertion("valuemask argument from the src argument to the dest");
	report_assertion("argument.");

	report_strategy("Create a source GC with function set to GXxor.");
	report_strategy("Create a different, destination GC.");
	report_strategy("Copy the source GC to the destination GC with XCopyGC.");
	report_strategy("Verify that GCValues structures are identical for the destination and source GC with XGetGCValues.");
	report_strategy("Verify the destination GC component function is used in graphics operations:");
	report_strategy("   Plot point (0,0) with XDrawPoint.");
	report_strategy("   Set fg to W_FG ^ W_BG with XSetForeground.");
	report_strategy("   Plot point (0,0) with XDrawPoint.");
	report_strategy("   Verify that pixel at (0,0) is W_BG.");
	report_strategy("");

	tpstartup();
	setargs();
	resetvinf(VI_WIN);
	nextvinf(&vp);
	w = makewin(display, vp);

	/* set up an XGCValues struct for source GC */

	srcgcv.function = (int)GXxor;
	srcgcv.plane_mask = ~0L;
	srcgcv.foreground = (unsigned long) W_FG;
	srcgcv.background = (unsigned long) W_FG;
	srcgcv.line_width = (int)0;
	srcgcv.line_style = (int)LineSolid;
	srcgcv.cap_style = (int)CapButt;
	srcgcv.join_style = (int)JoinMiter;
	srcgcv.fill_style = (int)FillSolid;
	srcgcv.fill_rule = (int)EvenOddRule;
	srcgcv.arc_mode = (int)ArcPieSlice;
	srcgcv.tile = (Pixmap)0;
	srcgcv.stipple = (Pixmap)0;
	srcgcv.ts_x_origin = (int)0;
	srcgcv.ts_y_origin = (int)0;
	srcgcv.font = (Font)0;
	srcgcv.subwindow_mode = (int)ClipByChildren;
	srcgcv.graphics_exposures = (Bool)True;
	srcgcv.clip_x_origin = (int)0;
	srcgcv.clip_y_origin = (int)0;
	srcgcv.clip_mask = (Pixmap)None;
	srcgcv.dash_offset = (int)0;

	/* create a GC using the source XGCValues struct */

	src = XCreateGC(display, w, vm, &srcgcv);

	if( XGetGCValues(display, src, valuemask, &srcgcv)  == False ) {
		delete("XGetGCValues failed on source GC");
		return;
	}

	/* set up an XGCValues struct for destination GC */

	destgcv.function = (int)GXnoop;
	destgcv.plane_mask = 1L;
	destgcv.foreground = (unsigned long)W_BG;
	destgcv.background = (unsigned long)W_BG;
	destgcv.line_width = (int)5;
	destgcv.line_style = (int)LineDoubleDash;
	destgcv.cap_style = (int)CapRound;
	destgcv.join_style = (int)JoinRound;
	destgcv.fill_style = (int)FillTiled;
	destgcv.fill_rule = (int)WindingRule;
	destgcv.arc_mode = (int)ArcChord;
	destgcv.tile = (Pixmap)0;
	destgcv.stipple = (Pixmap)0;
	destgcv.ts_x_origin = (int)4;
	destgcv.ts_y_origin = (int)4;
	destgcv.font = (Font)0;
	destgcv.subwindow_mode = (int)IncludeInferiors;
	destgcv.graphics_exposures = (Bool)False;
	destgcv.clip_x_origin = (int)0;
	destgcv.clip_y_origin = (int)0;
	destgcv.clip_mask = (Pixmap)None;
	destgcv.dash_offset = (int)0;

	/* create a GC using the destination XGCValues struct */

	dest = XCreateGC(display, w, vm, &destgcv);

	/* copy source GC into destination GC */

	valuemask = vm;
	startcall(display);
	if (isdeleted())
		return;
	XCopyGC(display, src, valuemask, dest);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	/* find out what destination GC looks like */

	if( XGetGCValues(display, dest, valuemask, &destgcv)  == False ) {
		delete("XGetGCValues failed on destination GC");
		return;
	}

	/* compare the source and destination GC's */

	if( destgcv.function  == srcgcv.function  ) {
		CHECK;
	} else {
		report("dest GCValue function differs from source");
		FAIL;
	}
	if( destgcv.plane_mask  == srcgcv.plane_mask  ) {
		CHECK;
	} else {
		report("dest GCValue plane_mask differs from source");
		FAIL;
	}
	if( destgcv.foreground  == srcgcv.foreground  ) {
		CHECK;
	} else {
		report("dest GCValue foreground differs from source");
		FAIL;
	}
	if( destgcv.background  == srcgcv.background  ) {
		CHECK;
	} else {
		report("dest GCValue background differs from source");
		FAIL;
	}
	if( destgcv.line_width  == srcgcv.line_width  ) {
		CHECK;
	} else {
		report("dest GCValue line_width differs from source");
		FAIL;
	}
	if( destgcv.line_style  == srcgcv.line_style  ) {
		CHECK;
	} else {
		report("dest GCValue line_style differs from source");
		FAIL;
	}
	if( destgcv.cap_style  == srcgcv.cap_style  ) {
		CHECK;
	} else {
		report("dest GCValue cap_style differs from source");
		FAIL;
	}
	if( destgcv.join_style  == srcgcv.join_style  ) {
		CHECK;
	} else {
		report("dest GCValue join_style differs from source");
		FAIL;
	}
	if( destgcv.fill_style  == srcgcv.fill_style  ) {
		CHECK;
	} else {
		report("dest GCValue fill_style differs from source");
		FAIL;
	}
	if( destgcv.fill_rule  == srcgcv.fill_rule  ) {
		CHECK;
	} else {
		report("dest GCValue fill_rule differs from source");
		FAIL;
	}
	if( destgcv.arc_mode  == srcgcv.arc_mode  ) {
		CHECK;
	} else {
		report("dest GCValue arc_mode differs from source");
		FAIL;
	}
	if( destgcv.tile  == srcgcv.tile  ) {
		CHECK;
	} else {
		report("dest GCValue tile differs from source");
		FAIL;
	}
	if( destgcv.stipple  == srcgcv.stipple  ) {
		CHECK;
	} else {
		report("dest GCValue stipple differs from source");
		FAIL;
	}
	if( destgcv.ts_x_origin  == srcgcv.ts_x_origin  ) {
		CHECK;
	} else {
		report("dest GCValue ts_x_origin differs from source");
		FAIL;
	}
	if( destgcv.ts_y_origin  == srcgcv.ts_y_origin  ) {
		CHECK;
	} else {
		report("dest GCValue ts_y_origin differs from source");
		FAIL;
	}
	if( destgcv.font  == srcgcv.font  ) {
		CHECK;
	} else {
		report("dest GCValue font differs from source");
		FAIL;
	}
	if( destgcv.subwindow_mode  == srcgcv.subwindow_mode  ) {
		CHECK;
	} else {
		report("dest GCValue subwindow_mode differs from source");
		FAIL;
	}
	if( destgcv.graphics_exposures  == srcgcv.graphics_exposures  ) {
		CHECK;
	} else {
		report("dest GCValue graphics_exposures differs from source");
		FAIL;
	}
	if( destgcv.clip_x_origin  == srcgcv.clip_x_origin  ) {
		CHECK;
	} else {
		report("dest GCValue clip_x_origin differs from source");
		FAIL;
	}
	if( destgcv.clip_y_origin  == srcgcv.clip_y_origin  ) {
		CHECK;
	} else {
		report("dest GCValue clip_y_origin differs from source");
		FAIL;
	}
	if( destgcv.clip_mask  == srcgcv.clip_mask  ) {
		CHECK;
	} else {
		report("dest GCValue clip_mask differs from source");
		FAIL;
	}
	if( destgcv.dash_offset  == srcgcv.dash_offset  ) {
		CHECK;
	} else {
		report("dest GCValue dash_offset differs from source");
		FAIL;
	}

	XDrawPoint(display, w, dest, 0, 0);
	XSetForeground(display, dest, W_FG ^ W_BG);
	XDrawPoint(display, w, dest, 0, 0);

	if( checkpixel(display, w, 0, 0, W_BG) == 0) {
		report("XCopyGC() did not set the function component of the GC.");
		FAIL;
	} else
		CHECK;

	CHECKPASS(23);

	tpcleanup();
	pfcount(pass, fail);
}

/* Including from file error/EAll.mc */
/* End of included file error/EAll.mc */

/* Including from file error/EAll.mc */
static void t002(){

int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XCopyGC-2.(B)");
	report_assertion("When the server fails to allocate a required resource, then");
	report_assertion("a BadAlloc error occurs.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	tpstartup();
	setargs();
	report("There is no reliable method of testing that a BadAlloc error is generated");
	tet_result(TET_UNTESTED);
	tpcleanup();
	pfcount(pass, fail);
}

/* End of included file error/EAll.mc */

static void t003(){

Window w;
XWindowAttributes atts;
Status  s;
int newdepth;
Pixmap pm;
int nitems, *depthlist;
unsigned long vm =  (unsigned long)GCFunction | GCPlaneMask | GCForeground |
		GCBackground | GCLineWidth | GCLineStyle | GCCapStyle |
		GCJoinStyle | GCFillStyle | GCFillRule |
		GCTileStipXOrigin | GCTileStipYOrigin |
		GCSubwindowMode | GCGraphicsExposures | GCClipXOrigin |
		GCClipYOrigin | GCDashOffset | GCArcMode;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XCopyGC-3.(C)");
	report_assertion("When the src and dest arguments do not have the same depth,");
	report_assertion("then a BadMatch error occurs.");

	report_strategy("If multiple pixmap depths are supported:");
	report_strategy("   Create a pixmap with a different depth to the root window");
	report_strategy("   Create a GC on the root window");
	report_strategy("   Create a GC on the pixmap");
	report_strategy("   Copy from the first GC to the second using XCopyGC.");
	report_strategy("   Verify that a BadMatch error was generated.");

	tpstartup();
	setargs();
		/* can not ask XGetGCValues for GCClipMask  or GCDashList,
		   also need pixmaps for GCTile, GCStipple and GCFont */

	w = DefaultRootWindow(display);

	s = XGetWindowAttributes(display, w, &atts);
	if (s == False) {
		delete("XGetWindowAttributes failed");
		return;
	}

	depthlist = XListDepths(display,XScreenNumberOfScreen(atts.screen),&nitems);

	/* search for a different depth to create pixmap */

	for( newdepth = atts.depth; nitems-- > 0 && depthlist; depthlist++ ) {
		if( newdepth != *depthlist ) {
			newdepth = *depthlist;
			break;
		}
	}
	if( atts.depth == newdepth ) {
		report("Screen only supports 1 depth");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	src = XCreateGC(display, w, 0L, (XGCValues *)NULL);

	pm = XCreatePixmap(display, w, 100, 100, newdepth );

	dest = XCreateGC(display, pm, 0L, (XGCValues *)NULL);

	valuemask = vm;

	startcall(display);
	if (isdeleted())
		return;
	XCopyGC(display, src, valuemask, dest);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

char    *altroot;
int     scr_num;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XCopyGC-4.(C)");
	report_assertion("When the src and dest arguments were not created for the");
	report_assertion("same root, then a BadMatch error occurs.");

	report_strategy("If multiple roots are supported:");
	report_strategy("   Create a GC for two different roots.");
	report_strategy("   Copy from the first to the second.");
	report_strategy("   Verify that a BadMatch error occurred.");
	report_strategy("   Copy from the second to the first.");
	report_strategy("   Verify that a BadMatch error occurred.");

	tpstartup();
	setargs();
	altroot = tet_getvar("XT_ALT_SCREEN");
	if (altroot == NULL) {
		delete("XT_ALT_SCREEN not set");
		return;
	}
	if (*altroot == 'U') {
		report("Only one screen supported");
		tet_result(TET_UNSUPPORTED);
		return;
	}

	scr_num = atoi(altroot);
	if (scr_num == DefaultScreen(display)) {
		delete("The Alternate root was the same as the one under test");
		return;
	}
	if (scr_num >= ScreenCount(display)) {
		delete("Screen given in XT_ALT_SCREEN could not be accessed");
		return;
	}


	src = XCreateGC(display, RootWindow(display,scr_num), 0L, (XGCValues*)0);
	dest = XCreateGC(display, RootWindow(display, DefaultScreen(display)), 0L, (XGCValues*)0);
	valuemask =   (unsigned long)GCFunction | GCPlaneMask | GCForeground |
			GCBackground | GCLineWidth | GCLineStyle | GCCapStyle |
			GCJoinStyle | GCFillStyle | GCFillRule |
			GCTileStipXOrigin | GCTileStipYOrigin |
			GCSubwindowMode | GCGraphicsExposures | GCClipXOrigin |
			GCClipYOrigin | GCDashOffset | GCArcMode;
	startcall(display);
	if (isdeleted())
		return;
	XCopyGC(display, src, valuemask, dest);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		CHECK;
	else
		FAIL;

	CHECKPASS(1);

	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

Window w;
GC	gcgood, gcbad;
unsigned long vm =  (unsigned long)GCFunction | GCPlaneMask | GCForeground |
		GCBackground | GCLineWidth | GCLineStyle | GCCapStyle |
		GCJoinStyle | GCFillStyle | GCFillRule |
		GCTileStipXOrigin | GCTileStipYOrigin |
		GCSubwindowMode | GCGraphicsExposures | GCClipXOrigin |
		GCClipYOrigin | GCDashOffset | GCArcMode;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XCopyGC-5.(A)");
	report_assertion("When either the src or dest argument does not name a");
	report_assertion("defined GC, then a BadGC error occurs.");

	report_strategy("Create a bad GC");
	report_strategy("Create a good GC");
	report_strategy("Call XCopyGC with bad source, good destination GC's");
	report_strategy("Verify that BadGC error occurs");
	report_strategy("Call XCopyGC with good source, bad destination GC's");
	report_strategy("Verify that BadGC error occurs");
	report_strategy("Call XCopyGC with bad source, bad destination GC's");
	report_strategy("Verify that BadGC error occurs");

	tpstartup();
	setargs();
	w = DefaultRootWindow(display);

	gcgood = XCreateGC(display, w, 0L, (XGCValues *)NULL);

	gcbad = badgc(display);

	/* test bad source, good destination */

	src = gcbad;
	dest = gcgood;
	valuemask = vm;

	trace("test bad source GC, good destination GC" );

	startcall(display);
	if (isdeleted())
		return;
	XCopyGC(display, src, valuemask, dest);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadGC) {
		report("Got %s, Expecting BadGC", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadGC)
		CHECK;
	else
		FAIL;

	/* test good source, bad destination */

	src = gcgood;
	dest = gcbad;
	valuemask = vm;

	trace("test good source GC, bad destination GC" );

	startcall(display);
	if (isdeleted())
		return;
	XCopyGC(display, src, valuemask, dest);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadGC) {
		report("Got %s, Expecting BadGC", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadGC)
		CHECK;
	else
		FAIL;

	/* test for bad source and bad destination */

	src = gcbad;
	dest = gcbad;
	valuemask = vm;

	trace("test bad source GC, bad destination GC" );

	startcall(display);
	if (isdeleted())
		return;
	XCopyGC(display, src, valuemask, dest);
	gcflush(A_DISPLAY, A_GC);
	endcall(display);
	if (geterr() != BadGC) {
		report("Got %s, Expecting BadGC", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadGC)
		CHECK;
	else
		FAIL;

	CHECKPASS(3);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
