/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   XEventClass *
 *   XGetSelectedExtensionEvents(display, win, this_client_count, this_client_list, all_clients_count, all_clients_list)
 *   Display	*display;
 *   Window	win;
 *   int	*this_client_count;
 *   XEventClass **this_client_list;
 *   int	*all_clients_count;
 *   XEventClass **all_clients_list;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetSelectedExtensionEvents	1
char    *TestName = "XGetSelectedExtensionEvents";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_WINDOW win
#define A_DRAWABLE win


/*
 * Arguments to the XGetSelectedExtensionEvents function
 */
static Display	*display;
static Window	win;
static int	*this_client_count;
static XEventClass **this_client_list;
static int	*all_clients_count;
static XEventClass **all_clients_list;


int acount, tcount;
XEventClass *tlist, *alist;

int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	win = 0;
	this_client_count = &tcount;
	this_client_list = &tlist;
	all_clients_count = &acount;
	all_clients_list = &alist;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
	win = ErrdefWindow;
}

static void t001(){

Window	w;
Display	*client1, *client2;
int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetSelectedExtensionEvents-1.(B)");
	report_assertion("A successful call to XGetSelectedExtensionEvents returns");
	report_assertion("the selected input extension events for the specified");
	report_assertion("window.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGetSelectedExtensionEvents.");

	tpstartup();
	setargs();
/* Create client1. */
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
	client2 = opendisplay();
	if (client2 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	w = mkwin(client1, (XVisualInfo *) NULL, (struct area *) NULL, False);
	win = w;
	XSync (client1, True);
	
	startcall(display);
	if (isdeleted())
		return;
	ret = XGetSelectedExtensionEvents(display, win, this_client_count, this_client_list, all_clients_count, all_clients_list);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(3);

	SuppressExtensionEvents(display,w);
	XSync (display, True);
	startcall(display);
	if (isdeleted())
		return;
	ret = XGetSelectedExtensionEvents(display, win, this_client_count, this_client_list, all_clients_count, all_clients_list);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(4);

	SelectExtensionEvents(display,w);
	XSync (display, True);
	startcall(display);
	if (isdeleted())
		return;
	ret = XGetSelectedExtensionEvents(display, win, this_client_count, this_client_list, all_clients_count, all_clients_list);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(5);

	SelectExtensionEvents(client1,w);
	XSync (client1, True);
	startcall(display);
	if (isdeleted())
		return;
	ret = XGetSelectedExtensionEvents(display, win, this_client_count, this_client_list, all_clients_count, all_clients_list);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(6);

	SelectExtensionEvents(client2,w);
	XSync (client2, True);
	startcall(display);
	if (isdeleted())
		return;
	ret = XGetSelectedExtensionEvents(display, win, this_client_count, this_client_list, all_clients_count, all_clients_list);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	if (geterr() == Success)
		CHECK;
	else
		FAIL;
	CHECKPASS(7);

	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

Display	*client1;
int 	ret;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetSelectedExtensionEvents-2.(B)");
	report_assertion("A call to XGetSelectedExtensionEvents with an invalid");
	report_assertion("window returns a BadWindow error.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGetSelectedExtensionEvents with an invalid window.");

	tpstartup();
	setargs();
/* Create client1. */
	if (!Setup_Extension_DeviceInfo(KeyMask))
	    {
	    untested("%s: No input extension key device.\n", TestName);
	    return;
	    }
	client1 = opendisplay();
	if (client1 == (Display *) NULL) {
		delete("Can not open display");
		return;
	}
	else
		CHECK;
/* Create window with client1. */
	win = 0;
	startcall(display);
	if (isdeleted())
		return;
	ret = XGetSelectedExtensionEvents(display, win, this_client_count, this_client_list, all_clients_count, all_clients_list);
	endcall(display);
	if (geterr() != BadWindow) {
		report("Got %s, Expecting BadWindow", errorname(geterr()));
		FAIL;
	}
	if (geterr() == BadWindow)
		CHECK;
	else {
		report("No BadWindow for invalid window test");
		FAIL;
		}
	CHECKPASS(2);

	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
