'\" t
.\"     Title: xichangeproperty
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.76.1 <http://docbook.sf.net/>
.\"      Date: 12/21/2011
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XICHANGEPROPERTY" "libmansuffix" "12/21/2011" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XIChangeProperty, XIGetProperty, XIDeleteProperty \- change, retrieve or delete a device\*(Aqs property\&.
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput2\&.h>
.fi
.sp
.nf
void XIChangeProperty( Display* dpy,
                       int deviceid,
                       Atom property,
                       Atom type,
                       int format,
                       int mode,
                       unsigned char *data,
                       int num_items)
.fi
.sp
.nf
void XIDeleteProperty( Display *dpy,
                       int deviceid,
                       Atom property)
.fi
.sp
.nf
Status XIGetProperty( Display *dpy,
                      int deviceid,
                      Atom property,
                      long offset,
                      long length,
                      Bool delete_property,
                      Atom type,
                      Atom *type_return,
                      int *format_return,
                      unsigned long *num_items_return,
                      unsigned long *bytes_after_return,
                      unsigned char **data)
.fi
.sp
.nf
bytes_after_return
       Returns the number of bytes remaining to be read in the prop\-
       erty if a partial read was performed\&.
.fi
.sp
.nf
data
       Specifies the property data\&.
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
delete_property
       Specifies a Boolean value that determines whether the property
       is to be deleted\&.
.fi
.sp
.nf
deviceid
       The device to list the properties for\&.
.fi
.sp
.nf
format
       Specifies whether the data should be viewed as a list of
       8\-bit, 16\-bit, or 32\-bit quantities\&.  Possible values are 8,
       16, and 32\&.  This information allows the X server to correctly
       perform byte\-swap operations as necessary\&. If the
       format is 16\-bit or 32\-bit, you must explicitly cast your
       data pointer to an (unsigned char *) in the call to
       XIChangeProperty\&.
.fi
.sp
.nf
format_return
       Returns the actual format of the property\&.
.fi
.sp
.nf
length
       Specifies the length in 32\-bit multiples of the data to be
       retrieved\&.
.fi
.sp
.nf
offset
       Specifies the offset in the specified property (in 32\-bit
       quantities) where the data is to be retrieved\&.
.fi
.sp
.nf
mode
       One of XIPropModeAppend, XIPropModePrepend or XIPropModeReplace\&.
.fi
.sp
.nf
num_items
       Number of items in data in the format specified\&.
.fi
.sp
.nf
nitems_return
       Returns the actual number of 8\-bit, 16\-bit, or 32\-bit items
       stored in data\&.
.fi
.sp
.nf
property
       Specifies the property name\&.
.fi
.sp
.nf
type
       Specifies the type of the property\&.  The X server does not
       interpret the type but simply passes it back to an application
       that later calls XIGetProperty\&.
.fi
.sp
.nf
type_return
       Returns the atom identifier that defines the actual type of
       the property\&.
.fi
.SH "DESCRIPTION"
.sp
The XIGetProperty function returns the actual type of the property; the actual format of the property; the number of 8\-bit, 16\-bit, or 32\-bit items transferred; the number of bytes remaining to be read in the property; and a pointer to the data actually returned\&. XIGetProperty sets the return arguments as follows:
.sp
.RS 4
.ie n \{\
\h'-04'\(bu\h'+03'\c
.\}
.el \{\
.sp -1
.IP \(bu 2.3
.\}
If the specified property does not exist for the specified device, XIGetProperty returns None to actual_type_return and the value zero to actual_format_return and bytes_after_return\&. The nitems_return argument is empty\&. In this case, the delete argument is ignored\&.
.RE
.sp
.RS 4
.ie n \{\
\h'-04'\(bu\h'+03'\c
.\}
.el \{\
.sp -1
.IP \(bu 2.3
.\}
If the specified property exists but its type does not match the specified type, XIGetProperty returns the actual property type to actual_type_return, the actual property format (never zero) to actual_format_return, and the property length in bytes (even if the actual_format_return is 16 or 32) to bytes_after_return\&. It also ignores the delete argument\&. The nitems_return argument is empty\&.
.RE
.sp
.RS 4
.ie n \{\
\h'-04'\(bu\h'+03'\c
.\}
.el \{\
.sp -1
.IP \(bu 2.3
.\}
If the specified property exists and either you assign XIAnyPropertyType to the req_type argument or the specified type matches the actual property type, XIGetProperty returns the actual property type to actual_type_return and the actual property format (never zero) to actual_format_return\&. It also returns a value to bytes_after_return and nitems_return, by defining the following values:
.sp
.if n \{\
.RS 4
.\}
.nf
N = length of the stored property in bytes
I = 4 * offset
T = N \- I
L = MINIMUM(T, 4 * length)
A = N \- (I + L)
.fi
.if n \{\
.RE
.\}
.RE
.sp
The returned value starts at byte index I in the property (indexing from zero), and its length in bytes is L\&. If the value for long_offset causes L to be negative, a BadValue error results\&. The value of bytes_after_return is A, giving the number of trailing unread bytes in the stored property\&.
.sp
If the returned format is 8, the returned data is represented as a char array\&. If the returned format is 16, the returned data is represented as a uint16_t array and should be cast to that type to obtain the ele\- ments\&. If the returned format is 32, the returned data is represented as a uint32_t array and should be cast to that type to obtain the elements\&.
.sp
XIGetProperty always allocates one extra byte in prop_return (even if the property is zero length) and sets it to zero so that simple properties consisting of characters do not have to be copied into yet another string before use\&.
.sp
If delete is True and bytes_after_return is zero, XIGetProperty deletes the property from the window and generates an XIPropertyNotify event on the window\&.
.sp
The function returns Success if it executes successfully\&. To free the resulting data, use XFree\&.
.sp
XIGetProperty can generate BadAtom, BadValue, and BadWindow errors\&.
.sp
The XIChangeProperty function alters the property for the specified device and causes the X server to generate a XIPropertyNotify event for that device\&. XIChangeProperty performs the following:
.sp
.RS 4
.ie n \{\
\h'-04'\(bu\h'+03'\c
.\}
.el \{\
.sp -1
.IP \(bu 2.3
.\}
If mode is XIPropModeReplace, XIChangeProperty discards the previous property value and stores the new data\&.
.RE
.sp
.RS 4
.ie n \{\
\h'-04'\(bu\h'+03'\c
.\}
.el \{\
.sp -1
.IP \(bu 2.3
.\}
If mode is XIPropModePrepend or XIPropModeAppend, XIChangeProperty inserts the specified data before the beginning of the existing data or onto the end of the existing data, respectively\&. The type and format must match the existing property value, or a BadMatch error results\&. If the property is undefined, it is treated as defined with the correct type and format with zero\-length data\&.
.RE
.sp
If the specified format is 8, the property data must be a char array\&. If the specified format is 16, the property data must be a uint16_t array\&. If the specified format is 32, the property data must be a uint32_t array\&.
.sp
The lifetime of a property is not tied to the storing client\&. Properties remain until explicitly deleted, until the device is removed, or until the server resets\&. The maximum size of a property is server dependent and can vary dynamically depending on the amount of memory the server has available\&. (If there is insufficient space, a BadAlloc error results\&.)
.sp
XIChangeProperty can generate BadAlloc, BadAtom, BadMatch, BadValue, and BadDevice errors\&.
.sp
The XIDeleteProperty function deletes the specified property only if the property was defined on the specified device and causes the X server to generate a XIPropertyNotify event for the device unless the property does not exist\&.
.sp
XIDeleteProperty can generate BadAtom and BadDevice errors\&.
.SH "DIAGNOSTICS"
.sp
BadAlloc The server failed to allocate the requested resource or server memory\&.
.sp
BadAtom A value for an Atom argument does not name a defined Atom\&.
.sp
BadValue Some numeric value falls outside the range of values accepted by the request\&. Unless a specific range is specified for an argument, the full range defined by the argument\(cqs type is accepted\&. Any argument defined as a set of alternatives can generate this error\&.
.sp
BadDevice An invalid device was specified\&. The device does not exist\&.
.sp
BadAtom An invalid property was specified\&. The property does not exist\&.
.SH "BUGS"
.sp
.if n \{\
.RS 4
.\}
.nf
The protocol headers for XI 2\&.0 did not provide
XIAnyPropertyType, XIPropModeReplace, XIPropModePrepend or
XIPropModeAppend\&. Use AnyPropertyType, PropModeReplace,
PropModePrepend and PropModeAppend instead, respectively\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
XIListProperties(libmansuffix)
