'\" t
.\"     Title: xigrabbutton
.\"    Author: [FIXME: author] [see http://docbook.sf.net/el/author]
.\" Generator: DocBook XSL Stylesheets v1.74.3 <http://docbook.sf.net/>
.\"      Date: 06/19/2009
.\"    Manual: [FIXME: manual]
.\"    Source: [FIXME: source]
.\"  Language: English
.\"
.TH "XIGRABBUTTON" "libmansuffix" "06/19/2009" "[FIXME: source]" "[FIXME: manual]"
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XIGrabButton, XIUngrabButton, XIGrabKeysym, XIUngrabKeysym \- grab/ungrab buttons or keys
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput\&.h>
.fi
.sp
.nf
int XIGrabButton( Display *display,
                  int deviceid,
                  int button,
                  Window grab_window,
                  Cursor cursor,
                  int grab_mode,
                  int paired_device_mode,
                  Bool owner_events,
                  XIEventMask *mask,
                  int num_modifiers,
                  XIGrabModifiers *modifiers_inout);
.fi
.sp
.nf
int XIUngrabButton( Display *display,
                    int deviceid,
                    int button,
                    Window grab_window,
                    int num_modifiers,
                    XIGrabModifiers *modifiers);
.fi
.sp
.nf
int XIGrabKeysym( Display *display,
                  int deviceid,
                  int keysym,
                  Window grab_window,
                  Cursor cursor,
                  int grab_mode,
                  int paired_device_mode,
                  Bool owner_events,
                  XIEventMask *mask,
                  int num_modifiers,
                  XIGrabModifiers *modifiers_inout);
.fi
.sp
.nf
int XIUngrabKeysym( Display *display,
                    int deviceid,
                    int keysym,
                    Window grab_window,
                    int num_modifiers,
                    XIGrabModifiers *modifiers);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
device
       Specifies the device that is to be grabbed or released
.fi
.sp
.nf
button
       Specifies the device button that is to be grabbed or
       released or XIAnyButton\&.
.fi
.sp
.nf
keysym
       Specifies the keysym that is to be grabbed or released
       or XIAnyKeysym\&.
.fi
.sp
.nf
num_modifiers
       Number of elements in modifiers or modifiers_return
.fi
.sp
.nf
modifiers
       Specifies the set of latched and base modifiers or
       XIAnyModifier to ungrab\&. The data type is for
       consistency with the respective grab request and the
       status code of the XIGrabModifiers struct is ignored\&.
.fi
.sp
.nf
modifiers_inout
       Specifies the set of latched and base modifiers or
       XIAnyModifier to grab\&. Returns the modifiers that could
       not be grabbed and their status code\&.
.fi
.sp
.nf
grab_window
       Specifies the grab window\&.
.fi
.sp
.nf
owner_events
       Specifies a Boolean value that indicates whether the are
       to be reported as usual or reported with respect to the
       grab window\&.
.fi
.sp
.nf
mask
       Specifies the event mask\&.
.fi
.sp
.nf
grab_mode
       Specifies further processing of events from this device\&.
       You can pass GrabModeSync or GrabModeAsync\&.
.fi
.sp
.nf
paired_device_mode
       Specifies further processing of events from the paired
       master device\&. You can pass GrabModeSync or
       GrabModeAsync\&. If deviceid specifies a floating slave
       device, this parameter is ignored\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
XIGrabButton and XIGrabKeysym establishes a passive grab\&. The
modifier device for a button grab is the paired master device
if deviceid specifies a master pointer\&. Otherwise, the modifier
device is the device specified with deviceid\&. In the future,
the device is actively grabbed (as for XIGrabDevice, the
last\-grab time is set to the time at which the button or keysym
was pressed and the X_XIButtonPress or X_XIKeyPress event is
reported if all of the following conditions are true:
  * The device is not grabbed, and the specified button or
    keysym is logically pressed when the specified modifier
    keys are logically down on the modifier device and no other
    buttons or modifier keys are logically down\&.
  * Either the grab window is an ancestor of (or is) the focus
    window, OR the grab window is a descendent of the focus
    window and contains the device\&.
  * A passive grab on the same button/modifier combination does
    not exist on any ancestor of grab_window\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The interpretation of the remaining arguments is as for
XIGrabDevice\&. The active grab is terminated automatically when
the logical state of the device has all buttons or keys
released (independent of the logical state of the modifier
keys)\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
Note that the logical state of a device (as seen by client
applications) may lag the physical state if device event
processing is frozen\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
This request overrides all previous grabs by the same client on
the same button/modifier or keysym/modifier combinations on the
same window\&. A modifiers of XIAnyModifier is equivalent to
issuing the grab request for all possible modifier combinations
(including the combination of no modifiers)\&. It is not required
that all modifiers specified have currently assigned KeyCodes\&.
A button of XIAnyButton is equivalent to issuing the request
for all possible buttons\&. Otherwise, it is not required that
the specified button currently be assigned to a physical
button\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
If some other client has already issued a XIGrabButton or
XIGrabKeysym with the same button/modifier or keysym/modifier
combination on the same window, a BadAccess error results\&. When
using XIAnyModifier or XIAnyButton , the request fails
completely, and a XIBadAccess error results (no grabs are
established) if there is a conflicting grab for any
combination\&. XIGrabButton and XIGrabKeysym have no effect on an
active grab\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIGrabButton and XIGrabKeysym can generate BadClass, BadDevice,
BadMatch, BadValue, and BadWindow errors\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIUngrabButton and XIUngrabKeysym releases the passive grab for
a button/modifier or keysym/modifier combination on the
specified window if it was grabbed by this client\&. A modifier
of XIAnyModifier is equivalent to issuing the ungrab request
for all possible modifier combinations, including the
combination of no modifiers\&. A button of XIAnyButton is
equivalent to issuing the request for all possible buttons\&.
XIUngrabButton and XIUngrabKeysym have no effect on an active
grab\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIUngrabButton and XIUngrabKeysym can generate BadDevice,
BadMatch, BadValue and BadWindow errors\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid deviceid was specified\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadMatch
       This error may occur if XIGrabButton specified a device
       that has no buttons, or XIGrabKeysym specified a device
       that has no keys\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadValue
       Some numeric value falls outside the range of values
       accepted by the request\&. Unless a specific range is
       specified for an argument, the full range defined by the
       argument\'s type is accepted\&. Any argument defined as a
       set of alternatives can generate this error\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadWindow
       A value for a Window argument does not name a defined
       Window\&.
.fi
.if n \{\
.RE
.\}
.SH "SEE ALSO"
.sp
.if n \{\
.RS 4
.\}
.nf
XIAllowEvents(libmansuffix)
.fi
.if n \{\
.RE
.\}
