.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetWMName __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetWMName, XGetWMName, XStoreName, XFetchName \- set or read a window's WM_NAME property
.SH SYNTAX
.HP
void XSetWMName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, XTextProperty
*\fItext_prop\fP\^);
.HP
Status XGetWMName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^,
XTextProperty *\fItext_prop_return\fP\^);
.HP
int XStoreName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, char
*\fIwindow_name\fP\^);
.HP
Status XFetchName\^(\^Display *\fIdisplay\fP\^, Window \fIw\fP\^, char
**\fIwindow_name_return\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fItext_prop\fP 1i
Specifies the
.B XTextProperty
structure to be used.
.IP \fItext_prop_return\fP 1i
Returns the
.B XTextProperty
structure.
.IP \fIw\fP 1i
Specifies the window.
.IP \fIwindow_name\fP 1i
Specifies the window name,
which should be a null-terminated string.
.IP \fIwindow_name_return\fP 1i
Returns the window name, which is a null-terminated string.
.SH DESCRIPTION
The
.B XSetWMName
convenience function calls
.B XSetTextProperty
to set the WM_NAME property.
.LP
The
.B XGetWMName
convenience function calls
.B XGetTextProperty
to obtain the WM_NAME property.
It returns a nonzero status on success;
otherwise, it returns a zero status.
.LP
The
.B XStoreName
function assigns the name passed to window_name to the specified window.
A window manager can display the window name in some prominent
place, such as the title bar, to allow users to identify windows easily.
Some window managers may display a window's name in the window's icon,
although they are encouraged to use the window's icon name
if one is provided by the application.
If the string is not in the Host Portable Character Encoding,
the result is implementation-dependent.
.LP
.B XStoreName
can generate
.B BadAlloc
and
.B BadWindow
errors.
.LP
The
.B XFetchName
function returns the name of the specified window.
If it succeeds,
it returns a nonzero status;
otherwise, no name has been set for the window,
and it returns zero.
If the WM_NAME property has not been set for this window,
.B XFetchName
sets window_name_return to NULL.
If the data returned by the server is in the Latin Portable Character Encoding,
then the returned string is in the Host Portable Character Encoding.
Otherwise, the result is implementation-dependent.
When finished with it, a client must free
the window name string using
.BR XFree .
.LP
.B XFetchName
can generate a
.B BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_NAME\s+1
The name of the application.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(__libmansuffix__),
XAllocIconSize(__libmansuffix__),
XAllocSizeHints(__libmansuffix__),
XAllocWMHints(__libmansuffix__),
XFree(__libmansuffix__),
XSetCommand(__libmansuffix__),
XSetTransientForHint(__libmansuffix__),
XSetTextProperty(__libmansuffix__),
XSetWMClientMachine(__libmansuffix__),
XSetWMColormapWindows(__libmansuffix__),
XSetWMIconName(__libmansuffix__),
XSetWMProperties(__libmansuffix__),
XSetWMProtocols(__libmansuffix__),
XStringListToTextProperty(__libmansuffix__)
.br
\fI\*(xL\fP
