
                Control Modifier Extension

                       3 June, 1994

                     FUJITSU LIMITED


1. Functions.

This extension enables the X clients to do any of following control.

	- To change Modifier state including LockModifier and
	  Mode_switch.
	- To get mode transition notify, when needed.


The following is a table of controlable Modifiers under this extension
protocol.

	Table 1. Controlable Modifiers list.
   -------------------------------------------------------------------
   value	Mask			Affecting Modifier
   -------------------------------------------------------------------
   (1<<0)	:ShiftMask		:ShiftModifier
   (1<<1)	:LockMask		:LockModifier
   (1<<2)	:ControlMask		:ControlModifier
   (1<<3)	:Mod1Mask		:Mod1
   (1<<4)	:Mod2Mask		:Mod2
   (1<<5)	:Mod3Mask		:Mod3
   (1<<6)	:Mod4Mask		:Mod4
   (1<<7)	:Mod5Mask		:Mod5
   (1<<16)	:CModKanaLockMask	:Modifier indicated by mode_switch
					 member of Display structure.
   -------------------------------------------------------------------

The extension is called "Control-Modifiers".

The X server supporting this extionsion should return the following
information on arrival QueryExtension with this name.

major-opcode
	The request code for this operation, used with other requests
	of this extionsion.
	
first-event
	The smallest code of the events that will be generated about
	this extension

first-error
	The smallest code of the errors that will be generated about
	this extension.

2. Protocols.

2.1. Requests.

ControlModifiersGetVersion	Get version number for this extension.

	byes		value			description
	--------------------------------------------------------------------
	1		CARD8			opcode
	1		0			function code
	2		1			request length
    =>(Reply)
	1		1			reply
	1		?			unused
	2		CARD16			sequence number
	4		8			reply length
	1		CARD8			major version
	1		CARD8			minor version
	2		?			unused
	4		CARD32			Or-ed bitmask of
						available Modifiers
						for notification.
	4		CARD32			Or-ed bitmask of
						available Modifiers
						for changing.
	12		?			unused

ControlModifiersSetMask		Set masks for notification of modifier state.

	byes		value			description
	--------------------------------------------------------------------
	1		CARD8			opcode
	1		1			function code
	2		8			request length
	4		WINDOW			notification dest. window
	4		CARD32			Or-ed bitmask of
						notification modifiers.
	20		?			unused

ControlModifiersGetMask		Query for bitmask for notification modifiers.

	byes		value			description
	--------------------------------------------------------------------
	1		CARD8			opcode
	1		2			function code
	2		8			request length
	4		WINDOW			notification dest. window
	24		?			unused
    =>(Reply)
	1		1			reply
	1		?			unused
	2		CARD16			sequence number
	4		8			reply length
	4		CARD32			bitmask for
						notification modifiers.
	20		?			unused

ControlModifiersGetState	Get current modifier state.

	byes		value			description
	--------------------------------------------------------------------
	1		CARD8			opcode
	1		3			function code
	2		1			request length
    =>(Reply)
	1		1			reply
	1		?			unused
	2		CARD16			sequence number
	4		8			reply length
	4		CARD32			modifer state
	20		?			unused

ControlModifiersChangeState	Change modifier state

	byes		value			description
	--------------------------------------------------------------------
	1		CARD8			opcode
	1		4			function code
	2		8			request length
	4		CARD32			mask for changing modifiers
	4		CARD32			value for modifiers
	20		?			unused

ControlModifiersGrab		Lock modifier states

	byes		value			description
	--------------------------------------------------------------------
	1		CARD8			opcode
	1		5			function code
	2		8			request length
	28		?			unused

ControlModifiersUngrab		Unlock modifier state

	byes		value			description
	--------------------------------------------------------------------
	1		CARD8			opcode		
	1		6			function code
	2		8			request length
	28		?			unused

2.2. Events 

ControlModifiersNotify		Notification of modifier state change

	byes		value			description
	--------------------------------------------------------------------
	1		first-event		event number
	1		?			unused
	2		CARD16			sequence number
	4		CARD32			bitmask for changed modifiers
	4		CARD32			values for modifier states
	20		?			unused

2.3. Errors

ControlModifiersError		Errors

	byes		value			description
	--------------------------------------------------------------------
	1		0			Error
	1		first-errorcode		code
	2		CARD16			sequence number
	4		CARD32			bad sequence id
	2		CARD8			opcode
	1		CARD8			function code
	21		?			unused



3. C language binding

Bool
ControlModifiersQueryExtension(	dpy,
				event_base_return,
				error_base_return )
	Display *dpy;
	int	*event_base_return, *error_base_return;

Status
ControlModifiersGetVersion(	dpy,
				major_version_return,
				minor_version_return,
				report_mask_return,
				change_mask_return )
	Display *dpy;
	int *major_version_return;
	int *minor_version_return;
	unsigned long *report_mask_return;
	unsigned long *change_mask_return;

void
ControlModifiersSetMask( dpy, win, mask)
	Display *dpy;
	Window win;
	unsigned long mask;

Status
ControlModifiersGetMask(dpy, win, mask_return)
	Display *dpy;
	Window win;
	unsigned long *mask_return;

Status
ControlModifiersGetState(dpy, state_return)
	Display *dpy;
	unsigned long *state_return;

void
ControlModifiersChangeState(dpy, change, state)
	Display *dpy;
	unsigned long change;
	unsigned long state;

void
ControlModifiersGrab(dpy)
	Display *dpy;

void
ControlModifiersUngrab(dpy)
	Display *dpy;


4. X server implementation for this extension.

void
ControlModifiersExtensionInit()

	This function set up extension entry points and should be
	called from InitExtensions() function of
	<Xserver/mi/miinitext.c>

The functions listed below should be provided for X server and called
internally when needed.

ControlModifiersGetInfo(report, change)
CARD32 *report;		/* bitmask for notifiable modifiers */
CARD32 *change;		/* bitmask for changeable modifiers */
	Returns bitmask for notifiable modifiers and bitmask for
	changeable modifiers.

unsinged long
ControlModifiersGetState()
	Returns value of modifir states.

void
ControlModifiersChangeState(mask, state)
CARD32 mask;		/* bitmask for changing modifiers */
CARD32 state;		/* values for changing modifiers */
	Change modifiers state specified in the mask, according to the
	correspoindig values in the state.

void
ControlModifiersGrab()
	Stop changing of modifier state from keyboard.

void
ControlModifiersUngrab()
	Resume changing of modifier state form keyboard.

ControlModifiersNotify(mask, state)
CARD32 mask;		/* bitmask for changing modifiers */
CARD32 state;		/* values for changing modifiers */

	This function should change X server internal state so that it
	reflects state values for masked modifiers.

	This function should also generate appropriate notification
	for the change of modifier states.


