.TH getconfig 1 __vendorversion__
.SH NAME
getconfig - get configuration information for the __xservername__ server
.SH SYNOPSIS
.B getconfig
.RI [ option
.IR ... ]
.SH DESCRIPTION
.B getconfig
is a programmatic interface that is used by the
.B __xservername__
server to get configuration information about video hardware when
operating without an
.B __xconfigfile__
file.
.PP
This implementation of
.B getconfig
is written in perl.  It processes a prioritized and ordered list of
rules supplied internally and from meta-configuration files.  The rules
are in the form of perl expressions.
.B getconfig
writes to standard output the __xconfigfile__-style configuration data
specified by the last highest priority rule that evaluates to true.
Information about the format of the meta-configuration files can be
found in the getconfig(__filemansuffix__) manual page.
.SH OPTIONS
.TP 8
.BI \-I " search-path"
Specify the search path to use for meta-config files.
.I search-path
is a comma-separated list of directories to search.  Each directory in
the search path is searched for files with a
.I .cfg
suffix.  Each such file is opened and checked for a valid signature
string.  Rules are read from files with a valid signature string and
appended to the list of rules to evaluate.  If no search path is specified,
only the internally supplied configuration rules will be used.
.TP 8
.B \-D
Enable debugging output.
.TP 8
.B \-V
Print out the version information and exit.
.TP 8
.BI \-X 
.BI __xservername__-version
Specify the __xservername__ version in numeric (integer) form.
.TP 8
.BI \-b " subsys-id"
Specify the PCI subsystem ID of the video device.
.TP 8
.BI \-c " class"
Specify the PCI class of the video device.
.TP 8
.BI \-d " device-id"
Specify the PCI devide ID of the video device.
.TP 8
.BI \-r " revision"
Specify the PCI revision of the video device.
.TP 8
.BI \-s " subsysvendor-id"
Specify the PCI subsystem vendor ID of the video device.
.TP 8
.BI \-v " vendor-id"
Specify the PCI vendor ID of the video device.
.SH FILES
.I .cfg
files located in the search path.  The search path typically specified
by the
.B __xservername__
server is:
.PP
.RS 4
.nf
.I /etc/X11
.I __projectroot__/etc/X11
.I <modulepath>
.I __projectroot__/lib/X11/getconfig
.fi
.RE
.PP
where
.I <modulepath>
is the
.B __xservername__
server's module search path.

.SH "SEE ALSO"
getconfig(__filemansuffix__),
__xservername__(__appmansuffix__),
__xconfigfile__(__filemansuffix__).

.SH AUTHORS
The __xservername__ automatic configuration support and the
.B getconfig
interface was written by David H. Dawes, with the support of X-Oz
Technologies for XFree86.
