.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XNextEvent 3X11 "Release 6.4" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XNextEvent, XPeekEvent, XWindowEvent, XCheckWindowEvent, XMaskEvent, XCheckMaskEvent, XCheckTypedEvent, XCheckTypedWindowEvent \- select events by type
.SH SYNTAX
XNextEvent\^(\^\fIdisplay\fP, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.LP
XPeekEvent\^(\^\fIdisplay\fP, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.LP
XWindowEvent\^(\^\fIdisplay\fP, \fIw\fP\^, \fIevent_mask\fP\^, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      long \fIevent_mask\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.LP
Bool XCheckWindowEvent\^(\^\fIdisplay\fP, \fIw\fP\^, \fIevent_mask\fP\^, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      long \fIevent_mask\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.LP
XMaskEvent\^(\^\fIdisplay\fP, \fIevent_mask\fP\^, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      long \fIevent_mask\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.LP
Bool XCheckMaskEvent\^(\^\fIdisplay\fP, \fIevent_mask\fP\^, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      long \fIevent_mask\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.LP
Bool XCheckTypedEvent\^(\^\fIdisplay\fP, \fIevent_type\fP\^, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      int \fIevent_type\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.LP
Bool XCheckTypedWindowEvent\^(\^\fIdisplay\fP, \fIw\fP\^, \fIevent_type\fP\^, \fIevent_return\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      int \fIevent_type\fP\^;
.br
      XEvent *\fIevent_return\fP\^;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIevent_mask\fP 1i
Specifies the event mask.
.IP \fIevent_return\fP 1i
Returns the matched event's associated structure.
.IP \fIevent_return\fP 1i
Returns the next event in the queue.
.IP \fIevent_return\fP 1i
Returns a copy of the matched event's associated structure.
.IP \fIevent_type\fP 1i
Specifies the event type to be compared.

.ds Wi \ whose event uou are interested in
.IP \fIw\fP 1i
Specifies the window \*(Wi.
.SH DESCRIPTION
The
.ZN XNextEvent
function copies the first event from the event queue into the specified
.ZN XEvent
structure and then removes it from the queue.
If the event queue is empty,
.ZN XNextEvent
flushes the output buffer and blocks until an event is received.
.LP
The
.ZN XPeekEvent
function returns the first event from the event queue,
but it does not remove the event from the queue.
If the queue is empty,
.ZN XPeekEvent
flushes the output buffer and blocks until an event is received.
It then copies the event into the client-supplied
.ZN XEvent
structure without removing it from the event queue.
.LP
The
.ZN XWindowEvent
function searches the event queue for an event that matches both the specified
window and event mask.
When it finds a match,
.ZN XWindowEvent
removes that event from the queue and copies it into the specified
.ZN XEvent
structure.
The other events stored in the queue are not discarded.
If a matching event is not in the queue,
.ZN XWindowEvent
flushes the output buffer and blocks until one is received.
.LP
The
.ZN XCheckWindowEvent
function searches the event queue and then the events available 
on the server connection for the first event that matches the specified window
and event mask.
If it finds a match,
.ZN XCheckWindowEvent
removes that event, copies it into the specified
.ZN XEvent
structure, and returns
.ZN True .
The other events stored in the queue are not discarded.
If the event you requested is not available,
.ZN XCheckWindowEvent
returns
.ZN False ,
and the output buffer will have been flushed.
.LP
The
.ZN XMaskEvent
function searches the event queue for the events associated with the 
specified mask.
When it finds a match,
.ZN XMaskEvent
removes that event and copies it into the specified
.ZN XEvent
structure.
The other events stored in the queue are not discarded.
If the event you requested is not in the queue,
.ZN XMaskEvent
flushes the output buffer and blocks until one is received.
.LP
The
.ZN XCheckMaskEvent
function searches the event queue and then any events available on the
server connection for the first event that matches the specified mask.
If it finds a match,
.ZN XCheckMaskEvent
removes that event, copies it into the specified
.ZN XEvent
structure, and returns
.ZN True .
The other events stored in the queue are not discarded.
If the event you requested is not available,
.ZN XCheckMaskEvent
returns
.ZN False ,
and the output buffer will have been flushed.
.LP
The
.ZN XCheckTypedEvent
function searches the event queue and then any events available  
on the server connection for the first event that matches the specified type.
If it finds a match,
.ZN XCheckTypedEvent
removes that event, copies it into the specified
.ZN XEvent
structure, and returns
.ZN True .
The other events in the queue are not discarded.
If the event is not available,
.ZN XCheckTypedEvent
returns
.ZN False ,
and the output buffer will have been flushed.
.LP
The
.ZN XCheckTypedWindowEvent
function searches the event queue and then any events available  
on the server connection for the first event that matches the specified
type and window.
If it finds a match,
.ZN XCheckTypedWindowEvent
removes the event from the queue, copies it into the specified
.ZN XEvent
structure, and returns
.ZN True .
The other events in the queue are not discarded.
If the event is not available,
.ZN XCheckTypedWindowEvent
returns
.ZN False ,
and the output buffer will have been flushed.
.SH "SEE ALSO"
XAnyEvent(3X11),
XIfEvent(3X11),
XPutBackEvent(3X11),
XSendEvent(3X11)
.br
\fI\*(xL\fP
