/* $XConsortium: xkbctrl.c /main/7 1996/02/01 21:03:27 kaleb $ */
/************************************************************
Copyright (c) 1993 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include <ctype.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/XKBlib.h>

#include <X11/extensions/XKBfile.h>

#ifndef MINSHORT
#define	MINSHORT	-32767
#endif

#define	ON	 1
#define	OFF	 0
#define	IGNORE	-1

static	char		*dpyName = NULL;
static	unsigned	 which;
static	XkbControlsRec	 newCtrls;
static	unsigned	 changeInternal;
static	unsigned	 internal;
static	unsigned	 changeVInternal;
static	unsigned	 vInternal;
static	unsigned	 changeIgnoreLocks;
static	unsigned	 ignoreLocks;
static	unsigned	 changeVIgnoreLocks;
static	unsigned	 vIgnoreLocks;
static	unsigned	 changeEnabled;
static	unsigned	 enabled;
static	unsigned	 oldEnabled;
static	unsigned	 newGroupInfo;
static	int		 synch = 0;
static	int		 device = XkbUseCoreKbd;
static	unsigned	 debug = 0;
static	Bool		 autoReset = False;
static	Bool		 resetDelay = 0;

int
#if NeedFunctionPrototypes
parseMods(char *modText,int onOff,unsigned *changes,unsigned *mods)
#else
parseMods(modText,onOff,changes,mods)
    char *modText;
    int   onOff;
    unsigned *changes;
    unsigned *mods;
#endif
{
register char *tmp;

    for (tmp=modText;*tmp;tmp++) {
	if ((*tmp=='s')||(*tmp=='S')) {
	    *changes|= ShiftMask;
	    if (onOff)	*mods|= ShiftMask;
	    else	*mods&= ~ShiftMask;
	}
	if ((*tmp=='l')||(*tmp=='L')) {
	    *changes|= LockMask;
	    if (onOff)	*mods|= LockMask;
	    else	*mods&= ~LockMask;
	}
	if ((*tmp=='c')||(*tmp=='C')) {
	    *changes|= ControlMask;
	    if (onOff)	*mods|= ControlMask;
	    else	*mods&= ~ControlMask;
	}
	if ((*tmp=='a')||(*tmp=='A')||(*tmp=='m')||(*tmp=='M')||(*tmp=='1')) {
	    *changes|= Mod1Mask;
	    if (onOff)	*mods|= Mod1Mask;
	    else	*mods&= ~Mod1Mask;
	}
	if (*tmp=='2') {
	    *changes|= Mod2Mask;
	    if (onOff)	*mods|= Mod2Mask;
	    else	*mods&= ~Mod2Mask;
	}
	if (*tmp=='3') {
	    *changes|= Mod3Mask;
	    if (onOff)	*mods|= Mod3Mask;
	    else	*mods&= ~Mod3Mask;
	}
	if (*tmp=='4') {
	    *changes|= Mod4Mask;
	    if (onOff)	*mods|= Mod4Mask;
	    else	*mods&= ~Mod2Mask;
	}
	if (*tmp=='5') {
	    *changes|= Mod5Mask;
	    if (onOff)	*mods|= Mod5Mask;
	    else	*mods&= ~Mod5Mask;
	}
    }
    return 1;
}

int
#if NeedFunctionPrototypes
parseVMods(char *modText,int onOff,unsigned *changes,unsigned *mods)
#else
parseVMods(modText,onOff,changes,mods)
    char *modText;
    int   onOff;
    unsigned *changes;
    unsigned *mods;
#endif
{
register char *tmp;

    for (tmp=modText;*tmp;tmp++) {
	if (isdigit(*tmp)) {
	    int ndx= *tmp-'0';
	    *changes|= (1<<ndx);
	    if (onOff)	*mods|= (1<<ndx);
	    else	*mods&= ~(1<<ndx);
	}
	else if ( (*tmp>='a') && (*tmp<='f') ) {
	    int ndx= 10+(*tmp-'a');
	    *changes|= (1<<ndx);
	    if (onOff)	*mods|= (1<<ndx);
	    else	*mods&= ~(1<<ndx);
	}
	else if ( (*tmp>='A') && (*tmp<='F') ) {
	    int ndx= 10+(*tmp-'F');
	    *changes|= (1<<ndx);
	    if (onOff)	*mods|= (1<<ndx);
	    else	*mods&= ~(1<<ndx);
	}
    }
    return 1;
}

#define	E(m)	fprintf(stderr,m)
void
#if NeedFunctionPrototypes
usage(int argc,char *argv[])
#else
usage(argc,argv)
    int argc;
    char *argv[];
#endif
{
    fprintf(stderr,"Usage: %s <options>\n",argv[0]);
    E("Where legal options are:\n");
    E("-display <dpy>                 specifies display to use\n");
    E("[+-]synch                      synchonize on/off\n");
    E("+clamp                         group clamp on/off\n");
    E("-debug                         enable debugging output\n");
    E("-device  <id>                  specifies device to use\n");
    E("+wrap                          group wrap on/off\n");
    E("[+-]bell                       audible bell on/off\n");
    E("[+-]autoautorepeat             automatic determination of repeating keys on/off\n");
    E("[+-]internal <mods>            set/clear internal modifiers\n");
    E("[+-]ignorelock <mods>          set/clear ignore locks modifiers\n");
    E("                               <mods> can contain one or more of:\n");
    E("                               s:         Shift\n");
    E("                               l:         Lock\n");
    E("                               c:         Control\n");
    E("                               [am]:      Alt/Meta (mod1)\n");
    E("                               [1-5]:     Mod1-Mod5\n");
    E("[+-]ignoregrouplock            set/clear ignore group lock control\n");
    E("[+-]vinternal <vmods>          set/clear internal virtual modifiers\n");
    E("[+-]vignorelock <vmods>        set/clear ignore locks virtual mods\n");
    E("                               virtual modifiers are specified by\n");
    E("                               using one hexadecimal digit per vmod\n");
    E("+redirect <group>              redirect illegal groups to <group>\n");
    E("-repeat                        disable RepeatKeys\n");
    E("+repeat [ delay [ ival ] ]     enable RepeatKeys with specified delay\n");
    E("                               and interval\n");
    E("-slow                          disable SlowKeys\n");
    E("+slow [ delay ]                enable SlowKeys with the specified delay\n");
    E("-bounce                        disable BounceKeys\n");
    E("+bounce [timeout]              enable BounceKeys with the specified timeout\n");
    E("[+-]sticky                     enable/disable sticky keys\n");
    E("-mouse                         disable MouseKeys\n");
    E("+mouse [ button ]              enable mouse keys with the specified behavior\n");
    E("-accel                         disable MouseKeys acceleration\n");
    E("+accel [ delay [ ival [ time-to-max [ max-speed [ curve ] ] ] ] ]\n");
    E("                               enable acceleration with the specified values\n");
    E("-accessx                       disable AccessX hotkeys\n");
    E("+accessx [options]             enable AccessX hotkeys with specified\n");
    E("                               options\n");
    E("-axtimeout                     disable AccessX timeout\n");
    E("+axtimeout  [ delay [ ctrls[/ctrl_values] [ opts[/opts_values] ] ] ]\n");
    E("                               enable AccessX timeout with specified\n");
    E("                               delay controls aand option\n");
    E("-feedback                      disable automatic AccessX feedback\n");
    E("+feedback                      enable automatic AccessX feedback\n");
    E("-overlay[12]                   disable specified keyboard overlay\n");
    E("+overlay[12]                   enable specified keyboard overlay\n");
    E("+reset [ delay ]               changes to enabled controls reset\n");
    E("                               automatically when xkbctrl exits.  If\n");
    E("                               <delay> is specified, xkbctrl exits\n");
    E("                               after <delay> seconds, the default.\n");
    E("                               delay is 60 seconds\n");
}

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int argc;
    char *argv[];
#endif
{
int i;
int onoff;

    for (i=1;i<argc;i++) {
	 if (argv[i][0]=='-')		onoff= 0;
	 else if (argv[i][0]=='+')	onoff= 1;
	 else {
	     fprintf(stderr,"Options must start with '+' or '-'\n");
	     return 0;
	 }
	 if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-debug")==0 ) {
	    debug= 1;
	}
	else if ( strcmp(argv[i],"-device")==0 ) {
	    if (( (i+1)<argc ) && isdigit(argv[i+1][0]))
		device= atoi(argv[++i]);
	    else {
		fprintf(stderr,"Must specify an id with -device option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"+wrap")==0 ) {
	    which|= XkbGroupsWrapMask;
	    newGroupInfo= XkbSetGroupInfo(0,XkbWrapIntoRange,0);
	}
	else if ( strcmp(argv[i],"+clamp")==0 ) {
	    which|= XkbGroupsWrapMask;
	    newGroupInfo= XkbSetGroupInfo(0,XkbClampIntoRange,0);
	}
	else if ( strcmp(argv[i],"+redirect")==0 ) {
	    int target;
	    which|= XkbGroupsWrapMask;
	    if (((i+1)>=argc) ||
		(sscanf(argv[i+1],"%d",&target)!=1)) {
		fprintf(stderr,"Must specify the target group\n");
		return 0;
	    }
	    else if ((target<1)||(target>XkbNumKbdGroups)) {
		fprintf(stderr,"Target group must be 1..%d\n",XkbNumKbdGroups);
	    }
	    newGroupInfo= XkbSetGroupInfo(0,XkbRedirectIntoRange,target-1);
	    i++;
	}
	else if ( strcmp(&argv[i][1],"synch")==0 ) {
	    synch= onoff;
	}
	else if ( strcmp(&argv[i][1],"bell")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbAudibleBellMask;
	    if (onoff)	enabled|= XkbAudibleBellMask;
	    else	enabled&= ~XkbAudibleBellMask;
	}
	else if ( strcmp(&argv[i][1],"internal")==0 ) {
	    which|= XkbInternalModsMask;
	    if (((i+1)>=argc) ||
		(!parseMods(argv[i+1],onoff,&changeInternal,&internal))) {
		fprintf(stderr,"Must specify the internal modifiers\n");
		return 0;
	    }
	    i++;
	}
	else if ( strcmp(&argv[i][1],"ignorelock")==0 ) {
	    which|= XkbIgnoreLockModsMask;
	    if (((i+1)>=argc) || (!parseMods(argv[i+1],onoff,&changeIgnoreLocks,
							&ignoreLocks))) {
		fprintf(stderr,"Must specify the ignore lock modifiers\n");
		return 0;
	    }
	    i++;
	}
	else if ( strcmp(&argv[i][1],"ignoregrouplock")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbIgnoreGroupLockMask;
	    enabled|= (onoff?XkbIgnoreGroupLockMask:0);
	}
	else if ( strcmp(&argv[i][1],"vinternal")==0 ) {
	    which|= XkbInternalModsMask;
	    if (((i+1)>=argc) ||
		(!parseVMods(argv[i+1],onoff,&changeVInternal,&vInternal))) {
		fprintf(stderr,"Must specify the internal virtual modifiers\n");
		return 0;
	    }
	    i++;
	}
	else if ( strcmp(&argv[i][1],"vignorelock")==0 ) {
	    which|= XkbIgnoreLockModsMask;
	    if (((i+1)>=argc) || (!parseVMods(argv[i+1],onoff,
					&changeVIgnoreLocks,&vIgnoreLocks))) {
		fprintf(stderr,"Must specify the ignore lock virtual mods\n");
		return 0;
	    }
	    i++;
	}
	else if ( strcmp(&argv[i][1],"repeat")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbRepeatKeysMask;
	    enabled|= (onoff?XkbRepeatKeysMask:0);
	    if (onoff) {
		int ok= 0;
		if ( ((i+1)<argc) && (isdigit(argv[i+1][0])) ) {
		    which|= XkbRepeatKeysMask;
		    newCtrls.repeat_delay= atoi(argv[++i]);
		    ok= 1;
		}
		if (ok && ((i+1)<argc) && (isdigit(argv[i+1][0]))) {
		    newCtrls.repeat_interval= atoi(argv[++i]);
		}
	    }
	}
	else if ( strcmp(&argv[i][1],"slow")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbSlowKeysMask;
	    enabled|= (onoff?XkbSlowKeysMask:0);
	    if (onoff) {
		if ( ((i+1)<argc) && (isdigit(argv[i+1][0])) ) {
		    which|= XkbSlowKeysMask;
		    newCtrls.slow_keys_delay= atoi(argv[++i]);
		}
	    }
	}
	else if ( strcmp(&argv[i][1],"bounce")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbBounceKeysMask;
	    enabled|= (onoff?XkbBounceKeysMask:0);
	    if (onoff) {
		if ( ((i+1)<argc) && (isdigit(argv[i+1][0])) ) {
		    which|= XkbBounceKeysMask;
		    newCtrls.debounce_delay= atoi(argv[++i]);
		}
	    }
	}
	else if ( strcmp(&argv[i][1],"sticky")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbStickyKeysMask;
	    enabled|= (onoff?XkbStickyKeysMask:0);
	}
	else if ( strcmp(&argv[i][1],"mouse")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbMouseKeysMask;
	    enabled|= (onoff?XkbMouseKeysMask:0);
	    if (onoff) {
		if (((i+1)<argc) && (isdigit(argv[i+1][0]))) {
		    which|= XkbMouseKeysMask;
		    newCtrls.mk_dflt_btn= atoi(argv[++i]);
		}
	    }
	}
	else if ( strcmp(&argv[i][1],"accel")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbMouseKeysAccelMask;
	    enabled|= (onoff?XkbMouseKeysAccelMask:0);
	    if (onoff) {
		int ok= 0;
		char *arg;
		if ( ((i+1)<argc) && (isdigit(argv[i+1][0])) ) {
		    which|= XkbMouseKeysAccelMask;
		    newCtrls.mk_delay= atoi(argv[++i]);
		    ok= 1;
		}
		if (ok && ((i+1)<argc) && (isdigit(argv[i+1][0]))) {
		    newCtrls.mk_interval= atoi(argv[++i]);
		}
		if (ok && ((i+1)<argc) && (isdigit(argv[i+1][0]))) {
		    newCtrls.mk_time_to_max= atoi(argv[++i]);
		}
		if (ok && ((i+1)<argc) && (isdigit(argv[i+1][0]))) {
		    newCtrls.mk_max_speed= atoi(argv[++i]);
		}
		arg= argv[i+1];
		if (ok && ((i+1)<argc) && 
			((isdigit(arg[0]))||((arg[0]=='-')&&(isdigit(arg[1])))))
		     newCtrls.mk_curve= atoi(argv[++i]);
		else newCtrls.mk_curve= MINSHORT;
	    }
	}
	else if ( strcmp(&argv[i][1],"accessx")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbAccessXKeysMask;
	    enabled|= (onoff?XkbAccessXKeysMask:0);
	    if (onoff) {
		if ( ((i+1)<argc) && (isdigit(argv[i+1][0])) ) {
		    int tmp;
		    if (sscanf(argv[++i],"%i",&tmp)) {
			which|= XkbAccessXKeysMask;
			newCtrls.ax_options= tmp;
		    }
		}
	    }
	}
	else if ( strcmp(&argv[i][1],"axtimeout")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbAccessXTimeoutMask;
	    enabled|= (onoff?XkbAccessXTimeoutMask:0);
	    if (onoff) {
		int ok= 0;
		if ( ((i+1)<argc) && (isdigit(argv[i+1][0])) ) {
		    int tmp;
		    if (sscanf(argv[++i],"%i",&tmp)>0) {
			which|= XkbAccessXTimeoutMask;
			newCtrls.ax_timeout= tmp;
			ok= 1;
		    }
		}
		if ( ok && ((i+1)<argc) && isdigit(argv[i+1][0]) ) {
		    int mask,vals;
		    mask=vals= 0;
		    if (sscanf(argv[++i],"%i/%i",&mask,&vals)>0) {
			newCtrls.axt_ctrls_mask= mask&XkbAllBooleanCtrlsMask;
			newCtrls.axt_ctrls_values= vals;
		    }
		}
		else newCtrls.axt_ctrls_mask= ~0;
		if ( ok && ((i+1)<argc) && isdigit(argv[i+1][0]) ) {
		    int mask,vals;
		    if (sscanf(argv[++i],"%i/%i",&mask,&vals)>0) {
			newCtrls.axt_opts_mask= mask&(~XkbAX_AllOptionsMask);
			newCtrls.axt_opts_values= vals;
		    }
		}
		else newCtrls.axt_opts_mask= ~0;
	    }
	}
	else if ( strcmp(&argv[i][1],"feedback")==0 ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbAccessXFeedbackMask;
	    enabled|= (onoff?XkbAccessXFeedbackMask:0);
	}
	else if ( strcmp(&argv[i][1],"overlay1")==0  ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbOverlay1Mask;
	    enabled|= (onoff?XkbOverlay1Mask:0);
	}
	else if ( strcmp(&argv[i][1],"overlay2")==0  ) {
	    which|= XkbControlsEnabledMask;
	    changeEnabled|= XkbOverlay2Mask;
	    enabled|= (onoff?XkbOverlay2Mask:0);
	}
	else if ( strcmp(argv[i],"+reset")==0 ) {
	    autoReset= True;
	    if (((i+1)<argc) && (isdigit(argv[i+1][0]))) {
	  	 resetDelay= atoi(argv[++i]);
	    }
	    else resetDelay= 60;
	}
	else if ( strcmp(argv[i],"-help") ) {
	    return 0;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    return 1;
}

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int argc;
    char *argv[];
#endif
{
Display	*dpy;
int	major,minor,why;
XkbDescRec	*xkb;
XkbControlsRec	*ctrls;
  
    if (!parseArgs(argc,argv)) {
	usage(argc,argv);
	return 1;
    }
    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy = XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&why);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
        switch (why) {
            case XkbOD_BadLibraryVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Xlib supports incompatible version %d.%02d\n",
                                major,minor);
                break;
            case XkbOD_ConnectionRefused:
                fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
                break;
            case XkbOD_NonXkbServer:
                fprintf(stderr,"XKB extension not present on %s\n",dpyName);
                break;
            case XkbOD_BadServerVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
                                dpyName,major,minor);
                break;
            default:
                fprintf(stderr,
		    "Internal Error! Unknown error %d from XkbOpenDisplay\n",
		    why);
        }
	return 1;
    }
    if (synch)
	XSynchronize(dpy,1);
    xkb = XkbGetMap(dpy,0,device);
    if (xkb) {
	if (XkbGetControls(dpy,XkbAllControlsMask,xkb)!=Success) {
	    fprintf(stderr,"XkbGetControls failed\n");
	    goto BAIL;
	}
	ctrls= xkb->ctrls;
	oldEnabled= ctrls->enabled_ctrls;
	if (XkbGetNames(dpy,XkbAllNamesMask,xkb)!=Success) {
	    fprintf(stderr,"Warning:  Couldn't get symbolic names\n");
	}
	if (which) {
	    if (which&XkbRepeatKeysMask) {
		fprintf(stderr,"Changing RepeatKeys delay%s",
			newCtrls.repeat_interval>0?" and interval\n":"\n");
		ctrls->repeat_delay= newCtrls.repeat_delay;
		if (newCtrls.repeat_interval>0)
		    ctrls->repeat_interval= newCtrls.repeat_interval;
	    }
	    if (which&XkbSlowKeysMask) {
		fprintf(stderr,"Changing SlowKeys delay\n");
		ctrls->slow_keys_delay= newCtrls.slow_keys_delay;
	    }
	    if (which&XkbBounceKeysMask) {
		fprintf(stderr,"Changing BounceKeys delay\n");
		ctrls->debounce_delay= newCtrls.debounce_delay;
	    }
	    if (which&XkbMouseKeysMask) {
		fprintf(stderr,"Changing MouseKeys default button\n");
		ctrls->mk_dflt_btn= newCtrls.mk_dflt_btn;
	    }
	    if (which&XkbMouseKeysAccelMask) {
		fprintf(stderr,"Changing MouseKeysAccel delay");
		ctrls->mk_delay= newCtrls.mk_delay;
		if (newCtrls.mk_interval>0) {
		    fprintf(stderr,", interval");
		    ctrls->mk_interval= newCtrls.mk_interval;
		}
		if (newCtrls.mk_time_to_max>0) {
		    fprintf(stderr,", time-to-max");
		    ctrls->mk_time_to_max= newCtrls.mk_time_to_max;
		}
		if (newCtrls.mk_max_speed>0) {
		    fprintf(stderr,", speed");
		    ctrls->mk_max_speed= newCtrls.mk_max_speed;
		}
		if (newCtrls.mk_curve!=MINSHORT) {
		    fprintf(stderr,", curve");
		    ctrls->mk_curve= newCtrls.mk_curve;
		}
		fprintf(stderr,"\n");
	    }
	    if (which&XkbGroupsWrapMask) {
	 	fprintf(stderr,"Changing out of range group behavior\n");
		ctrls->groups_wrap= newGroupInfo;
	    }
	    if (which&XkbAccessXKeysMask) {
		fprintf(stderr,"Changing AccessX options\n");
		ctrls->ax_options= newCtrls.ax_options;
	    }
	    if (which&XkbAccessXTimeoutMask) {
		fprintf(stderr,"Changing AccessX timeout");
		ctrls->ax_timeout= newCtrls.ax_timeout;
		if ((newCtrls.axt_ctrls_mask&(~XkbAllBooleanCtrlsMask))==0){
		    fprintf(stderr,", controls");
		    ctrls->axt_ctrls_mask= newCtrls.axt_ctrls_mask;
		    ctrls->axt_ctrls_values= newCtrls.axt_ctrls_values;
		}
		if ((newCtrls.axt_opts_mask&(~XkbAX_AllOptionsMask))==0) {
		    fprintf(stderr,", options");
		    ctrls->axt_opts_mask= newCtrls.axt_opts_mask;
		    ctrls->axt_opts_values= newCtrls.axt_opts_values;
		}
		fprintf(stderr,"\n");
	    }
	    if (which&XkbControlsEnabledMask) {
		fprintf(stderr,"Changing enabled controls\n");
		ctrls->enabled_ctrls&= ~changeEnabled;
		ctrls->enabled_ctrls|= (changeEnabled&enabled);
	    }
	    if (which&XkbInternalModsMask) {
		fprintf(stderr,"Changing internal modifiers\n");
		ctrls->internal.real_mods&= ~changeInternal;
		ctrls->internal.real_mods|= (changeInternal|internal);
		ctrls->internal.vmods&= ~changeVInternal;
		ctrls->internal.vmods|= 
					(changeVInternal&vInternal);
	    }
	    if (which&XkbIgnoreLockModsMask) {
		fprintf(stderr,"Changing ignore locks modifiers\n");
		ctrls->ignore_lock.real_mods&= ~changeIgnoreLocks;
		ctrls->ignore_lock.real_mods|=
					(changeIgnoreLocks|ignoreLocks);
		ctrls->ignore_lock.vmods&= ~changeVIgnoreLocks;
		ctrls->ignore_lock.vmods|=
					(changeVIgnoreLocks&vIgnoreLocks);
	    }
	    XkbSetControls(dpy,which,xkb);
	}
    }
    else {
	fprintf(stderr,"Get keyboard description request failed\n");
	return 1;
    }
    ctrls= xkb->ctrls;
    printf("Device ID:         %d\n",xkb->device_spec);
    printf("Groups:            %d group%s,",ctrls->num_groups,
					((ctrls->num_groups>1)?"s":""));
    switch (XkbOutOfRangeGroupAction(ctrls->groups_wrap)) {
	case XkbWrapIntoRange:	
	    printf("wrap\n");
	    break;
	case XkbClampIntoRange:	
	    printf("clamp\n");
	    break;
	case XkbRedirectIntoRange:
	    printf("redirect to group%d\n",
				XkbOutOfRangeGroupNumber(ctrls->groups_wrap)+1);
	    break;
	default:
	    printf("ILLEGAL!!\n");
	    break;
    }
    printf("audible bell:      %s\n",
		(ctrls->enabled_ctrls&XkbAudibleBellMask)?"on ":"off");
    printf("internal mask:     %s\n",
		XkbModMaskText(ctrls->internal.mask,XkbMessage));
    printf("internal mods:     %s\n",
		XkbVModMaskText(dpy,xkb,
				ctrls->internal.real_mods,ctrls->internal.vmods,
				XkbMessage));
    printf("ignore lock mask:  %s\n",
		XkbModMaskText(ctrls->ignore_lock.mask,XkbMessage));
    printf("ignore lock mods:  %s\n",
		XkbVModMaskText(dpy,xkb,
				ctrls->ignore_lock.real_mods,
				ctrls->ignore_lock.vmods,
				XkbMessage));
    printf("ignore group lock: %s\n",
		(ctrls->enabled_ctrls&XkbIgnoreGroupLockMask?"on":"off"));
    printf("repeat keys:       %s (%d/%d)\n",
		(ctrls->enabled_ctrls&XkbRepeatKeysMask?"on ":"off"),
		ctrls->repeat_delay,ctrls->repeat_interval);
    printf("slow keys:         %s (%d)\n",
		(ctrls->enabled_ctrls&XkbSlowKeysMask?"on ":"off"),
		ctrls->slow_keys_delay);
    printf("bounce keys:       %s (%d)\n",
		(ctrls->enabled_ctrls&XkbBounceKeysMask?"on ":"off"),
		ctrls->debounce_delay);
    printf("sticky keys:       %s\n",
		(ctrls->enabled_ctrls&XkbStickyKeysMask?"on ":"off"));
    printf("mouse keys:        %s (btn=%d)\n",
		(ctrls->enabled_ctrls&XkbMouseKeysMask?"on ":"off"),
		ctrls->mk_dflt_btn);
    printf("mouse keys accel:  %s (%d/%d/%d/%d/%d)\n",
		(ctrls->enabled_ctrls&XkbMouseKeysAccelMask?"on ":"off"),
		ctrls->mk_delay, ctrls->mk_interval,
		ctrls->mk_time_to_max, ctrls->mk_max_speed, ctrls->mk_curve);
    printf("accessX keys:      %s (0x%02x)\n",
		(ctrls->enabled_ctrls&XkbAccessXKeysMask?"on ":"off"),
		ctrls->ax_options);
    printf("accessX timeout:   %s (timeout=%d)\n",
		(ctrls->enabled_ctrls&XkbAccessXTimeoutMask?"on ":"off"),
		ctrls->ax_timeout);
    printf("                   controls: 0x%x/0x%x, options 0x%x/0x%x\n",
		ctrls->axt_ctrls_mask,ctrls->axt_ctrls_values,
		ctrls->axt_opts_mask,ctrls->axt_opts_values);
    printf("accessX feedback:  %s\n",
		(ctrls->enabled_ctrls&XkbAccessXFeedbackMask?"on ":"off"));
    printf("overlay 1:         %s\n",
    		(ctrls->enabled_ctrls&XkbOverlay1Mask?"on":"off"));
    printf("overlay 2:         %s\n",
    		(ctrls->enabled_ctrls&XkbOverlay2Mask?"on":"off"));
    fflush(stdout);
    if ((autoReset) && (changeEnabled)) {
	unsigned ctrlsToReset,valuesToReset;
	ctrlsToReset= changeEnabled;
	valuesToReset= oldEnabled&changeEnabled;
	if (XkbSetAutoResetControls(dpy,XkbAllControlsMask,
						&ctrlsToReset,&valuesToReset)) {
	    printf("Setting enabled controls to reset on exit in %d seconds\n",
								resetDelay);
	    printf("Sleeping...");
	    fflush(stdout);
	    sleep(resetDelay);
	    printf("Done.  Exiting.\n");
	}
	else {
	    printf("Error setting enabled controls to reset on exit!\n");
	}
    }
    fflush(stdout);
    XCloseDisplay(dpy);
    return 0;
BAIL:
    XCloseDisplay(dpy);
    return 0;
}
