
/***
 ***  NOTE!!!  DO NOT EDIT THIS FILE!!!  IT IS GENERATED BY get_gen.py
 ***/

#include "main/glheader.h"
#include "main/context.h"
#include "main/enable.h"
#include "main/extensions.h"
#include "main/fbobject.h"
#include "main/get.h"
#include "main/macros.h"
#include "main/mtypes.h"
#include "main/state.h"
#include "main/texcompress.h"


/* ES1 tokens that should be in gl.h but aren't */
#define GL_MAX_ELEMENTS_INDICES             0x80E9
#define GL_MAX_ELEMENTS_VERTICES            0x80E8


/* ES2 special tokens */
#define GL_MAX_FRAGMENT_UNIFORM_VECTORS     0x8DFD
#define GL_MAX_VARYING_VECTORS              0x8DFC
#define GL_MAX_VARYING_VECTORS              0x8DFC
#define GL_MAX_VERTEX_UNIFORM_VECTORS       0x8DFB
#define GL_SHADER_COMPILER                  0x8DFA
#define GL_PLATFORM_BINARY                  0x8D63
#define GL_SHADER_BINARY_FORMATS            0x8DF8
#define GL_NUM_SHADER_BINARY_FORMATS        0x8DF9


#ifndef GL_OES_matrix_get
#define GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES               0x898D
#define GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES              0x898E
#define GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES                 0x898F
#endif

#ifndef GL_OES_compressed_paletted_texture
#define GL_PALETTE4_RGB8_OES                                    0x8B90
#define GL_PALETTE4_RGBA8_OES                                   0x8B91
#define GL_PALETTE4_R5_G6_B5_OES                                0x8B92
#define GL_PALETTE4_RGBA4_OES                                   0x8B93
#define GL_PALETTE4_RGB5_A1_OES                                 0x8B94
#define GL_PALETTE8_RGB8_OES                                    0x8B95
#define GL_PALETTE8_RGBA8_OES                                   0x8B96
#define GL_PALETTE8_R5_G6_B5_OES                                0x8B97
#define GL_PALETTE8_RGBA4_OES                                   0x8B98
#define GL_PALETTE8_RGB5_A1_OES                                 0x8B99
#endif


#define FLOAT_TO_BOOLEAN(X)   ( (X) ? GL_TRUE : GL_FALSE )

#define INT_TO_BOOLEAN(I)     ( (I) ? GL_TRUE : GL_FALSE )

#define BOOLEAN_TO_INT(B)     ( (GLint) (B) )
#define BOOLEAN_TO_FLOAT(B)   ( (B) ? 1.0F : 0.0F )


/*
 * Check if named extension is enabled, if not generate error and return.
 */
#define CHECK_EXT1(EXT1, FUNC)                                         \
   if (!ctx->Extensions.EXT1) {                                        \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }

/*
 * Check if either of two extensions is enabled.
 */
#define CHECK_EXT2(EXT1, EXT2, FUNC)                                   \
   if (!ctx->Extensions.EXT1 && !ctx->Extensions.EXT2) {               \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }

/*
 * Check if either of three extensions is enabled.
 */
#define CHECK_EXT3(EXT1, EXT2, EXT3, FUNC)                             \
   if (!ctx->Extensions.EXT1 && !ctx->Extensions.EXT2 &&               \
       !ctx->Extensions.EXT3) {                                        \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }

/*
 * Check if either of four extensions is enabled.
 */
#define CHECK_EXT4(EXT1, EXT2, EXT3, EXT4, FUNC)                       \
   if (!ctx->Extensions.EXT1 && !ctx->Extensions.EXT2 &&               \
       !ctx->Extensions.EXT3 && !ctx->Extensions.EXT4) {               \
      _mesa_error(ctx, GL_INVALID_ENUM, FUNC "(0x%x)", (int) pname);  \
      return;                                                          \
   }



/**
 * List of compressed texture formats supported by ES.
 */
static GLenum compressed_formats[] = {
   GL_PALETTE4_RGB8_OES,
   GL_PALETTE4_RGBA8_OES,
   GL_PALETTE4_R5_G6_B5_OES,
   GL_PALETTE4_RGBA4_OES,
   GL_PALETTE4_RGB5_A1_OES,
   GL_PALETTE8_RGB8_OES,
   GL_PALETTE8_RGBA8_OES,
   GL_PALETTE8_R5_G6_B5_OES,
   GL_PALETTE8_RGBA4_OES,
   GL_PALETTE8_RGB5_A1_OES
};

#define ARRAY_SIZE(A)  (sizeof(A) / sizeof(A[0]))


void GLAPIENTRY
_mesa_GetBooleanv( GLenum pname, GLboolean *params )
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END(ctx);

   if (!params)
      return;

   if (ctx->NewState)
      _mesa_update_state(ctx);

   switch (pname) {
      case GL_ALPHA_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.alphaBits);
         break;
      case GL_BLEND:
         params[0] = ctx->Color.BlendEnabled;
         break;
      case GL_BLEND_SRC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLUE_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.blueBits);
         break;
      case GL_COLOR_CLEAR_VALUE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[2]);
         params[3] = FLOAT_TO_BOOLEAN(ctx->Color.ClearColor[3]);
         break;
      case GL_COLOR_WRITEMASK:
         params[0] = INT_TO_BOOLEAN(ctx->Color.ColorMask[RCOMP] ? 1 : 0);
         params[1] = INT_TO_BOOLEAN(ctx->Color.ColorMask[GCOMP] ? 1 : 0);
         params[2] = INT_TO_BOOLEAN(ctx->Color.ColorMask[BCOMP] ? 1 : 0);
         params[3] = INT_TO_BOOLEAN(ctx->Color.ColorMask[ACOMP] ? 1 : 0);
         break;
      case GL_CULL_FACE:
         params[0] = ctx->Polygon.CullFlag;
         break;
      case GL_CULL_FACE_MODE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Polygon.CullFaceMode);
         break;
      case GL_DEPTH_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.depthBits);
         break;
      case GL_DEPTH_CLEAR_VALUE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Depth.Clear);
         break;
      case GL_DEPTH_FUNC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Depth.Func);
         break;
      case GL_DEPTH_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Viewport.Near);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Viewport.Far);
         break;
      case GL_DEPTH_TEST:
         params[0] = ctx->Depth.Test;
         break;
      case GL_DEPTH_WRITEMASK:
         params[0] = ctx->Depth.Mask;
         break;
      case GL_DITHER:
         params[0] = ctx->Color.DitherFlag;
         break;
      case GL_FRONT_FACE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Polygon.FrontFace);
         break;
      case GL_GREEN_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.greenBits);
         break;
      case GL_LINE_WIDTH:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Line.Width);
         break;
      case GL_ALIASED_LINE_WIDTH_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Const.MinLineWidth);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Const.MaxLineWidth);
         break;
      case GL_MAX_ELEMENTS_INDICES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_ELEMENTS_VERTICES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_TEXTURE_SIZE:
         params[0] = INT_TO_BOOLEAN(1 << (ctx->Const.MaxTextureLevels - 1));
         break;
      case GL_MAX_VIEWPORT_DIMS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxViewportWidth);
         params[1] = INT_TO_BOOLEAN(ctx->Const.MaxViewportHeight);
         break;
      case GL_PACK_ALIGNMENT:
         params[0] = INT_TO_BOOLEAN(ctx->Pack.Alignment);
         break;
      case GL_ALIASED_POINT_SIZE_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Const.MinPointSize);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Const.MaxPointSize);
         break;
      case GL_POLYGON_OFFSET_FACTOR:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Polygon.OffsetFactor );
         break;
      case GL_POLYGON_OFFSET_UNITS:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Polygon.OffsetUnits );
         break;
      case GL_RED_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.redBits);
         break;
      case GL_SCISSOR_BOX:
         params[0] = INT_TO_BOOLEAN(ctx->Scissor.X);
         params[1] = INT_TO_BOOLEAN(ctx->Scissor.Y);
         params[2] = INT_TO_BOOLEAN(ctx->Scissor.Width);
         params[3] = INT_TO_BOOLEAN(ctx->Scissor.Height);
         break;
      case GL_SCISSOR_TEST:
         params[0] = ctx->Scissor.Enabled;
         break;
      case GL_STENCIL_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.stencilBits);
         break;
      case GL_STENCIL_CLEAR_VALUE:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.Clear);
         break;
      case GL_STENCIL_FAIL:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.FailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_FUNC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.Function[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.ZFailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_BOOLEAN(ctx->Stencil.ZPassFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_REF:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.Ref[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_TEST:
         params[0] = ctx->Stencil.Enabled;
         break;
      case GL_STENCIL_VALUE_MASK:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.ValueMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_WRITEMASK:
         params[0] = INT_TO_BOOLEAN(ctx->Stencil.WriteMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_SUBPIXEL_BITS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.SubPixelBits);
         break;
      case GL_TEXTURE_BINDING_2D:
         params[0] = INT_TO_BOOLEAN(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_2D_INDEX]->Name);
         break;
      case GL_UNPACK_ALIGNMENT:
         params[0] = INT_TO_BOOLEAN(ctx->Unpack.Alignment);
         break;
      case GL_VIEWPORT:
         params[0] = INT_TO_BOOLEAN(ctx->Viewport.X);
         params[1] = INT_TO_BOOLEAN(ctx->Viewport.Y);
         params[2] = INT_TO_BOOLEAN(ctx->Viewport.Width);
         params[3] = INT_TO_BOOLEAN(ctx->Viewport.Height);
         break;
      case GL_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(GL_TEXTURE0_ARB + ctx->Texture.CurrentUnit);
         break;
      case GL_TEXTURE_BINDING_CUBE_MAP_ARB:
         params[0] = INT_TO_BOOLEAN(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_CUBE_INDEX]->Name);
         break;
      case GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB:
         params[0] = INT_TO_BOOLEAN((1 << (ctx->Const.MaxCubeTextureLevels - 1)));
         break;
      case GL_BLEND_SRC_RGB_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLEND_DST_RGB_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendDstRGB);
         break;
      case GL_BLEND_SRC_ALPHA_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendSrcA);
         break;
      case GL_BLEND_DST_ALPHA_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendDstA);
         break;
      case GL_BLEND_EQUATION:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendEquationRGB );
         break;
      case GL_BLEND_EQUATION_ALPHA_EXT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendEquationA );
         break;
      case GL_SAMPLE_ALPHA_TO_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.SampleAlphaToCoverage;
         break;
      case GL_SAMPLE_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.SampleCoverage;
         break;
      case GL_SAMPLE_COVERAGE_VALUE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = FLOAT_TO_BOOLEAN(ctx->Multisample.SampleCoverageValue);
         break;
      case GL_SAMPLE_COVERAGE_INVERT_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.SampleCoverageInvert;
         break;
      case GL_SAMPLE_BUFFERS_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.sampleBuffers);
         break;
      case GL_SAMPLES_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Visual.samples);
         break;
      case GL_GENERATE_MIPMAP_HINT_SGIS:
         CHECK_EXT1(SGIS_generate_mipmap, "_mesa_GetBooleanv");
         params[0] = ENUM_TO_BOOLEAN(ctx->Hint.GenerateMipmap);
         break;
      case GL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayBufferObj->Name);
         break;
      case GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ElementArrayBufferObj->Name);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.ColorReadType);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.ColorReadFormat);
         break;
      case GL_FRAMEBUFFER_BINDING_EXT:
         params[0] = INT_TO_BOOLEAN(ctx->DrawBuffer->Name);
         break;
      case GL_RENDERBUFFER_BINDING_EXT:
         params[0] = INT_TO_BOOLEAN(ctx->CurrentRenderbuffer ? ctx->CurrentRenderbuffer->Name : 0);
         break;
      case GL_MAX_RENDERBUFFER_SIZE_EXT:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxRenderbufferSize);
         break;
      case GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB:
         params[0] = INT_TO_BOOLEAN(ARRAY_SIZE(compressed_formats));
         break;
      case GL_COMPRESSED_TEXTURE_FORMATS_ARB:
         {
         
     int i;
     for (i = 0; i < ARRAY_SIZE(compressed_formats); i++) {
        params[i] = compressed_formats[i];
     }
         }
         break;
      case GL_POLYGON_OFFSET_FILL:
         params[0] = ctx->Polygon.OffsetFill;
         break;
      case GL_MAX_LIGHTS:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxLights);
         break;
      case GL_LIGHT0:
         params[0] = ctx->Light.Light[0].Enabled;
         break;
      case GL_LIGHT1:
         params[0] = ctx->Light.Light[1].Enabled;
         break;
      case GL_LIGHT2:
         params[0] = ctx->Light.Light[2].Enabled;
         break;
      case GL_LIGHT3:
         params[0] = ctx->Light.Light[3].Enabled;
         break;
      case GL_LIGHT4:
         params[0] = ctx->Light.Light[4].Enabled;
         break;
      case GL_LIGHT5:
         params[0] = ctx->Light.Light[5].Enabled;
         break;
      case GL_LIGHT6:
         params[0] = ctx->Light.Light[6].Enabled;
         break;
      case GL_LIGHT7:
         params[0] = ctx->Light.Light[7].Enabled;
         break;
      case GL_LIGHTING:
         params[0] = ctx->Light.Enabled;
         break;
      case GL_LIGHT_MODEL_AMBIENT:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Light.Model.Ambient[0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Light.Model.Ambient[1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Light.Model.Ambient[2]);
         params[3] = FLOAT_TO_BOOLEAN(ctx->Light.Model.Ambient[3]);
         break;
      case GL_LIGHT_MODEL_TWO_SIDE:
         params[0] = ctx->Light.Model.TwoSide;
         break;
      case GL_ALPHA_TEST:
         params[0] = ctx->Color.AlphaEnabled;
         break;
      case GL_ALPHA_TEST_FUNC:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.AlphaFunc);
         break;
      case GL_ALPHA_TEST_REF:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Color.AlphaRef);
         break;
      case GL_BLEND_DST:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.BlendDstRGB);
         break;
      case GL_MAX_CLIP_PLANES:
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxClipPlanes);
         break;
      case GL_CLIP_PLANE0:
         params[0] = (ctx->Transform.ClipPlanesEnabled >> 0) & 1;
         break;
      case GL_CLIP_PLANE1:
         params[0] = (ctx->Transform.ClipPlanesEnabled >> 1) & 1;
         break;
      case GL_CLIP_PLANE2:
         params[0] = (ctx->Transform.ClipPlanesEnabled >> 2) & 1;
         break;
      case GL_CLIP_PLANE3:
         params[0] = (ctx->Transform.ClipPlanesEnabled >> 3) & 1;
         break;
      case GL_CLIP_PLANE4:
         params[0] = (ctx->Transform.ClipPlanesEnabled >> 4) & 1;
         break;
      case GL_CLIP_PLANE5:
         params[0] = (ctx->Transform.ClipPlanesEnabled >> 5) & 1;
         break;
      case GL_COLOR_MATERIAL:
         params[0] = ctx->Light.ColorMaterialEnabled;
         break;
      case GL_CURRENT_COLOR:
         {
         FLUSH_CURRENT(ctx, 0);
         params[0] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][2]);
         params[3] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][3]);
         }
         break;
      case GL_CURRENT_NORMAL:
         {
         FLUSH_CURRENT(ctx, 0);
         params[0] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_NORMAL][0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_NORMAL][1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_NORMAL][2]);
         }
         break;
      case GL_CURRENT_TEXTURE_COORDS:
         {
         const GLuint texUnit = ctx->Texture.CurrentUnit;
         params[0] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][2]);
         params[3] = FLOAT_TO_BOOLEAN(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][3]);
         }
         break;
      case GL_DISTANCE_ATTENUATION_EXT:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Point.Params[0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Point.Params[1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Point.Params[2]);
         break;
      case GL_FOG:
         params[0] = ctx->Fog.Enabled;
         break;
      case GL_FOG_COLOR:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Fog.Color[0]);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Fog.Color[1]);
         params[2] = FLOAT_TO_BOOLEAN(ctx->Fog.Color[2]);
         params[3] = FLOAT_TO_BOOLEAN(ctx->Fog.Color[3]);
         break;
      case GL_FOG_DENSITY:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Fog.Density);
         break;
      case GL_FOG_END:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Fog.End);
         break;
      case GL_FOG_HINT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Hint.Fog);
         break;
      case GL_FOG_MODE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Fog.Mode);
         break;
      case GL_FOG_START:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Fog.Start);
         break;
      case GL_LINE_SMOOTH:
         params[0] = ctx->Line.SmoothFlag;
         break;
      case GL_LINE_SMOOTH_HINT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Hint.LineSmooth);
         break;
      case GL_LINE_WIDTH_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Const.MinLineWidthAA);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Const.MaxLineWidthAA);
         break;
      case GL_COLOR_LOGIC_OP:
         params[0] = ctx->Color.ColorLogicOpEnabled;
         break;
      case GL_LOGIC_OP_MODE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Color.LogicOp);
         break;
      case GL_MATRIX_MODE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Transform.MatrixMode);
         break;
      case GL_MAX_MODELVIEW_STACK_DEPTH:
         params[0] = INT_TO_BOOLEAN(MAX_MODELVIEW_STACK_DEPTH);
         break;
      case GL_MAX_PROJECTION_STACK_DEPTH:
         params[0] = INT_TO_BOOLEAN(MAX_PROJECTION_STACK_DEPTH);
         break;
      case GL_MAX_TEXTURE_STACK_DEPTH:
         params[0] = INT_TO_BOOLEAN(MAX_TEXTURE_STACK_DEPTH);
         break;
      case GL_MODELVIEW_MATRIX:
         {
         const GLfloat *matrix = ctx->ModelviewMatrixStack.Top->m;
         params[0] = FLOAT_TO_BOOLEAN(matrix[0]);
         params[1] = FLOAT_TO_BOOLEAN(matrix[1]);
         params[2] = FLOAT_TO_BOOLEAN(matrix[2]);
         params[3] = FLOAT_TO_BOOLEAN(matrix[3]);
         params[4] = FLOAT_TO_BOOLEAN(matrix[4]);
         params[5] = FLOAT_TO_BOOLEAN(matrix[5]);
         params[6] = FLOAT_TO_BOOLEAN(matrix[6]);
         params[7] = FLOAT_TO_BOOLEAN(matrix[7]);
         params[8] = FLOAT_TO_BOOLEAN(matrix[8]);
         params[9] = FLOAT_TO_BOOLEAN(matrix[9]);
         params[10] = FLOAT_TO_BOOLEAN(matrix[10]);
         params[11] = FLOAT_TO_BOOLEAN(matrix[11]);
         params[12] = FLOAT_TO_BOOLEAN(matrix[12]);
         params[13] = FLOAT_TO_BOOLEAN(matrix[13]);
         params[14] = FLOAT_TO_BOOLEAN(matrix[14]);
         params[15] = FLOAT_TO_BOOLEAN(matrix[15]);
         }
         break;
      case GL_MODELVIEW_STACK_DEPTH:
         params[0] = INT_TO_BOOLEAN(ctx->ModelviewMatrixStack.Depth + 1);
         break;
      case GL_NORMALIZE:
         params[0] = ctx->Transform.Normalize;
         break;
      case GL_PACK_SKIP_IMAGES_EXT:
         params[0] = INT_TO_BOOLEAN(ctx->Pack.SkipImages);
         break;
      case GL_PERSPECTIVE_CORRECTION_HINT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Hint.PerspectiveCorrection);
         break;
      case GL_POINT_SIZE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Point.Size);
         break;
      case GL_POINT_SIZE_RANGE:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Const.MinPointSizeAA);
         params[1] = FLOAT_TO_BOOLEAN(ctx->Const.MaxPointSizeAA);
         break;
      case GL_POINT_SMOOTH:
         params[0] = ctx->Point.SmoothFlag;
         break;
      case GL_POINT_SMOOTH_HINT:
         params[0] = ENUM_TO_BOOLEAN(ctx->Hint.PointSmooth);
         break;
      case GL_POINT_SIZE_MIN_EXT:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Point.MinSize);
         break;
      case GL_POINT_SIZE_MAX_EXT:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Point.MaxSize);
         break;
      case GL_POINT_FADE_THRESHOLD_SIZE_EXT:
         params[0] = FLOAT_TO_BOOLEAN(ctx->Point.Threshold);
         break;
      case GL_PROJECTION_MATRIX:
         {
         const GLfloat *matrix = ctx->ProjectionMatrixStack.Top->m;
         params[0] = FLOAT_TO_BOOLEAN(matrix[0]);
         params[1] = FLOAT_TO_BOOLEAN(matrix[1]);
         params[2] = FLOAT_TO_BOOLEAN(matrix[2]);
         params[3] = FLOAT_TO_BOOLEAN(matrix[3]);
         params[4] = FLOAT_TO_BOOLEAN(matrix[4]);
         params[5] = FLOAT_TO_BOOLEAN(matrix[5]);
         params[6] = FLOAT_TO_BOOLEAN(matrix[6]);
         params[7] = FLOAT_TO_BOOLEAN(matrix[7]);
         params[8] = FLOAT_TO_BOOLEAN(matrix[8]);
         params[9] = FLOAT_TO_BOOLEAN(matrix[9]);
         params[10] = FLOAT_TO_BOOLEAN(matrix[10]);
         params[11] = FLOAT_TO_BOOLEAN(matrix[11]);
         params[12] = FLOAT_TO_BOOLEAN(matrix[12]);
         params[13] = FLOAT_TO_BOOLEAN(matrix[13]);
         params[14] = FLOAT_TO_BOOLEAN(matrix[14]);
         params[15] = FLOAT_TO_BOOLEAN(matrix[15]);
         }
         break;
      case GL_PROJECTION_STACK_DEPTH:
         params[0] = INT_TO_BOOLEAN(ctx->ProjectionMatrixStack.Depth + 1);
         break;
      case GL_RESCALE_NORMAL:
         params[0] = ctx->Transform.RescaleNormals;
         break;
      case GL_SHADE_MODEL:
         params[0] = ENUM_TO_BOOLEAN(ctx->Light.ShadeModel);
         break;
      case GL_TEXTURE_2D:
         params[0] = _mesa_IsEnabled(GL_TEXTURE_2D);
         break;
      case GL_TEXTURE_MATRIX:
         {
         const GLfloat *matrix = ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Top->m;
         params[0] = FLOAT_TO_BOOLEAN(matrix[0]);
         params[1] = FLOAT_TO_BOOLEAN(matrix[1]);
         params[2] = FLOAT_TO_BOOLEAN(matrix[2]);
         params[3] = FLOAT_TO_BOOLEAN(matrix[3]);
         params[4] = FLOAT_TO_BOOLEAN(matrix[4]);
         params[5] = FLOAT_TO_BOOLEAN(matrix[5]);
         params[6] = FLOAT_TO_BOOLEAN(matrix[6]);
         params[7] = FLOAT_TO_BOOLEAN(matrix[7]);
         params[8] = FLOAT_TO_BOOLEAN(matrix[8]);
         params[9] = FLOAT_TO_BOOLEAN(matrix[9]);
         params[10] = FLOAT_TO_BOOLEAN(matrix[10]);
         params[11] = FLOAT_TO_BOOLEAN(matrix[11]);
         params[12] = FLOAT_TO_BOOLEAN(matrix[12]);
         params[13] = FLOAT_TO_BOOLEAN(matrix[13]);
         params[14] = FLOAT_TO_BOOLEAN(matrix[14]);
         params[15] = FLOAT_TO_BOOLEAN(matrix[15]);
         }
         break;
      case GL_TEXTURE_STACK_DEPTH:
         params[0] = INT_TO_BOOLEAN(ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Depth + 1);
         break;
      case GL_VERTEX_ARRAY:
         params[0] = ctx->Array.ArrayObj->Vertex.Enabled;
         break;
      case GL_VERTEX_ARRAY_SIZE:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Vertex.Size);
         break;
      case GL_VERTEX_ARRAY_TYPE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Array.ArrayObj->Vertex.Type);
         break;
      case GL_VERTEX_ARRAY_STRIDE:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Vertex.Stride);
         break;
      case GL_NORMAL_ARRAY:
         params[0] = ENUM_TO_BOOLEAN(ctx->Array.ArrayObj->Normal.Enabled);
         break;
      case GL_NORMAL_ARRAY_TYPE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Array.ArrayObj->Normal.Type);
         break;
      case GL_NORMAL_ARRAY_STRIDE:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Normal.Stride);
         break;
      case GL_COLOR_ARRAY:
         params[0] = ctx->Array.ArrayObj->Color.Enabled;
         break;
      case GL_COLOR_ARRAY_SIZE:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Color.Size);
         break;
      case GL_COLOR_ARRAY_TYPE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Array.ArrayObj->Color.Type);
         break;
      case GL_COLOR_ARRAY_STRIDE:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Color.Stride);
         break;
      case GL_TEXTURE_COORD_ARRAY:
         params[0] = ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Enabled;
         break;
      case GL_TEXTURE_COORD_ARRAY_SIZE:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Size);
         break;
      case GL_TEXTURE_COORD_ARRAY_TYPE:
         params[0] = ENUM_TO_BOOLEAN(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Type);
         break;
      case GL_TEXTURE_COORD_ARRAY_STRIDE:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Stride);
         break;
      case GL_MAX_TEXTURE_UNITS_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxTextureUnits);
         break;
      case GL_CLIENT_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(GL_TEXTURE0_ARB + ctx->Array.ActiveTexture);
         break;
      case GL_TEXTURE_CUBE_MAP_ARB:
         params[0] = _mesa_IsEnabled(GL_TEXTURE_CUBE_MAP_ARB);
         break;
      case GL_TEXTURE_GEN_S:
         params[0] = ((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & S_BIT) ? 1 : 0);
         break;
      case GL_TEXTURE_GEN_T:
         params[0] = ((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & T_BIT) ? 1 : 0);
         break;
      case GL_TEXTURE_GEN_R:
         params[0] = ((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & R_BIT) ? 1 : 0);
         break;
      case GL_MULTISAMPLE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.Enabled;
         break;
      case GL_SAMPLE_ALPHA_TO_ONE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetBooleanv");
         params[0] = ctx->Multisample.SampleAlphaToOne;
         break;
      case GL_VERTEX_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Vertex.BufferObj->Name);
         break;
      case GL_NORMAL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Normal.BufferObj->Name);
         break;
      case GL_COLOR_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->Color.BufferObj->Name);
         break;
      case GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].BufferObj->Name);
         break;
      case GL_POINT_SPRITE_NV:
         params[0] = ctx->Point.PointSprite;
         break;
      case GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB:
         CHECK_EXT1(ARB_fragment_shader, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.FragmentProgram.MaxUniformComponents);
         break;
      case GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.VertexProgram.MaxUniformComponents);
         break;
      case GL_MAX_VARYING_FLOATS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetBooleanv");
         params[0] = INT_TO_BOOLEAN(ctx->Const.MaxVarying * 4);
         break;
      case GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix = ctx->ModelviewMatrixStack.Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix = ctx->ProjectionMatrixStack.Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix =
            ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_POINT_SIZE_ARRAY_OES:
         params[0] = ctx->Array.ArrayObj->PointSize.Enabled;
         break;
      case GL_POINT_SIZE_ARRAY_TYPE_OES:
         params[0] = ENUM_TO_BOOLEAN(ctx->Array.ArrayObj->PointSize.Type);
         break;
      case GL_POINT_SIZE_ARRAY_STRIDE_OES:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->PointSize.Stride);
         break;
      case GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES:
         params[0] = INT_TO_BOOLEAN(ctx->Array.ArrayObj->PointSize.BufferObj->Name);
         break;
      case GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT:
         CHECK_EXT1(EXT_texture_filter_anisotropic, "_mesa_GetBooleanv");
         params[0] = FLOAT_TO_BOOLEAN(ctx->Const.MaxTextureMaxAnisotropy);
         break;
      default:
         _mesa_error(ctx, GL_INVALID_ENUM, "gl_mesa_GetBooleanv(pname=0x%x)", pname);
   }
}

void GLAPIENTRY
_mesa_GetFloatv( GLenum pname, GLfloat *params )
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END(ctx);

   if (!params)
      return;

   if (ctx->NewState)
      _mesa_update_state(ctx);

   switch (pname) {
      case GL_ALPHA_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.alphaBits);
         break;
      case GL_BLEND:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Color.BlendEnabled);
         break;
      case GL_BLEND_SRC:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLUE_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.blueBits);
         break;
      case GL_COLOR_CLEAR_VALUE:
         params[0] = ctx->Color.ClearColor[0];
         params[1] = ctx->Color.ClearColor[1];
         params[2] = ctx->Color.ClearColor[2];
         params[3] = ctx->Color.ClearColor[3];
         break;
      case GL_COLOR_WRITEMASK:
         params[0] = (GLfloat)(ctx->Color.ColorMask[RCOMP] ? 1 : 0);
         params[1] = (GLfloat)(ctx->Color.ColorMask[GCOMP] ? 1 : 0);
         params[2] = (GLfloat)(ctx->Color.ColorMask[BCOMP] ? 1 : 0);
         params[3] = (GLfloat)(ctx->Color.ColorMask[ACOMP] ? 1 : 0);
         break;
      case GL_CULL_FACE:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Polygon.CullFlag);
         break;
      case GL_CULL_FACE_MODE:
         params[0] = ENUM_TO_FLOAT(ctx->Polygon.CullFaceMode);
         break;
      case GL_DEPTH_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.depthBits);
         break;
      case GL_DEPTH_CLEAR_VALUE:
         params[0] = ctx->Depth.Clear;
         break;
      case GL_DEPTH_FUNC:
         params[0] = ENUM_TO_FLOAT(ctx->Depth.Func);
         break;
      case GL_DEPTH_RANGE:
         params[0] = ctx->Viewport.Near;
         params[1] = ctx->Viewport.Far;
         break;
      case GL_DEPTH_TEST:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Depth.Test);
         break;
      case GL_DEPTH_WRITEMASK:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Depth.Mask);
         break;
      case GL_DITHER:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Color.DitherFlag);
         break;
      case GL_FRONT_FACE:
         params[0] = ENUM_TO_FLOAT(ctx->Polygon.FrontFace);
         break;
      case GL_GREEN_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.greenBits);
         break;
      case GL_LINE_WIDTH:
         params[0] = ctx->Line.Width;
         break;
      case GL_ALIASED_LINE_WIDTH_RANGE:
         params[0] = ctx->Const.MinLineWidth;
         params[1] = ctx->Const.MaxLineWidth;
         break;
      case GL_MAX_ELEMENTS_INDICES:
         params[0] = (GLfloat)(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_ELEMENTS_VERTICES:
         params[0] = (GLfloat)(ctx->Const.MaxArrayLockSize);
         break;
      case GL_MAX_TEXTURE_SIZE:
         params[0] = (GLfloat)(1 << (ctx->Const.MaxTextureLevels - 1));
         break;
      case GL_MAX_VIEWPORT_DIMS:
         params[0] = (GLfloat)(ctx->Const.MaxViewportWidth);
         params[1] = (GLfloat)(ctx->Const.MaxViewportHeight);
         break;
      case GL_PACK_ALIGNMENT:
         params[0] = (GLfloat)(ctx->Pack.Alignment);
         break;
      case GL_ALIASED_POINT_SIZE_RANGE:
         params[0] = ctx->Const.MinPointSize;
         params[1] = ctx->Const.MaxPointSize;
         break;
      case GL_POLYGON_OFFSET_FACTOR:
         params[0] = ctx->Polygon.OffsetFactor ;
         break;
      case GL_POLYGON_OFFSET_UNITS:
         params[0] = ctx->Polygon.OffsetUnits ;
         break;
      case GL_RED_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.redBits);
         break;
      case GL_SCISSOR_BOX:
         params[0] = (GLfloat)(ctx->Scissor.X);
         params[1] = (GLfloat)(ctx->Scissor.Y);
         params[2] = (GLfloat)(ctx->Scissor.Width);
         params[3] = (GLfloat)(ctx->Scissor.Height);
         break;
      case GL_SCISSOR_TEST:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Scissor.Enabled);
         break;
      case GL_STENCIL_BITS:
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.stencilBits);
         break;
      case GL_STENCIL_CLEAR_VALUE:
         params[0] = (GLfloat)(ctx->Stencil.Clear);
         break;
      case GL_STENCIL_FAIL:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.FailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_FUNC:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.Function[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.ZFailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_FLOAT(ctx->Stencil.ZPassFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_REF:
         params[0] = (GLfloat)(ctx->Stencil.Ref[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_TEST:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Stencil.Enabled);
         break;
      case GL_STENCIL_VALUE_MASK:
         params[0] = (GLfloat)(ctx->Stencil.ValueMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_WRITEMASK:
         params[0] = (GLfloat)(ctx->Stencil.WriteMask[ctx->Stencil.ActiveFace]);
         break;
      case GL_SUBPIXEL_BITS:
         params[0] = (GLfloat)(ctx->Const.SubPixelBits);
         break;
      case GL_TEXTURE_BINDING_2D:
         params[0] = (GLfloat)(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_2D_INDEX]->Name);
         break;
      case GL_UNPACK_ALIGNMENT:
         params[0] = (GLfloat)(ctx->Unpack.Alignment);
         break;
      case GL_VIEWPORT:
         params[0] = (GLfloat)(ctx->Viewport.X);
         params[1] = (GLfloat)(ctx->Viewport.Y);
         params[2] = (GLfloat)(ctx->Viewport.Width);
         params[3] = (GLfloat)(ctx->Viewport.Height);
         break;
      case GL_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetFloatv");
         params[0] = (GLfloat)(GL_TEXTURE0_ARB + ctx->Texture.CurrentUnit);
         break;
      case GL_TEXTURE_BINDING_CUBE_MAP_ARB:
         params[0] = (GLfloat)(ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_CUBE_INDEX]->Name);
         break;
      case GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB:
         params[0] = (GLfloat)((1 << (ctx->Const.MaxCubeTextureLevels - 1)));
         break;
      case GL_BLEND_SRC_RGB_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLEND_DST_RGB_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendDstRGB);
         break;
      case GL_BLEND_SRC_ALPHA_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendSrcA);
         break;
      case GL_BLEND_DST_ALPHA_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendDstA);
         break;
      case GL_BLEND_EQUATION:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendEquationRGB );
         break;
      case GL_BLEND_EQUATION_ALPHA_EXT:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendEquationA );
         break;
      case GL_SAMPLE_ALPHA_TO_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.SampleAlphaToCoverage);
         break;
      case GL_SAMPLE_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.SampleCoverage);
         break;
      case GL_SAMPLE_COVERAGE_VALUE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = ctx->Multisample.SampleCoverageValue;
         break;
      case GL_SAMPLE_COVERAGE_INVERT_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.SampleCoverageInvert);
         break;
      case GL_SAMPLE_BUFFERS_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.sampleBuffers);
         break;
      case GL_SAMPLES_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->DrawBuffer->Visual.samples);
         break;
      case GL_GENERATE_MIPMAP_HINT_SGIS:
         CHECK_EXT1(SGIS_generate_mipmap, "_mesa_GetFloatv");
         params[0] = ENUM_TO_FLOAT(ctx->Hint.GenerateMipmap);
         break;
      case GL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ArrayBufferObj->Name);
         break;
      case GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ElementArrayBufferObj->Name);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
         params[0] = (GLfloat)(ctx->Const.ColorReadType);
         break;
      case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
         params[0] = (GLfloat)(ctx->Const.ColorReadFormat);
         break;
      case GL_FRAMEBUFFER_BINDING_EXT:
         params[0] = (GLfloat)(ctx->DrawBuffer->Name);
         break;
      case GL_RENDERBUFFER_BINDING_EXT:
         params[0] = (GLfloat)(ctx->CurrentRenderbuffer ? ctx->CurrentRenderbuffer->Name : 0);
         break;
      case GL_MAX_RENDERBUFFER_SIZE_EXT:
         params[0] = (GLfloat)(ctx->Const.MaxRenderbufferSize);
         break;
      case GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB:
         params[0] = (GLfloat)(ARRAY_SIZE(compressed_formats));
         break;
      case GL_COMPRESSED_TEXTURE_FORMATS_ARB:
         {
         
     int i;
     for (i = 0; i < ARRAY_SIZE(compressed_formats); i++) {
        params[i] = compressed_formats[i];
     }
         }
         break;
      case GL_POLYGON_OFFSET_FILL:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Polygon.OffsetFill);
         break;
      case GL_MAX_LIGHTS:
         params[0] = (GLfloat)(ctx->Const.MaxLights);
         break;
      case GL_LIGHT0:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[0].Enabled);
         break;
      case GL_LIGHT1:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[1].Enabled);
         break;
      case GL_LIGHT2:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[2].Enabled);
         break;
      case GL_LIGHT3:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[3].Enabled);
         break;
      case GL_LIGHT4:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[4].Enabled);
         break;
      case GL_LIGHT5:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[5].Enabled);
         break;
      case GL_LIGHT6:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[6].Enabled);
         break;
      case GL_LIGHT7:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Light[7].Enabled);
         break;
      case GL_LIGHTING:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Enabled);
         break;
      case GL_LIGHT_MODEL_AMBIENT:
         params[0] = ctx->Light.Model.Ambient[0];
         params[1] = ctx->Light.Model.Ambient[1];
         params[2] = ctx->Light.Model.Ambient[2];
         params[3] = ctx->Light.Model.Ambient[3];
         break;
      case GL_LIGHT_MODEL_TWO_SIDE:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.Model.TwoSide);
         break;
      case GL_ALPHA_TEST:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Color.AlphaEnabled);
         break;
      case GL_ALPHA_TEST_FUNC:
         params[0] = ENUM_TO_FLOAT(ctx->Color.AlphaFunc);
         break;
      case GL_ALPHA_TEST_REF:
         params[0] = ctx->Color.AlphaRef;
         break;
      case GL_BLEND_DST:
         params[0] = ENUM_TO_FLOAT(ctx->Color.BlendDstRGB);
         break;
      case GL_MAX_CLIP_PLANES:
         params[0] = (GLfloat)(ctx->Const.MaxClipPlanes);
         break;
      case GL_CLIP_PLANE0:
         params[0] = BOOLEAN_TO_FLOAT((ctx->Transform.ClipPlanesEnabled >> 0) & 1);
         break;
      case GL_CLIP_PLANE1:
         params[0] = BOOLEAN_TO_FLOAT((ctx->Transform.ClipPlanesEnabled >> 1) & 1);
         break;
      case GL_CLIP_PLANE2:
         params[0] = BOOLEAN_TO_FLOAT((ctx->Transform.ClipPlanesEnabled >> 2) & 1);
         break;
      case GL_CLIP_PLANE3:
         params[0] = BOOLEAN_TO_FLOAT((ctx->Transform.ClipPlanesEnabled >> 3) & 1);
         break;
      case GL_CLIP_PLANE4:
         params[0] = BOOLEAN_TO_FLOAT((ctx->Transform.ClipPlanesEnabled >> 4) & 1);
         break;
      case GL_CLIP_PLANE5:
         params[0] = BOOLEAN_TO_FLOAT((ctx->Transform.ClipPlanesEnabled >> 5) & 1);
         break;
      case GL_COLOR_MATERIAL:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Light.ColorMaterialEnabled);
         break;
      case GL_CURRENT_COLOR:
         {
         FLUSH_CURRENT(ctx, 0);
         params[0] = ctx->Current.Attrib[VERT_ATTRIB_COLOR0][0];
         params[1] = ctx->Current.Attrib[VERT_ATTRIB_COLOR0][1];
         params[2] = ctx->Current.Attrib[VERT_ATTRIB_COLOR0][2];
         params[3] = ctx->Current.Attrib[VERT_ATTRIB_COLOR0][3];
         }
         break;
      case GL_CURRENT_NORMAL:
         {
         FLUSH_CURRENT(ctx, 0);
         params[0] = ctx->Current.Attrib[VERT_ATTRIB_NORMAL][0];
         params[1] = ctx->Current.Attrib[VERT_ATTRIB_NORMAL][1];
         params[2] = ctx->Current.Attrib[VERT_ATTRIB_NORMAL][2];
         }
         break;
      case GL_CURRENT_TEXTURE_COORDS:
         {
         const GLuint texUnit = ctx->Texture.CurrentUnit;
         params[0] = ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][0];
         params[1] = ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][1];
         params[2] = ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][2];
         params[3] = ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][3];
         }
         break;
      case GL_DISTANCE_ATTENUATION_EXT:
         params[0] = ctx->Point.Params[0];
         params[1] = ctx->Point.Params[1];
         params[2] = ctx->Point.Params[2];
         break;
      case GL_FOG:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Fog.Enabled);
         break;
      case GL_FOG_COLOR:
         params[0] = ctx->Fog.Color[0];
         params[1] = ctx->Fog.Color[1];
         params[2] = ctx->Fog.Color[2];
         params[3] = ctx->Fog.Color[3];
         break;
      case GL_FOG_DENSITY:
         params[0] = ctx->Fog.Density;
         break;
      case GL_FOG_END:
         params[0] = ctx->Fog.End;
         break;
      case GL_FOG_HINT:
         params[0] = ENUM_TO_FLOAT(ctx->Hint.Fog);
         break;
      case GL_FOG_MODE:
         params[0] = ENUM_TO_FLOAT(ctx->Fog.Mode);
         break;
      case GL_FOG_START:
         params[0] = ctx->Fog.Start;
         break;
      case GL_LINE_SMOOTH:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Line.SmoothFlag);
         break;
      case GL_LINE_SMOOTH_HINT:
         params[0] = ENUM_TO_FLOAT(ctx->Hint.LineSmooth);
         break;
      case GL_LINE_WIDTH_RANGE:
         params[0] = ctx->Const.MinLineWidthAA;
         params[1] = ctx->Const.MaxLineWidthAA;
         break;
      case GL_COLOR_LOGIC_OP:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Color.ColorLogicOpEnabled);
         break;
      case GL_LOGIC_OP_MODE:
         params[0] = ENUM_TO_FLOAT(ctx->Color.LogicOp);
         break;
      case GL_MATRIX_MODE:
         params[0] = ENUM_TO_FLOAT(ctx->Transform.MatrixMode);
         break;
      case GL_MAX_MODELVIEW_STACK_DEPTH:
         params[0] = (GLfloat)(MAX_MODELVIEW_STACK_DEPTH);
         break;
      case GL_MAX_PROJECTION_STACK_DEPTH:
         params[0] = (GLfloat)(MAX_PROJECTION_STACK_DEPTH);
         break;
      case GL_MAX_TEXTURE_STACK_DEPTH:
         params[0] = (GLfloat)(MAX_TEXTURE_STACK_DEPTH);
         break;
      case GL_MODELVIEW_MATRIX:
         {
         const GLfloat *matrix = ctx->ModelviewMatrixStack.Top->m;
         params[0] = matrix[0];
         params[1] = matrix[1];
         params[2] = matrix[2];
         params[3] = matrix[3];
         params[4] = matrix[4];
         params[5] = matrix[5];
         params[6] = matrix[6];
         params[7] = matrix[7];
         params[8] = matrix[8];
         params[9] = matrix[9];
         params[10] = matrix[10];
         params[11] = matrix[11];
         params[12] = matrix[12];
         params[13] = matrix[13];
         params[14] = matrix[14];
         params[15] = matrix[15];
         }
         break;
      case GL_MODELVIEW_STACK_DEPTH:
         params[0] = (GLfloat)(ctx->ModelviewMatrixStack.Depth + 1);
         break;
      case GL_NORMALIZE:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Transform.Normalize);
         break;
      case GL_PACK_SKIP_IMAGES_EXT:
         params[0] = (GLfloat)(ctx->Pack.SkipImages);
         break;
      case GL_PERSPECTIVE_CORRECTION_HINT:
         params[0] = ENUM_TO_FLOAT(ctx->Hint.PerspectiveCorrection);
         break;
      case GL_POINT_SIZE:
         params[0] = ctx->Point.Size;
         break;
      case GL_POINT_SIZE_RANGE:
         params[0] = ctx->Const.MinPointSizeAA;
         params[1] = ctx->Const.MaxPointSizeAA;
         break;
      case GL_POINT_SMOOTH:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Point.SmoothFlag);
         break;
      case GL_POINT_SMOOTH_HINT:
         params[0] = ENUM_TO_FLOAT(ctx->Hint.PointSmooth);
         break;
      case GL_POINT_SIZE_MIN_EXT:
         params[0] = ctx->Point.MinSize;
         break;
      case GL_POINT_SIZE_MAX_EXT:
         params[0] = ctx->Point.MaxSize;
         break;
      case GL_POINT_FADE_THRESHOLD_SIZE_EXT:
         params[0] = ctx->Point.Threshold;
         break;
      case GL_PROJECTION_MATRIX:
         {
         const GLfloat *matrix = ctx->ProjectionMatrixStack.Top->m;
         params[0] = matrix[0];
         params[1] = matrix[1];
         params[2] = matrix[2];
         params[3] = matrix[3];
         params[4] = matrix[4];
         params[5] = matrix[5];
         params[6] = matrix[6];
         params[7] = matrix[7];
         params[8] = matrix[8];
         params[9] = matrix[9];
         params[10] = matrix[10];
         params[11] = matrix[11];
         params[12] = matrix[12];
         params[13] = matrix[13];
         params[14] = matrix[14];
         params[15] = matrix[15];
         }
         break;
      case GL_PROJECTION_STACK_DEPTH:
         params[0] = (GLfloat)(ctx->ProjectionMatrixStack.Depth + 1);
         break;
      case GL_RESCALE_NORMAL:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Transform.RescaleNormals);
         break;
      case GL_SHADE_MODEL:
         params[0] = ENUM_TO_FLOAT(ctx->Light.ShadeModel);
         break;
      case GL_TEXTURE_2D:
         params[0] = BOOLEAN_TO_FLOAT(_mesa_IsEnabled(GL_TEXTURE_2D));
         break;
      case GL_TEXTURE_MATRIX:
         {
         const GLfloat *matrix = ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Top->m;
         params[0] = matrix[0];
         params[1] = matrix[1];
         params[2] = matrix[2];
         params[3] = matrix[3];
         params[4] = matrix[4];
         params[5] = matrix[5];
         params[6] = matrix[6];
         params[7] = matrix[7];
         params[8] = matrix[8];
         params[9] = matrix[9];
         params[10] = matrix[10];
         params[11] = matrix[11];
         params[12] = matrix[12];
         params[13] = matrix[13];
         params[14] = matrix[14];
         params[15] = matrix[15];
         }
         break;
      case GL_TEXTURE_STACK_DEPTH:
         params[0] = (GLfloat)(ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Depth + 1);
         break;
      case GL_VERTEX_ARRAY:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Array.ArrayObj->Vertex.Enabled);
         break;
      case GL_VERTEX_ARRAY_SIZE:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Vertex.Size);
         break;
      case GL_VERTEX_ARRAY_TYPE:
         params[0] = ENUM_TO_FLOAT(ctx->Array.ArrayObj->Vertex.Type);
         break;
      case GL_VERTEX_ARRAY_STRIDE:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Vertex.Stride);
         break;
      case GL_NORMAL_ARRAY:
         params[0] = ENUM_TO_FLOAT(ctx->Array.ArrayObj->Normal.Enabled);
         break;
      case GL_NORMAL_ARRAY_TYPE:
         params[0] = ENUM_TO_FLOAT(ctx->Array.ArrayObj->Normal.Type);
         break;
      case GL_NORMAL_ARRAY_STRIDE:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Normal.Stride);
         break;
      case GL_COLOR_ARRAY:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Array.ArrayObj->Color.Enabled);
         break;
      case GL_COLOR_ARRAY_SIZE:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Color.Size);
         break;
      case GL_COLOR_ARRAY_TYPE:
         params[0] = ENUM_TO_FLOAT(ctx->Array.ArrayObj->Color.Type);
         break;
      case GL_COLOR_ARRAY_STRIDE:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Color.Stride);
         break;
      case GL_TEXTURE_COORD_ARRAY:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Enabled);
         break;
      case GL_TEXTURE_COORD_ARRAY_SIZE:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Size);
         break;
      case GL_TEXTURE_COORD_ARRAY_TYPE:
         params[0] = ENUM_TO_FLOAT(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Type);
         break;
      case GL_TEXTURE_COORD_ARRAY_STRIDE:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Stride);
         break;
      case GL_MAX_TEXTURE_UNITS_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.MaxTextureUnits);
         break;
      case GL_CLIENT_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetFloatv");
         params[0] = (GLfloat)(GL_TEXTURE0_ARB + ctx->Array.ActiveTexture);
         break;
      case GL_TEXTURE_CUBE_MAP_ARB:
         params[0] = BOOLEAN_TO_FLOAT(_mesa_IsEnabled(GL_TEXTURE_CUBE_MAP_ARB));
         break;
      case GL_TEXTURE_GEN_S:
         params[0] = BOOLEAN_TO_FLOAT(((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & S_BIT) ? 1 : 0));
         break;
      case GL_TEXTURE_GEN_T:
         params[0] = BOOLEAN_TO_FLOAT(((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & T_BIT) ? 1 : 0));
         break;
      case GL_TEXTURE_GEN_R:
         params[0] = BOOLEAN_TO_FLOAT(((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & R_BIT) ? 1 : 0));
         break;
      case GL_MULTISAMPLE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.Enabled);
         break;
      case GL_SAMPLE_ALPHA_TO_ONE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetFloatv");
         params[0] = BOOLEAN_TO_FLOAT(ctx->Multisample.SampleAlphaToOne);
         break;
      case GL_VERTEX_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Vertex.BufferObj->Name);
         break;
      case GL_NORMAL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Normal.BufferObj->Name);
         break;
      case GL_COLOR_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ArrayObj->Color.BufferObj->Name);
         break;
      case GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].BufferObj->Name);
         break;
      case GL_POINT_SPRITE_NV:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Point.PointSprite);
         break;
      case GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB:
         CHECK_EXT1(ARB_fragment_shader, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.FragmentProgram.MaxUniformComponents);
         break;
      case GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.VertexProgram.MaxUniformComponents);
         break;
      case GL_MAX_VARYING_FLOATS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetFloatv");
         params[0] = (GLfloat)(ctx->Const.MaxVarying * 4);
         break;
      case GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix = ctx->ModelviewMatrixStack.Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix = ctx->ProjectionMatrixStack.Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix =
            ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_POINT_SIZE_ARRAY_OES:
         params[0] = BOOLEAN_TO_FLOAT(ctx->Array.ArrayObj->PointSize.Enabled);
         break;
      case GL_POINT_SIZE_ARRAY_TYPE_OES:
         params[0] = ENUM_TO_FLOAT(ctx->Array.ArrayObj->PointSize.Type);
         break;
      case GL_POINT_SIZE_ARRAY_STRIDE_OES:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->PointSize.Stride);
         break;
      case GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES:
         params[0] = (GLfloat)(ctx->Array.ArrayObj->PointSize.BufferObj->Name);
         break;
      case GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT:
         CHECK_EXT1(EXT_texture_filter_anisotropic, "_mesa_GetFloatv");
         params[0] = ctx->Const.MaxTextureMaxAnisotropy;
         break;
      default:
         _mesa_error(ctx, GL_INVALID_ENUM, "gl_mesa_GetFloatv(pname=0x%x)", pname);
   }
}

void GLAPIENTRY
_mesa_GetIntegerv( GLenum pname, GLint *params )
{
   GET_CURRENT_CONTEXT(ctx);
   ASSERT_OUTSIDE_BEGIN_END(ctx);

   if (!params)
      return;

   if (ctx->NewState)
      _mesa_update_state(ctx);

   switch (pname) {
      case GL_ALPHA_BITS:
         params[0] = ctx->DrawBuffer->Visual.alphaBits;
         break;
      case GL_BLEND:
         params[0] = BOOLEAN_TO_INT(ctx->Color.BlendEnabled);
         break;
      case GL_BLEND_SRC:
         params[0] = ENUM_TO_INT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLUE_BITS:
         params[0] = ctx->DrawBuffer->Visual.blueBits;
         break;
      case GL_COLOR_CLEAR_VALUE:
         params[0] = FLOAT_TO_INT(ctx->Color.ClearColor[0]);
         params[1] = FLOAT_TO_INT(ctx->Color.ClearColor[1]);
         params[2] = FLOAT_TO_INT(ctx->Color.ClearColor[2]);
         params[3] = FLOAT_TO_INT(ctx->Color.ClearColor[3]);
         break;
      case GL_COLOR_WRITEMASK:
         params[0] = ctx->Color.ColorMask[RCOMP] ? 1 : 0;
         params[1] = ctx->Color.ColorMask[GCOMP] ? 1 : 0;
         params[2] = ctx->Color.ColorMask[BCOMP] ? 1 : 0;
         params[3] = ctx->Color.ColorMask[ACOMP] ? 1 : 0;
         break;
      case GL_CULL_FACE:
         params[0] = BOOLEAN_TO_INT(ctx->Polygon.CullFlag);
         break;
      case GL_CULL_FACE_MODE:
         params[0] = ENUM_TO_INT(ctx->Polygon.CullFaceMode);
         break;
      case GL_DEPTH_BITS:
         params[0] = ctx->DrawBuffer->Visual.depthBits;
         break;
      case GL_DEPTH_CLEAR_VALUE:
         params[0] = FLOAT_TO_INT(ctx->Depth.Clear);
         break;
      case GL_DEPTH_FUNC:
         params[0] = ENUM_TO_INT(ctx->Depth.Func);
         break;
      case GL_DEPTH_RANGE:
         params[0] = FLOAT_TO_INT(ctx->Viewport.Near);
         params[1] = FLOAT_TO_INT(ctx->Viewport.Far);
         break;
      case GL_DEPTH_TEST:
         params[0] = BOOLEAN_TO_INT(ctx->Depth.Test);
         break;
      case GL_DEPTH_WRITEMASK:
         params[0] = BOOLEAN_TO_INT(ctx->Depth.Mask);
         break;
      case GL_DITHER:
         params[0] = BOOLEAN_TO_INT(ctx->Color.DitherFlag);
         break;
      case GL_FRONT_FACE:
         params[0] = ENUM_TO_INT(ctx->Polygon.FrontFace);
         break;
      case GL_GREEN_BITS:
         params[0] = ctx->DrawBuffer->Visual.greenBits;
         break;
      case GL_LINE_WIDTH:
         params[0] = IROUND(ctx->Line.Width);
         break;
      case GL_ALIASED_LINE_WIDTH_RANGE:
         params[0] = IROUND(ctx->Const.MinLineWidth);
         params[1] = IROUND(ctx->Const.MaxLineWidth);
         break;
      case GL_MAX_ELEMENTS_INDICES:
         params[0] = ctx->Const.MaxArrayLockSize;
         break;
      case GL_MAX_ELEMENTS_VERTICES:
         params[0] = ctx->Const.MaxArrayLockSize;
         break;
      case GL_MAX_TEXTURE_SIZE:
         params[0] = 1 << (ctx->Const.MaxTextureLevels - 1);
         break;
      case GL_MAX_VIEWPORT_DIMS:
         params[0] = ctx->Const.MaxViewportWidth;
         params[1] = ctx->Const.MaxViewportHeight;
         break;
      case GL_PACK_ALIGNMENT:
         params[0] = ctx->Pack.Alignment;
         break;
      case GL_ALIASED_POINT_SIZE_RANGE:
         params[0] = IROUND(ctx->Const.MinPointSize);
         params[1] = IROUND(ctx->Const.MaxPointSize);
         break;
      case GL_POLYGON_OFFSET_FACTOR:
         params[0] = IROUND(ctx->Polygon.OffsetFactor );
         break;
      case GL_POLYGON_OFFSET_UNITS:
         params[0] = IROUND(ctx->Polygon.OffsetUnits );
         break;
      case GL_RED_BITS:
         params[0] = ctx->DrawBuffer->Visual.redBits;
         break;
      case GL_SCISSOR_BOX:
         params[0] = ctx->Scissor.X;
         params[1] = ctx->Scissor.Y;
         params[2] = ctx->Scissor.Width;
         params[3] = ctx->Scissor.Height;
         break;
      case GL_SCISSOR_TEST:
         params[0] = BOOLEAN_TO_INT(ctx->Scissor.Enabled);
         break;
      case GL_STENCIL_BITS:
         params[0] = ctx->DrawBuffer->Visual.stencilBits;
         break;
      case GL_STENCIL_CLEAR_VALUE:
         params[0] = ctx->Stencil.Clear;
         break;
      case GL_STENCIL_FAIL:
         params[0] = ENUM_TO_INT(ctx->Stencil.FailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_FUNC:
         params[0] = ENUM_TO_INT(ctx->Stencil.Function[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_FAIL:
         params[0] = ENUM_TO_INT(ctx->Stencil.ZFailFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_PASS_DEPTH_PASS:
         params[0] = ENUM_TO_INT(ctx->Stencil.ZPassFunc[ctx->Stencil.ActiveFace]);
         break;
      case GL_STENCIL_REF:
         params[0] = ctx->Stencil.Ref[ctx->Stencil.ActiveFace];
         break;
      case GL_STENCIL_TEST:
         params[0] = BOOLEAN_TO_INT(ctx->Stencil.Enabled);
         break;
      case GL_STENCIL_VALUE_MASK:
         params[0] = ctx->Stencil.ValueMask[ctx->Stencil.ActiveFace];
         break;
      case GL_STENCIL_WRITEMASK:
         params[0] = ctx->Stencil.WriteMask[ctx->Stencil.ActiveFace];
         break;
      case GL_SUBPIXEL_BITS:
         params[0] = ctx->Const.SubPixelBits;
         break;
      case GL_TEXTURE_BINDING_2D:
         params[0] = ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_2D_INDEX]->Name;
         break;
      case GL_UNPACK_ALIGNMENT:
         params[0] = ctx->Unpack.Alignment;
         break;
      case GL_VIEWPORT:
         params[0] = ctx->Viewport.X;
         params[1] = ctx->Viewport.Y;
         params[2] = ctx->Viewport.Width;
         params[3] = ctx->Viewport.Height;
         break;
      case GL_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetIntegerv");
         params[0] = GL_TEXTURE0_ARB + ctx->Texture.CurrentUnit;
         break;
      case GL_TEXTURE_BINDING_CUBE_MAP_ARB:
         params[0] = ctx->Texture.Unit[ctx->Texture.CurrentUnit].CurrentTex[TEXTURE_CUBE_INDEX]->Name;
         break;
      case GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB:
         params[0] = (1 << (ctx->Const.MaxCubeTextureLevels - 1));
         break;
      case GL_BLEND_SRC_RGB_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendSrcRGB);
         break;
      case GL_BLEND_DST_RGB_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendDstRGB);
         break;
      case GL_BLEND_SRC_ALPHA_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendSrcA);
         break;
      case GL_BLEND_DST_ALPHA_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendDstA);
         break;
      case GL_BLEND_EQUATION:
         params[0] = ENUM_TO_INT(ctx->Color.BlendEquationRGB );
         break;
      case GL_BLEND_EQUATION_ALPHA_EXT:
         params[0] = ENUM_TO_INT(ctx->Color.BlendEquationA );
         break;
      case GL_SAMPLE_ALPHA_TO_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.SampleAlphaToCoverage);
         break;
      case GL_SAMPLE_COVERAGE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.SampleCoverage);
         break;
      case GL_SAMPLE_COVERAGE_VALUE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = IROUND(ctx->Multisample.SampleCoverageValue);
         break;
      case GL_SAMPLE_COVERAGE_INVERT_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.SampleCoverageInvert);
         break;
      case GL_SAMPLE_BUFFERS_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = ctx->DrawBuffer->Visual.sampleBuffers;
         break;
      case GL_SAMPLES_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = ctx->DrawBuffer->Visual.samples;
         break;
      case GL_GENERATE_MIPMAP_HINT_SGIS:
         CHECK_EXT1(SGIS_generate_mipmap, "_mesa_GetIntegerv");
         params[0] = ENUM_TO_INT(ctx->Hint.GenerateMipmap);
         break;
      case GL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ArrayBufferObj->Name;
         break;
      case GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ElementArrayBufferObj->Name;
         break;
      case GL_IMPLEMENTATION_COLOR_READ_TYPE_OES:
         params[0] = ctx->Const.ColorReadType;
         break;
      case GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES:
         params[0] = ctx->Const.ColorReadFormat;
         break;
      case GL_FRAMEBUFFER_BINDING_EXT:
         params[0] = ctx->DrawBuffer->Name;
         break;
      case GL_RENDERBUFFER_BINDING_EXT:
         params[0] = ctx->CurrentRenderbuffer ? ctx->CurrentRenderbuffer->Name : 0;
         break;
      case GL_MAX_RENDERBUFFER_SIZE_EXT:
         params[0] = ctx->Const.MaxRenderbufferSize;
         break;
      case GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB:
         params[0] = ARRAY_SIZE(compressed_formats);
         break;
      case GL_COMPRESSED_TEXTURE_FORMATS_ARB:
         {
         
     int i;
     for (i = 0; i < ARRAY_SIZE(compressed_formats); i++) {
        params[i] = compressed_formats[i];
     }
         }
         break;
      case GL_POLYGON_OFFSET_FILL:
         params[0] = BOOLEAN_TO_INT(ctx->Polygon.OffsetFill);
         break;
      case GL_MAX_LIGHTS:
         params[0] = ctx->Const.MaxLights;
         break;
      case GL_LIGHT0:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[0].Enabled);
         break;
      case GL_LIGHT1:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[1].Enabled);
         break;
      case GL_LIGHT2:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[2].Enabled);
         break;
      case GL_LIGHT3:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[3].Enabled);
         break;
      case GL_LIGHT4:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[4].Enabled);
         break;
      case GL_LIGHT5:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[5].Enabled);
         break;
      case GL_LIGHT6:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[6].Enabled);
         break;
      case GL_LIGHT7:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Light[7].Enabled);
         break;
      case GL_LIGHTING:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Enabled);
         break;
      case GL_LIGHT_MODEL_AMBIENT:
         params[0] = FLOAT_TO_INT(ctx->Light.Model.Ambient[0]);
         params[1] = FLOAT_TO_INT(ctx->Light.Model.Ambient[1]);
         params[2] = FLOAT_TO_INT(ctx->Light.Model.Ambient[2]);
         params[3] = FLOAT_TO_INT(ctx->Light.Model.Ambient[3]);
         break;
      case GL_LIGHT_MODEL_TWO_SIDE:
         params[0] = BOOLEAN_TO_INT(ctx->Light.Model.TwoSide);
         break;
      case GL_ALPHA_TEST:
         params[0] = BOOLEAN_TO_INT(ctx->Color.AlphaEnabled);
         break;
      case GL_ALPHA_TEST_FUNC:
         params[0] = ENUM_TO_INT(ctx->Color.AlphaFunc);
         break;
      case GL_ALPHA_TEST_REF:
         params[0] = FLOAT_TO_INT(ctx->Color.AlphaRef);
         break;
      case GL_BLEND_DST:
         params[0] = ENUM_TO_INT(ctx->Color.BlendDstRGB);
         break;
      case GL_MAX_CLIP_PLANES:
         params[0] = ctx->Const.MaxClipPlanes;
         break;
      case GL_CLIP_PLANE0:
         params[0] = BOOLEAN_TO_INT((ctx->Transform.ClipPlanesEnabled >> 0) & 1);
         break;
      case GL_CLIP_PLANE1:
         params[0] = BOOLEAN_TO_INT((ctx->Transform.ClipPlanesEnabled >> 1) & 1);
         break;
      case GL_CLIP_PLANE2:
         params[0] = BOOLEAN_TO_INT((ctx->Transform.ClipPlanesEnabled >> 2) & 1);
         break;
      case GL_CLIP_PLANE3:
         params[0] = BOOLEAN_TO_INT((ctx->Transform.ClipPlanesEnabled >> 3) & 1);
         break;
      case GL_CLIP_PLANE4:
         params[0] = BOOLEAN_TO_INT((ctx->Transform.ClipPlanesEnabled >> 4) & 1);
         break;
      case GL_CLIP_PLANE5:
         params[0] = BOOLEAN_TO_INT((ctx->Transform.ClipPlanesEnabled >> 5) & 1);
         break;
      case GL_COLOR_MATERIAL:
         params[0] = BOOLEAN_TO_INT(ctx->Light.ColorMaterialEnabled);
         break;
      case GL_CURRENT_COLOR:
         {
         FLUSH_CURRENT(ctx, 0);
         params[0] = FLOAT_TO_INT(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][0]);
         params[1] = FLOAT_TO_INT(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][1]);
         params[2] = FLOAT_TO_INT(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][2]);
         params[3] = FLOAT_TO_INT(ctx->Current.Attrib[VERT_ATTRIB_COLOR0][3]);
         }
         break;
      case GL_CURRENT_NORMAL:
         {
         FLUSH_CURRENT(ctx, 0);
         params[0] = FLOAT_TO_INT(ctx->Current.Attrib[VERT_ATTRIB_NORMAL][0]);
         params[1] = FLOAT_TO_INT(ctx->Current.Attrib[VERT_ATTRIB_NORMAL][1]);
         params[2] = FLOAT_TO_INT(ctx->Current.Attrib[VERT_ATTRIB_NORMAL][2]);
         }
         break;
      case GL_CURRENT_TEXTURE_COORDS:
         {
         const GLuint texUnit = ctx->Texture.CurrentUnit;
         params[0] = IROUND(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][0]);
         params[1] = IROUND(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][1]);
         params[2] = IROUND(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][2]);
         params[3] = IROUND(ctx->Current.Attrib[VERT_ATTRIB_TEX0 + texUnit][3]);
         }
         break;
      case GL_DISTANCE_ATTENUATION_EXT:
         params[0] = IROUND(ctx->Point.Params[0]);
         params[1] = IROUND(ctx->Point.Params[1]);
         params[2] = IROUND(ctx->Point.Params[2]);
         break;
      case GL_FOG:
         params[0] = BOOLEAN_TO_INT(ctx->Fog.Enabled);
         break;
      case GL_FOG_COLOR:
         params[0] = FLOAT_TO_INT(ctx->Fog.Color[0]);
         params[1] = FLOAT_TO_INT(ctx->Fog.Color[1]);
         params[2] = FLOAT_TO_INT(ctx->Fog.Color[2]);
         params[3] = FLOAT_TO_INT(ctx->Fog.Color[3]);
         break;
      case GL_FOG_DENSITY:
         params[0] = IROUND(ctx->Fog.Density);
         break;
      case GL_FOG_END:
         params[0] = IROUND(ctx->Fog.End);
         break;
      case GL_FOG_HINT:
         params[0] = ENUM_TO_INT(ctx->Hint.Fog);
         break;
      case GL_FOG_MODE:
         params[0] = ENUM_TO_INT(ctx->Fog.Mode);
         break;
      case GL_FOG_START:
         params[0] = IROUND(ctx->Fog.Start);
         break;
      case GL_LINE_SMOOTH:
         params[0] = BOOLEAN_TO_INT(ctx->Line.SmoothFlag);
         break;
      case GL_LINE_SMOOTH_HINT:
         params[0] = ENUM_TO_INT(ctx->Hint.LineSmooth);
         break;
      case GL_LINE_WIDTH_RANGE:
         params[0] = IROUND(ctx->Const.MinLineWidthAA);
         params[1] = IROUND(ctx->Const.MaxLineWidthAA);
         break;
      case GL_COLOR_LOGIC_OP:
         params[0] = BOOLEAN_TO_INT(ctx->Color.ColorLogicOpEnabled);
         break;
      case GL_LOGIC_OP_MODE:
         params[0] = ENUM_TO_INT(ctx->Color.LogicOp);
         break;
      case GL_MATRIX_MODE:
         params[0] = ENUM_TO_INT(ctx->Transform.MatrixMode);
         break;
      case GL_MAX_MODELVIEW_STACK_DEPTH:
         params[0] = MAX_MODELVIEW_STACK_DEPTH;
         break;
      case GL_MAX_PROJECTION_STACK_DEPTH:
         params[0] = MAX_PROJECTION_STACK_DEPTH;
         break;
      case GL_MAX_TEXTURE_STACK_DEPTH:
         params[0] = MAX_TEXTURE_STACK_DEPTH;
         break;
      case GL_MODELVIEW_MATRIX:
         {
         const GLfloat *matrix = ctx->ModelviewMatrixStack.Top->m;
         params[0] = IROUND(matrix[0]);
         params[1] = IROUND(matrix[1]);
         params[2] = IROUND(matrix[2]);
         params[3] = IROUND(matrix[3]);
         params[4] = IROUND(matrix[4]);
         params[5] = IROUND(matrix[5]);
         params[6] = IROUND(matrix[6]);
         params[7] = IROUND(matrix[7]);
         params[8] = IROUND(matrix[8]);
         params[9] = IROUND(matrix[9]);
         params[10] = IROUND(matrix[10]);
         params[11] = IROUND(matrix[11]);
         params[12] = IROUND(matrix[12]);
         params[13] = IROUND(matrix[13]);
         params[14] = IROUND(matrix[14]);
         params[15] = IROUND(matrix[15]);
         }
         break;
      case GL_MODELVIEW_STACK_DEPTH:
         params[0] = ctx->ModelviewMatrixStack.Depth + 1;
         break;
      case GL_NORMALIZE:
         params[0] = BOOLEAN_TO_INT(ctx->Transform.Normalize);
         break;
      case GL_PACK_SKIP_IMAGES_EXT:
         params[0] = ctx->Pack.SkipImages;
         break;
      case GL_PERSPECTIVE_CORRECTION_HINT:
         params[0] = ENUM_TO_INT(ctx->Hint.PerspectiveCorrection);
         break;
      case GL_POINT_SIZE:
         params[0] = IROUND(ctx->Point.Size);
         break;
      case GL_POINT_SIZE_RANGE:
         params[0] = IROUND(ctx->Const.MinPointSizeAA);
         params[1] = IROUND(ctx->Const.MaxPointSizeAA);
         break;
      case GL_POINT_SMOOTH:
         params[0] = BOOLEAN_TO_INT(ctx->Point.SmoothFlag);
         break;
      case GL_POINT_SMOOTH_HINT:
         params[0] = ENUM_TO_INT(ctx->Hint.PointSmooth);
         break;
      case GL_POINT_SIZE_MIN_EXT:
         params[0] = IROUND(ctx->Point.MinSize);
         break;
      case GL_POINT_SIZE_MAX_EXT:
         params[0] = IROUND(ctx->Point.MaxSize);
         break;
      case GL_POINT_FADE_THRESHOLD_SIZE_EXT:
         params[0] = IROUND(ctx->Point.Threshold);
         break;
      case GL_PROJECTION_MATRIX:
         {
         const GLfloat *matrix = ctx->ProjectionMatrixStack.Top->m;
         params[0] = IROUND(matrix[0]);
         params[1] = IROUND(matrix[1]);
         params[2] = IROUND(matrix[2]);
         params[3] = IROUND(matrix[3]);
         params[4] = IROUND(matrix[4]);
         params[5] = IROUND(matrix[5]);
         params[6] = IROUND(matrix[6]);
         params[7] = IROUND(matrix[7]);
         params[8] = IROUND(matrix[8]);
         params[9] = IROUND(matrix[9]);
         params[10] = IROUND(matrix[10]);
         params[11] = IROUND(matrix[11]);
         params[12] = IROUND(matrix[12]);
         params[13] = IROUND(matrix[13]);
         params[14] = IROUND(matrix[14]);
         params[15] = IROUND(matrix[15]);
         }
         break;
      case GL_PROJECTION_STACK_DEPTH:
         params[0] = ctx->ProjectionMatrixStack.Depth + 1;
         break;
      case GL_RESCALE_NORMAL:
         params[0] = BOOLEAN_TO_INT(ctx->Transform.RescaleNormals);
         break;
      case GL_SHADE_MODEL:
         params[0] = ENUM_TO_INT(ctx->Light.ShadeModel);
         break;
      case GL_TEXTURE_2D:
         params[0] = BOOLEAN_TO_INT(_mesa_IsEnabled(GL_TEXTURE_2D));
         break;
      case GL_TEXTURE_MATRIX:
         {
         const GLfloat *matrix = ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Top->m;
         params[0] = IROUND(matrix[0]);
         params[1] = IROUND(matrix[1]);
         params[2] = IROUND(matrix[2]);
         params[3] = IROUND(matrix[3]);
         params[4] = IROUND(matrix[4]);
         params[5] = IROUND(matrix[5]);
         params[6] = IROUND(matrix[6]);
         params[7] = IROUND(matrix[7]);
         params[8] = IROUND(matrix[8]);
         params[9] = IROUND(matrix[9]);
         params[10] = IROUND(matrix[10]);
         params[11] = IROUND(matrix[11]);
         params[12] = IROUND(matrix[12]);
         params[13] = IROUND(matrix[13]);
         params[14] = IROUND(matrix[14]);
         params[15] = IROUND(matrix[15]);
         }
         break;
      case GL_TEXTURE_STACK_DEPTH:
         params[0] = ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Depth + 1;
         break;
      case GL_VERTEX_ARRAY:
         params[0] = BOOLEAN_TO_INT(ctx->Array.ArrayObj->Vertex.Enabled);
         break;
      case GL_VERTEX_ARRAY_SIZE:
         params[0] = ctx->Array.ArrayObj->Vertex.Size;
         break;
      case GL_VERTEX_ARRAY_TYPE:
         params[0] = ENUM_TO_INT(ctx->Array.ArrayObj->Vertex.Type);
         break;
      case GL_VERTEX_ARRAY_STRIDE:
         params[0] = ctx->Array.ArrayObj->Vertex.Stride;
         break;
      case GL_NORMAL_ARRAY:
         params[0] = ENUM_TO_INT(ctx->Array.ArrayObj->Normal.Enabled);
         break;
      case GL_NORMAL_ARRAY_TYPE:
         params[0] = ENUM_TO_INT(ctx->Array.ArrayObj->Normal.Type);
         break;
      case GL_NORMAL_ARRAY_STRIDE:
         params[0] = ctx->Array.ArrayObj->Normal.Stride;
         break;
      case GL_COLOR_ARRAY:
         params[0] = BOOLEAN_TO_INT(ctx->Array.ArrayObj->Color.Enabled);
         break;
      case GL_COLOR_ARRAY_SIZE:
         params[0] = ctx->Array.ArrayObj->Color.Size;
         break;
      case GL_COLOR_ARRAY_TYPE:
         params[0] = ENUM_TO_INT(ctx->Array.ArrayObj->Color.Type);
         break;
      case GL_COLOR_ARRAY_STRIDE:
         params[0] = ctx->Array.ArrayObj->Color.Stride;
         break;
      case GL_TEXTURE_COORD_ARRAY:
         params[0] = BOOLEAN_TO_INT(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Enabled);
         break;
      case GL_TEXTURE_COORD_ARRAY_SIZE:
         params[0] = ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Size;
         break;
      case GL_TEXTURE_COORD_ARRAY_TYPE:
         params[0] = ENUM_TO_INT(ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Type);
         break;
      case GL_TEXTURE_COORD_ARRAY_STRIDE:
         params[0] = ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].Stride;
         break;
      case GL_MAX_TEXTURE_UNITS_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetIntegerv");
         params[0] = ctx->Const.MaxTextureUnits;
         break;
      case GL_CLIENT_ACTIVE_TEXTURE_ARB:
         CHECK_EXT1(ARB_multitexture, "_mesa_GetIntegerv");
         params[0] = GL_TEXTURE0_ARB + ctx->Array.ActiveTexture;
         break;
      case GL_TEXTURE_CUBE_MAP_ARB:
         params[0] = BOOLEAN_TO_INT(_mesa_IsEnabled(GL_TEXTURE_CUBE_MAP_ARB));
         break;
      case GL_TEXTURE_GEN_S:
         params[0] = BOOLEAN_TO_INT(((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & S_BIT) ? 1 : 0));
         break;
      case GL_TEXTURE_GEN_T:
         params[0] = BOOLEAN_TO_INT(((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & T_BIT) ? 1 : 0));
         break;
      case GL_TEXTURE_GEN_R:
         params[0] = BOOLEAN_TO_INT(((ctx->Texture.Unit[ctx->Texture.CurrentUnit].TexGenEnabled & R_BIT) ? 1 : 0));
         break;
      case GL_MULTISAMPLE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.Enabled);
         break;
      case GL_SAMPLE_ALPHA_TO_ONE_ARB:
         CHECK_EXT1(ARB_multisample, "_mesa_GetIntegerv");
         params[0] = BOOLEAN_TO_INT(ctx->Multisample.SampleAlphaToOne);
         break;
      case GL_VERTEX_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ArrayObj->Vertex.BufferObj->Name;
         break;
      case GL_NORMAL_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ArrayObj->Normal.BufferObj->Name;
         break;
      case GL_COLOR_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ArrayObj->Color.BufferObj->Name;
         break;
      case GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB:
         CHECK_EXT1(ARB_vertex_buffer_object, "_mesa_GetIntegerv");
         params[0] = ctx->Array.ArrayObj->TexCoord[ctx->Array.ActiveTexture].BufferObj->Name;
         break;
      case GL_POINT_SPRITE_NV:
         params[0] = BOOLEAN_TO_INT(ctx->Point.PointSprite);
         break;
      case GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB:
         CHECK_EXT1(ARB_fragment_shader, "_mesa_GetIntegerv");
         params[0] = ctx->Const.FragmentProgram.MaxUniformComponents;
         break;
      case GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetIntegerv");
         params[0] = ctx->Const.VertexProgram.MaxUniformComponents;
         break;
      case GL_MAX_VARYING_FLOATS_ARB:
         CHECK_EXT1(ARB_vertex_shader, "_mesa_GetIntegerv");
         params[0] = ctx->Const.MaxVarying * 4;
         break;
      case GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix = ctx->ModelviewMatrixStack.Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix = ctx->ProjectionMatrixStack.Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES:
         {
         
      /* See GL_OES_matrix_get */
      {
         const GLfloat *matrix =
            ctx->TextureMatrixStack[ctx->Texture.CurrentUnit].Top->m;
         memcpy(params, matrix, 16 * sizeof(GLint));
      }
         }
         break;
      case GL_POINT_SIZE_ARRAY_OES:
         params[0] = BOOLEAN_TO_INT(ctx->Array.ArrayObj->PointSize.Enabled);
         break;
      case GL_POINT_SIZE_ARRAY_TYPE_OES:
         params[0] = ENUM_TO_INT(ctx->Array.ArrayObj->PointSize.Type);
         break;
      case GL_POINT_SIZE_ARRAY_STRIDE_OES:
         params[0] = ctx->Array.ArrayObj->PointSize.Stride;
         break;
      case GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES:
         params[0] = ctx->Array.ArrayObj->PointSize.BufferObj->Name;
         break;
      case GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT:
         CHECK_EXT1(EXT_texture_filter_anisotropic, "_mesa_GetIntegerv");
         params[0] = IROUND(ctx->Const.MaxTextureMaxAnisotropy);
         break;
      default:
         _mesa_error(ctx, GL_INVALID_ENUM, "gl_mesa_GetIntegerv(pname=0x%x)", pname);
   }
}

