
/*
 * Mesa 3-D graphics library
 * Version:  4.1
 *
 * Copyright (C) 1999-2002  Brian Paul   All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *    Gareth Hughes
 */

/*
 * This generates an asm version of mtypes.h (called matypes.h), so that
 * Mesa's x86 assembly code can access the internal structures easily.
 * This will be particularly useful when developing new x86 asm code for
 * Mesa, including lighting, clipping, texture image conversion etc.
 */

#include "glheader.h"
#include "mtypes.h"
#include "tnl/t_context.h"


#undef offsetof
#define offsetof( type, member ) ((size_t) &((type *)0)->member)


#define OFFSET_HEADER( x )						\
do {									\
   printf( "\n" );							\
   printf( "\n" );							\
   printf( "/* ====================================================="	\
	   "========\n" );						\
   printf( " * Offsets for %s\n", x );					\
   printf( " */\n" );							\
   printf( "\n" );							\
} while (0)

#define DEFINE_HEADER( x )						\
do {									\
   printf( "\n" );							\
   printf( "/*\n" );							\
   printf( " * Flags for %s\n", x );					\
   printf( " */\n" );							\
   printf( "\n" );							\
} while (0)

#if defined(__BEOS__)
#define OFFSET( s, t, m )						\
   printf( "#define %s\t%ld\n", s, offsetof( t, m ) );
#else
#define OFFSET( s, t, m )						\
   printf( "#define %s\t%d\n", s, offsetof( t, m ) );
#endif

#if defined(__BEOS__)
#define SIZEOF( s, t )							\
   printf( "#define %s\t%ld\n", s, sizeof(t) );
#else
#define SIZEOF( s, t )							\
   printf( "#define %s\t%d\n", s, sizeof(t) );
#endif

#define DEFINE( s, d )							\
   printf( "#define %s\t0x%x\n", s, d );



int main( int argc, char **argv )
{
   printf( "/*\n" );
   printf( " * This file is automatically generated from the Mesa internal type\n" );
   printf( " * definitions.  Do not edit directly.\n" );
   printf( " */\n" );
   printf( "\n" );
   printf( "#ifndef __ASM_TYPES_H__\n" );
   printf( "#define __ASM_TYPES_H__\n" );
   printf( "\n" );
   printf( "#include \"assyntax.h\"\n" );


   /* GLcontext offsets:
    */
   OFFSET_HEADER( "GLcontext" );

   OFFSET( "CTX_DRIVER_CTX              ", GLcontext, DriverCtx );
   printf( "\n" );
   OFFSET( "CTX_LIGHT_ENABLED           ", GLcontext, Light.Enabled );
   OFFSET( "CTX_LIGHT_SHADE_MODEL       ", GLcontext, Light.ShadeModel );
   OFFSET( "CTX_LIGHT_COLOR_MAT_FACE    ", GLcontext, Light.ColorMaterialFace );
   OFFSET( "CTX_LIGHT_COLOR_MAT_MODE    ", GLcontext, Light.ColorMaterialMode );
   OFFSET( "CTX_LIGHT_COLOR_MAT_MASK    ", GLcontext, Light.ColorMaterialBitmask );
   OFFSET( "CTX_LIGHT_COLOR_MAT_ENABLED ", GLcontext, Light.ColorMaterialEnabled );
   OFFSET( "CTX_LIGHT_ENABLED_LIST      ", GLcontext, Light.EnabledList );
   OFFSET( "CTX_LIGHT_NEED_VERTS        ", GLcontext, Light._NeedVertices );
   OFFSET( "CTX_LIGHT_FLAGS             ", GLcontext, Light._Flags );
   OFFSET( "CTX_LIGHT_BASE_COLOR        ", GLcontext, Light._BaseColor );


   /* struct vertex_buffer offsets:
    */
   OFFSET_HEADER( "struct vertex_buffer" );

   OFFSET( "VB_SIZE                ", struct vertex_buffer, Size );
   OFFSET( "VB_COUNT               ", struct vertex_buffer, Count );
   printf( "\n" );
   OFFSET( "VB_FIRST_CLIPPED       ", struct vertex_buffer, FirstClipped );
   OFFSET( "VB_FIRST_PRIMITIVE     ", struct vertex_buffer, FirstPrimitive );
   printf( "\n" );
   OFFSET( "VB_ELTS                ", struct vertex_buffer, Elts );
   OFFSET( "VB_OBJ_PTR             ", struct vertex_buffer, ObjPtr );
   OFFSET( "VB_EYE_PTR             ", struct vertex_buffer, EyePtr );
   OFFSET( "VB_CLIP_PTR            ", struct vertex_buffer, ClipPtr );
   OFFSET( "VB_PROJ_CLIP_PTR       ", struct vertex_buffer, NdcPtr );
   OFFSET( "VB_CLIP_OR_MASK        ", struct vertex_buffer, ClipOrMask );
   OFFSET( "VB_CLIP_MASK           ", struct vertex_buffer, ClipMask );
   OFFSET( "VB_NORMAL_PTR          ", struct vertex_buffer, NormalPtr );
   OFFSET( "VB_EDGE_FLAG           ", struct vertex_buffer, EdgeFlag );
   OFFSET( "VB_TEX0_COORD_PTR      ", struct vertex_buffer, TexCoordPtr[0] );
   OFFSET( "VB_TEX1_COORD_PTR      ", struct vertex_buffer, TexCoordPtr[1] );
   OFFSET( "VB_TEX2_COORD_PTR      ", struct vertex_buffer, TexCoordPtr[2] );
   OFFSET( "VB_TEX3_COORD_PTR      ", struct vertex_buffer, TexCoordPtr[3] );
   OFFSET( "VB_INDEX_PTR           ", struct vertex_buffer, IndexPtr );
   OFFSET( "VB_COLOR_PTR           ", struct vertex_buffer, ColorPtr );
   OFFSET( "VB_SECONDARY_COLOR_PTR ", struct vertex_buffer, SecondaryColorPtr );
   OFFSET( "VB_FOG_COORD_PTR       ", struct vertex_buffer, FogCoordPtr );
   OFFSET( "VB_POINT_SIZE_PTR      ", struct vertex_buffer, PointSizePtr );
   OFFSET( "VB_MATERIAL            ", struct vertex_buffer, Material );
   OFFSET( "VB_MATERIAL_MASK       ", struct vertex_buffer, MaterialMask );
   OFFSET( "VB_FLAG                ", struct vertex_buffer, Flag );
   OFFSET( "VB_PRIMITIVE           ", struct vertex_buffer, Primitive );
   OFFSET( "VB_PRIMITIVE_LENGTH    ", struct vertex_buffer, PrimitiveLength );
   printf( "\n" );
   OFFSET( "VB_IMPORTABLE_DATA     ", struct vertex_buffer, importable_data );
   printf( "\n" );
   OFFSET( "VB_LAST_CLIPPED        ", struct vertex_buffer, LastClipped );

   DEFINE_HEADER( "struct vertex_buffer" );

   /* XXX use new labels here someday after vertex proram is done */
   DEFINE( "VERT_BIT_OBJ           ", VERT_BIT_POS );
   DEFINE( "VERT_BIT_NORM          ", VERT_BIT_NORMAL );
   DEFINE( "VERT_BIT_RGBA          ", VERT_BIT_COLOR0 );
   DEFINE( "VERT_BIT_SPEC_RGB      ", VERT_BIT_COLOR1 );
   DEFINE( "VERT_BIT_FOG_COORD     ", VERT_BIT_FOG );
   DEFINE( "VERT_BIT_INDEX         ", VERT_BIT_INDEX );
   DEFINE( "VERT_BIT_EDGE          ", VERT_BIT_EDGEFLAG );
   DEFINE( "VERT_BIT_TEX0          ", VERT_BIT_TEX0 );
   DEFINE( "VERT_BIT_TEX1          ", VERT_BIT_TEX1 );
   DEFINE( "VERT_BIT_TEX2          ", VERT_BIT_TEX2 );
   DEFINE( "VERT_BIT_TEX3          ", VERT_BIT_TEX3 );
   DEFINE( "VERT_BIT_EVAL_C1       ", VERT_BIT_EVAL_C1 );
   DEFINE( "VERT_BIT_EVAL_C2       ", VERT_BIT_EVAL_C2 );
   DEFINE( "VERT_BIT_EVAL_P1       ", VERT_BIT_EVAL_P1 );
   DEFINE( "VERT_BIT_EVAL_P2       ", VERT_BIT_EVAL_P2 );
   DEFINE( "VERT_BIT_OBJ_3         ", VERT_BIT_OBJ_3 );
   DEFINE( "VERT_BIT_OBJ_4         ", VERT_BIT_OBJ_4 );
   DEFINE( "VERT_BIT_MATERIAL      ", VERT_BIT_MATERIAL );
   DEFINE( "VERT_BIT_ELT           ", VERT_BIT_ELT );
   DEFINE( "VERT_BIT_BEGIN         ", VERT_BIT_BEGIN );
   DEFINE( "VERT_BIT_END           ", VERT_BIT_END );
   DEFINE( "VERT_BIT_END_VB        ", VERT_BIT_END_VB );
   DEFINE( "VERT_BIT_POINT_SIZE    ", VERT_BIT_POINT_SIZE );
   DEFINE( "VERT_BIT_EYE           ", VERT_BIT_EYE );
   DEFINE( "VERT_BIT_CLIP          ", VERT_BIT_CLIP );
   printf( "\n" );
   DEFINE( "VERT_BIT_OBJ_23        ", VERT_BIT_OBJ_3 );
   DEFINE( "VERT_BIT_OBJ_234       ", VERT_BIT_OBJ_4 );


   /* GLvector3f offsets:
    */
   OFFSET_HEADER( "GLvector3f" );

   OFFSET( "V3F_DATA          ", GLvector3f, data );
   OFFSET( "V3F_START         ", GLvector3f, start );
   OFFSET( "V3F_COUNT         ", GLvector3f, count );
   OFFSET( "V3F_STRIDE        ", GLvector3f, stride );
   OFFSET( "V3F_FLAGS         ", GLvector3f, flags );


   /* GLvector4f offsets:
    */
   OFFSET_HEADER( "GLvector4f" );

   OFFSET( "V4F_DATA          ", GLvector4f, data );
   OFFSET( "V4F_START         ", GLvector4f, start );
   OFFSET( "V4F_COUNT         ", GLvector4f, count );
   OFFSET( "V4F_STRIDE        ", GLvector4f, stride );
   OFFSET( "V4F_SIZE          ", GLvector4f, size );
   OFFSET( "V4F_FLAGS         ", GLvector4f, flags );

   DEFINE_HEADER( "GLvector4f" );

   DEFINE( "VEC_MALLOC        ", VEC_MALLOC );
   DEFINE( "VEC_NOT_WRITEABLE ", VEC_NOT_WRITEABLE );
   DEFINE( "VEC_BAD_STRIDE    ", VEC_BAD_STRIDE );
   printf( "\n" );
   DEFINE( "VEC_SIZE_1        ", VEC_SIZE_1 );
   DEFINE( "VEC_SIZE_2        ", VEC_SIZE_2 );
   DEFINE( "VEC_SIZE_3        ", VEC_SIZE_3 );
   DEFINE( "VEC_SIZE_4        ", VEC_SIZE_4 );


   /* GLmatrix offsets:
    */
   OFFSET_HEADER( "GLmatrix" );

   OFFSET( "MATRIX_DATA   ", GLmatrix, m );
   OFFSET( "MATRIX_INV    ", GLmatrix, inv );
   OFFSET( "MATRIX_FLAGS  ", GLmatrix, flags );
   OFFSET( "MATRIX_TYPE   ", GLmatrix, type );


   /* struct gl_light offsets:
    */
   OFFSET_HEADER( "struct gl_light" );

   OFFSET( "LIGHT_NEXT              ", struct gl_light, next );
   OFFSET( "LIGHT_PREV              ", struct gl_light, prev );
   printf( "\n" );
   OFFSET( "LIGHT_AMBIENT           ", struct gl_light, Ambient );
   OFFSET( "LIGHT_DIFFUSE           ", struct gl_light, Diffuse );
   OFFSET( "LIGHT_SPECULAR          ", struct gl_light, Specular );
   OFFSET( "LIGHT_EYE_POSITION      ", struct gl_light, EyePosition );
   OFFSET( "LIGHT_EYE_DIRECTION     ", struct gl_light, EyeDirection );
   OFFSET( "LIGHT_SPOT_EXPONENT     ", struct gl_light, SpotExponent );
   OFFSET( "LIGHT_SPOT_CUTOFF       ", struct gl_light, SpotCutoff );
   OFFSET( "LIGHT_COS_CUTOFF        ", struct gl_light, _CosCutoff );
   OFFSET( "LIGHT_CONST_ATTEN       ", struct gl_light, ConstantAttenuation );
   OFFSET( "LIGHT_LINEAR_ATTEN      ", struct gl_light, LinearAttenuation );
   OFFSET( "LIGHT_QUADRATIC_ATTEN   ", struct gl_light, QuadraticAttenuation );
   OFFSET( "LIGHT_ENABLED           ", struct gl_light, Enabled );
   printf( "\n" );
   OFFSET( "LIGHT_FLAGS             ", struct gl_light, _Flags );
   printf( "\n" );
   OFFSET( "LIGHT_POSITION          ", struct gl_light, _Position );
   OFFSET( "LIGHT_VP_INF_NORM       ", struct gl_light, _VP_inf_norm );
   OFFSET( "LIGHT_H_INF_NORM        ", struct gl_light, _h_inf_norm );
   OFFSET( "LIGHT_NORM_DIRECTION    ", struct gl_light, _NormDirection );
   OFFSET( "LIGHT_VP_INF_SPOT_ATTEN ", struct gl_light, _VP_inf_spot_attenuation );
   printf( "\n" );
   OFFSET( "LIGHT_SPOT_EXP_TABLE    ", struct gl_light, _SpotExpTable );
   OFFSET( "LIGHT_MAT_AMBIENT       ", struct gl_light, _MatAmbient );
   OFFSET( "LIGHT_MAT_DIFFUSE       ", struct gl_light, _MatDiffuse );
   OFFSET( "LIGHT_MAT_SPECULAR      ", struct gl_light, _MatSpecular );
   printf( "\n" );
   SIZEOF( "SIZEOF_GL_LIGHT         ", struct gl_light );

   DEFINE_HEADER( "struct gl_light" );

   DEFINE( "LIGHT_SPOT              ", LIGHT_SPOT );
   DEFINE( "LIGHT_LOCAL_VIEWER      ", LIGHT_LOCAL_VIEWER );
   DEFINE( "LIGHT_POSITIONAL        ", LIGHT_POSITIONAL );
   printf( "\n" );
   DEFINE( "LIGHT_NEED_VERTICES     ", LIGHT_NEED_VERTICES );


   /* struct gl_lightmodel offsets:
    */
   OFFSET_HEADER( "struct gl_lightmodel" );

   OFFSET( "LIGHT_MODEL_AMBIENT       ", struct gl_lightmodel, Ambient );
   OFFSET( "LIGHT_MODEL_LOCAL_VIEWER  ", struct gl_lightmodel, LocalViewer );
   OFFSET( "LIGHT_MODEL_TWO_SIDE      ", struct gl_lightmodel, TwoSide );
   OFFSET( "LIGHT_MODEL_COLOR_CONTROL ", struct gl_lightmodel, ColorControl );


   printf( "\n" );
   printf( "\n" );
   printf( "#endif /* __ASM_TYPES_H__ */\n" );

   return 0;
}
