
#include "target-helpers/inline_debug_helper.h"
#include "frontend/drm_driver.h"
#include "nouveau/drm/nouveau_drm_public.h"

static struct pipe_screen *
create_screen(int fd, const struct pipe_screen_config *config)
{
   struct pipe_screen *screen;

   screen = nouveau_drm_screen_create(fd);
   if (!screen)
      return NULL;

   screen = debug_screen_wrap(screen);

   return screen;
}

PUBLIC
DRM_DRIVER_DESCRIPTOR("nouveau", NULL, create_screen)
