/* Autogenerated file, DO NOT EDIT manually! generated by brw_oa.py
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdint.h>
#include <stdbool.h>

#include "util/hash_table.h"

#include "brw_oa_kblgt2.h"
#include "brw_context.h"
#include "brw_performance_query.h"


#define MIN(a, b) ((a < b) ? (a) : (b))
#define MAX(a, b) ((a > b) ? (a) : (b))


/* Render Metrics Basic Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__render_basic__gpu_core_clocks__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: EU Active */
static float
kblgt2__render_basic__eu_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: L3 Misses */
static uint64_t
kblgt2__render_basic__l3_misses__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: GTI L3 Throughput */
static uint64_t
kblgt2__render_basic__gti_l3_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: $L3Misses 64 UMUL */
   uint64_t tmp0 = kblgt2__render_basic__l3_misses__read(brw, query, accumulator) * 64;

   return tmp0;
}

/* Render Metrics Basic Gen9 :: EU Both FPU Pipes Active */
static float
kblgt2__render_basic__eu_fpu_both_active__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Sampler Cache Misses */
static uint64_t
kblgt2__render_basic__sampler_l1_misses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 8 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 8;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: VS Send Pipe Active */
static float
kblgt2__render_basic__vs_send_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Sampler 1 Bottleneck */
static float
kblgt2__render_basic__sampler1_bottleneck__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: VS FPU1 Pipe Active */
static float
kblgt2__render_basic__vs_fpu1_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: GS Threads Dispatched */
static uint64_t
kblgt2__render_basic__gs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: L3 Sampler Throughput */
static uint64_t
kblgt2__render_basic__l3_sampler_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: $SamplerL1Misses 64 UMUL */
   uint64_t tmp0 = kblgt2__render_basic__sampler_l1_misses__read(brw, query, accumulator) * 64;

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__render_basic__hi_depth_test_fails__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: FS Both FPU Active */
static float
kblgt2__render_basic__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: VS Threads Dispatched */
static uint64_t
kblgt2__render_basic__vs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: FS Threads Dispatched */
static uint64_t
kblgt2__render_basic__ps_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Sampler 0 Busy */
static float
kblgt2__render_basic__sampler0_busy__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Sampler 1 Busy */
static float
kblgt2__render_basic__sampler1_busy__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Samplers Busy */
static float
kblgt2__render_basic__samplers_busy__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: $Sampler0Busy $Sampler1Busy FMAX */
   double tmp0 = kblgt2__render_basic__sampler0_busy__read(brw, query, accumulator);
   double tmp1 = kblgt2__render_basic__sampler1_busy__read(brw, query, accumulator);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Render Metrics Basic Gen9 :: GTI Fixed Pipe Throughput */
static uint64_t
kblgt2__render_basic__gti_vf_throughput__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 6 READ B 7 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = accumulator[query->b_offset + 7];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: Shader Barrier Messages */
static uint64_t
kblgt2__render_basic__shader_barriers__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Sampler 0 Bottleneck */
static float
kblgt2__render_basic__sampler0_bottleneck__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Sampler Texels */
static uint64_t
kblgt2__render_basic__sampler_texels__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Pixels Failing Tests */
static uint64_t
kblgt2__render_basic__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__render_basic__gpu_time__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__render_basic__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__render_basic__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__render_basic__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Render Metrics Basic Gen9 :: Sampler Texels Misses */
static uint64_t
kblgt2__render_basic__sampler_texel_misses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__render_basic__cs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Shader Memory Accesses */
static uint64_t
kblgt2__render_basic__shader_memory_accesses__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: L3 Lookup Accesses w/o IC */
static uint64_t
kblgt2__render_basic__l3_lookups__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
   uint64_t tmp0 = kblgt2__render_basic__sampler_l1_misses__read(brw, query, accumulator) + kblgt2__render_basic__shader_memory_accesses__read(brw, query, accumulator);

   return tmp0;
}

/* Render Metrics Basic Gen9 :: SLM Bytes Read */
static uint64_t
kblgt2__render_basic__slm_bytes_read__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GTI Read Throughput */
static uint64_t
kblgt2__render_basic__gti_read_throughput__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: PS FPU1 Pipe Active */
static float
kblgt2__render_basic__ps_fpu1_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: PS Send Pipeline Active */
static float
kblgt2__render_basic__ps_send_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Rasterized Pixels */
static uint64_t
kblgt2__render_basic__rasterized_pixels__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GPU Busy */
static float
kblgt2__render_basic__gpu_busy__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: GTI Depth Throughput */
static uint64_t
kblgt2__render_basic__gti_depth_throughput__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 0 READ C 1 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = accumulator[query->c_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: VS FPU0 Pipe Active */
static float
kblgt2__render_basic__vs_fpu0_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: PS FPU0 Pipe Active */
static float
kblgt2__render_basic__ps_fpu0_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: DS Threads Dispatched */
static uint64_t
kblgt2__render_basic__ds_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: Samples Written */
static uint64_t
kblgt2__render_basic__samples_written__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: EU Stall */
static float
kblgt2__render_basic__eu_stall__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics Basic Gen9 :: Samples Blended */
static uint64_t
kblgt2__render_basic__samples_blended__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Early Depth Test Fails */
static uint64_t
kblgt2__render_basic__early_depth_test_fails__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Samplers Bottleneck */
static float
kblgt2__render_basic__sampler_bottleneck__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: $Sampler0Bottleneck $Sampler1Bottleneck FMAX */
   double tmp0 = kblgt2__render_basic__sampler0_bottleneck__read(brw, query, accumulator);
   double tmp1 = kblgt2__render_basic__sampler1_bottleneck__read(brw, query, accumulator);
   double tmp2 = MAX(tmp0, tmp1);

   return tmp2;
}

/* Render Metrics Basic Gen9 :: GTI HDC TLB Lookup Throughput */
static uint64_t
kblgt2__render_basic__gti_hdc_lookups_throughput__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: GTI RCC Throughput */
static uint64_t
kblgt2__render_basic__gti_rcc_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 2 READ C 3 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = accumulator[query->c_offset + 3];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Render Metrics Basic Gen9 :: HS Threads Dispatched */
static uint64_t
kblgt2__render_basic__hs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Render Metrics Basic Gen9 :: GTI Write Throughput */
static uint64_t
kblgt2__render_basic__gti_write_throughput__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: SLM Bytes Written */
static uint64_t
kblgt2__render_basic__slm_bytes_written__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: L3 Shader Throughput */
static uint64_t
kblgt2__render_basic__l3_shader_throughput__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__render_basic__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Render Metrics Basic Gen9 :: Samples Killed in FS */
static uint64_t
kblgt2__render_basic__samples_killed_in_ps__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics Basic Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__render_basic__shader_atomics__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_render_basic_query_counters[52];
static struct brw_perf_query_info kblgt2_render_basic_query = {
   .kind = OA_COUNTERS,
   .name = "Render Metrics Basic Gen9",
   .guid = "f8d677e9-ff6f-4df1-9310-0334c6efacce",
   .counters = kblgt2_render_basic_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_render_basic_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_render_basic_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__l3_misses__read;
      counter->name = "L3 Misses";
      counter->desc = "The total number of L3 misses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gti_l3_throughput__read;
      counter->name = "GTI L3 Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 32;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__sampler_l1_misses__read;
      counter->name = "Sampler Cache Misses";
      counter->desc = "The total number of sampler cache misses in all LODs in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x12) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__render_basic__sampler1_bottleneck__read;
         counter->name = "Sampler 1 Bottleneck";
         counter->desc = "The percentage of time in which Sampler 1 has been slowing down the pipe when processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 52;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__l3_sampler_throughput__read;
      counter->name = "L3 Sampler Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 88;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x09) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__render_basic__sampler0_busy__read;
         counter->name = "Sampler 0 Busy";
         counter->desc = "The percentage of time in which Sampler 0 has been processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 112;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x12) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__render_basic__sampler1_busy__read;
         counter->name = "Sampler 1 Busy";
         counter->desc = "The percentage of time in which Sampler 1 has been processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 116;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__samplers_busy__read;
      counter->name = "Samplers Busy";
      counter->desc = "The percentage of time in which samplers have been processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 120;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gti_vf_throughput__read;
      counter->name = "GTI Fixed Pipe Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between 3D Pipeline (Command Dispatch, Input Assembly and Stream Output) and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x09) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__render_basic__sampler0_bottleneck__read;
         counter->name = "Sampler 0 Bottleneck";
         counter->desc = "The percentage of time in which Sampler 0 has been slowing down the pipe when processing EU requests.";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 144;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__render_basic__avg_gpu_core_frequency__max(brw);
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__l3_lookups__read;
      counter->name = "L3 Lookup Accesses w/o IC";
      counter->desc = "The total number of L3 cache lookup accesses w/o IC.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 232;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 236;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 248;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gti_depth_throughput__read;
      counter->name = "GTI Depth Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between depth caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 264;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 268;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 288;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_basic__sampler_bottleneck__read;
      counter->name = "Samplers Bottleneck";
      counter->desc = "The percentage of time in which samplers have been slowing down the pipe when processing EU requests.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 312;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gti_hdc_lookups_throughput__read;
      counter->name = "GTI HDC TLB Lookup Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between GTI and HDC, when HDC is doing TLB lookups.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 320;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gti_rcc_throughput__read;
      counter->name = "GTI RCC Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between render color caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 328;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 336;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 344;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 352;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 360;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 368;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_basic__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 376;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics Basic Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__compute_basic__gpu_core_clocks__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: EU Active */
static float
kblgt2__compute_basic__eu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: Untyped Bytes Read */
static uint64_t
kblgt2__compute_basic__untyped_bytes_read__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 6 READ B 7 READ C 0 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = accumulator[query->b_offset + 7];
   uint64_t tmp2 = accumulator[query->c_offset + 0];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic Gen9 :: EU Both FPU Pipes Active */
static float
kblgt2__compute_basic__eu_fpu_both_active__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: Typed Bytes Written */
static uint64_t
kblgt2__compute_basic__typed_bytes_written__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 3 READ B 4 READ B 5 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = accumulator[query->b_offset + 4];
   uint64_t tmp2 = accumulator[query->b_offset + 5];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic Gen9 :: EU FPU0 Pipe Active */
static float
kblgt2__compute_basic__fpu0_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: EU FPU1 Pipe Active */
static float
kblgt2__compute_basic__fpu1_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: EU AVG IPC Rate */
static float
kblgt2__compute_basic__eu_avg_ipc_rate__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = accumulator[query->a_offset + 10];
   uint64_t tmp2 = accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics Basic Gen9 :: GS Threads Dispatched */
static uint64_t
kblgt2__compute_basic__gs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__compute_basic__hi_depth_test_fails__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: VS Threads Dispatched */
static uint64_t
kblgt2__compute_basic__vs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: FS Threads Dispatched */
static uint64_t
kblgt2__compute_basic__ps_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: Shader Barrier Messages */
static uint64_t
kblgt2__compute_basic__shader_barriers__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: Sampler Texels */
static uint64_t
kblgt2__compute_basic__sampler_texels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Pixels Failing Tests */
static uint64_t
kblgt2__compute_basic__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__compute_basic__gpu_time__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_basic__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__compute_basic__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Basic Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_basic__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics Basic Gen9 :: Sampler Texels Misses */
static uint64_t
kblgt2__compute_basic__sampler_texel_misses__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__compute_basic__cs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: SLM Bytes Read */
static uint64_t
kblgt2__compute_basic__slm_bytes_read__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: GTI Read Throughput */
static uint64_t
kblgt2__compute_basic__gti_read_throughput__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Untyped Writes */
static uint64_t
kblgt2__compute_basic__untyped_bytes_written__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: C 1 READ C 2 READ C 3 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = accumulator[query->c_offset + 2];
   uint64_t tmp2 = accumulator[query->c_offset + 3];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic Gen9 :: GPU Busy */
static float
kblgt2__compute_basic__gpu_busy__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: Rasterized Pixels */
static uint64_t
kblgt2__compute_basic__rasterized_pixels__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Typed Bytes Read */
static uint64_t
kblgt2__compute_basic__typed_bytes_read__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: B 0 READ B 1 READ B 2 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = accumulator[query->b_offset + 1];
   uint64_t tmp2 = accumulator[query->b_offset + 2];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;
   uint64_t tmp5 = brw->perfquery.sys_vars.n_eu_slices * 64;
   uint64_t tmp6 = tmp4 * tmp5;

   return tmp6;
}

/* Compute Metrics Basic Gen9 :: DS Threads Dispatched */
static uint64_t
kblgt2__compute_basic__ds_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: EU Thread Occupancy */
static float
kblgt2__compute_basic__eu_thread_occupancy__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 13 READ 8 UMUL $EuCoresTotalCount UDIV $EuThreadsCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0 * 8;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = brw->perfquery.sys_vars.eu_threads_count;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Compute Metrics Basic Gen9 :: EU Stall */
static float
kblgt2__compute_basic__eu_stall__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Basic Gen9 :: Samples Blended */
static uint64_t
kblgt2__compute_basic__samples_blended__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Early Depth Test Fails */
static uint64_t
kblgt2__compute_basic__early_depth_test_fails__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Shader Memory Accesses */
static uint64_t
kblgt2__compute_basic__shader_memory_accesses__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: HS Threads Dispatched */
static uint64_t
kblgt2__compute_basic__hs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: GTI Write Throughput */
static uint64_t
kblgt2__compute_basic__gti_write_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: SLM Bytes Written */
static uint64_t
kblgt2__compute_basic__slm_bytes_written__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: L3 Shader Throughput */
static uint64_t
kblgt2__compute_basic__l3_shader_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__compute_basic__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Compute Metrics Basic Gen9 :: Samples Killed in FS */
static uint64_t
kblgt2__compute_basic__samples_killed_in_ps__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Samples Written */
static uint64_t
kblgt2__compute_basic__samples_written__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Basic Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__compute_basic__shader_atomics__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Compute Metrics Basic Gen9 :: EU Send Pipe Active */
static float
kblgt2__compute_basic__eu_send_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_basic__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

static struct brw_perf_query_counter kblgt2_compute_basic_query_counters[39];
static struct brw_perf_query_info kblgt2_compute_basic_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics Basic Gen9",
   .guid = "e17fc42a-e614-41b6-90c4-1074841a6c77",
   .counters = kblgt2_compute_basic_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_compute_basic_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_compute_basic_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__untyped_bytes_read__read;
      counter->name = "Untyped Bytes Read";
      counter->desc = "The total number of typed memory bytes read via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__typed_bytes_written__read;
      counter->name = "Typed Bytes Written";
      counter->desc = "The total number of untyped memory bytes written via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__fpu0_active__read;
      counter->name = "EU FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 44;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__eu_avg_ipc_rate__read;
      counter->name = "EU AVG IPC Rate";
      counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 2;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__compute_basic__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__untyped_bytes_written__read;
      counter->name = "Untyped Writes";
      counter->desc = "The total number of untyped memory bytes written via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__typed_bytes_read__read;
      counter->name = "Typed Bytes Read";
      counter->desc = "The total number of typed memory bytes read via Data Port.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__eu_thread_occupancy__read;
      counter->name = "EU Thread Occupancy";
      counter->desc = "The percentage of time in which hardware threads occupied EUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 204;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_basic__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_basic__eu_send_active__read;
      counter->name = "EU Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 288;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__render_pipe_profile__gpu_core_clocks__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: EU Active */
static float
kblgt2__render_pipe_profile__eu_active__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: VS Bottleneck */
static float
kblgt2__render_pipe_profile__vs_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Hi-Depth Bottleneck */
static float
kblgt2__render_pipe_profile__hi_depth_bottleneck__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GS Bottleneck */
static float
kblgt2__render_pipe_profile__gs_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GS Threads Dispatched */
static uint64_t
kblgt2__render_pipe_profile__gs_threads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__render_pipe_profile__hi_depth_test_fails__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: VS Threads Dispatched */
static uint64_t
kblgt2__render_pipe_profile__vs_threads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: FS Threads Dispatched */
static uint64_t
kblgt2__render_pipe_profile__ps_threads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: BC Bottleneck */
static float
kblgt2__render_pipe_profile__bc_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: HS Stall */
static float
kblgt2__render_pipe_profile__hs_stall__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Shader Barrier Messages */
static uint64_t
kblgt2__render_pipe_profile__shader_barriers__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Sampler Texels */
static uint64_t
kblgt2__render_pipe_profile__sampler_texels__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Pixels Failing Tests */
static uint64_t
kblgt2__render_pipe_profile__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__render_pipe_profile__gpu_time__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__render_pipe_profile__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__render_pipe_profile__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__render_pipe_profile__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Sampler Texels Misses */
static uint64_t
kblgt2__render_pipe_profile__sampler_texel_misses__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__render_pipe_profile__cs_threads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: VF Bottleneck */
static float
kblgt2__render_pipe_profile__vf_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SLM Bytes Read */
static uint64_t
kblgt2__render_pipe_profile__slm_bytes_read__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Strip-Fans Bottleneck */
static float
kblgt2__render_pipe_profile__sf_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SF Stall */
static float
kblgt2__render_pipe_profile__sf_stall__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: GPU Busy */
static float
kblgt2__render_pipe_profile__gpu_busy__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: HS Bottleneck */
static float
kblgt2__render_pipe_profile__hs_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: CL Stall */
static float
kblgt2__render_pipe_profile__cl_stall__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SO Bottleneck */
static float
kblgt2__render_pipe_profile__so_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Rasterized Pixels */
static uint64_t
kblgt2__render_pipe_profile__rasterized_pixels__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: DS Threads Dispatched */
static uint64_t
kblgt2__render_pipe_profile__ds_threads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Samples Written */
static uint64_t
kblgt2__render_pipe_profile__samples_written__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: DS Bottleneck */
static float
kblgt2__render_pipe_profile__ds_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: EU Stall */
static float
kblgt2__render_pipe_profile__eu_stall__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Clipper Bottleneck */
static float
kblgt2__render_pipe_profile__cl_bottleneck__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: DS Stall */
static float
kblgt2__render_pipe_profile__ds_stall__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Early Depth Bottleneck */
static float
kblgt2__render_pipe_profile__early_depth_bottleneck__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: B 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Samples Blended */
static uint64_t
kblgt2__render_pipe_profile__samples_blended__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Early Depth Test Fails */
static uint64_t
kblgt2__render_pipe_profile__early_depth_test_fails__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Shader Memory Accesses */
static uint64_t
kblgt2__render_pipe_profile__shader_memory_accesses__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: HS Threads Dispatched */
static uint64_t
kblgt2__render_pipe_profile__hs_threads__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SLM Bytes Written */
static uint64_t
kblgt2__render_pipe_profile__slm_bytes_written__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: L3 Shader Throughput */
static uint64_t
kblgt2__render_pipe_profile__l3_shader_throughput__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__render_pipe_profile__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Samples Killed in FS */
static uint64_t
kblgt2__render_pipe_profile__samples_killed_in_ps__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: SO Stall */
static float
kblgt2__render_pipe_profile__so_stall__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__render_pipe_profile__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Render Metrics for 3D Pipeline Profile Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__render_pipe_profile__shader_atomics__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_render_pipe_profile_query_counters[43];
static struct brw_perf_query_info kblgt2_render_pipe_profile_query = {
   .kind = OA_COUNTERS,
   .name = "Render Metrics for 3D Pipeline Profile Gen9",
   .guid = "d7a17a3a-ca71-40d2-a919-ace80d50633f",
   .counters = kblgt2_render_pipe_profile_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_render_pipe_profile_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_render_pipe_profile_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__vs_bottleneck__read;
      counter->name = "VS Bottleneck";
      counter->desc = "The percentage of time in which vertex shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__hi_depth_bottleneck__read;
      counter->name = "Hi-Depth Bottleneck";
      counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__gs_bottleneck__read;
      counter->name = "GS Bottleneck";
      counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__bc_bottleneck__read;
      counter->name = "BC Bottleneck";
      counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__hs_stall__read;
      counter->name = "HS Stall";
      counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 60;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__render_pipe_profile__avg_gpu_core_frequency__max(brw);
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__vf_bottleneck__read;
      counter->name = "VF Bottleneck";
      counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__sf_bottleneck__read;
      counter->name = "Strip-Fans Bottleneck";
      counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__sf_stall__read;
      counter->name = "SF Stall";
      counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 140;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__hs_bottleneck__read;
      counter->name = "HS Bottleneck";
      counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__cl_stall__read;
      counter->name = "CL Stall";
      counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__so_bottleneck__read;
      counter->name = "SO Bottleneck";
      counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__ds_bottleneck__read;
      counter->name = "DS Bottleneck";
      counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 188;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__cl_bottleneck__read;
      counter->name = "Clipper Bottleneck";
      counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__ds_stall__read;
      counter->name = "DS Stall";
      counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 196;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__early_depth_bottleneck__read;
      counter->name = "Early Depth Bottleneck";
      counter->desc = "The percentage of time in which early depth test pipeline stage was slowing down the 3D pipeline.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__render_pipe_profile__so_stall__read;
      counter->name = "SO Stall";
      counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__render_pipe_profile__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Memory Reads Distribution Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__memory_reads__gpu_core_clocks__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: EU Active */
static float
kblgt2__memory_reads__eu_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__memory_reads__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank0Reads */
static uint64_t
kblgt2__memory_reads__gti_l3_bank0_reads__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GS Threads Dispatched */
static uint64_t
kblgt2__memory_reads__gs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiRingAccesses */
static uint64_t
kblgt2__memory_reads__gti_ring_accesses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__memory_reads__hi_depth_test_fails__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: VS Threads Dispatched */
static uint64_t
kblgt2__memory_reads__vs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: FS Threads Dispatched */
static uint64_t
kblgt2__memory_reads__ps_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank3Reads */
static uint64_t
kblgt2__memory_reads__gti_l3_bank3_reads__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 7];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Shader Barrier Messages */
static uint64_t
kblgt2__memory_reads__shader_barriers__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiRsMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_rs_memory_reads__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Sampler Texels */
static uint64_t
kblgt2__memory_reads__sampler_texels__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: Pixels Failing Tests */
static uint64_t
kblgt2__memory_reads__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiHizMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_hiz_memory_reads__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__memory_reads__gpu_time__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Reads Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__memory_reads__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__memory_reads__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__memory_reads__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Memory Reads Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__memory_reads__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Memory Reads Distribution Gen9 :: Sampler Texels Misses */
static uint64_t
kblgt2__memory_reads__sampler_texel_misses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiRccMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_rcc_memory_reads__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__memory_reads__cs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: SLM Bytes Read */
static uint64_t
kblgt2__memory_reads__slm_bytes_read__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank1Reads */
static uint64_t
kblgt2__memory_reads__gti_l3_bank1_reads__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 5 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 5];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GPU Busy */
static float
kblgt2__memory_reads__gpu_busy__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__memory_reads__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Reads Distribution Gen9 :: GtiCmdStreamerMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_cmd_streamer_memory_reads__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiL3Bank2Reads */
static uint64_t
kblgt2__memory_reads__gti_l3_bank2_reads__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 6 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 6];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_memory_reads__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 0 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 0];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Rasterized Pixels */
static uint64_t
kblgt2__memory_reads__rasterized_pixels__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiRczMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_rcz_memory_reads__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: DS Threads Dispatched */
static uint64_t
kblgt2__memory_reads__ds_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Samples Written */
static uint64_t
kblgt2__memory_reads__samples_written__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: EU Stall */
static float
kblgt2__memory_reads__eu_stall__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__memory_reads__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Reads Distribution Gen9 :: Samples Blended */
static uint64_t
kblgt2__memory_reads__samples_blended__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: Early Depth Test Fails */
static uint64_t
kblgt2__memory_reads__early_depth_test_fails__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiMscMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_msc_memory_reads__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiVfMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_vf_memory_reads__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 1];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: GtiStcMemoryReads */
static uint64_t
kblgt2__memory_reads__gti_stc_memory_reads__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Shader Memory Accesses */
static uint64_t
kblgt2__memory_reads__shader_memory_accesses__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: HS Threads Dispatched */
static uint64_t
kblgt2__memory_reads__hs_threads__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Memory Reads Distribution Gen9 :: Samples Killed in FS */
static uint64_t
kblgt2__memory_reads__samples_killed_in_ps__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: SLM Bytes Written */
static uint64_t
kblgt2__memory_reads__slm_bytes_written__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Reads Distribution Gen9 :: GtiL3Reads */
static uint64_t
kblgt2__memory_reads__gti_l3_reads__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: $GtiL3Bank0Reads $GtiL3Bank1Reads $GtiL3Bank2Reads $GtiL3Bank3Reads UADD UADD UADD */
   uint64_t tmp0 = kblgt2__memory_reads__gti_l3_bank2_reads__read(brw, query, accumulator) + kblgt2__memory_reads__gti_l3_bank3_reads__read(brw, query, accumulator);
   uint64_t tmp1 = kblgt2__memory_reads__gti_l3_bank1_reads__read(brw, query, accumulator) + tmp0;
   uint64_t tmp2 = kblgt2__memory_reads__gti_l3_bank0_reads__read(brw, query, accumulator) + tmp1;

   return tmp2;
}

/* Memory Reads Distribution Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__memory_reads__shader_atomics__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_memory_reads_query_counters[41];
static struct brw_perf_query_info kblgt2_memory_reads_query = {
   .kind = OA_COUNTERS,
   .name = "Memory Reads Distribution Gen9",
   .guid = "57b59202-172b-477a-87de-33f85572c589",
   .counters = kblgt2_memory_reads_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_memory_reads_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_memory_reads_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__memory_reads__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_l3_bank0_reads__read;
      counter->name = "GtiL3Bank0Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 0 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_ring_accesses__read;
      counter->name = "GtiRingAccesses";
      counter->desc = "The total number of all accesses from GTI to the ring.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_l3_bank3_reads__read;
      counter->name = "GtiL3Bank3Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 3 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_rs_memory_reads__read;
      counter->name = "GtiRsMemoryReads";
      counter->desc = "The total number of GTI memory reads from Resource Streamer.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_hiz_memory_reads__read;
      counter->name = "GtiHizMemoryReads";
      counter->desc = "The total number of GTI memory reads from Hierarchical Depth Cache (Hi-Depth Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__memory_reads__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_rcc_memory_reads__read;
      counter->name = "GtiRccMemoryReads";
      counter->desc = "The total number of GTI memory reads from Render Color Cache (Render Color Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_l3_bank1_reads__read;
      counter->name = "GtiL3Bank1Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 1 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__memory_reads__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_cmd_streamer_memory_reads__read;
      counter->name = "GtiCmdStreamerMemoryReads";
      counter->desc = "The total number of GTI memory reads from Command Streamer.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_l3_bank2_reads__read;
      counter->name = "GtiL3Bank2Reads";
      counter->desc = "The total number of GTI memory reads from L3 Bank 2 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_memory_reads__read;
      counter->name = "GtiMemoryReads";
      counter->desc = "The total number of GTI memory reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_rcz_memory_reads__read;
      counter->name = "GtiRczMemoryReads";
      counter->desc = "The total number of GTI memory reads from Render Depth Cache (Render Depth Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__memory_reads__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 232;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_msc_memory_reads__read;
      counter->name = "GtiMscMemoryReads";
      counter->desc = "The total number of GTI memory reads from Multisampling Color Cache (Multisampling Color Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_vf_memory_reads__read;
      counter->name = "GtiVfMemoryReads";
      counter->desc = "The total number of GTI memory reads from Vertex Fetch.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_stc_memory_reads__read;
      counter->name = "GtiStcMemoryReads";
      counter->desc = "The total number of GTI memory reads from Stencil Cache (Stencil Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__gti_l3_reads__read;
      counter->name = "GtiL3Reads";
      counter->desc = "The total number of GTI memory reads from L3 (L3 Cache misses).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 312;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_reads__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 320;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Memory Writes Distribution Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__memory_writes__gpu_core_clocks__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: EU Active */
static float
kblgt2__memory_writes__eu_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__memory_writes__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Writes Distribution Gen9 :: GtiMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_memory_writes__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 0 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 0];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GS Threads Dispatched */
static uint64_t
kblgt2__memory_writes__gs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiRingAccesses */
static uint64_t
kblgt2__memory_writes__gti_ring_accesses__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__memory_writes__hi_depth_test_fails__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: VS Threads Dispatched */
static uint64_t
kblgt2__memory_writes__vs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: FS Threads Dispatched */
static uint64_t
kblgt2__memory_writes__ps_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiMscMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_msc_memory_writes__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Shader Barrier Messages */
static uint64_t
kblgt2__memory_writes__shader_barriers__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiCmdStreamerMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_cmd_streamer_memory_writes__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Sampler Texels */
static uint64_t
kblgt2__memory_writes__sampler_texels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Pixels Failing Tests */
static uint64_t
kblgt2__memory_writes__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                          const struct brw_perf_query_info *query,
                                                          uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank0Writes */
static uint64_t
kblgt2__memory_writes__gti_l3_bank0_writes__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank1Writes */
static uint64_t
kblgt2__memory_writes__gti_l3_bank1_writes__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 5 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 5];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank2Writes */
static uint64_t
kblgt2__memory_writes__gti_l3_bank2_writes__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 6 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 6];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Bank3Writes */
static uint64_t
kblgt2__memory_writes__gti_l3_bank3_writes__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 7];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiL3Writes */
static uint64_t
kblgt2__memory_writes__gti_l3_writes__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $GtiL3Bank0Writes $GtiL3Bank1Writes $GtiL3Bank2Writes $GtiL3Bank3Writes UADD UADD UADD */
   uint64_t tmp0 = kblgt2__memory_writes__gti_l3_bank2_writes__read(brw, query, accumulator) + kblgt2__memory_writes__gti_l3_bank3_writes__read(brw, query, accumulator);
   uint64_t tmp1 = kblgt2__memory_writes__gti_l3_bank1_writes__read(brw, query, accumulator) + tmp0;
   uint64_t tmp2 = kblgt2__memory_writes__gti_l3_bank0_writes__read(brw, query, accumulator) + tmp1;

   return tmp2;
}

/* Memory Writes Distribution Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__memory_writes__gpu_time__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Writes Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__memory_writes__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__memory_writes__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__memory_writes__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Memory Writes Distribution Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__memory_writes__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Memory Writes Distribution Gen9 :: Sampler Texels Misses */
static uint64_t
kblgt2__memory_writes__sampler_texel_misses__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__memory_writes__cs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: SLM Bytes Read */
static uint64_t
kblgt2__memory_writes__slm_bytes_read__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: GtiRccMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_rcc_memory_writes__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiSoMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_so_memory_writes__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GPU Busy */
static float
kblgt2__memory_writes__gpu_busy__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__memory_writes__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Memory Writes Distribution Gen9 :: GtiStcMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_stc_memory_writes__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Rasterized Pixels */
static uint64_t
kblgt2__memory_writes__rasterized_pixels__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: DS Threads Dispatched */
static uint64_t
kblgt2__memory_writes__ds_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Samples Written */
static uint64_t
kblgt2__memory_writes__samples_written__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: EU Stall */
static float
kblgt2__memory_writes__eu_stall__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__memory_writes__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Memory Writes Distribution Gen9 :: Samples Blended */
static uint64_t
kblgt2__memory_writes__samples_blended__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Early Depth Test Fails */
static uint64_t
kblgt2__memory_writes__early_depth_test_fails__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: Shader Memory Accesses */
static uint64_t
kblgt2__memory_writes__shader_memory_accesses__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: HS Threads Dispatched */
static uint64_t
kblgt2__memory_writes__hs_threads__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: GtiRczMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_rcz_memory_writes__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: SLM Bytes Written */
static uint64_t
kblgt2__memory_writes__slm_bytes_written__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: L3 Shader Throughput */
static uint64_t
kblgt2__memory_writes__l3_shader_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__memory_writes__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Memory Writes Distribution Gen9 :: Samples Killed in FS */
static uint64_t
kblgt2__memory_writes__samples_killed_in_ps__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Memory Writes Distribution Gen9 :: GtiHizMemoryWrites */
static uint64_t
kblgt2__memory_writes__gti_hiz_memory_writes__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* Memory Writes Distribution Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__memory_writes__shader_atomics__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_memory_writes_query_counters[41];
static struct brw_perf_query_info kblgt2_memory_writes_query = {
   .kind = OA_COUNTERS,
   .name = "Memory Writes Distribution Gen9",
   .guid = "3addf8ef-8e9b-40f5-a448-3dbb5d5128b0",
   .counters = kblgt2_memory_writes_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_memory_writes_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_memory_writes_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__memory_writes__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_memory_writes__read;
      counter->name = "GtiMemoryWrites";
      counter->desc = "The total number of GTI memory writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_ring_accesses__read;
      counter->name = "GtiRingAccesses";
      counter->desc = "The total number of all GTI accesses to the ring.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_msc_memory_writes__read;
      counter->name = "GtiMscMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Multisampling Color Cache (Multisampling Color Cache invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_cmd_streamer_memory_writes__read;
      counter->name = "GtiCmdStreamerMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Command Streamer.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_l3_bank0_writes__read;
      counter->name = "GtiL3Bank0Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 0 (L3 Bank 0 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_l3_bank1_writes__read;
      counter->name = "GtiL3Bank1Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 1 (L3 Bank 1 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_l3_bank2_writes__read;
      counter->name = "GtiL3Bank2Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 2 (L3 Bank 2 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_l3_bank3_writes__read;
      counter->name = "GtiL3Bank3Writes";
      counter->desc = "The total number of GTI memory writes from L3 Bank 3 (L3 Bank 3 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_l3_writes__read;
      counter->name = "GtiL3Writes";
      counter->desc = "The total number of GTI memory writes from L3 (L3 invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__memory_writes__avg_gpu_core_frequency__max(brw);
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_rcc_memory_writes__read;
      counter->name = "GtiRccMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Render Color Cache (Render Color Cache invalidations).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_so_memory_writes__read;
      counter->name = "GtiSoMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Stream Output.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__memory_writes__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_stc_memory_writes__read;
      counter->name = "GtiStcMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Stencil Cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__memory_writes__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 240;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_rcz_memory_writes__read;
      counter->name = "GtiRczMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Render Depth Cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 296;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__gti_hiz_memory_writes__read;
      counter->name = "GtiHizMemoryWrites";
      counter->desc = "The total number of GTI memory writes from Hierarchical Depth Cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 312;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__memory_writes__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 320;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics Extended Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__compute_extended__gpu_core_clocks__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EU Active */
static float
kblgt2__compute_extended__eu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU Both FPU Pipes Active */
static float
kblgt2__compute_extended__eu_fpu_both_active__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU FPU0 Pipe Active */
static float
kblgt2__compute_extended__fpu0_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU FPU1 Pipe Active */
static float
kblgt2__compute_extended__fpu1_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EU AVG IPC Rate */
static float
kblgt2__compute_extended__eu_avg_ipc_rate__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = accumulator[query->a_offset + 10];
   uint64_t tmp2 = accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics Extended Gen9 :: Typed Writes 0 */
static uint64_t
kblgt2__compute_extended__typed_writes0__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 0 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuTypedAtomics0 */
static uint64_t
kblgt2__compute_extended__eu_typed_atomics0__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Typed Atomics 0 */
static uint64_t
kblgt2__compute_extended__typed_atomics0__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 4 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: TypedAtomicsPerCacheLine */
static float
kblgt2__compute_extended__typed_atomics_per_cache_line__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: $EuTypedAtomics0 $TypedAtomics0 FDIV */
   double tmp0 = kblgt2__compute_extended__eu_typed_atomics0__read(brw, query, accumulator);
   double tmp1 = kblgt2__compute_extended__typed_atomics0__read(brw, query, accumulator);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended Gen9 :: EuUntypedReads0 */
static uint64_t
kblgt2__compute_extended__eu_untyped_reads0__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Untyped Writes 0 */
static uint64_t
kblgt2__compute_extended__untyped_writes0__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: C 1 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 1];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuUntypedAtomics0 */
static uint64_t
kblgt2__compute_extended__eu_untyped_atomics0__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuUntypedWrites0 */
static uint64_t
kblgt2__compute_extended__eu_untyped_writes0__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 1];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuA64UntypedWrites0 */
static uint64_t
kblgt2__compute_extended__eu_a64_untyped_writes0__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: UntypedWritesPerCacheLine */
static float
kblgt2__compute_extended__untyped_writes_per_cache_line__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: $EuUntypedWrites0 $EuA64UntypedWrites0 UADD $UntypedWrites0 FDIV */
   uint64_t tmp0 = kblgt2__compute_extended__eu_untyped_writes0__read(brw, query, accumulator) + kblgt2__compute_extended__eu_a64_untyped_writes0__read(brw, query, accumulator);
   double tmp1 = tmp0;
   double tmp2 = kblgt2__compute_extended__untyped_writes0__read(brw, query, accumulator);
   double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended Gen9 :: Shader Barrier Messages */
static uint64_t
kblgt2__compute_extended__shader_barriers__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Sampler Texels */
static uint64_t
kblgt2__compute_extended__sampler_texels__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__compute_extended__gpu_time__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Extended Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_extended__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__compute_extended__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_extended__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics Extended Gen9 :: Sampler Texels Misses */
static uint64_t
kblgt2__compute_extended__sampler_texel_misses__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__compute_extended__cs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: SLM Bytes Read */
static uint64_t
kblgt2__compute_extended__slm_bytes_read__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: EuTypedWrites0 */
static uint64_t
kblgt2__compute_extended__eu_typed_writes0__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: TypedWritesPerCacheLine */
static float
kblgt2__compute_extended__typed_writes_per_cache_line__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: $EuTypedWrites0 $TypedWrites0 FDIV */
   double tmp0 = kblgt2__compute_extended__eu_typed_writes0__read(brw, query, accumulator);
   double tmp1 = kblgt2__compute_extended__typed_writes0__read(brw, query, accumulator);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended Gen9 :: Typed Reads 0 */
static uint64_t
kblgt2__compute_extended__typed_reads0__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: C 2 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 2];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: Untyped Reads 0 */
static uint64_t
kblgt2__compute_extended__untyped_reads0__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: C 3 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 3];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EuA64UntypedReads0 */
static uint64_t
kblgt2__compute_extended__eu_a64_untyped_reads0__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EU Thread Occupancy */
static float
kblgt2__compute_extended__eu_thread_occupancy__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 13 READ 8 UMUL $EuCoresTotalCount UDIV $EuThreadsCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0 * 8;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = brw->perfquery.sys_vars.eu_threads_count;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Compute Metrics Extended Gen9 :: EU Stall */
static float
kblgt2__compute_extended__eu_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extended Gen9 :: EuTypedReads0 */
static uint64_t
kblgt2__compute_extended__eu_typed_reads0__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: UntypedReadsPerCacheLine */
static float
kblgt2__compute_extended__untyped_reads_per_cache_line__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: $EuUntypedReads0 $EuA64UntypedReads0 UADD $UntypedReads0 FDIV */
   uint64_t tmp0 = kblgt2__compute_extended__eu_untyped_reads0__read(brw, query, accumulator) + kblgt2__compute_extended__eu_a64_untyped_reads0__read(brw, query, accumulator);
   double tmp1 = tmp0;
   double tmp2 = kblgt2__compute_extended__untyped_reads0__read(brw, query, accumulator);
   double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extended Gen9 :: Shader Memory Accesses */
static uint64_t
kblgt2__compute_extended__shader_memory_accesses__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: TypedReadsPerCacheLine */
static float
kblgt2__compute_extended__typed_reads_per_cache_line__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: $EuTypedReads0 $TypedReads0 FDIV */
   double tmp0 = kblgt2__compute_extended__eu_typed_reads0__read(brw, query, accumulator);
   double tmp1 = kblgt2__compute_extended__typed_reads0__read(brw, query, accumulator);
   double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

   return tmp2;
}

/* Compute Metrics Extended Gen9 :: SLM Bytes Written */
static uint64_t
kblgt2__compute_extended__slm_bytes_written__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics Extended Gen9 :: L3 Shader Throughput */
static uint64_t
kblgt2__compute_extended__l3_shader_throughput__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__compute_extended__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Compute Metrics Extended Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__compute_extended__shader_atomics__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Compute Metrics Extended Gen9 :: EU Send Pipe Active */
static float
kblgt2__compute_extended__eu_send_active__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_extended__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

static struct brw_perf_query_counter kblgt2_compute_extended_query_counters[38];
static struct brw_perf_query_info kblgt2_compute_extended_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics Extended Gen9",
   .guid = "4af0400a-81c3-47db-a6b6-deddbd75680e",
   .counters = kblgt2_compute_extended_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_compute_extended_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_compute_extended_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__fpu0_active__read;
      counter->name = "EU FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__eu_avg_ipc_rate__read;
      counter->name = "EU AVG IPC Rate";
      counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 2;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__typed_writes0__read;
      counter->name = "Typed Writes 0";
      counter->desc = "The subslice 0 typed writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_typed_atomics0__read;
      counter->name = "EuTypedAtomics0";
      counter->desc = "The subslice 0 EU Typed Atomics subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__typed_atomics0__read;
      counter->name = "Typed Atomics 0";
      counter->desc = "The subslice 0 typed atomics.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__typed_atomics_per_cache_line__read;
      counter->name = "TypedAtomicsPerCacheLine";
      counter->desc = "The ratio of EU typed atomics requests to L3 cache line writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_untyped_reads0__read;
      counter->name = "EuUntypedReads0";
      counter->desc = "The subslice 0 EU Untyped Reads subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__untyped_writes0__read;
      counter->name = "Untyped Writes 0";
      counter->desc = "The subslice 0 untyped writes (including SLM writes).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_untyped_atomics0__read;
      counter->name = "EuUntypedAtomics0";
      counter->desc = "The subslice 0 EU Untyped Atomics subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_untyped_writes0__read;
      counter->name = "EuUntypedWrites0";
      counter->desc = "The subslice 0 EU Untyped Writes subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_a64_untyped_writes0__read;
      counter->name = "EuA64UntypedWrites0";
      counter->desc = "The subslice 0 EU A64 Untyped Writes subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__untyped_writes_per_cache_line__read;
      counter->name = "UntypedWritesPerCacheLine";
      counter->desc = "The ratio of EU untyped write requests to L3 cache line writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__compute_extended__avg_gpu_core_frequency__max(brw);
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_typed_writes0__read;
      counter->name = "EuTypedWrites0";
      counter->desc = "The subslice 0 EU Typed Writes subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__typed_writes_per_cache_line__read;
      counter->name = "TypedWritesPerCacheLine";
      counter->desc = "The ratio of EU typed write requests to L3 cache line writes.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__typed_reads0__read;
      counter->name = "Typed Reads 0";
      counter->desc = "The subslice 0 typed reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__untyped_reads0__read;
      counter->name = "Untyped Reads 0";
      counter->desc = "The subslice 0 untyped reads (including SLM reads).";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_a64_untyped_reads0__read;
      counter->name = "EuA64UntypedReads0";
      counter->desc = "The subslice 0 EU A64 Untyped Reads subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__eu_thread_occupancy__read;
      counter->name = "EU Thread Occupancy";
      counter->desc = "The percentage of time in which hardware threads occupied EUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 208;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 212;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__eu_typed_reads0__read;
      counter->name = "EuTypedReads0";
      counter->desc = "The subslice 0 EU Typed Reads subslice 0.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__untyped_reads_per_cache_line__read;
      counter->name = "UntypedReadsPerCacheLine";
      counter->desc = "The ratio of EU untyped read requests to L3 cache line reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__typed_reads_per_cache_line__read;
      counter->name = "TypedReadsPerCacheLine";
      counter->desc = "The ratio of EU typed read requests to L3 cache line reads.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extended__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extended__eu_send_active__read;
      counter->name = "EU Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 272;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics L3 Cache Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__compute_l3_cache__gpu_core_clocks__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: EU Active */
static float
kblgt2__compute_l3_cache__eu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 03 Accesses */
static uint64_t
kblgt2__compute_l3_cache__l3_bank03_accesses__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Accesses */
static uint64_t
kblgt2__compute_l3_cache__l3_accesses__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: C 0 READ C 1 READ B 2 READ B 3 READ UADD UADD UADD 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = accumulator[query->c_offset + 1];
   uint64_t tmp2 = accumulator[query->b_offset + 2];
   uint64_t tmp3 = accumulator[query->b_offset + 3];
   uint64_t tmp4 = tmp2 + tmp3;
   uint64_t tmp5 = tmp1 + tmp4;
   uint64_t tmp6 = tmp0 + tmp5;
   uint64_t tmp7 = tmp6 * 2;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU Both FPU Pipes Active */
static float
kblgt2__compute_l3_cache__eu_fpu_both_active__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Sampler Throughput */
static uint64_t
kblgt2__compute_l3_cache__l3_sampler_throughput__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Pipe Active */
static float
kblgt2__compute_l3_cache__fpu0_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Pipe Active */
static float
kblgt2__compute_l3_cache__fpu1_active__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU AVG IPC Rate */
static float
kblgt2__compute_l3_cache__eu_avg_ipc_rate__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = accumulator[query->a_offset + 10];
   uint64_t tmp2 = accumulator[query->a_offset + 11];
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->a_offset + 9];
   uint64_t tmp5 = tmp3 - tmp4;
   double tmp6 = tmp0;
   double tmp7 = tmp5;
   double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
   double tmp9 = tmp8 + 1;

   return tmp9;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Binary Instruction */
static float
kblgt2__compute_l3_cache__eu_binary_fpu0_instruction__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: GS Threads Dispatched */
static uint64_t
kblgt2__compute_l3_cache__gs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Shader Memory Accesses */
static uint64_t
kblgt2__compute_l3_cache__shader_memory_accesses__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__compute_l3_cache__hi_depth_test_fails__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: VS Threads Dispatched */
static uint64_t
kblgt2__compute_l3_cache__vs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: FS Threads Dispatched */
static uint64_t
kblgt2__compute_l3_cache__ps_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Hybrid Instruction */
static float
kblgt2__compute_l3_cache__eu_hybrid_fpu0_instruction__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 13];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Misses */
static uint64_t
kblgt2__compute_l3_cache__l3_misses__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: C 4 READ C 5 READ UADD */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = accumulator[query->c_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;

   return tmp2;
}

/* Compute Metrics L3 Cache Gen9 :: Shader Barrier Messages */
static uint64_t
kblgt2__compute_l3_cache__shader_barriers__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 00 Accesses */
static uint64_t
kblgt2__compute_l3_cache__l3_bank00_accesses__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: C 0 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 0];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Move Instruction */
static float
kblgt2__compute_l3_cache__eu_move_fpu0_instruction__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 19 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 19];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: Sampler Texels */
static uint64_t
kblgt2__compute_l3_cache__sampler_texels__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: Pixels Failing Tests */
static uint64_t
kblgt2__compute_l3_cache__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                             const struct brw_perf_query_info *query,
                                                             uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Hybrid Instruction */
static float
kblgt2__compute_l3_cache__eu_hybrid_fpu1_instruction__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 14 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 14];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__compute_l3_cache__gpu_time__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_l3_cache__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__compute_l3_cache__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics L3 Cache Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_l3_cache__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics L3 Cache Gen9 :: Sampler Texels Misses */
static uint64_t
kblgt2__compute_l3_cache__sampler_texel_misses__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__compute_l3_cache__cs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: SLM Bytes Read */
static uint64_t
kblgt2__compute_l3_cache__slm_bytes_read__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: GTI Read Throughput */
static uint64_t
kblgt2__compute_l3_cache__gti_read_throughput__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: GTI L3 Throughput */
static uint64_t
kblgt2__compute_l3_cache__gti_l3_throughput__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: C 4 READ C 5 READ UADD 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = accumulator[query->c_offset + 5];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 64;

   return tmp3;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 00 IC Accesses */
static uint64_t
kblgt2__compute_l3_cache__l3_bank00_ic_accesses__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: B 0 READ B 1 READ UADD 2 UMUL $L3Bank00Accesses UMIN */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = accumulator[query->b_offset + 1];
   uint64_t tmp2 = tmp0 + tmp1;
   uint64_t tmp3 = tmp2 * 2;
   uint64_t tmp4 = MIN(tmp3, kblgt2__compute_l3_cache__l3_bank00_accesses__read(brw, query, accumulator));

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 00 IC Hits */
static uint64_t
kblgt2__compute_l3_cache__l3_bank00_ic_hits__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 2 UMUL $L3Bank00IcAccesses UMIN */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 2;
   uint64_t tmp2 = MIN(tmp1, kblgt2__compute_l3_cache__l3_bank00_ic_accesses__read(brw, query, accumulator));

   return tmp2;
}

/* Compute Metrics L3 Cache Gen9 :: Sampler Accesses */
static uint64_t
kblgt2__compute_l3_cache__sampler_accesses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 28 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 28];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 01 Accesses */
static uint64_t
kblgt2__compute_l3_cache__l3_bank01_accesses__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: C 1 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 1];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: GPU Busy */
static float
kblgt2__compute_l3_cache__gpu_busy__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU0 Ternary Instruction */
static float
kblgt2__compute_l3_cache__eu_ternary_fpu0_instruction__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__compute_l3_cache__shader_atomics__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Rasterized Pixels */
static uint64_t
kblgt2__compute_l3_cache__rasterized_pixels__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: DS Threads Dispatched */
static uint64_t
kblgt2__compute_l3_cache__ds_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: Samples Written */
static uint64_t
kblgt2__compute_l3_cache__samples_written__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Move Instruction */
static float
kblgt2__compute_l3_cache__eu_move_fpu1_instruction__read(struct brw_context *brw,
                                                         const struct brw_perf_query_info *query,
                                                         uint64_t *accumulator)
{
   /* RPN equation: A 20 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 20];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU Stall */
static float
kblgt2__compute_l3_cache__eu_stall__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: Samples Blended */
static uint64_t
kblgt2__compute_l3_cache__samples_blended__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: Early Depth Test Fails */
static uint64_t
kblgt2__compute_l3_cache__early_depth_test_fails__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Bank 02 Accesses */
static uint64_t
kblgt2__compute_l3_cache__l3_bank02_accesses__read(struct brw_context *brw,
                                                   const struct brw_perf_query_info *query,
                                                   uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 2 UMUL */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 2;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: HS Threads Dispatched */
static uint64_t
kblgt2__compute_l3_cache__hs_threads__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Total Throughput */
static uint64_t
kblgt2__compute_l3_cache__l3_total_throughput__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: $L3Accesses 64 UMUL */
   uint64_t tmp0 = kblgt2__compute_l3_cache__l3_accesses__read(brw, query, accumulator) * 64;

   return tmp0;
}

/* Compute Metrics L3 Cache Gen9 :: GTI Write Throughput */
static uint64_t
kblgt2__compute_l3_cache__gti_write_throughput__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: SLM Bytes Written */
static uint64_t
kblgt2__compute_l3_cache__slm_bytes_written__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: L3 Shader Throughput */
static uint64_t
kblgt2__compute_l3_cache__l3_shader_throughput__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__compute_l3_cache__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Compute Metrics L3 Cache Gen9 :: Samples Killed in FS */
static uint64_t
kblgt2__compute_l3_cache__samples_killed_in_ps__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Binary Instruction */
static float
kblgt2__compute_l3_cache__eu_binary_fpu1_instruction__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU FPU1 Ternary Instruction */
static float
kblgt2__compute_l3_cache__eu_ternary_fpu1_instruction__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics L3 Cache Gen9 :: EU Send Pipe Active */
static float
kblgt2__compute_l3_cache__eu_send_active__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_l3_cache__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

static struct brw_perf_query_counter kblgt2_compute_l3_cache_query_counters[54];
static struct brw_perf_query_info kblgt2_compute_l3_cache_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics L3 Cache Gen9",
   .guid = "0e22f995-79ca-4f67-83ab-e9d9772488d8",
   .counters = kblgt2_compute_l3_cache_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_compute_l3_cache_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_compute_l3_cache_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_bank03_accesses__read;
         counter->name = "L3 Bank 03 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 03.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 16;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_accesses__read;
      counter->name = "L3 Accesses";
      counter->desc = "The total number of L3 accesses from all entities.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 32;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_sampler_throughput__read;
      counter->name = "L3 Sampler Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__fpu0_active__read;
      counter->name = "EU FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 52;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_avg_ipc_rate__read;
      counter->name = "EU AVG IPC Rate";
      counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 2;
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_binary_fpu0_instruction__read;
      counter->name = "EU FPU0 Binary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing binary instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 60;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_hybrid_fpu0_instruction__read;
      counter->name = "EU FPU0 Hybrid Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 104;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_misses__read;
      counter->name = "L3 Misses";
      counter->desc = "The total number of L3 misses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_bank00_accesses__read;
         counter->name = "L3 Bank 00 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 00.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 128;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_move_fpu0_instruction__read;
      counter->name = "EU FPU0 Move Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing move instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_hybrid_fpu1_instruction__read;
      counter->name = "EU FPU1 Hybrid Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing hybrid instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__compute_l3_cache__avg_gpu_core_frequency__max(brw);
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__gti_read_throughput__read;
      counter->name = "GTI Read Throughput";
      counter->desc = "The total number of GPU memory bytes read from GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__gti_l3_throughput__read;
      counter->name = "GTI L3 Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_bank00_ic_accesses__read;
         counter->name = "L3 Bank 00 IC Accesses";
         counter->desc = "The total number of accesses to L3 Bank 00 from IC cache.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 224;
         counter->size = sizeof(uint64_t);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_bank00_ic_hits__read;
         counter->name = "L3 Bank 00 IC Hits";
         counter->desc = "The total number of hits in L3 Bank 00 from IC cache.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 232;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__sampler_accesses__read;
      counter->name = "Sampler Accesses";
      counter->desc = "The total number of messages send to samplers.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_bank01_accesses__read;
         counter->name = "L3 Bank 01 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 01.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 248;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 256;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_ternary_fpu0_instruction__read;
      counter->name = "EU FPU0 Ternary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU0.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 260;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 288;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_move_fpu1_instruction__read;
      counter->name = "EU FPU1 Move Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing move instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 296;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 300;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 304;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 312;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x01) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_bank02_accesses__read;
         counter->name = "L3 Bank 02 Accesses";
         counter->desc = "The total number of accesses to L3 Bank 02.";
         counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
         counter->raw_max = 0; /* undefined */
         counter->offset = 320;
         counter->size = sizeof(uint64_t);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 328;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_total_throughput__read;
      counter->name = "L3 Total Throughput";
      counter->desc = "The total number of GPU memory bytes transferred via L3.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 336;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__gti_write_throughput__read;
      counter->name = "GTI Write Throughput";
      counter->desc = "The total number of GPU memory bytes written to GTI.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 344;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 352;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 360;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_l3_cache__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 368;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_binary_fpu1_instruction__read;
      counter->name = "EU FPU1 Binary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing binary instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 376;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_ternary_fpu1_instruction__read;
      counter->name = "EU FPU1 Ternary Instruction";
      counter->desc = "The percentage of time in which execution units were actively processing ternary instructions on FPU1.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 380;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_l3_cache__eu_send_active__read;
      counter->name = "EU Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 384;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set HDCAndSF :: GPU Core Clocks */
static uint64_t
kblgt2__hdc_and_sf__gpu_core_clocks__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set HDCAndSF :: EU Active */
static float
kblgt2__hdc_and_sf__eu_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: EU Both FPU Pipes Active */
static float
kblgt2__hdc_and_sf__eu_fpu_both_active__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS Send Pipe Active */
static float
kblgt2__hdc_and_sf__vs_send_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS FPU1 Pipe Active */
static float
kblgt2__hdc_and_sf__vs_fpu1_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: GS Threads Dispatched */
static uint64_t
kblgt2__hdc_and_sf__gs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set HDCAndSF :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__hdc_and_sf__hi_depth_test_fails__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: FS Both FPU Active */
static float
kblgt2__hdc_and_sf__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                                const struct brw_perf_query_info *query,
                                                uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS Threads Dispatched */
static uint64_t
kblgt2__hdc_and_sf__vs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set HDCAndSF :: Polygon Data Ready */
static float
kblgt2__hdc_and_sf__poly_data_ready__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: FS Threads Dispatched */
static uint64_t
kblgt2__hdc_and_sf__ps_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set HDCAndSF :: Shader Barrier Messages */
static uint64_t
kblgt2__hdc_and_sf__shader_barriers__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set HDCAndSF :: Sampler Texels */
static uint64_t
kblgt2__hdc_and_sf__sampler_texels__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Pixels Failing Tests */
static uint64_t
kblgt2__hdc_and_sf__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: GPU Time Elapsed */
static uint64_t
kblgt2__hdc_and_sf__gpu_time__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
static uint64_t
kblgt2__hdc_and_sf__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__hdc_and_sf__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set HDCAndSF :: AVG GPU Core Frequency */
static uint64_t
kblgt2__hdc_and_sf__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set HDCAndSF :: Sampler Texels Misses */
static uint64_t
kblgt2__hdc_and_sf__sampler_texel_misses__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
static float
kblgt2__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read(struct brw_context *brw,
                                                                    const struct brw_perf_query_info *query,
                                                                    uint64_t *accumulator)
{
   /* RPN equation: C 5 READ C 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = accumulator[query->c_offset + 4];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: CS Threads Dispatched */
static uint64_t
kblgt2__hdc_and_sf__cs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
static float
kblgt2__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read(struct brw_context *brw,
                                                                    const struct brw_perf_query_info *query,
                                                                    uint64_t *accumulator)
{
   /* RPN equation: C 3 READ C 2 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = accumulator[query->c_offset + 2];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: SLM Bytes Read */
static uint64_t
kblgt2__hdc_and_sf__slm_bytes_read__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set HDCAndSF :: PS FPU1 Pipe Active */
static float
kblgt2__hdc_and_sf__ps_fpu1_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: PS Send Pipeline Active */
static float
kblgt2__hdc_and_sf__ps_send_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: VS FPU0 Pipe Active */
static float
kblgt2__hdc_and_sf__vs_fpu0_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: GPU Busy */
static float
kblgt2__hdc_and_sf__gpu_busy__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set HDCAndSF :: Rasterized Pixels */
static uint64_t
kblgt2__hdc_and_sf__rasterized_pixels__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: PS FPU0 Pipe Active */
static float
kblgt2__hdc_and_sf__ps_fpu0_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: DS Threads Dispatched */
static uint64_t
kblgt2__hdc_and_sf__ds_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set HDCAndSF :: Samples Written */
static uint64_t
kblgt2__hdc_and_sf__samples_written__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: EU Stall */
static float
kblgt2__hdc_and_sf__eu_stall__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set HDCAndSF :: Samples Blended */
static uint64_t
kblgt2__hdc_and_sf__samples_blended__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Early Depth Test Fails */
static uint64_t
kblgt2__hdc_and_sf__early_depth_test_fails__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: Shader Memory Accesses */
static uint64_t
kblgt2__hdc_and_sf__shader_memory_accesses__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set HDCAndSF :: HS Threads Dispatched */
static uint64_t
kblgt2__hdc_and_sf__hs_threads__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set HDCAndSF :: SLM Bytes Written */
static uint64_t
kblgt2__hdc_and_sf__slm_bytes_written__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set HDCAndSF :: L3 Shader Throughput */
static uint64_t
kblgt2__hdc_and_sf__l3_shader_throughput__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__hdc_and_sf__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set HDCAndSF :: Samples Killed in FS */
static uint64_t
kblgt2__hdc_and_sf__samples_killed_in_ps__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
static float
kblgt2__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read(struct brw_context *brw,
                                                                    const struct brw_perf_query_info *query,
                                                                    uint64_t *accumulator)
{
   /* RPN equation: C 7 READ C 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = accumulator[query->c_offset + 6];
   uint64_t tmp2 = tmp0 - tmp1;
   uint64_t tmp3 = tmp2 * 100;
   double tmp4 = tmp3;
   double tmp5 = kblgt2__hdc_and_sf__gpu_core_clocks__read(brw, query, accumulator);
   double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

   return tmp6;
}

/* Metric set HDCAndSF :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__hdc_and_sf__shader_atomics__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_hdc_and_sf_query_counters[39];
static struct brw_perf_query_info kblgt2_hdc_and_sf_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set HDCAndSF",
   .guid = "bc2a00f7-cb8a-4ff2-8ad0-e241dad16937",
   .counters = kblgt2_hdc_and_sf_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_hdc_and_sf_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_hdc_and_sf_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__poly_data_ready__read;
      counter->name = "Polygon Data Ready";
      counter->desc = "The percentage of time in which geometry pipeline output is ready";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 56;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__hdc_and_sf__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss1)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss1)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 120;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss2)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss2)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 136;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__hdc_and_sf__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read;
         counter->name = "HDC stalled by L3 (s0.ss0)";
         counter->desc = "Percentage of time when HDC has messges to L3, but it's stalled due to lack of credits (s0.ss0)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 264;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__hdc_and_sf__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_1 :: GPU Core Clocks */
static uint64_t
kblgt2__l3_1__gpu_core_clocks__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_1 :: EU Active */
static float
kblgt2__l3_1__eu_active__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Slice0 L3 Bank1 Active */
static float
kblgt2__l3_1__l30_bank1_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: EU Both FPU Pipes Active */
static float
kblgt2__l3_1__eu_fpu_both_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS Send Pipe Active */
static float
kblgt2__l3_1__vs_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS FPU1 Pipe Active */
static float
kblgt2__l3_1__vs_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: GS Threads Dispatched */
static uint64_t
kblgt2__l3_1__gs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_1 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__l3_1__hi_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: FS Both FPU Active */
static float
kblgt2__l3_1__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS Threads Dispatched */
static uint64_t
kblgt2__l3_1__vs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_1 :: Slice0 L3 Bank1 Stalled */
static float
kblgt2__l3_1__l30_bank1_stalled__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: FS Threads Dispatched */
static uint64_t
kblgt2__l3_1__ps_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_1 :: Shader Barrier Messages */
static uint64_t
kblgt2__l3_1__shader_barriers__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_1 :: Sampler Texels */
static uint64_t
kblgt2__l3_1__sampler_texels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Pixels Failing Tests */
static uint64_t
kblgt2__l3_1__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: GPU Time Elapsed */
static uint64_t
kblgt2__l3_1__gpu_time__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__l3_1__avg_gpu_core_frequency__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__l3_1__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_1 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__l3_1__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_1 :: Sampler Texels Misses */
static uint64_t
kblgt2__l3_1__sampler_texel_misses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: CS Threads Dispatched */
static uint64_t
kblgt2__l3_1__cs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_1 :: SLM Bytes Read */
static uint64_t
kblgt2__l3_1__slm_bytes_read__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_1 :: PS FPU1 Pipe Active */
static float
kblgt2__l3_1__ps_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: PS Send Pipeline Active */
static float
kblgt2__l3_1__ps_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: VS FPU0 Pipe Active */
static float
kblgt2__l3_1__vs_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: GPU Busy */
static float
kblgt2__l3_1__gpu_busy__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: Slice0 L3 Bank0 Active */
static float
kblgt2__l3_1__l30_bank0_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: Rasterized Pixels */
static uint64_t
kblgt2__l3_1__rasterized_pixels__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: PS FPU0 Pipe Active */
static float
kblgt2__l3_1__ps_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Slice0 L3 Bank0 Stalled */
static float
kblgt2__l3_1__l30_bank0_stalled__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_1 :: DS Threads Dispatched */
static uint64_t
kblgt2__l3_1__ds_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_1 :: Samples Written */
static uint64_t
kblgt2__l3_1__samples_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: EU Stall */
static float
kblgt2__l3_1__eu_stall__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_1 :: Samples Blended */
static uint64_t
kblgt2__l3_1__samples_blended__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Early Depth Test Fails */
static uint64_t
kblgt2__l3_1__early_depth_test_fails__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Shader Memory Accesses */
static uint64_t
kblgt2__l3_1__shader_memory_accesses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_1 :: HS Threads Dispatched */
static uint64_t
kblgt2__l3_1__hs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_1 :: SLM Bytes Written */
static uint64_t
kblgt2__l3_1__slm_bytes_written__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_1 :: L3 Shader Throughput */
static uint64_t
kblgt2__l3_1__l3_shader_throughput__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__l3_1__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_1 :: Samples Killed in FS */
static uint64_t
kblgt2__l3_1__samples_killed_in_ps__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_1 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__l3_1__shader_atomics__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_l3_1_query_counters[39];
static struct brw_perf_query_info kblgt2_l3_1_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_1",
   .guid = "d2bbe790-f058-42d9-81c6-cdedcf655bc2",
   .counters = kblgt2_l3_1_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_l3_1_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_l3_1_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_1__l30_bank1_active__read;
         counter->name = "Slice0 L3 Bank1 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank1 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 12;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 24;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_1__l30_bank1_stalled__read;
         counter->name = "Slice0 L3 Bank1 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank1 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__l3_1__avg_gpu_core_frequency__max(brw);
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_1__l30_bank0_active__read;
         counter->name = "Slice0 L3 Bank0 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank0 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 160;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_1__l30_bank0_stalled__read;
         counter->name = "Slice0 L3 Bank0 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank0 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 180;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_1__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_1__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_2 :: GPU Core Clocks */
static uint64_t
kblgt2__l3_2__gpu_core_clocks__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_2 :: EU Active */
static float
kblgt2__l3_2__eu_active__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: EU Both FPU Pipes Active */
static float
kblgt2__l3_2__eu_fpu_both_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS Send Pipe Active */
static float
kblgt2__l3_2__vs_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS FPU1 Pipe Active */
static float
kblgt2__l3_2__vs_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: GS Threads Dispatched */
static uint64_t
kblgt2__l3_2__gs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_2 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__l3_2__hi_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: FS Both FPU Active */
static float
kblgt2__l3_2__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS Threads Dispatched */
static uint64_t
kblgt2__l3_2__vs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_2 :: FS Threads Dispatched */
static uint64_t
kblgt2__l3_2__ps_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_2 :: Shader Barrier Messages */
static uint64_t
kblgt2__l3_2__shader_barriers__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_2 :: Sampler Texels */
static uint64_t
kblgt2__l3_2__sampler_texels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Pixels Failing Tests */
static uint64_t
kblgt2__l3_2__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: GPU Time Elapsed */
static uint64_t
kblgt2__l3_2__gpu_time__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__l3_2__avg_gpu_core_frequency__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__l3_2__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_2 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__l3_2__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_2 :: Sampler Texels Misses */
static uint64_t
kblgt2__l3_2__sampler_texel_misses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: CS Threads Dispatched */
static uint64_t
kblgt2__l3_2__cs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_2 :: SLM Bytes Read */
static uint64_t
kblgt2__l3_2__slm_bytes_read__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_2 :: PS FPU1 Pipe Active */
static float
kblgt2__l3_2__ps_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: Slice0 L3 Bank2 Stalled */
static float
kblgt2__l3_2__l30_bank2_stalled__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: PS Send Pipeline Active */
static float
kblgt2__l3_2__ps_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: VS FPU0 Pipe Active */
static float
kblgt2__l3_2__vs_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: GPU Busy */
static float
kblgt2__l3_2__gpu_busy__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: Slice0 L3 Bank2 Active */
static float
kblgt2__l3_2__l30_bank2_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_2 :: Rasterized Pixels */
static uint64_t
kblgt2__l3_2__rasterized_pixels__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: PS FPU0 Pipe Active */
static float
kblgt2__l3_2__ps_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: DS Threads Dispatched */
static uint64_t
kblgt2__l3_2__ds_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_2 :: Samples Written */
static uint64_t
kblgt2__l3_2__samples_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: EU Stall */
static float
kblgt2__l3_2__eu_stall__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_2 :: Samples Blended */
static uint64_t
kblgt2__l3_2__samples_blended__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Early Depth Test Fails */
static uint64_t
kblgt2__l3_2__early_depth_test_fails__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Shader Memory Accesses */
static uint64_t
kblgt2__l3_2__shader_memory_accesses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_2 :: HS Threads Dispatched */
static uint64_t
kblgt2__l3_2__hs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_2 :: SLM Bytes Written */
static uint64_t
kblgt2__l3_2__slm_bytes_written__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_2 :: L3 Shader Throughput */
static uint64_t
kblgt2__l3_2__l3_shader_throughput__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__l3_2__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_2 :: Samples Killed in FS */
static uint64_t
kblgt2__l3_2__samples_killed_in_ps__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_2 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__l3_2__shader_atomics__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_l3_2_query_counters[37];
static struct brw_perf_query_info kblgt2_l3_2_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_2",
   .guid = "2f8e32e4-5956-46e2-af31-c8ea95887332",
   .counters = kblgt2_l3_2_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_l3_2_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_l3_2_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__l3_2__avg_gpu_core_frequency__max(brw);
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 128;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_2__l30_bank2_stalled__read;
         counter->name = "Slice0 L3 Bank2 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank2 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 132;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 140;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_2__l30_bank2_active__read;
         counter->name = "Slice0 L3 Bank2 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank2 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 148;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 152;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_2__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 184;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_2__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set L3_3 :: GPU Core Clocks */
static uint64_t
kblgt2__l3_3__gpu_core_clocks__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set L3_3 :: EU Active */
static float
kblgt2__l3_3__eu_active__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: EU Both FPU Pipes Active */
static float
kblgt2__l3_3__eu_fpu_both_active__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS Send Pipe Active */
static float
kblgt2__l3_3__vs_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS FPU1 Pipe Active */
static float
kblgt2__l3_3__vs_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: GS Threads Dispatched */
static uint64_t
kblgt2__l3_3__gs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set L3_3 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__l3_3__hi_depth_test_fails__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: FS Both FPU Active */
static float
kblgt2__l3_3__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS Threads Dispatched */
static uint64_t
kblgt2__l3_3__vs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set L3_3 :: FS Threads Dispatched */
static uint64_t
kblgt2__l3_3__ps_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set L3_3 :: Slice0 L3 Bank3 Stalled */
static float
kblgt2__l3_3__l30_bank3_stalled__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: Shader Barrier Messages */
static uint64_t
kblgt2__l3_3__shader_barriers__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set L3_3 :: Sampler Texels */
static uint64_t
kblgt2__l3_3__sampler_texels__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Pixels Failing Tests */
static uint64_t
kblgt2__l3_3__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: GPU Time Elapsed */
static uint64_t
kblgt2__l3_3__gpu_time__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__l3_3__avg_gpu_core_frequency__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__l3_3__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set L3_3 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__l3_3__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set L3_3 :: Sampler Texels Misses */
static uint64_t
kblgt2__l3_3__sampler_texel_misses__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: CS Threads Dispatched */
static uint64_t
kblgt2__l3_3__cs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set L3_3 :: SLM Bytes Read */
static uint64_t
kblgt2__l3_3__slm_bytes_read__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_3 :: PS FPU1 Pipe Active */
static float
kblgt2__l3_3__ps_fpu1_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: Slice0 L3 Bank3 Active */
static float
kblgt2__l3_3__l30_bank3_active__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: PS Send Pipeline Active */
static float
kblgt2__l3_3__ps_send_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: VS FPU0 Pipe Active */
static float
kblgt2__l3_3__vs_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: GPU Busy */
static float
kblgt2__l3_3__gpu_busy__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set L3_3 :: Rasterized Pixels */
static uint64_t
kblgt2__l3_3__rasterized_pixels__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: PS FPU0 Pipe Active */
static float
kblgt2__l3_3__ps_fpu0_active__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: DS Threads Dispatched */
static uint64_t
kblgt2__l3_3__ds_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set L3_3 :: Samples Written */
static uint64_t
kblgt2__l3_3__samples_written__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: EU Stall */
static float
kblgt2__l3_3__eu_stall__read(struct brw_context *brw,
                             const struct brw_perf_query_info *query,
                             uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__l3_3__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set L3_3 :: Samples Blended */
static uint64_t
kblgt2__l3_3__samples_blended__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Early Depth Test Fails */
static uint64_t
kblgt2__l3_3__early_depth_test_fails__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Shader Memory Accesses */
static uint64_t
kblgt2__l3_3__shader_memory_accesses__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set L3_3 :: HS Threads Dispatched */
static uint64_t
kblgt2__l3_3__hs_threads__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set L3_3 :: SLM Bytes Written */
static uint64_t
kblgt2__l3_3__slm_bytes_written__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set L3_3 :: L3 Shader Throughput */
static uint64_t
kblgt2__l3_3__l3_shader_throughput__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__l3_3__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set L3_3 :: Samples Killed in FS */
static uint64_t
kblgt2__l3_3__samples_killed_in_ps__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set L3_3 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__l3_3__shader_atomics__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_l3_3_query_counters[37];
static struct brw_perf_query_info kblgt2_l3_3_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set L3_3",
   .guid = "ca046aad-b5fb-4101-adce-6473ee6e5b14",
   .counters = kblgt2_l3_3_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_l3_3_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_l3_3_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_3__l30_bank3_stalled__read;
         counter->name = "Slice0 L3 Bank3 Stalled";
         counter->desc = "The percentage of time in which slice0 L3 bank3 is stalled";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__l3_3__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__l3_3__l30_bank3_active__read;
         counter->name = "Slice0 L3 Bank3 Active";
         counter->desc = "The percentage of time in which slice0 L3 bank3 is active";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 140;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__l3_3__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__l3_3__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set RasterizerAndPixelBackend :: GPU Core Clocks */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: EU Active */
static float
kblgt2__rasterizer_and_pixel_backend__eu_active__read(struct brw_context *brw,
                                                      const struct brw_perf_query_info *query,
                                                      uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: EU Both FPU Pipes Active */
static float
kblgt2__rasterizer_and_pixel_backend__eu_fpu_both_active__read(struct brw_context *brw,
                                                               const struct brw_perf_query_info *query,
                                                               uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS Send Pipe Active */
static float
kblgt2__rasterizer_and_pixel_backend__vs_send_active__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS FPU1 Pipe Active */
static float
kblgt2__rasterizer_and_pixel_backend__vs_fpu1_active__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: GS Threads Dispatched */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__gs_threads__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__hi_depth_test_fails__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: FS Both FPU Active */
static float
kblgt2__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                                                  const struct brw_perf_query_info *query,
                                                                  uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS Threads Dispatched */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__vs_threads__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: FS Threads Dispatched */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__ps_threads__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Pixel Values Ready */
static float
kblgt2__rasterizer_and_pixel_backend__pixel_values0_ready__read(struct brw_context *brw,
                                                                const struct brw_perf_query_info *query,
                                                                uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Shader Barrier Messages */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__shader_barriers__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Sampler Texels */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__sampler_texels__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Pixels Failing Tests */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                                         const struct brw_perf_query_info *query,
                                                                         uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: GPU Time Elapsed */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__gpu_time__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                                   const struct brw_perf_query_info *query,
                                                                   uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__rasterizer_and_pixel_backend__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set RasterizerAndPixelBackend :: AVG GPU Core Frequency */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set RasterizerAndPixelBackend :: Sampler Texels Misses */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__sampler_texel_misses__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: CS Threads Dispatched */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__cs_threads__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Input Available */
static float
kblgt2__rasterizer_and_pixel_backend__rasterizer0_input_available__read(struct brw_context *brw,
                                                                        const struct brw_perf_query_info *query,
                                                                        uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Post-EarlyZ Pixel Data Ready */
static float
kblgt2__rasterizer_and_pixel_backend__pixel_data0_ready__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Read */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__slm_bytes_read__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: PS FPU1 Pipe Active */
static float
kblgt2__rasterizer_and_pixel_backend__ps_fpu1_active__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: PS Send Pipeline Active */
static float
kblgt2__rasterizer_and_pixel_backend__ps_send_active__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: VS FPU0 Pipe Active */
static float
kblgt2__rasterizer_and_pixel_backend__vs_fpu0_active__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: GPU Busy */
static float
kblgt2__rasterizer_and_pixel_backend__gpu_busy__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Rasterized Pixels */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__rasterized_pixels__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: PS FPU0 Pipe Active */
static float
kblgt2__rasterizer_and_pixel_backend__ps_fpu0_active__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: DS Threads Dispatched */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__ds_threads__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: Samples Written */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__samples_written__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: EU Stall */
static float
kblgt2__rasterizer_and_pixel_backend__eu_stall__read(struct brw_context *brw,
                                                     const struct brw_perf_query_info *query,
                                                     uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 Rasterizer Output Ready */
static float
kblgt2__rasterizer_and_pixel_backend__rasterizer0_output_ready__read(struct brw_context *brw,
                                                                     const struct brw_perf_query_info *query,
                                                                     uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Samples Blended */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__samples_blended__read(struct brw_context *brw,
                                                            const struct brw_perf_query_info *query,
                                                            uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Early Depth Test Fails */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__early_depth_test_fails__read(struct brw_context *brw,
                                                                   const struct brw_perf_query_info *query,
                                                                   uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Shader Memory Accesses */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__shader_memory_accesses__read(struct brw_context *brw,
                                                                   const struct brw_perf_query_info *query,
                                                                   uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: HS Threads Dispatched */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__hs_threads__read(struct brw_context *brw,
                                                       const struct brw_perf_query_info *query,
                                                       uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set RasterizerAndPixelBackend :: SLM Bytes Written */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__slm_bytes_written__read(struct brw_context *brw,
                                                              const struct brw_perf_query_info *query,
                                                              uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: L3 Shader Throughput */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__l3_shader_throughput__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__rasterizer_and_pixel_backend__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Samples Killed in FS */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__samples_killed_in_ps__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set RasterizerAndPixelBackend :: Slice0 PS Output Available */
static float
kblgt2__rasterizer_and_pixel_backend__ps_output0_available__read(struct brw_context *brw,
                                                                 const struct brw_perf_query_info *query,
                                                                 uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set RasterizerAndPixelBackend :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__rasterizer_and_pixel_backend__shader_atomics__read(struct brw_context *brw,
                                                           const struct brw_perf_query_info *query,
                                                           uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_rasterizer_and_pixel_backend_query_counters[40];
static struct brw_perf_query_info kblgt2_rasterizer_and_pixel_backend_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set RasterizerAndPixelBackend",
   .guid = "605f388f-24bb-455c-88e3-8d57ae0d7e9f",
   .counters = kblgt2_rasterizer_and_pixel_backend_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_rasterizer_and_pixel_backend_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_rasterizer_and_pixel_backend_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__pixel_values0_ready__read;
         counter->name = "Slice0 Pixel Values Ready";
         counter->desc = "The percentage of time in which slice0 pixel values are ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__rasterizer0_input_available__read;
         counter->name = "Slice0 Rasterizer Input Available";
         counter->desc = "The percentage of time in which slice0 rasterizer input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 128;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__pixel_data0_ready__read;
         counter->name = "Slice0 Post-EarlyZ Pixel Data Ready";
         counter->desc = "The percentage of time in which slice0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 132;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__rasterizer0_output_ready__read;
         counter->name = "Slice0 Rasterizer Output Ready";
         counter->desc = "The percentage of time in which slice0 rasterizer output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 196;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.slice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__rasterizer_and_pixel_backend__ps_output0_available__read;
         counter->name = "Slice0 PS Output Available";
         counter->desc = "The percentage of time in which slice0 PS output is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 256;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__rasterizer_and_pixel_backend__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set Sampler :: GPU Core Clocks */
static uint64_t
kblgt2__sampler__gpu_core_clocks__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set Sampler :: EU Active */
static float
kblgt2__sampler__eu_active__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: Slice0 Subslice2 Input Available */
static float
kblgt2__sampler__sampler02_input_available__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: EU Both FPU Pipes Active */
static float
kblgt2__sampler__eu_fpu_both_active__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: VS Send Pipe Active */
static float
kblgt2__sampler__vs_send_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: Slice0 Subslice0 Input Available */
static float
kblgt2__sampler__sampler00_input_available__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: VS FPU1 Pipe Active */
static float
kblgt2__sampler__vs_fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: GS Threads Dispatched */
static uint64_t
kblgt2__sampler__gs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set Sampler :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__sampler__hi_depth_test_fails__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: FS Both FPU Active */
static float
kblgt2__sampler__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: VS Threads Dispatched */
static uint64_t
kblgt2__sampler__vs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set Sampler :: Slice0 Subslice2 Sampler Output Ready */
static float
kblgt2__sampler__sampler02_output_ready__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: FS Threads Dispatched */
static uint64_t
kblgt2__sampler__ps_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set Sampler :: Shader Barrier Messages */
static uint64_t
kblgt2__sampler__shader_barriers__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set Sampler :: Slice0 Subslice1 Input Available */
static float
kblgt2__sampler__sampler01_input_available__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Sampler Texels */
static uint64_t
kblgt2__sampler__sampler_texels__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Pixels Failing Tests */
static uint64_t
kblgt2__sampler__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: GPU Time Elapsed */
static uint64_t
kblgt2__sampler__gpu_time__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: AVG GPU Core Frequency */
static uint64_t
kblgt2__sampler__avg_gpu_core_frequency__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__sampler__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set Sampler :: AVG GPU Core Frequency */
static uint64_t
kblgt2__sampler__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set Sampler :: Sampler Texels Misses */
static uint64_t
kblgt2__sampler__sampler_texel_misses__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: CS Threads Dispatched */
static uint64_t
kblgt2__sampler__cs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set Sampler :: SLM Bytes Read */
static uint64_t
kblgt2__sampler__slm_bytes_read__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler :: PS FPU1 Pipe Active */
static float
kblgt2__sampler__ps_fpu1_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: PS Send Pipeline Active */
static float
kblgt2__sampler__ps_send_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: VS FPU0 Pipe Active */
static float
kblgt2__sampler__vs_fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: GPU Busy */
static float
kblgt2__sampler__gpu_busy__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Rasterized Pixels */
static uint64_t
kblgt2__sampler__rasterized_pixels__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: PS FPU0 Pipe Active */
static float
kblgt2__sampler__ps_fpu0_active__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: DS Threads Dispatched */
static uint64_t
kblgt2__sampler__ds_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set Sampler :: Samples Written */
static uint64_t
kblgt2__sampler__samples_written__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: EU Stall */
static float
kblgt2__sampler__eu_stall__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set Sampler :: Samples Blended */
static uint64_t
kblgt2__sampler__samples_blended__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Early Depth Test Fails */
static uint64_t
kblgt2__sampler__early_depth_test_fails__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Slice0 Subslice0 Sampler Output Ready */
static float
kblgt2__sampler__sampler00_output_ready__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Slice0 Subslice1 Sampler Output Ready */
static float
kblgt2__sampler__sampler01_output_ready__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__sampler__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set Sampler :: Shader Memory Accesses */
static uint64_t
kblgt2__sampler__shader_memory_accesses__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set Sampler :: HS Threads Dispatched */
static uint64_t
kblgt2__sampler__hs_threads__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set Sampler :: SLM Bytes Written */
static uint64_t
kblgt2__sampler__slm_bytes_written__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set Sampler :: L3 Shader Throughput */
static uint64_t
kblgt2__sampler__l3_shader_throughput__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__sampler__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set Sampler :: Samples Killed in FS */
static uint64_t
kblgt2__sampler__samples_killed_in_ps__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set Sampler :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__sampler__shader_atomics__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_sampler_query_counters[41];
static struct brw_perf_query_info kblgt2_sampler_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set Sampler",
   .guid = "31dd157c-bf4e-4bab-bf2b-f5c8174af1af",
   .counters = kblgt2_sampler_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_sampler_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_sampler_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__sampler__sampler02_input_available__read;
         counter->name = "Slice0 Subslice2 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice2 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 12;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__sampler__sampler00_input_available__read;
         counter->name = "Slice0 Subslice0 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice0 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 24;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 28;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__sampler__sampler02_output_ready__read;
         counter->name = "Slice0 Subslice2 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice2 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__sampler__sampler01_input_available__read;
         counter->name = "Slice0 Subslice1 Input Available";
         counter->desc = "The percentage of time in which slice0 subslice1 sampler input is available";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 88;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__sampler__avg_gpu_core_frequency__max(brw);
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 144;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 160;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 164;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__sampler__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__sampler__sampler00_output_ready__read;
         counter->name = "Slice0 Subslice0 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice0 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 224;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__sampler__sampler01_output_ready__read;
         counter->name = "Slice0 Subslice1 Sampler Output Ready";
         counter->desc = "The percentage of time in which slice0 subslice1 sampler output is ready";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 228;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__sampler__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set TDL_1 :: GPU Core Clocks */
static uint64_t
kblgt2__tdl_1__gpu_core_clocks__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set TDL_1 :: EU Active */
static float
kblgt2__tdl_1__eu_active__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: EU Both FPU Pipes Active */
static float
kblgt2__tdl_1__eu_fpu_both_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS Send Pipe Active */
static float
kblgt2__tdl_1__vs_send_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS FPU1 Pipe Active */
static float
kblgt2__tdl_1__vs_fpu1_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: GS Threads Dispatched */
static uint64_t
kblgt2__tdl_1__gs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set TDL_1 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__tdl_1__hi_depth_test_fails__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: FS Both FPU Active */
static float
kblgt2__tdl_1__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS Threads Dispatched */
static uint64_t
kblgt2__tdl_1__vs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set TDL_1 :: FS Threads Dispatched */
static uint64_t
kblgt2__tdl_1__ps_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set TDL_1 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher */
static float
kblgt2__tdl_1__non_ps_thread02_ready_for_dispatch__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Shader Barrier Messages */
static uint64_t
kblgt2__tdl_1__shader_barriers__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set TDL_1 :: Sampler Texels */
static uint64_t
kblgt2__tdl_1__sampler_texels__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Pixels Failing Tests */
static uint64_t
kblgt2__tdl_1__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: GPU Time Elapsed */
static uint64_t
kblgt2__tdl_1__gpu_time__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__tdl_1__avg_gpu_core_frequency__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__tdl_1__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set TDL_1 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__tdl_1__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set TDL_1 :: Sampler Texels Misses */
static uint64_t
kblgt2__tdl_1__sampler_texel_misses__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher */
static float
kblgt2__tdl_1__non_ps_thread00_ready_for_dispatch__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: CS Threads Dispatched */
static uint64_t
kblgt2__tdl_1__cs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set TDL_1 :: SLM Bytes Read */
static uint64_t
kblgt2__tdl_1__slm_bytes_read__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_1 :: PS FPU1 Pipe Active */
static float
kblgt2__tdl_1__ps_fpu1_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: PS Send Pipeline Active */
static float
kblgt2__tdl_1__ps_send_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: VS FPU0 Pipe Active */
static float
kblgt2__tdl_1__vs_fpu0_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: GPU Busy */
static float
kblgt2__tdl_1__gpu_busy__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher */
static float
kblgt2__tdl_1__ps_thread00_ready_for_dispatch__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 1];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Rasterized Pixels */
static uint64_t
kblgt2__tdl_1__rasterized_pixels__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: PS FPU0 Pipe Active */
static float
kblgt2__tdl_1__ps_fpu0_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: DS Threads Dispatched */
static uint64_t
kblgt2__tdl_1__ds_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set TDL_1 :: Samples Written */
static uint64_t
kblgt2__tdl_1__samples_written__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: EU Stall */
static float
kblgt2__tdl_1__eu_stall__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_1 :: Samples Blended */
static uint64_t
kblgt2__tdl_1__samples_blended__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Early Depth Test Fails */
static uint64_t
kblgt2__tdl_1__early_depth_test_fails__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher */
static float
kblgt2__tdl_1__ps_thread01_ready_for_dispatch__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: Shader Memory Accesses */
static uint64_t
kblgt2__tdl_1__shader_memory_accesses__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set TDL_1 :: HS Threads Dispatched */
static uint64_t
kblgt2__tdl_1__hs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set TDL_1 :: PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher */
static float
kblgt2__tdl_1__ps_thread02_ready_for_dispatch__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_1 :: SLM Bytes Written */
static uint64_t
kblgt2__tdl_1__slm_bytes_written__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_1 :: L3 Shader Throughput */
static uint64_t
kblgt2__tdl_1__l3_shader_throughput__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__tdl_1__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set TDL_1 :: Samples Killed in FS */
static uint64_t
kblgt2__tdl_1__samples_killed_in_ps__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_1 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__tdl_1__shader_atomics__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Metric set TDL_1 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher */
static float
kblgt2__tdl_1__non_ps_thread01_ready_for_dispatch__read(struct brw_context *brw,
                                                        const struct brw_perf_query_info *query,
                                                        uint64_t *accumulator)
{
   /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_1__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

static struct brw_perf_query_counter kblgt2_tdl_1_query_counters[41];
static struct brw_perf_query_info kblgt2_tdl_1_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set TDL_1",
   .guid = "105db928-5542-466b-9128-e1f3c91426cb",
   .counters = kblgt2_tdl_1_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_tdl_1_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_tdl_1_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_1__non_ps_thread02_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 64;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__tdl_1__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_1__non_ps_thread00_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 120;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 136;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 152;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 156;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_1__ps_thread00_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice0 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 160;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 168;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 176;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 192;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_1__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 200;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_1__ps_thread01_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 224;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_1__ps_thread02_ready_for_dispatch__read;
         counter->name = "PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher";
         counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 subslice2 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 248;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 256;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 272;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_1__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 280;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_1__non_ps_thread01_ready_for_dispatch__read;
         counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher";
         counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 subslice1 thread dispatcher";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 288;
         counter->size = sizeof(float);
      }

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Metric set TDL_2 :: GPU Core Clocks */
static uint64_t
kblgt2__tdl_2__gpu_core_clocks__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Metric set TDL_2 :: EU Active */
static float
kblgt2__tdl_2__eu_active__read(struct brw_context *brw,
                               const struct brw_perf_query_info *query,
                               uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: EU Both FPU Pipes Active */
static float
kblgt2__tdl_2__eu_fpu_both_active__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS Send Pipe Active */
static float
kblgt2__tdl_2__vs_send_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 12];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS FPU1 Pipe Active */
static float
kblgt2__tdl_2__vs_fpu1_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 11];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: GS Threads Dispatched */
static uint64_t
kblgt2__tdl_2__gs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 5 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 5];

   return tmp0;
}

/* Metric set TDL_2 :: Early Hi-Depth Test Fails */
static uint64_t
kblgt2__tdl_2__hi_depth_test_fails__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 22 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 22];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: FS Both FPU Active */
static float
kblgt2__tdl_2__ps_eu_both_fpu_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 18];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS Threads Dispatched */
static uint64_t
kblgt2__tdl_2__vs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 1 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 1];

   return tmp0;
}

/* Metric set TDL_2 :: FS Threads Dispatched */
static uint64_t
kblgt2__tdl_2__ps_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 6 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 6];

   return tmp0;
}

/* Metric set TDL_2 :: Shader Barrier Messages */
static uint64_t
kblgt2__tdl_2__shader_barriers__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 35 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 35];

   return tmp0;
}

/* Metric set TDL_2 :: Sampler Texels */
static uint64_t
kblgt2__tdl_2__sampler_texels__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 28 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 28];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Pixels Failing Tests */
static uint64_t
kblgt2__tdl_2__pixels_failing_post_ps_tests__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 25 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 25];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 0 */
static float
kblgt2__tdl_2__thread_header01_ready_port0__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 7];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 0 */
static float
kblgt2__tdl_2__thread_header01_ready_port1__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 2];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: GPU Time Elapsed */
static uint64_t
kblgt2__tdl_2__gpu_time__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__tdl_2__avg_gpu_core_frequency__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__tdl_2__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Metric set TDL_2 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__tdl_2__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Metric set TDL_2 :: Sampler Texels Misses */
static uint64_t
kblgt2__tdl_2__sampler_texel_misses__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 29 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 29];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: CS Threads Dispatched */
static uint64_t
kblgt2__tdl_2__cs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Metric set TDL_2 :: SLM Bytes Read */
static uint64_t
kblgt2__tdl_2__slm_bytes_read__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 30 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_2 :: PS FPU1 Pipe Active */
static float
kblgt2__tdl_2__ps_fpu1_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 16];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: PS Send Pipeline Active */
static float
kblgt2__tdl_2__ps_send_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 17];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: VS FPU0 Pipe Active */
static float
kblgt2__tdl_2__vs_fpu0_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: GPU Busy */
static float
kblgt2__tdl_2__gpu_busy__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 1 */
static float
kblgt2__tdl_2__thread_header02_ready_port1__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 4];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 0 */
static float
kblgt2__tdl_2__thread_header02_ready_port0__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 3];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Rasterized Pixels */
static uint64_t
kblgt2__tdl_2__rasterized_pixels__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 21 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 21];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: PS FPU0 Pipe Active */
static float
kblgt2__tdl_2__ps_fpu0_active__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 15];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: DS Threads Dispatched */
static uint64_t
kblgt2__tdl_2__ds_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 3 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 3];

   return tmp0;
}

/* Metric set TDL_2 :: Samples Written */
static uint64_t
kblgt2__tdl_2__samples_written__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 26 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 26];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: EU Stall */
static float
kblgt2__tdl_2__eu_stall__read(struct brw_context *brw,
                              const struct brw_perf_query_info *query,
                              uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Metric set TDL_2 :: Samples Blended */
static uint64_t
kblgt2__tdl_2__samples_blended__read(struct brw_context *brw,
                                     const struct brw_perf_query_info *query,
                                     uint64_t *accumulator)
{
   /* RPN equation: A 27 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 27];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Early Depth Test Fails */
static uint64_t
kblgt2__tdl_2__early_depth_test_fails__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 23 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 23];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Shader Memory Accesses */
static uint64_t
kblgt2__tdl_2__shader_memory_accesses__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: A 32 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 32];

   return tmp0;
}

/* Metric set TDL_2 :: HS Threads Dispatched */
static uint64_t
kblgt2__tdl_2__hs_threads__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: A 2 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 2];

   return tmp0;
}

/* Metric set TDL_2 :: SLM Bytes Written */
static uint64_t
kblgt2__tdl_2__slm_bytes_written__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: A 31 READ 64 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 31];
   uint64_t tmp1 = tmp0 * 64;

   return tmp1;
}

/* Metric set TDL_2 :: L3 Shader Throughput */
static uint64_t
kblgt2__tdl_2__l3_shader_throughput__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses 64 UMUL UADD UADD */
   uint64_t tmp0 = accumulator[query->a_offset + 30];
   uint64_t tmp1 = accumulator[query->a_offset + 31];
   uint64_t tmp2 = kblgt2__tdl_2__shader_memory_accesses__read(brw, query, accumulator) * 64;
   uint64_t tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = tmp0 + tmp3;

   return tmp4;
}

/* Metric set TDL_2 :: Samples Killed in FS */
static uint64_t
kblgt2__tdl_2__samples_killed_in_ps__read(struct brw_context *brw,
                                          const struct brw_perf_query_info *query,
                                          uint64_t *accumulator)
{
   /* RPN equation: A 24 READ 4 UMUL */
   uint64_t tmp0 = accumulator[query->a_offset + 24];
   uint64_t tmp1 = tmp0 * 4;

   return tmp1;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 0 */
static float
kblgt2__tdl_2__thread_header00_ready_port0__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 5];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Metric set TDL_2 :: Shader Atomic Memory Accesses */
static uint64_t
kblgt2__tdl_2__shader_atomics__read(struct brw_context *brw,
                                    const struct brw_perf_query_info *query,
                                    uint64_t *accumulator)
{
   /* RPN equation: A 34 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 34];

   return tmp0;
}

/* Metric set TDL_2 :: Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 1 */
static float
kblgt2__tdl_2__thread_header00_ready_port1__read(struct brw_context *brw,
                                                 const struct brw_perf_query_info *query,
                                                 uint64_t *accumulator)
{
   /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->c_offset + 6];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__tdl_2__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

static struct brw_perf_query_counter kblgt2_tdl_2_query_counters[41];
static struct brw_perf_query_info kblgt2_tdl_2_query = {
   .kind = OA_COUNTERS,
   .name = "Metric set TDL_2",
   .guid = "03db94d2-b37f-4c58-a791-0d2067b013bb",
   .counters = kblgt2_tdl_2_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_tdl_2_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_tdl_2_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__vs_send_active__read;
      counter->name = "VS Send Pipe Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 16;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__vs_fpu1_active__read;
      counter->name = "VS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 20;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__gs_threads__read;
      counter->name = "GS Threads Dispatched";
      counter->desc = "The total number of geometry shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__hi_depth_test_fails__read;
      counter->name = "Early Hi-Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__ps_eu_both_fpu_active__read;
      counter->name = "FS Both FPU Active";
      counter->desc = "The percentage of time in which fragment shaders were processed actively on the both FPUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__vs_threads__read;
      counter->name = "VS Threads Dispatched";
      counter->desc = "The total number of vertex shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__ps_threads__read;
      counter->name = "FS Threads Dispatched";
      counter->desc = "The total number of fragment shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__shader_barriers__read;
      counter->name = "Shader Barrier Messages";
      counter->desc = "The total number of shader barrier messages.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__sampler_texels__read;
      counter->name = "Sampler Texels";
      counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__pixels_failing_post_ps_tests__read;
      counter->name = "Pixels Failing Tests";
      counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_2__thread_header01_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 88;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x2) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_2__thread_header01_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice1 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice1 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 92;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 96;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__tdl_2__avg_gpu_core_frequency__max(brw);
      counter->offset = 104;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__sampler_texel_misses__read;
      counter->name = "Sampler Texels Misses";
      counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 112;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 120;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__slm_bytes_read__read;
      counter->name = "SLM Bytes Read";
      counter->desc = "The total number of GPU memory bytes read from shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 128;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__ps_fpu1_active__read;
      counter->name = "PS FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 136;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__ps_send_active__read;
      counter->name = "PS Send Pipeline Active";
      counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 140;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__vs_fpu0_active__read;
      counter->name = "VS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a vertex shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 144;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 148;
      counter->size = sizeof(float);

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_2__thread_header02_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 152;
         counter->size = sizeof(float);
      }

      if (brw->perfquery.sys_vars.subslice_mask & 0x4) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_2__thread_header02_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice2 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice2 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 156;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__rasterized_pixels__read;
      counter->name = "Rasterized Pixels";
      counter->desc = "The total number of rasterized pixels.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 160;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__ps_fpu0_active__read;
      counter->name = "PS FPU0 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU0 pipeline was actively processing a pixel shader instruction.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 168;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__ds_threads__read;
      counter->name = "DS Threads Dispatched";
      counter->desc = "The total number of domain shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 176;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__samples_written__read;
      counter->name = "Samples Written";
      counter->desc = "The total number of samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 184;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__tdl_2__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 192;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__samples_blended__read;
      counter->name = "Samples Blended";
      counter->desc = "The total number of blended samples or pixels written to all render targets.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 200;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__early_depth_test_fails__read;
      counter->name = "Early Depth Test Fails";
      counter->desc = "The total number of pixels dropped on early depth test.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 208;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__shader_memory_accesses__read;
      counter->name = "Shader Memory Accesses";
      counter->desc = "The total number of shader memory accesses to L3.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 216;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__hs_threads__read;
      counter->name = "HS Threads Dispatched";
      counter->desc = "The total number of hull shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 224;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__slm_bytes_written__read;
      counter->name = "SLM Bytes Written";
      counter->desc = "The total number of GPU memory bytes written into shared local memory.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 232;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__l3_shader_throughput__read;
      counter->name = "L3 Shader Throughput";
      counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
      counter->type = GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* unsupported (varies over time) */
      counter->offset = 240;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__samples_killed_in_ps__read;
      counter->name = "Samples Killed in FS";
      counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 248;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_2__thread_header00_ready_port0__read;
         counter->name = "Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 0";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 0";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 256;
         counter->size = sizeof(float);
      }

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__tdl_2__shader_atomics__read;
      counter->name = "Shader Atomic Memory Accesses";
      counter->desc = "The total number of shader atomic memory accesses.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 264;
      counter->size = sizeof(uint64_t);

      if (brw->perfquery.sys_vars.subslice_mask & 0x1) {
         counter = &query->counters[query->n_counters++];
         counter->oa_counter_read_float = kblgt2__tdl_2__thread_header00_ready_port1__read;
         counter->name = "Thread Header Ready on Slice0 Subslice0 Thread Dispatcher Port 1";
         counter->desc = "The percentage of time in which thread header is ready on slice0 subslice0 thread dispatcher port 1";
         counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
         counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
         counter->raw_max = 100;
         counter->offset = 272;
         counter->size = sizeof(float);
      }

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Compute Metrics Extra Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__compute_extra__gpu_core_clocks__read(struct brw_context *brw,
                                             const struct brw_perf_query_info *query,
                                             uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Compute Metrics Extra Gen9 :: EU FPU1 Pipe Active */
static float
kblgt2__compute_extra__fpu1_active__read(struct brw_context *brw,
                                         const struct brw_perf_query_info *query,
                                         uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__compute_extra__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Compute Metrics Extra Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__compute_extra__gpu_time__read(struct brw_context *brw,
                                      const struct brw_perf_query_info *query,
                                      uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* Compute Metrics Extra Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_extra__avg_gpu_core_frequency__read(struct brw_context *brw,
                                                    const struct brw_perf_query_info *query,
                                                    uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__compute_extra__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__compute_extra__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* Compute Metrics Extra Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__compute_extra__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Compute Metrics Extra Gen9 :: EU FPU1 Pipe Active including Ext Math */
static float
kblgt2__compute_extra__fpu1_active_adjusted__read(struct brw_context *brw,
                                                  const struct brw_perf_query_info *query,
                                                  uint64_t *accumulator)
{
   /* RPN equation: A 8 READ  C 7 READ C 6 READ FADD C 5 READ FADD 8 FMUL FADD 100 FMUL $EuCoresTotalCount FDIV $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = accumulator[query->c_offset + 7];
   uint64_t tmp2 = accumulator[query->c_offset + 6];
   double tmp3 = tmp1 + tmp2;
   uint64_t tmp4 = accumulator[query->c_offset + 5];
   double tmp5 = tmp3 + tmp4;
   double tmp6 = tmp5 * 8;
   double tmp7 = tmp0 + tmp6;
   double tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = brw->perfquery.sys_vars.n_eus;
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;
   double tmp12 = tmp11;
   double tmp13 = kblgt2__compute_extra__gpu_core_clocks__read(brw, query, accumulator);
   double tmp14 = tmp13 ? tmp12 / tmp13 : 0;

   return tmp14;
}

static struct brw_perf_query_counter kblgt2_compute_extra_query_counters[5];
static struct brw_perf_query_info kblgt2_compute_extra_query = {
   .kind = OA_COUNTERS,
   .name = "Compute Metrics Extra Gen9",
   .guid = "aa7a3fb9-22fb-43ff-a32d-0ab6c13bbd16",
   .counters = kblgt2_compute_extra_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_compute_extra_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_compute_extra_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extra__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extra__fpu1_active__read;
      counter->name = "EU FPU1 Pipe Active";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extra__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__compute_extra__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__compute_extra__avg_gpu_core_frequency__max(brw);
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__compute_extra__fpu1_active_adjusted__read;
      counter->name = "EU FPU1 Pipe Active including Ext Math";
      counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing including Extended Math processing";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 32;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* Media Vme Pipe Gen9 :: GPU Core Clocks */
static uint64_t
kblgt2__vme_pipe__gpu_core_clocks__read(struct brw_context *brw,
                                        const struct brw_perf_query_info *query,
                                        uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* Media Vme Pipe Gen9 :: EU Active */
static float
kblgt2__vme_pipe__eu_active__read(struct brw_context *brw,
                                  const struct brw_perf_query_info *query,
                                  uint64_t *accumulator)
{
   /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 7];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__vme_pipe__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Media Vme Pipe Gen9 :: EU Both FPU Pipes Active */
static float
kblgt2__vme_pipe__eu_fpu_both_active__read(struct brw_context *brw,
                                           const struct brw_perf_query_info *query,
                                           uint64_t *accumulator)
{
   /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 9];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__vme_pipe__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Media Vme Pipe Gen9 :: GPU Time Elapsed */
static uint64_t
kblgt2__vme_pipe__gpu_time__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4 * 1000000000;
   uint64_t tmp6 = tmp5;
   uint64_t tmp7 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp8 = tmp7 ? tmp6 / tmp7 : 0;

   return tmp8;
}

/* Media Vme Pipe Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__vme_pipe__avg_gpu_core_frequency__read(struct brw_context *brw,
                                               const struct brw_perf_query_info *query,
                                               uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL  GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV UDIV */
   uint64_t tmp0 = kblgt2__vme_pipe__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp2 = tmp1 * 1000000000;
   uint64_t tmp3 = tmp2;
   uint64_t tmp4 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   uint64_t tmp6 = tmp0;
   uint64_t tmp7 = tmp5;
   uint64_t tmp8 = tmp7 ? tmp6 / tmp7 : 0;

   return tmp8;
}

/* Media Vme Pipe Gen9 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__vme_pipe__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* Media Vme Pipe Gen9 :: CS Threads Dispatched */
static uint64_t
kblgt2__vme_pipe__cs_threads__read(struct brw_context *brw,
                                   const struct brw_perf_query_info *query,
                                   uint64_t *accumulator)
{
   /* RPN equation: A 4 READ */
   uint64_t tmp0 = accumulator[query->a_offset + 4];

   return tmp0;
}

/* Media Vme Pipe Gen9 :: EU Thread Occupancy */
static float
kblgt2__vme_pipe__eu_thread_occupancy__read(struct brw_context *brw,
                                            const struct brw_perf_query_info *query,
                                            uint64_t *accumulator)
{
   /* RPN equation: 8 A 10 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 10];
   double tmp1 = 8 * tmp0;
   double tmp2 = tmp1;
   double tmp3 = brw->perfquery.sys_vars.eu_threads_count;
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
   uint64_t tmp5 = tmp4;
   uint64_t tmp6 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
   uint64_t tmp8 = tmp7 * 100;
   double tmp9 = tmp8;
   double tmp10 = kblgt2__vme_pipe__gpu_core_clocks__read(brw, query, accumulator);
   double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

   return tmp11;
}

/* Media Vme Pipe Gen9 :: EU Stall */
static float
kblgt2__vme_pipe__eu_stall__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 8];
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = brw->perfquery.sys_vars.n_eus;
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
   uint64_t tmp4 = tmp3 * 100;
   double tmp5 = tmp4;
   double tmp6 = kblgt2__vme_pipe__gpu_core_clocks__read(brw, query, accumulator);
   double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

   return tmp7;
}

/* Media Vme Pipe Gen9 :: VME Busy */
static float
kblgt2__vme_pipe__vme_busy__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: B 0 READ B 3 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->b_offset + 0];
   uint64_t tmp1 = accumulator[query->b_offset + 3];
   double tmp2 = tmp0 + tmp1;
   double tmp3 = tmp2;
   double tmp4 = 2;
   double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
   uint64_t tmp6 = tmp5 * 100;
   double tmp7 = tmp6;
   double tmp8 = kblgt2__vme_pipe__gpu_core_clocks__read(brw, query, accumulator);
   double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

   return tmp9;
}

/* Media Vme Pipe Gen9 :: GPU Busy */
static float
kblgt2__vme_pipe__gpu_busy__read(struct brw_context *brw,
                                 const struct brw_perf_query_info *query,
                                 uint64_t *accumulator)
{
   /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
   uint64_t tmp0 = accumulator[query->a_offset + 0];
   uint64_t tmp1 = tmp0 * 100;
   double tmp2 = tmp1;
   double tmp3 = kblgt2__vme_pipe__gpu_core_clocks__read(brw, query, accumulator);
   double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

static struct brw_perf_query_counter kblgt2_vme_pipe_query_counters[10];
static struct brw_perf_query_info kblgt2_vme_pipe_query = {
   .kind = OA_COUNTERS,
   .name = "Media Vme Pipe Gen9",
   .guid = "398a4268-ef6f-4ffc-b55f-3c7b5363ce61",
   .counters = kblgt2_vme_pipe_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_vme_pipe_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_vme_pipe_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__vme_pipe__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__vme_pipe__eu_active__read;
      counter->name = "EU Active";
      counter->desc = "The percentage of time in which the Execution Units were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 8;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__vme_pipe__eu_fpu_both_active__read;
      counter->name = "EU Both FPU Pipes Active";
      counter->desc = "The percentage of time in which both EU FPU pipelines were actively processing.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 12;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__vme_pipe__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__vme_pipe__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__vme_pipe__avg_gpu_core_frequency__max(brw);
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__vme_pipe__cs_threads__read;
      counter->name = "CS Threads Dispatched";
      counter->desc = "The total number of compute shader hardware threads dispatched.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__vme_pipe__eu_thread_occupancy__read;
      counter->name = "EU Thread Occupancy";
      counter->desc = "The percentage of time in which hardware threads occupied EUs.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 40;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__vme_pipe__eu_stall__read;
      counter->name = "EU Stall";
      counter->desc = "The percentage of time in which the Execution Units were stalled.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 44;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__vme_pipe__vme_busy__read;
      counter->name = "VME Busy";
      counter->desc = "The percentage of time in which VME (IME or CRE) was actively processing data.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 48;
      counter->size = sizeof(float);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_float = kblgt2__vme_pipe__gpu_busy__read;
      counter->name = "GPU Busy";
      counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL;
      counter->raw_max = 100;
      counter->offset = 52;
      counter->size = sizeof(float);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

/* MDAPI testing set Gen9.5 :: TestCounter7 */
static uint64_t
kblgt2__test_oa__counter7__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 7 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 7];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: GPU Time Elapsed */
static uint64_t
kblgt2__test_oa__gpu_time__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
   uint64_t tmp0 = accumulator[query->gpu_time_offset + 0];
   uint64_t tmp1 = tmp0 * 1000000000;
   uint64_t tmp2 = tmp1;
   uint64_t tmp3 = brw->perfquery.sys_vars.timestamp_frequency;
   uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

   return tmp4;
}

/* MDAPI testing set Gen9.5 :: GPU Core Clocks */
static uint64_t
kblgt2__test_oa__gpu_core_clocks__read(struct brw_context *brw,
                                       const struct brw_perf_query_info *query,
                                       uint64_t *accumulator)
{
   /* RPN equation: GPU_CLOCK 0 READ */
   uint64_t tmp0 = accumulator[query->gpu_clock_offset + 0];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__test_oa__avg_gpu_core_frequency__read(struct brw_context *brw,
                                              const struct brw_perf_query_info *query,
                                              uint64_t *accumulator)
{
   /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
   uint64_t tmp0 = kblgt2__test_oa__gpu_core_clocks__read(brw, query, accumulator) * 1000000000;
   uint64_t tmp1 = tmp0;
   uint64_t tmp2 = kblgt2__test_oa__gpu_time__read(brw, query, accumulator);
   uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

   return tmp3;
}

/* MDAPI testing set Gen9.5 :: AVG GPU Core Frequency */
static uint64_t
kblgt2__test_oa__avg_gpu_core_frequency__max(struct brw_context *brw)
{
   /* RPN equation: $GpuMaxFrequency */

   return brw->perfquery.sys_vars.gt_max_freq;
}

/* MDAPI testing set Gen9.5 :: TestCounter8 */
static uint64_t
kblgt2__test_oa__counter8__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: C 7 READ */
   uint64_t tmp0 = accumulator[query->c_offset + 7];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: TestCounter4 */
static uint64_t
kblgt2__test_oa__counter4__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 4 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 4];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: TestCounter5 */
static uint64_t
kblgt2__test_oa__counter5__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 5 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 5];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: TestCounter6 */
static uint64_t
kblgt2__test_oa__counter6__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 6 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 6];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: TestCounter3 */
static uint64_t
kblgt2__test_oa__counter3__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 3 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 3];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: TestCounter0 */
static uint64_t
kblgt2__test_oa__counter0__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 0 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 0];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: TestCounter1 */
static uint64_t
kblgt2__test_oa__counter1__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 1 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 1];

   return tmp0;
}

/* MDAPI testing set Gen9.5 :: TestCounter2 */
static uint64_t
kblgt2__test_oa__counter2__read(struct brw_context *brw,
                                const struct brw_perf_query_info *query,
                                uint64_t *accumulator)
{
   /* RPN equation: B 2 READ */
   uint64_t tmp0 = accumulator[query->b_offset + 2];

   return tmp0;
}

static struct brw_perf_query_counter kblgt2_test_oa_query_counters[12];
static struct brw_perf_query_info kblgt2_test_oa_query = {
   .kind = OA_COUNTERS,
   .name = "MDAPI testing set Gen9.5",
   .guid = "baa3c7e4-52b6-4b85-801e-465a94b746dd",
   .counters = kblgt2_test_oa_query_counters,
   .n_counters = 0,
   .oa_metrics_set_id = 0, /* determined at runtime, via sysfs */
   .oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8,

   /* Accumulation buffer offsets... */
   .gpu_time_offset = 0,
   .gpu_clock_offset = 1,
   .a_offset = 2,
   .b_offset = 38,
   .c_offset = 46,
};

static void
register_test_oa_counter_query(struct brw_context *brw)
{
   static struct brw_perf_query_info *query = &kblgt2_test_oa_query;
   struct brw_perf_query_counter *counter;

   /* Note: we're assuming there can't be any variation in the definition
    * of a query between contexts so it's ok to describe a query within a
    * global variable which only needs to be initialized once... */

   if (!query->data_size) {

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter7__read;
      counter->name = "TestCounter7";
      counter->desc = "HW test counter 7. Factor: 0.666";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 0;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__gpu_time__read;
      counter->name = "GPU Time Elapsed";
      counter->desc = "Time elapsed on the GPU during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_RAW_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 8;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__gpu_core_clocks__read;
      counter->name = "GPU Core Clocks";
      counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 16;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__avg_gpu_core_frequency__read;
      counter->name = "AVG GPU Core Frequency";
      counter->desc = "Average GPU Core Frequency in the measurement.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = kblgt2__test_oa__avg_gpu_core_frequency__max(brw);
      counter->offset = 24;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter8__read;
      counter->name = "TestCounter8";
      counter->desc = "HW test counter 8. Should be equal to 1.";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 32;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter4__read;
      counter->name = "TestCounter4";
      counter->desc = "HW test counter 4. Factor: 0.333";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 40;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter5__read;
      counter->name = "TestCounter5";
      counter->desc = "HW test counter 5. Factor: 0.333";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 48;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter6__read;
      counter->name = "TestCounter6";
      counter->desc = "HW test counter 6. Factor: 0.166";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 56;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter3__read;
      counter->name = "TestCounter3";
      counter->desc = "HW test counter 3. Factor: 0.5";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 64;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter0__read;
      counter->name = "TestCounter0";
      counter->desc = "HW test counter 0. Factor: 0.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 72;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter1__read;
      counter->name = "TestCounter1";
      counter->desc = "HW test counter 1. Factor: 1.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 80;
      counter->size = sizeof(uint64_t);

      counter = &query->counters[query->n_counters++];
      counter->oa_counter_read_uint64 = kblgt2__test_oa__counter2__read;
      counter->name = "TestCounter2";
      counter->desc = "HW test counter 2. Factor: 1.0";
      counter->type = GL_PERFQUERY_COUNTER_EVENT_INTEL;
      counter->data_type = GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL;
      counter->raw_max = 0; /* undefined */
      counter->offset = 88;
      counter->size = sizeof(uint64_t);

      query->data_size = counter->offset + counter->size;
   }

   _mesa_hash_table_insert(brw->perfquery.oa_metrics_table, query->guid, query);
}

void
brw_oa_register_queries_kblgt2(struct brw_context *brw)
{
   register_render_basic_counter_query(brw);
   register_compute_basic_counter_query(brw);
   register_render_pipe_profile_counter_query(brw);
   register_memory_reads_counter_query(brw);
   register_memory_writes_counter_query(brw);
   register_compute_extended_counter_query(brw);
   register_compute_l3_cache_counter_query(brw);
   register_hdc_and_sf_counter_query(brw);
   register_l3_1_counter_query(brw);
   register_l3_2_counter_query(brw);
   register_l3_3_counter_query(brw);
   register_rasterizer_and_pixel_backend_counter_query(brw);
   register_sampler_counter_query(brw);
   register_tdl_1_counter_query(brw);
   register_tdl_2_counter_query(brw);
   register_compute_extra_counter_query(brw);
   register_vme_pipe_counter_query(brw);
   register_test_oa_counter_query(brw);
}
