#!/usr/bin/env python

# Copyright (C) 2015 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

"""Table of functions that have ABI-mandated offsets in the dispatch table.

This list will never change."""
offsets = {
    "NewList": 0,
    "EndList": 1,
    "CallList": 2,
    "CallLists": 3,
    "DeleteLists": 4,
    "GenLists": 5,
    "ListBase": 6,
    "Begin": 7,
    "Bitmap": 8,
    "Color3b": 9,
    "Color3bv": 10,
    "Color3d": 11,
    "Color3dv": 12,
    "Color3f": 13,
    "Color3fv": 14,
    "Color3i": 15,
    "Color3iv": 16,
    "Color3s": 17,
    "Color3sv": 18,
    "Color3ub": 19,
    "Color3ubv": 20,
    "Color3ui": 21,
    "Color3uiv": 22,
    "Color3us": 23,
    "Color3usv": 24,
    "Color4b": 25,
    "Color4bv": 26,
    "Color4d": 27,
    "Color4dv": 28,
    "Color4f": 29,
    "Color4fv": 30,
    "Color4i": 31,
    "Color4iv": 32,
    "Color4s": 33,
    "Color4sv": 34,
    "Color4ub": 35,
    "Color4ubv": 36,
    "Color4ui": 37,
    "Color4uiv": 38,
    "Color4us": 39,
    "Color4usv": 40,
    "EdgeFlag": 41,
    "EdgeFlagv": 42,
    "End": 43,
    "Indexd": 44,
    "Indexdv": 45,
    "Indexf": 46,
    "Indexfv": 47,
    "Indexi": 48,
    "Indexiv": 49,
    "Indexs": 50,
    "Indexsv": 51,
    "Normal3b": 52,
    "Normal3bv": 53,
    "Normal3d": 54,
    "Normal3dv": 55,
    "Normal3f": 56,
    "Normal3fv": 57,
    "Normal3i": 58,
    "Normal3iv": 59,
    "Normal3s": 60,
    "Normal3sv": 61,
    "RasterPos2d": 62,
    "RasterPos2dv": 63,
    "RasterPos2f": 64,
    "RasterPos2fv": 65,
    "RasterPos2i": 66,
    "RasterPos2iv": 67,
    "RasterPos2s": 68,
    "RasterPos2sv": 69,
    "RasterPos3d": 70,
    "RasterPos3dv": 71,
    "RasterPos3f": 72,
    "RasterPos3fv": 73,
    "RasterPos3i": 74,
    "RasterPos3iv": 75,
    "RasterPos3s": 76,
    "RasterPos3sv": 77,
    "RasterPos4d": 78,
    "RasterPos4dv": 79,
    "RasterPos4f": 80,
    "RasterPos4fv": 81,
    "RasterPos4i": 82,
    "RasterPos4iv": 83,
    "RasterPos4s": 84,
    "RasterPos4sv": 85,
    "Rectd": 86,
    "Rectdv": 87,
    "Rectf": 88,
    "Rectfv": 89,
    "Recti": 90,
    "Rectiv": 91,
    "Rects": 92,
    "Rectsv": 93,
    "TexCoord1d": 94,
    "TexCoord1dv": 95,
    "TexCoord1f": 96,
    "TexCoord1fv": 97,
    "TexCoord1i": 98,
    "TexCoord1iv": 99,
    "TexCoord1s": 100,
    "TexCoord1sv": 101,
    "TexCoord2d": 102,
    "TexCoord2dv": 103,
    "TexCoord2f": 104,
    "TexCoord2fv": 105,
    "TexCoord2i": 106,
    "TexCoord2iv": 107,
    "TexCoord2s": 108,
    "TexCoord2sv": 109,
    "TexCoord3d": 110,
    "TexCoord3dv": 111,
    "TexCoord3f": 112,
    "TexCoord3fv": 113,
    "TexCoord3i": 114,
    "TexCoord3iv": 115,
    "TexCoord3s": 116,
    "TexCoord3sv": 117,
    "TexCoord4d": 118,
    "TexCoord4dv": 119,
    "TexCoord4f": 120,
    "TexCoord4fv": 121,
    "TexCoord4i": 122,
    "TexCoord4iv": 123,
    "TexCoord4s": 124,
    "TexCoord4sv": 125,
    "Vertex2d": 126,
    "Vertex2dv": 127,
    "Vertex2f": 128,
    "Vertex2fv": 129,
    "Vertex2i": 130,
    "Vertex2iv": 131,
    "Vertex2s": 132,
    "Vertex2sv": 133,
    "Vertex3d": 134,
    "Vertex3dv": 135,
    "Vertex3f": 136,
    "Vertex3fv": 137,
    "Vertex3i": 138,
    "Vertex3iv": 139,
    "Vertex3s": 140,
    "Vertex3sv": 141,
    "Vertex4d": 142,
    "Vertex4dv": 143,
    "Vertex4f": 144,
    "Vertex4fv": 145,
    "Vertex4i": 146,
    "Vertex4iv": 147,
    "Vertex4s": 148,
    "Vertex4sv": 149,
    "ClipPlane": 150,
    "ColorMaterial": 151,
    "CullFace": 152,
    "Fogf": 153,
    "Fogfv": 154,
    "Fogi": 155,
    "Fogiv": 156,
    "FrontFace": 157,
    "Hint": 158,
    "Lightf": 159,
    "Lightfv": 160,
    "Lighti": 161,
    "Lightiv": 162,
    "LightModelf": 163,
    "LightModelfv": 164,
    "LightModeli": 165,
    "LightModeliv": 166,
    "LineStipple": 167,
    "LineWidth": 168,
    "Materialf": 169,
    "Materialfv": 170,
    "Materiali": 171,
    "Materialiv": 172,
    "PointSize": 173,
    "PolygonMode": 174,
    "PolygonStipple": 175,
    "Scissor": 176,
    "ShadeModel": 177,
    "TexParameterf": 178,
    "TexParameterfv": 179,
    "TexParameteri": 180,
    "TexParameteriv": 181,
    "TexImage1D": 182,
    "TexImage2D": 183,
    "TexEnvf": 184,
    "TexEnvfv": 185,
    "TexEnvi": 186,
    "TexEnviv": 187,
    "TexGend": 188,
    "TexGendv": 189,
    "TexGenf": 190,
    "TexGenfv": 191,
    "TexGeni": 192,
    "TexGeniv": 193,
    "FeedbackBuffer": 194,
    "SelectBuffer": 195,
    "RenderMode": 196,
    "InitNames": 197,
    "LoadName": 198,
    "PassThrough": 199,
    "PopName": 200,
    "PushName": 201,
    "DrawBuffer": 202,
    "Clear": 203,
    "ClearAccum": 204,
    "ClearIndex": 205,
    "ClearColor": 206,
    "ClearStencil": 207,
    "ClearDepth": 208,
    "StencilMask": 209,
    "ColorMask": 210,
    "DepthMask": 211,
    "IndexMask": 212,
    "Accum": 213,
    "Disable": 214,
    "Enable": 215,
    "Finish": 216,
    "Flush": 217,
    "PopAttrib": 218,
    "PushAttrib": 219,
    "Map1d": 220,
    "Map1f": 221,
    "Map2d": 222,
    "Map2f": 223,
    "MapGrid1d": 224,
    "MapGrid1f": 225,
    "MapGrid2d": 226,
    "MapGrid2f": 227,
    "EvalCoord1d": 228,
    "EvalCoord1dv": 229,
    "EvalCoord1f": 230,
    "EvalCoord1fv": 231,
    "EvalCoord2d": 232,
    "EvalCoord2dv": 233,
    "EvalCoord2f": 234,
    "EvalCoord2fv": 235,
    "EvalMesh1": 236,
    "EvalPoint1": 237,
    "EvalMesh2": 238,
    "EvalPoint2": 239,
    "AlphaFunc": 240,
    "BlendFunc": 241,
    "LogicOp": 242,
    "StencilFunc": 243,
    "StencilOp": 244,
    "DepthFunc": 245,
    "PixelZoom": 246,
    "PixelTransferf": 247,
    "PixelTransferi": 248,
    "PixelStoref": 249,
    "PixelStorei": 250,
    "PixelMapfv": 251,
    "PixelMapuiv": 252,
    "PixelMapusv": 253,
    "ReadBuffer": 254,
    "CopyPixels": 255,
    "ReadPixels": 256,
    "DrawPixels": 257,
    "GetBooleanv": 258,
    "GetClipPlane": 259,
    "GetDoublev": 260,
    "GetError": 261,
    "GetFloatv": 262,
    "GetIntegerv": 263,
    "GetLightfv": 264,
    "GetLightiv": 265,
    "GetMapdv": 266,
    "GetMapfv": 267,
    "GetMapiv": 268,
    "GetMaterialfv": 269,
    "GetMaterialiv": 270,
    "GetPixelMapfv": 271,
    "GetPixelMapuiv": 272,
    "GetPixelMapusv": 273,
    "GetPolygonStipple": 274,
    "GetString": 275,
    "GetTexEnvfv": 276,
    "GetTexEnviv": 277,
    "GetTexGendv": 278,
    "GetTexGenfv": 279,
    "GetTexGeniv": 280,
    "GetTexImage": 281,
    "GetTexParameterfv": 282,
    "GetTexParameteriv": 283,
    "GetTexLevelParameterfv": 284,
    "GetTexLevelParameteriv": 285,
    "IsEnabled": 286,
    "IsList": 287,
    "DepthRange": 288,
    "Frustum": 289,
    "LoadIdentity": 290,
    "LoadMatrixf": 291,
    "LoadMatrixd": 292,
    "MatrixMode": 293,
    "MultMatrixf": 294,
    "MultMatrixd": 295,
    "Ortho": 296,
    "PopMatrix": 297,
    "PushMatrix": 298,
    "Rotated": 299,
    "Rotatef": 300,
    "Scaled": 301,
    "Scalef": 302,
    "Translated": 303,
    "Translatef": 304,
    "Viewport": 305,
    "ArrayElement": 306,
    "ColorPointer": 308,
    "DisableClientState": 309,
    "DrawArrays": 310,
    "DrawElements": 311,
    "EdgeFlagPointer": 312,
    "EnableClientState": 313,
    "GetPointerv": 329,
    "IndexPointer": 314,
    "InterleavedArrays": 317,
    "NormalPointer": 318,
    "TexCoordPointer": 320,
    "VertexPointer": 321,
    "PolygonOffset": 319,
    "CopyTexImage1D": 323,
    "CopyTexImage2D": 324,
    "CopyTexSubImage1D": 325,
    "CopyTexSubImage2D": 326,
    "TexSubImage1D": 332,
    "TexSubImage2D": 333,
    "AreTexturesResident": 322,
    "BindTexture": 307,
    "DeleteTextures": 327,
    "GenTextures": 328,
    "IsTexture": 330,
    "PrioritizeTextures": 331,
    "Indexub": 315,
    "Indexubv": 316,
    "PopClientAttrib": 334,
    "PushClientAttrib": 335,
    "BlendColor": 336,
    "BlendEquation": 337,
    "DrawRangeElements": 338,
    "ColorTable": 339,
    "ColorTableParameterfv": 340,
    "ColorTableParameteriv": 341,
    "CopyColorTable": 342,
    "GetColorTable": 343,
    "GetColorTableParameterfv": 344,
    "GetColorTableParameteriv": 345,
    "ColorSubTable": 346,
    "CopyColorSubTable": 347,
    "ConvolutionFilter1D": 348,
    "ConvolutionFilter2D": 349,
    "ConvolutionParameterf": 350,
    "ConvolutionParameterfv": 351,
    "ConvolutionParameteri": 352,
    "ConvolutionParameteriv": 353,
    "CopyConvolutionFilter1D": 354,
    "CopyConvolutionFilter2D": 355,
    "GetConvolutionFilter": 356,
    "GetConvolutionParameterfv": 357,
    "GetConvolutionParameteriv": 358,
    "GetSeparableFilter": 359,
    "SeparableFilter2D": 360,
    "GetHistogram": 361,
    "GetHistogramParameterfv": 362,
    "GetHistogramParameteriv": 363,
    "GetMinmax": 364,
    "GetMinmaxParameterfv": 365,
    "GetMinmaxParameteriv": 366,
    "Histogram": 367,
    "Minmax": 368,
    "ResetHistogram": 369,
    "ResetMinmax": 370,
    "TexImage3D": 371,
    "TexSubImage3D": 372,
    "CopyTexSubImage3D": 373,
    "ActiveTexture": 374,
    "ClientActiveTexture": 375,
    "MultiTexCoord1d": 376,
    "MultiTexCoord1dv": 377,
    "MultiTexCoord1fARB": 378,
    "MultiTexCoord1fvARB": 379,
    "MultiTexCoord1i": 380,
    "MultiTexCoord1iv": 381,
    "MultiTexCoord1s": 382,
    "MultiTexCoord1sv": 383,
    "MultiTexCoord2d": 384,
    "MultiTexCoord2dv": 385,
    "MultiTexCoord2fARB": 386,
    "MultiTexCoord2fvARB": 387,
    "MultiTexCoord2i": 388,
    "MultiTexCoord2iv": 389,
    "MultiTexCoord2s": 390,
    "MultiTexCoord2sv": 391,
    "MultiTexCoord3d": 392,
    "MultiTexCoord3dv": 393,
    "MultiTexCoord3fARB": 394,
    "MultiTexCoord3fvARB": 395,
    "MultiTexCoord3i": 396,
    "MultiTexCoord3iv": 397,
    "MultiTexCoord3s": 398,
    "MultiTexCoord3sv": 399,
    "MultiTexCoord4d": 400,
    "MultiTexCoord4dv": 401,
    "MultiTexCoord4fARB": 402,
    "MultiTexCoord4fvARB": 403,
    "MultiTexCoord4i": 404,
    "MultiTexCoord4iv": 405,
    "MultiTexCoord4s": 406,
    "MultiTexCoord4sv": 407
}

functions = [
    "Accum",
    "ActiveShaderProgram",
    "ActiveTexture",
    "ActiveTextureARB",
    "AlphaFunc",
    "AlphaFuncx",
    "AreTexturesResident",
    "AreTexturesResidentEXT",
    "ArrayElement",
    "ArrayElementEXT",
    "AttachObjectARB",
    "AttachShader",
    "Begin",
    "BeginConditionalRender",
    "BeginConditionalRenderNV",
    "BeginQuery",
    "BeginQueryARB",
    "BeginQueryIndexed",
    "BeginTransformFeedback",
    "BindAttribLocation",
    "BindAttribLocationARB",
    "BindBuffer",
    "BindBufferARB",
    "BindBufferBase",
    "BindBufferRange",
    "BindBuffersBase",
    "BindBuffersRange",
    "BindFragDataLocation",
    "BindFragDataLocationEXT",
    "BindFragDataLocationIndexed",
    "BindFramebuffer",
    "BindFramebufferEXT",
    "BindImageTexture",
    "BindImageTextures",
    "BindProgramARB",
    "BindProgramPipeline",
    "BindRenderbuffer",
    "BindRenderbufferEXT",
    "BindSampler",
    "BindSamplers",
    "BindTexture",
    "BindTextureEXT",
    "BindTextures",
    "BindTransformFeedback",
    "BindVertexArray",
    "BindVertexBuffer",
    "BindVertexBuffers",
    "Bitmap",
    "BlendBarrier",
    "BlendColor",
    "BlendColorEXT",
    "BlendEquation",
    "BlendEquationEXT",
    "BlendEquationi",
    "BlendEquationiARB",
    "BlendEquationSeparate",
    "BlendEquationSeparatei",
    "BlendEquationSeparateiARB",
    "BlendFunc",
    "BlendFunci",
    "BlendFunciARB",
    "BlendFuncSeparate",
    "BlendFuncSeparateEXT",
    "BlendFuncSeparatei",
    "BlendFuncSeparateiARB",
    "BlitFramebuffer",
    "BufferData",
    "BufferDataARB",
    "BufferStorage",
    "BufferSubData",
    "BufferSubDataARB",
    "CallList",
    "CallLists",
    "CheckFramebufferStatus",
    "CheckFramebufferStatusEXT",
    "ClampColor",
    "ClampColorARB",
    "Clear",
    "ClearAccum",
    "ClearBufferData",
    "ClearBufferfi",
    "ClearBufferfv",
    "ClearBufferiv",
    "ClearBufferSubData",
    "ClearBufferuiv",
    "ClearColor",
    "ClearColorIiEXT",
    "ClearColorIuiEXT",
    "ClearColorx",
    "ClearDepth",
    "ClearDepthf",
    "ClearDepthx",
    "ClearIndex",
    "ClearStencil",
    "ClearTexImage",
    "ClearTexSubImage",
    "ClientActiveTexture",
    "ClientActiveTextureARB",
    "ClientWaitSync",
    "ClipPlane",
    "ClipPlanef",
    "ClipPlanex",
    "Color3b",
    "Color3bv",
    "Color3d",
    "Color3dv",
    "Color3f",
    "Color3fv",
    "Color3i",
    "Color3iv",
    "Color3s",
    "Color3sv",
    "Color3ub",
    "Color3ubv",
    "Color3ui",
    "Color3uiv",
    "Color3us",
    "Color3usv",
    "Color4b",
    "Color4bv",
    "Color4d",
    "Color4dv",
    "Color4f",
    "Color4fv",
    "Color4i",
    "Color4iv",
    "Color4s",
    "Color4sv",
    "Color4ub",
    "Color4ubv",
    "Color4ui",
    "Color4uiv",
    "Color4us",
    "Color4usv",
    "Color4x",
    "ColorMask",
    "ColorMaski",
    "ColorMaskIndexedEXT",
    "ColorMaterial",
    "ColorP3ui",
    "ColorP3uiv",
    "ColorP4ui",
    "ColorP4uiv",
    "ColorPointer",
    "ColorPointerEXT",
    "ColorSubTable",
    "ColorTable",
    "ColorTableParameterfv",
    "ColorTableParameteriv",
    "CompileShader",
    "CompileShaderARB",
    "CompressedTexImage1D",
    "CompressedTexImage1DARB",
    "CompressedTexImage2D",
    "CompressedTexImage2DARB",
    "CompressedTexImage3D",
    "CompressedTexImage3DARB",
    "CompressedTexSubImage1D",
    "CompressedTexSubImage1DARB",
    "CompressedTexSubImage2D",
    "CompressedTexSubImage2DARB",
    "CompressedTexSubImage3D",
    "CompressedTexSubImage3DARB",
    "ConvolutionFilter1D",
    "ConvolutionFilter2D",
    "ConvolutionParameterf",
    "ConvolutionParameterfv",
    "ConvolutionParameteri",
    "ConvolutionParameteriv",
    "CopyBufferSubData",
    "CopyColorSubTable",
    "CopyColorTable",
    "CopyConvolutionFilter1D",
    "CopyConvolutionFilter2D",
    "CopyImageSubData",
    "CopyPixels",
    "CopyTexImage1D",
    "CopyTexImage2D",
    "CopyTexSubImage1D",
    "CopyTexSubImage2D",
    "CopyTexSubImage3D",
    "CopyTexSubImage3DEXT",
    "CreateProgram",
    "CreateProgramObjectARB",
    "CreateShader",
    "CreateShaderObjectARB",
    "CreateShaderProgramv",
    "CullFace",
    "DebugMessageCallback",
    "DebugMessageCallbackARB",
    "DebugMessageControl",
    "DebugMessageControlARB",
    "DebugMessageInsert",
    "DebugMessageInsertARB",
    "DeleteBuffers",
    "DeleteBuffersARB",
    "DeleteFramebuffers",
    "DeleteFramebuffersEXT",
    "DeleteLists",
    "DeleteObjectARB",
    "DeleteProgram",
    "DeleteProgramPipelines",
    "DeleteProgramsARB",
    "DeleteQueries",
    "DeleteQueriesARB",
    "DeleteRenderbuffers",
    "DeleteRenderbuffersEXT",
    "DeleteSamplers",
    "DeleteShader",
    "DeleteSync",
    "DeleteTextures",
    "DeleteTexturesEXT",
    "DeleteTransformFeedbacks",
    "DeleteVertexArrays",
    "DepthFunc",
    "DepthMask",
    "DepthRange",
    "DepthRangeArrayv",
    "DepthRangef",
    "DepthRangeIndexed",
    "DepthRangex",
    "DetachObjectARB",
    "DetachShader",
    "Disable",
    "DisableClientState",
    "Disablei",
    "DisableIndexedEXT",
    "DisableVertexAttribArray",
    "DisableVertexAttribArrayARB",
    "DispatchCompute",
    "DispatchComputeIndirect",
    "DrawArrays",
    "DrawArraysEXT",
    "DrawArraysIndirect",
    "DrawArraysInstanced",
    "DrawArraysInstancedARB",
    "DrawArraysInstancedBaseInstance",
    "DrawArraysInstancedEXT",
    "DrawBuffer",
    "DrawBuffers",
    "DrawBuffersARB",
    "DrawBuffersATI",
    "DrawElements",
    "DrawElementsBaseVertex",
    "DrawElementsIndirect",
    "DrawElementsInstanced",
    "DrawElementsInstancedARB",
    "DrawElementsInstancedBaseInstance",
    "DrawElementsInstancedBaseVertex",
    "DrawElementsInstancedBaseVertexBaseInstance",
    "DrawElementsInstancedEXT",
    "DrawPixels",
    "DrawRangeElements",
    "DrawRangeElementsBaseVertex",
    "DrawRangeElementsEXT",
    "DrawTransformFeedback",
    "DrawTransformFeedbackInstanced",
    "DrawTransformFeedbackStream",
    "DrawTransformFeedbackStreamInstanced",
    "EdgeFlag",
    "EdgeFlagPointer",
    "EdgeFlagPointerEXT",
    "EdgeFlagv",
    "Enable",
    "EnableClientState",
    "Enablei",
    "EnableIndexedEXT",
    "EnableVertexAttribArray",
    "EnableVertexAttribArrayARB",
    "End",
    "EndConditionalRender",
    "EndConditionalRenderNV",
    "EndList",
    "EndQuery",
    "EndQueryARB",
    "EndQueryIndexed",
    "EndTransformFeedback",
    "EvalCoord1d",
    "EvalCoord1dv",
    "EvalCoord1f",
    "EvalCoord1fv",
    "EvalCoord2d",
    "EvalCoord2dv",
    "EvalCoord2f",
    "EvalCoord2fv",
    "EvalMesh1",
    "EvalMesh2",
    "EvalPoint1",
    "EvalPoint2",
    "FeedbackBuffer",
    "FenceSync",
    "Finish",
    "Flush",
    "FlushMappedBufferRange",
    "FogCoordd",
    "FogCoorddEXT",
    "FogCoorddv",
    "FogCoorddvEXT",
    "FogCoordf",
    "FogCoordfEXT",
    "FogCoordfv",
    "FogCoordfvEXT",
    "FogCoordPointer",
    "FogCoordPointerEXT",
    "Fogf",
    "Fogfv",
    "Fogi",
    "Fogiv",
    "Fogx",
    "Fogxv",
    "FramebufferParameteri",
    "FramebufferRenderbuffer",
    "FramebufferRenderbufferEXT",
    "FramebufferTexture",
    "FramebufferTexture1D",
    "FramebufferTexture1DEXT",
    "FramebufferTexture2D",
    "FramebufferTexture2DEXT",
    "FramebufferTexture3D",
    "FramebufferTexture3DEXT",
    "FramebufferTextureARB",
    "FramebufferTextureLayer",
    "FramebufferTextureLayerARB",
    "FramebufferTextureLayerEXT",
    "FrontFace",
    "Frustum",
    "Frustumf",
    "Frustumx",
    "GenBuffers",
    "GenBuffersARB",
    "GenerateMipmap",
    "GenerateMipmapEXT",
    "GenFramebuffers",
    "GenFramebuffersEXT",
    "GenLists",
    "GenProgramPipelines",
    "GenProgramsARB",
    "GenQueries",
    "GenQueriesARB",
    "GenRenderbuffers",
    "GenRenderbuffersEXT",
    "GenSamplers",
    "GenTextures",
    "GenTexturesEXT",
    "GenTransformFeedbacks",
    "GenVertexArrays",
    "GetActiveAtomicCounterBufferiv",
    "GetActiveAttrib",
    "GetActiveAttribARB",
    "GetActiveUniform",
    "GetActiveUniformARB",
    "GetActiveUniformBlockiv",
    "GetActiveUniformBlockName",
    "GetActiveUniformName",
    "GetActiveUniformsiv",
    "GetAttachedObjectsARB",
    "GetAttachedShaders",
    "GetAttribLocation",
    "GetAttribLocationARB",
    "GetBooleani_v",
    "GetBooleanIndexedvEXT",
    "GetBooleanv",
    "GetBufferParameteri64v",
    "GetBufferParameteriv",
    "GetBufferParameterivARB",
    "GetBufferPointerv",
    "GetBufferPointervARB",
    "GetBufferSubData",
    "GetBufferSubDataARB",
    "GetClipPlane",
    "GetClipPlanef",
    "GetClipPlanex",
    "GetColorTable",
    "GetColorTableParameterfv",
    "GetColorTableParameteriv",
    "GetCompressedTexImage",
    "GetCompressedTexImageARB",
    "GetConvolutionFilter",
    "GetConvolutionParameterfv",
    "GetConvolutionParameteriv",
    "GetDebugMessageLog",
    "GetDebugMessageLogARB",
    "GetDoublei_v",
    "GetDoublev",
    "GetError",
    "GetFixedv",
    "GetFloati_v",
    "GetFloatv",
    "GetFragDataIndex",
    "GetFragDataLocation",
    "GetFragDataLocationEXT",
    "GetFramebufferAttachmentParameteriv",
    "GetFramebufferAttachmentParameterivEXT",
    "GetFramebufferParameteriv",
    "GetGraphicsResetStatus",
    "GetGraphicsResetStatusARB",
    "GetHandleARB",
    "GetHistogram",
    "GetHistogramParameterfv",
    "GetHistogramParameteriv",
    "GetInfoLogARB",
    "GetInteger64i_v",
    "GetInteger64v",
    "GetIntegeri_v",
    "GetIntegerIndexedvEXT",
    "GetIntegerv",
    "GetLightfv",
    "GetLightiv",
    "GetLightxv",
    "GetMapdv",
    "GetMapfv",
    "GetMapiv",
    "GetMaterialfv",
    "GetMaterialiv",
    "GetMaterialxv",
    "GetMinmax",
    "GetMinmaxParameterfv",
    "GetMinmaxParameteriv",
    "GetMultisamplefv",
    "GetnColorTableARB",
    "GetnCompressedTexImageARB",
    "GetnConvolutionFilterARB",
    "GetnHistogramARB",
    "GetnMapdvARB",
    "GetnMapfvARB",
    "GetnMapivARB",
    "GetnMinmaxARB",
    "GetnPixelMapfvARB",
    "GetnPixelMapuivARB",
    "GetnPixelMapusvARB",
    "GetnPolygonStippleARB",
    "GetnSeparableFilterARB",
    "GetnTexImageARB",
    "GetnUniformdvARB",
    "GetnUniformfv",
    "GetnUniformfvARB",
    "GetnUniformiv",
    "GetnUniformivARB",
    "GetnUniformuiv",
    "GetnUniformuivARB",
    "GetObjectLabel",
    "GetObjectParameterfvARB",
    "GetObjectParameterivARB",
    "GetObjectPtrLabel",
    "GetPixelMapfv",
    "GetPixelMapuiv",
    "GetPixelMapusv",
    "GetPointerv",
    "GetPointervEXT",
    "GetPolygonStipple",
    "GetProgramBinary",
    "GetProgramEnvParameterdvARB",
    "GetProgramEnvParameterfvARB",
    "GetProgramInfoLog",
    "GetProgramInterfaceiv",
    "GetProgramiv",
    "GetProgramivARB",
    "GetProgramLocalParameterdvARB",
    "GetProgramLocalParameterfvARB",
    "GetProgramPipelineInfoLog",
    "GetProgramPipelineiv",
    "GetProgramResourceIndex",
    "GetProgramResourceiv",
    "GetProgramResourceLocation",
    "GetProgramResourceName",
    "GetProgramStringARB",
    "GetQueryIndexediv",
    "GetQueryiv",
    "GetQueryivARB",
    "GetQueryObjectiv",
    "GetQueryObjectivARB",
    "GetQueryObjectuiv",
    "GetQueryObjectuivARB",
    "GetRenderbufferParameteriv",
    "GetRenderbufferParameterivEXT",
    "GetSamplerParameterfv",
    "GetSamplerParameterIiv",
    "GetSamplerParameterIuiv",
    "GetSamplerParameteriv",
    "GetSeparableFilter",
    "GetShaderInfoLog",
    "GetShaderiv",
    "GetShaderPrecisionFormat",
    "GetShaderSource",
    "GetShaderSourceARB",
    "GetString",
    "GetStringi",
    "GetSynciv",
    "GetTexEnvfv",
    "GetTexEnviv",
    "GetTexEnvxv",
    "GetTexGendv",
    "GetTexGenfv",
    "GetTexGeniv",
    "GetTexImage",
    "GetTexLevelParameterfv",
    "GetTexLevelParameteriv",
    "GetTexParameterfv",
    "GetTexParameterIiv",
    "GetTexParameterIivEXT",
    "GetTexParameterIuiv",
    "GetTexParameterIuivEXT",
    "GetTexParameteriv",
    "GetTexParameterxv",
    "GetTransformFeedbackVarying",
    "GetUniformBlockIndex",
    "GetUniformfv",
    "GetUniformfvARB",
    "GetUniformIndices",
    "GetUniformiv",
    "GetUniformivARB",
    "GetUniformLocation",
    "GetUniformLocationARB",
    "GetUniformuiv",
    "GetUniformuivEXT",
    "GetVertexAttribdv",
    "GetVertexAttribdvARB",
    "GetVertexAttribfv",
    "GetVertexAttribfvARB",
    "GetVertexAttribIiv",
    "GetVertexAttribIivEXT",
    "GetVertexAttribIuiv",
    "GetVertexAttribIuivEXT",
    "GetVertexAttribiv",
    "GetVertexAttribivARB",
    "GetVertexAttribPointerv",
    "GetVertexAttribPointervARB",
    "Hint",
    "Histogram",
    "Indexd",
    "Indexdv",
    "Indexf",
    "Indexfv",
    "Indexi",
    "Indexiv",
    "IndexMask",
    "IndexPointer",
    "IndexPointerEXT",
    "Indexs",
    "Indexsv",
    "Indexub",
    "Indexubv",
    "InitNames",
    "InterleavedArrays",
    "InvalidateBufferData",
    "InvalidateBufferSubData",
    "InvalidateFramebuffer",
    "InvalidateSubFramebuffer",
    "InvalidateTexImage",
    "InvalidateTexSubImage",
    "IsBuffer",
    "IsBufferARB",
    "IsEnabled",
    "IsEnabledi",
    "IsEnabledIndexedEXT",
    "IsFramebuffer",
    "IsFramebufferEXT",
    "IsList",
    "IsProgram",
    "IsProgramARB",
    "IsProgramPipeline",
    "IsQuery",
    "IsQueryARB",
    "IsRenderbuffer",
    "IsRenderbufferEXT",
    "IsSampler",
    "IsShader",
    "IsSync",
    "IsTexture",
    "IsTextureEXT",
    "IsTransformFeedback",
    "IsVertexArray",
    "Lightf",
    "Lightfv",
    "Lighti",
    "Lightiv",
    "LightModelf",
    "LightModelfv",
    "LightModeli",
    "LightModeliv",
    "LightModelx",
    "LightModelxv",
    "Lightx",
    "Lightxv",
    "LineStipple",
    "LineWidth",
    "LineWidthx",
    "LinkProgram",
    "LinkProgramARB",
    "ListBase",
    "LoadIdentity",
    "LoadMatrixd",
    "LoadMatrixf",
    "LoadMatrixx",
    "LoadName",
    "LoadTransposeMatrixd",
    "LoadTransposeMatrixdARB",
    "LoadTransposeMatrixf",
    "LoadTransposeMatrixfARB",
    "LockArraysEXT",
    "LogicOp",
    "Map1d",
    "Map1f",
    "Map2d",
    "Map2f",
    "MapBuffer",
    "MapBufferARB",
    "MapBufferRange",
    "MapGrid1d",
    "MapGrid1f",
    "MapGrid2d",
    "MapGrid2f",
    "Materialf",
    "Materialfv",
    "Materiali",
    "Materialiv",
    "Materialx",
    "Materialxv",
    "MatrixMode",
    "MemoryBarrier",
    "MemoryBarrierByRegion",
    "Minmax",
    "MinSampleShading",
    "MinSampleShadingARB",
    "MultiDrawArrays",
    "MultiDrawArraysEXT",
    "MultiDrawArraysIndirect",
    "MultiDrawElements",
    "MultiDrawElementsBaseVertex",
    "MultiDrawElementsEXT",
    "MultiDrawElementsIndirect",
    "MultiTexCoord1d",
    "MultiTexCoord1dARB",
    "MultiTexCoord1dv",
    "MultiTexCoord1dvARB",
    "MultiTexCoord1f",
    "MultiTexCoord1fARB",
    "MultiTexCoord1fv",
    "MultiTexCoord1fvARB",
    "MultiTexCoord1i",
    "MultiTexCoord1iARB",
    "MultiTexCoord1iv",
    "MultiTexCoord1ivARB",
    "MultiTexCoord1s",
    "MultiTexCoord1sARB",
    "MultiTexCoord1sv",
    "MultiTexCoord1svARB",
    "MultiTexCoord2d",
    "MultiTexCoord2dARB",
    "MultiTexCoord2dv",
    "MultiTexCoord2dvARB",
    "MultiTexCoord2f",
    "MultiTexCoord2fARB",
    "MultiTexCoord2fv",
    "MultiTexCoord2fvARB",
    "MultiTexCoord2i",
    "MultiTexCoord2iARB",
    "MultiTexCoord2iv",
    "MultiTexCoord2ivARB",
    "MultiTexCoord2s",
    "MultiTexCoord2sARB",
    "MultiTexCoord2sv",
    "MultiTexCoord2svARB",
    "MultiTexCoord3d",
    "MultiTexCoord3dARB",
    "MultiTexCoord3dv",
    "MultiTexCoord3dvARB",
    "MultiTexCoord3f",
    "MultiTexCoord3fARB",
    "MultiTexCoord3fv",
    "MultiTexCoord3fvARB",
    "MultiTexCoord3i",
    "MultiTexCoord3iARB",
    "MultiTexCoord3iv",
    "MultiTexCoord3ivARB",
    "MultiTexCoord3s",
    "MultiTexCoord3sARB",
    "MultiTexCoord3sv",
    "MultiTexCoord3svARB",
    "MultiTexCoord4d",
    "MultiTexCoord4dARB",
    "MultiTexCoord4dv",
    "MultiTexCoord4dvARB",
    "MultiTexCoord4f",
    "MultiTexCoord4fARB",
    "MultiTexCoord4fv",
    "MultiTexCoord4fvARB",
    "MultiTexCoord4i",
    "MultiTexCoord4iARB",
    "MultiTexCoord4iv",
    "MultiTexCoord4ivARB",
    "MultiTexCoord4s",
    "MultiTexCoord4sARB",
    "MultiTexCoord4sv",
    "MultiTexCoord4svARB",
    "MultiTexCoord4x",
    "MultiTexCoordP1ui",
    "MultiTexCoordP1uiv",
    "MultiTexCoordP2ui",
    "MultiTexCoordP2uiv",
    "MultiTexCoordP3ui",
    "MultiTexCoordP3uiv",
    "MultiTexCoordP4ui",
    "MultiTexCoordP4uiv",
    "MultMatrixd",
    "MultMatrixf",
    "MultMatrixx",
    "MultTransposeMatrixd",
    "MultTransposeMatrixdARB",
    "MultTransposeMatrixf",
    "MultTransposeMatrixfARB",
    "NewList",
    "Normal3b",
    "Normal3bv",
    "Normal3d",
    "Normal3dv",
    "Normal3f",
    "Normal3fv",
    "Normal3i",
    "Normal3iv",
    "Normal3s",
    "Normal3sv",
    "Normal3x",
    "NormalP3ui",
    "NormalP3uiv",
    "NormalPointer",
    "NormalPointerEXT",
    "ObjectLabel",
    "ObjectPtrLabel",
    "Ortho",
    "Orthof",
    "Orthox",
    "PassThrough",
    "PatchParameteri",
    "PauseTransformFeedback",
    "PixelMapfv",
    "PixelMapuiv",
    "PixelMapusv",
    "PixelStoref",
    "PixelStorei",
    "PixelTransferf",
    "PixelTransferi",
    "PixelZoom",
    "PointParameterf",
    "PointParameterfARB",
    "PointParameterfEXT",
    "PointParameterfv",
    "PointParameterfvARB",
    "PointParameterfvEXT",
    "PointParameteri",
    "PointParameteriv",
    "PointParameterx",
    "PointParameterxv",
    "PointSize",
    "PointSizePointerOES",
    "PointSizex",
    "PolygonMode",
    "PolygonOffset",
    "PolygonOffsetx",
    "PolygonStipple",
    "PopAttrib",
    "PopClientAttrib",
    "PopDebugGroup",
    "PopMatrix",
    "PopName",
    "PrimitiveBoundingBox",
    "PrimitiveRestartIndex",
    "PrimitiveRestartIndexNV",
    "PrimitiveRestartNV",
    "PrioritizeTextures",
    "PrioritizeTexturesEXT",
    "ProgramBinary",
    "ProgramEnvParameter4dARB",
    "ProgramEnvParameter4dvARB",
    "ProgramEnvParameter4fARB",
    "ProgramEnvParameter4fvARB",
    "ProgramLocalParameter4dARB",
    "ProgramLocalParameter4dvARB",
    "ProgramLocalParameter4fARB",
    "ProgramLocalParameter4fvARB",
    "ProgramParameteri",
    "ProgramParameteriARB",
    "ProgramStringARB",
    "ProgramUniform1f",
    "ProgramUniform1fv",
    "ProgramUniform1i",
    "ProgramUniform1iv",
    "ProgramUniform1ui",
    "ProgramUniform1uiv",
    "ProgramUniform2f",
    "ProgramUniform2fv",
    "ProgramUniform2i",
    "ProgramUniform2iv",
    "ProgramUniform2ui",
    "ProgramUniform2uiv",
    "ProgramUniform3f",
    "ProgramUniform3fv",
    "ProgramUniform3i",
    "ProgramUniform3iv",
    "ProgramUniform3ui",
    "ProgramUniform3uiv",
    "ProgramUniform4f",
    "ProgramUniform4fv",
    "ProgramUniform4i",
    "ProgramUniform4iv",
    "ProgramUniform4ui",
    "ProgramUniform4uiv",
    "ProgramUniformMatrix2fv",
    "ProgramUniformMatrix2x3fv",
    "ProgramUniformMatrix2x4fv",
    "ProgramUniformMatrix3fv",
    "ProgramUniformMatrix3x2fv",
    "ProgramUniformMatrix3x4fv",
    "ProgramUniformMatrix4fv",
    "ProgramUniformMatrix4x2fv",
    "ProgramUniformMatrix4x3fv",
    "ProvokingVertex",
    "ProvokingVertexEXT",
    "PushAttrib",
    "PushClientAttrib",
    "PushDebugGroup",
    "PushMatrix",
    "PushName",
    "RasterPos2d",
    "RasterPos2dv",
    "RasterPos2f",
    "RasterPos2fv",
    "RasterPos2i",
    "RasterPos2iv",
    "RasterPos2s",
    "RasterPos2sv",
    "RasterPos3d",
    "RasterPos3dv",
    "RasterPos3f",
    "RasterPos3fv",
    "RasterPos3i",
    "RasterPos3iv",
    "RasterPos3s",
    "RasterPos3sv",
    "RasterPos4d",
    "RasterPos4dv",
    "RasterPos4f",
    "RasterPos4fv",
    "RasterPos4i",
    "RasterPos4iv",
    "RasterPos4s",
    "RasterPos4sv",
    "ReadBuffer",
    "ReadnPixels",
    "ReadnPixelsARB",
    "ReadPixels",
    "Rectd",
    "Rectdv",
    "Rectf",
    "Rectfv",
    "Recti",
    "Rectiv",
    "Rects",
    "Rectsv",
    "ReleaseShaderCompiler",
    "RenderbufferStorage",
    "RenderbufferStorageEXT",
    "RenderbufferStorageMultisample",
    "RenderbufferStorageMultisampleEXT",
    "RenderMode",
    "ResetHistogram",
    "ResetMinmax",
    "ResumeTransformFeedback",
    "Rotated",
    "Rotatef",
    "Rotatex",
    "SampleCoverage",
    "SampleCoverageARB",
    "SampleCoveragex",
    "SampleMaski",
    "SamplerParameterf",
    "SamplerParameterfv",
    "SamplerParameteri",
    "SamplerParameterIiv",
    "SamplerParameterIuiv",
    "SamplerParameteriv",
    "Scaled",
    "Scalef",
    "Scalex",
    "Scissor",
    "ScissorArrayv",
    "ScissorIndexed",
    "ScissorIndexedv",
    "SecondaryColor3b",
    "SecondaryColor3bEXT",
    "SecondaryColor3bv",
    "SecondaryColor3bvEXT",
    "SecondaryColor3d",
    "SecondaryColor3dEXT",
    "SecondaryColor3dv",
    "SecondaryColor3dvEXT",
    "SecondaryColor3f",
    "SecondaryColor3fEXT",
    "SecondaryColor3fv",
    "SecondaryColor3fvEXT",
    "SecondaryColor3i",
    "SecondaryColor3iEXT",
    "SecondaryColor3iv",
    "SecondaryColor3ivEXT",
    "SecondaryColor3s",
    "SecondaryColor3sEXT",
    "SecondaryColor3sv",
    "SecondaryColor3svEXT",
    "SecondaryColor3ub",
    "SecondaryColor3ubEXT",
    "SecondaryColor3ubv",
    "SecondaryColor3ubvEXT",
    "SecondaryColor3ui",
    "SecondaryColor3uiEXT",
    "SecondaryColor3uiv",
    "SecondaryColor3uivEXT",
    "SecondaryColor3us",
    "SecondaryColor3usEXT",
    "SecondaryColor3usv",
    "SecondaryColor3usvEXT",
    "SecondaryColorP3ui",
    "SecondaryColorP3uiv",
    "SecondaryColorPointer",
    "SecondaryColorPointerEXT",
    "SelectBuffer",
    "SeparableFilter2D",
    "ShadeModel",
    "ShaderBinary",
    "ShaderSource",
    "ShaderSourceARB",
    "StencilFunc",
    "StencilFuncSeparate",
    "StencilMask",
    "StencilMaskSeparate",
    "StencilOp",
    "StencilOpSeparate",
    "TexBuffer",
    "TexBufferARB",
    "TexBufferRange",
    "TexCoord1d",
    "TexCoord1dv",
    "TexCoord1f",
    "TexCoord1fv",
    "TexCoord1i",
    "TexCoord1iv",
    "TexCoord1s",
    "TexCoord1sv",
    "TexCoord2d",
    "TexCoord2dv",
    "TexCoord2f",
    "TexCoord2fv",
    "TexCoord2i",
    "TexCoord2iv",
    "TexCoord2s",
    "TexCoord2sv",
    "TexCoord3d",
    "TexCoord3dv",
    "TexCoord3f",
    "TexCoord3fv",
    "TexCoord3i",
    "TexCoord3iv",
    "TexCoord3s",
    "TexCoord3sv",
    "TexCoord4d",
    "TexCoord4dv",
    "TexCoord4f",
    "TexCoord4fv",
    "TexCoord4i",
    "TexCoord4iv",
    "TexCoord4s",
    "TexCoord4sv",
    "TexCoordP1ui",
    "TexCoordP1uiv",
    "TexCoordP2ui",
    "TexCoordP2uiv",
    "TexCoordP3ui",
    "TexCoordP3uiv",
    "TexCoordP4ui",
    "TexCoordP4uiv",
    "TexCoordPointer",
    "TexCoordPointerEXT",
    "TexEnvf",
    "TexEnvfv",
    "TexEnvi",
    "TexEnviv",
    "TexEnvx",
    "TexEnvxv",
    "TexGend",
    "TexGendv",
    "TexGenf",
    "TexGenfv",
    "TexGeni",
    "TexGeniv",
    "TexImage1D",
    "TexImage2D",
    "TexImage2DMultisample",
    "TexImage3D",
    "TexImage3DEXT",
    "TexImage3DMultisample",
    "TexParameterf",
    "TexParameterfv",
    "TexParameteri",
    "TexParameterIiv",
    "TexParameterIivEXT",
    "TexParameterIuiv",
    "TexParameterIuivEXT",
    "TexParameteriv",
    "TexParameterx",
    "TexParameterxv",
    "TexStorage1D",
    "TexStorage2D",
    "TexStorage2DMultisample",
    "TexStorage3D",
    "TexStorage3DMultisample",
    "TexSubImage1D",
    "TexSubImage2D",
    "TexSubImage3D",
    "TexSubImage3DEXT",
    "TextureBarrierNV",
    "TextureStorage1DEXT",
    "TextureStorage2DEXT",
    "TextureStorage3DEXT",
    "TextureView",
    "TransformFeedbackVaryings",
    "Translated",
    "Translatef",
    "Translatex",
    "Uniform1f",
    "Uniform1fARB",
    "Uniform1fv",
    "Uniform1fvARB",
    "Uniform1i",
    "Uniform1iARB",
    "Uniform1iv",
    "Uniform1ivARB",
    "Uniform1ui",
    "Uniform1uiEXT",
    "Uniform1uiv",
    "Uniform1uivEXT",
    "Uniform2f",
    "Uniform2fARB",
    "Uniform2fv",
    "Uniform2fvARB",
    "Uniform2i",
    "Uniform2iARB",
    "Uniform2iv",
    "Uniform2ivARB",
    "Uniform2ui",
    "Uniform2uiEXT",
    "Uniform2uiv",
    "Uniform2uivEXT",
    "Uniform3f",
    "Uniform3fARB",
    "Uniform3fv",
    "Uniform3fvARB",
    "Uniform3i",
    "Uniform3iARB",
    "Uniform3iv",
    "Uniform3ivARB",
    "Uniform3ui",
    "Uniform3uiEXT",
    "Uniform3uiv",
    "Uniform3uivEXT",
    "Uniform4f",
    "Uniform4fARB",
    "Uniform4fv",
    "Uniform4fvARB",
    "Uniform4i",
    "Uniform4iARB",
    "Uniform4iv",
    "Uniform4ivARB",
    "Uniform4ui",
    "Uniform4uiEXT",
    "Uniform4uiv",
    "Uniform4uivEXT",
    "UniformBlockBinding",
    "UniformMatrix2fv",
    "UniformMatrix2fvARB",
    "UniformMatrix2x3fv",
    "UniformMatrix2x4fv",
    "UniformMatrix3fv",
    "UniformMatrix3fvARB",
    "UniformMatrix3x2fv",
    "UniformMatrix3x4fv",
    "UniformMatrix4fv",
    "UniformMatrix4fvARB",
    "UniformMatrix4x2fv",
    "UniformMatrix4x3fv",
    "UnlockArraysEXT",
    "UnmapBuffer",
    "UnmapBufferARB",
    "UseProgram",
    "UseProgramObjectARB",
    "UseProgramStages",
    "ValidateProgram",
    "ValidateProgramARB",
    "ValidateProgramPipeline",
    "Vertex2d",
    "Vertex2dv",
    "Vertex2f",
    "Vertex2fv",
    "Vertex2i",
    "Vertex2iv",
    "Vertex2s",
    "Vertex2sv",
    "Vertex3d",
    "Vertex3dv",
    "Vertex3f",
    "Vertex3fv",
    "Vertex3i",
    "Vertex3iv",
    "Vertex3s",
    "Vertex3sv",
    "Vertex4d",
    "Vertex4dv",
    "Vertex4f",
    "Vertex4fv",
    "Vertex4i",
    "Vertex4iv",
    "Vertex4s",
    "Vertex4sv",
    "VertexAttrib1d",
    "VertexAttrib1dARB",
    "VertexAttrib1dv",
    "VertexAttrib1dvARB",
    "VertexAttrib1f",
    "VertexAttrib1fARB",
    "VertexAttrib1fv",
    "VertexAttrib1fvARB",
    "VertexAttrib1s",
    "VertexAttrib1sARB",
    "VertexAttrib1sv",
    "VertexAttrib1svARB",
    "VertexAttrib2d",
    "VertexAttrib2dARB",
    "VertexAttrib2dv",
    "VertexAttrib2dvARB",
    "VertexAttrib2f",
    "VertexAttrib2fARB",
    "VertexAttrib2fv",
    "VertexAttrib2fvARB",
    "VertexAttrib2s",
    "VertexAttrib2sARB",
    "VertexAttrib2sv",
    "VertexAttrib2svARB",
    "VertexAttrib3d",
    "VertexAttrib3dARB",
    "VertexAttrib3dv",
    "VertexAttrib3dvARB",
    "VertexAttrib3f",
    "VertexAttrib3fARB",
    "VertexAttrib3fv",
    "VertexAttrib3fvARB",
    "VertexAttrib3s",
    "VertexAttrib3sARB",
    "VertexAttrib3sv",
    "VertexAttrib3svARB",
    "VertexAttrib4bv",
    "VertexAttrib4bvARB",
    "VertexAttrib4d",
    "VertexAttrib4dARB",
    "VertexAttrib4dv",
    "VertexAttrib4dvARB",
    "VertexAttrib4f",
    "VertexAttrib4fARB",
    "VertexAttrib4fv",
    "VertexAttrib4fvARB",
    "VertexAttrib4iv",
    "VertexAttrib4ivARB",
    "VertexAttrib4Nbv",
    "VertexAttrib4NbvARB",
    "VertexAttrib4Niv",
    "VertexAttrib4NivARB",
    "VertexAttrib4Nsv",
    "VertexAttrib4NsvARB",
    "VertexAttrib4Nub",
    "VertexAttrib4NubARB",
    "VertexAttrib4Nubv",
    "VertexAttrib4NubvARB",
    "VertexAttrib4Nuiv",
    "VertexAttrib4NuivARB",
    "VertexAttrib4Nusv",
    "VertexAttrib4NusvARB",
    "VertexAttrib4s",
    "VertexAttrib4sARB",
    "VertexAttrib4sv",
    "VertexAttrib4svARB",
    "VertexAttrib4ubv",
    "VertexAttrib4ubvARB",
    "VertexAttrib4uiv",
    "VertexAttrib4uivARB",
    "VertexAttrib4usv",
    "VertexAttrib4usvARB",
    "VertexAttribBinding",
    "VertexAttribDivisor",
    "VertexAttribDivisorARB",
    "VertexAttribFormat",
    "VertexAttribI1i",
    "VertexAttribI1iEXT",
    "VertexAttribI1iv",
    "VertexAttribI1ivEXT",
    "VertexAttribI1ui",
    "VertexAttribI1uiEXT",
    "VertexAttribI1uiv",
    "VertexAttribI1uivEXT",
    "VertexAttribI2i",
    "VertexAttribI2iEXT",
    "VertexAttribI2iv",
    "VertexAttribI2ivEXT",
    "VertexAttribI2ui",
    "VertexAttribI2uiEXT",
    "VertexAttribI2uiv",
    "VertexAttribI2uivEXT",
    "VertexAttribI3i",
    "VertexAttribI3iEXT",
    "VertexAttribI3iv",
    "VertexAttribI3ivEXT",
    "VertexAttribI3ui",
    "VertexAttribI3uiEXT",
    "VertexAttribI3uiv",
    "VertexAttribI3uivEXT",
    "VertexAttribI4bv",
    "VertexAttribI4bvEXT",
    "VertexAttribI4i",
    "VertexAttribI4iEXT",
    "VertexAttribI4iv",
    "VertexAttribI4ivEXT",
    "VertexAttribI4sv",
    "VertexAttribI4svEXT",
    "VertexAttribI4ubv",
    "VertexAttribI4ubvEXT",
    "VertexAttribI4ui",
    "VertexAttribI4uiEXT",
    "VertexAttribI4uiv",
    "VertexAttribI4uivEXT",
    "VertexAttribI4usv",
    "VertexAttribI4usvEXT",
    "VertexAttribIFormat",
    "VertexAttribIPointer",
    "VertexAttribIPointerEXT",
    "VertexAttribLFormat",
    "VertexAttribP1ui",
    "VertexAttribP1uiv",
    "VertexAttribP2ui",
    "VertexAttribP2uiv",
    "VertexAttribP3ui",
    "VertexAttribP3uiv",
    "VertexAttribP4ui",
    "VertexAttribP4uiv",
    "VertexAttribPointer",
    "VertexAttribPointerARB",
    "VertexBindingDivisor",
    "VertexP2ui",
    "VertexP2uiv",
    "VertexP3ui",
    "VertexP3uiv",
    "VertexP4ui",
    "VertexP4uiv",
    "VertexPointer",
    "VertexPointerEXT",
    "Viewport",
    "ViewportArrayv",
    "ViewportIndexedf",
    "ViewportIndexedfv",
    "WaitSync",
    "WindowPos2d",
    "WindowPos2dARB",
    "WindowPos2dv",
    "WindowPos2dvARB",
    "WindowPos2f",
    "WindowPos2fARB",
    "WindowPos2fv",
    "WindowPos2fvARB",
    "WindowPos2i",
    "WindowPos2iARB",
    "WindowPos2iv",
    "WindowPos2ivARB",
    "WindowPos2s",
    "WindowPos2sARB",
    "WindowPos2sv",
    "WindowPos2svARB",
    "WindowPos3d",
    "WindowPos3dARB",
    "WindowPos3dv",
    "WindowPos3dvARB",
    "WindowPos3f",
    "WindowPos3fARB",
    "WindowPos3fv",
    "WindowPos3fvARB",
    "WindowPos3i",
    "WindowPos3iARB",
    "WindowPos3iv",
    "WindowPos3ivARB",
    "WindowPos3s",
    "WindowPos3sARB",
    "WindowPos3sv",
    "WindowPos3svARB",
]

"""Functions that need dispatch slots but are not used

Some of these functions may have GLX protocol support (for
indirect-rendering).  Other were used in previous versions of Mesa.  They keep
slots in the dispatch table so that newer versions of libGL can still be used
with older drivers."""
unused_functions = [
    # SGIS_multisample
    "SampleMaskSGIS",
    "SamplePatternSGIS",

    # NV_vertex_program
    "AreProgramsResidentNV",
    "ExecuteProgramNV",
    "GetProgramParameterdvNV",
    "GetProgramParameterfvNV",
    "GetProgramivNV",
    "GetProgramStringNV",
    "GetTrackMatrixivNV",
    "GetVertexAttribdvNV",
    "GetVertexAttribfvNV",
    "GetVertexAttribivNV",
    "LoadProgramNV",
    "ProgramParameters4dvNV",
    "ProgramParameters4fvNV",
    "RequestResidentProgramsNV",
    "TrackMatrixNV",
    "VertexAttribPointerNV",

    # MESA_resize_buffers
    "ResizeBuffersMESA",

    # ATI_envmap_bumpmap
    "TexBumpParameterfvATI",
    "TexBumpParameterivATI",
    "GetTexBumpParameterfvATI",
    "GetTexBumpParameterivATI",

    # NV_fragment_program
    "ProgramNamedParameter4fNV",
    "ProgramNamedParameter4dNV",
    "ProgramNamedParameter4fvNV",
    "ProgramNamedParameter4dvNV",
    "GetProgramNamedParameterfvNV",
    "GetProgramNamedParameterdvNV",

    # APPLE_flush_buffer_range
    "BufferParameteriAPPLE",
    "FlushMappedBufferRangeAPPLE",

    # EXT_separate_shader_objects
    "UseShaderProgramEXT",
    "ActiveProgramEXT",
    "CreateShaderProgramEXT",
]
