typedef const unsigned short table_t[1024];

static const int prime_factor = 89, prime_step = 281;

static const struct value_desc values[] = {
    { 0,  },
    { GL_ALPHA_BITS, BUFFER_INT(Visual.alphaBits), extra_new_buffers },
    { GL_BLEND, CONTEXT_BIT0(Color.BlendEnabled), NO_EXTRA },
    { GL_BLEND_SRC, CONTEXT_ENUM(Color.Blend[0].SrcRGB), NO_EXTRA },
    { GL_BLUE_BITS, BUFFER_INT(Visual.blueBits), extra_new_buffers },
    { GL_COLOR_CLEAR_VALUE, LOC_CUSTOM, TYPE_FLOATN_4, 0, extra_new_frag_clamp },
    { GL_COLOR_WRITEMASK, LOC_CUSTOM, TYPE_INT_4, 0, NO_EXTRA },
    { GL_CULL_FACE, CONTEXT_BOOL(Polygon.CullFlag), NO_EXTRA },
    { GL_CULL_FACE_MODE, CONTEXT_ENUM(Polygon.CullFaceMode), NO_EXTRA },
    { GL_DEPTH_BITS, BUFFER_INT(Visual.depthBits), extra_new_buffers },
    { GL_DEPTH_CLEAR_VALUE, CONTEXT_FIELD(Depth.Clear, TYPE_DOUBLEN), NO_EXTRA },
    { GL_DEPTH_FUNC, CONTEXT_ENUM(Depth.Func), NO_EXTRA },
    { GL_DEPTH_RANGE, LOC_CUSTOM, TYPE_DOUBLEN_2, 0, NO_EXTRA },
    { GL_DEPTH_TEST, CONTEXT_BOOL(Depth.Test), NO_EXTRA },
    { GL_DEPTH_WRITEMASK, CONTEXT_BOOL(Depth.Mask), NO_EXTRA },
    { GL_DITHER, CONTEXT_BOOL(Color.DitherFlag), NO_EXTRA },
    { GL_FRONT_FACE, CONTEXT_ENUM(Polygon.FrontFace), NO_EXTRA },
    { GL_GREEN_BITS, BUFFER_INT(Visual.greenBits), extra_new_buffers },
    { GL_LINE_WIDTH, CONTEXT_FLOAT(Line.Width), NO_EXTRA },
    { GL_ALIASED_LINE_WIDTH_RANGE, CONTEXT_FLOAT2(Const.MinLineWidth), NO_EXTRA },
    { GL_MAX_ELEMENTS_VERTICES, CONTEXT_INT(Const.MaxArrayLockSize), NO_EXTRA },
    { GL_MAX_ELEMENTS_INDICES, CONTEXT_INT(Const.MaxArrayLockSize), NO_EXTRA },
    { GL_MAX_TEXTURE_SIZE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.MaxTextureLevels), NO_EXTRA },
    { GL_MAX_VIEWPORT_DIMS, CONTEXT_INT2(Const.MaxViewportWidth), NO_EXTRA },
    { GL_PACK_ALIGNMENT, CONTEXT_INT(Pack.Alignment), NO_EXTRA },
    { GL_ALIASED_POINT_SIZE_RANGE, CONTEXT_FLOAT2(Const.MinPointSize), NO_EXTRA },
    { GL_POLYGON_OFFSET_FACTOR, CONTEXT_FLOAT(Polygon.OffsetFactor ), NO_EXTRA },
    { GL_POLYGON_OFFSET_UNITS, CONTEXT_FLOAT(Polygon.OffsetUnits ), NO_EXTRA },
    { GL_POLYGON_OFFSET_FILL, CONTEXT_BOOL(Polygon.OffsetFill), NO_EXTRA },
    { GL_RED_BITS, BUFFER_INT(Visual.redBits), extra_new_buffers },
    { GL_SCISSOR_BOX, LOC_CUSTOM, TYPE_INT_4, 0, NO_EXTRA },
    { GL_SCISSOR_TEST, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_BITS, BUFFER_INT(Visual.stencilBits), extra_new_buffers },
    { GL_STENCIL_CLEAR_VALUE, CONTEXT_INT(Stencil.Clear), NO_EXTRA },
    { GL_STENCIL_FAIL, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_FUNC, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_PASS_DEPTH_FAIL, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_PASS_DEPTH_PASS, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_REF, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_TEST, CONTEXT_BOOL(Stencil.Enabled), NO_EXTRA },
    { GL_STENCIL_VALUE_MASK, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_WRITEMASK, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_SUBPIXEL_BITS, CONTEXT_INT(Const.SubPixelBits), NO_EXTRA },
    { GL_TEXTURE_BINDING_2D, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_INDEX, NO_EXTRA },
    { GL_UNPACK_ALIGNMENT, CONTEXT_INT(Unpack.Alignment), NO_EXTRA },
    { GL_VIEWPORT, LOC_CUSTOM, TYPE_FLOAT_4, 0, NO_EXTRA },
    { GL_ACTIVE_TEXTURE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_TEXTURE_BINDING_CUBE_MAP_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_CUBE_INDEX, extra_ARB_texture_cube_map },
    { GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.MaxCubeTextureLevels), extra_ARB_texture_cube_map },
    { GL_BLEND_SRC_RGB, CONTEXT_ENUM(Color.Blend[0].SrcRGB), NO_EXTRA },
    { GL_BLEND_DST_RGB, CONTEXT_ENUM(Color.Blend[0].DstRGB), NO_EXTRA },
    { GL_BLEND_SRC_ALPHA, CONTEXT_ENUM(Color.Blend[0].SrcA), NO_EXTRA },
    { GL_BLEND_DST_ALPHA, CONTEXT_ENUM(Color.Blend[0].DstA), NO_EXTRA },
    { GL_BLEND_EQUATION, CONTEXT_ENUM(Color.Blend[0].EquationRGB), NO_EXTRA },
    { GL_BLEND_EQUATION_ALPHA_EXT, CONTEXT_ENUM(Color.Blend[0].EquationA), NO_EXTRA },
    { GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COMPRESSED_TEXTURE_FORMATS, LOC_CUSTOM, TYPE_INT_N, 0, NO_EXTRA },
    { GL_SAMPLE_ALPHA_TO_COVERAGE_ARB, CONTEXT_BOOL(Multisample.SampleAlphaToCoverage), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_ARB, CONTEXT_BOOL(Multisample.SampleCoverage), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_VALUE_ARB, CONTEXT_FLOAT(Multisample.SampleCoverageValue), NO_EXTRA },
    { GL_SAMPLE_COVERAGE_INVERT_ARB, CONTEXT_BOOL(Multisample.SampleCoverageInvert), NO_EXTRA },
    { GL_SAMPLE_BUFFERS_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_SAMPLES_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_SAMPLE_SHADING_ARB, CONTEXT_BOOL(Multisample.SampleShading), extra_gl40_ARB_sample_shading },
    { GL_MIN_SAMPLE_SHADING_VALUE_ARB, CONTEXT_FLOAT(Multisample.MinSampleShadingValue), extra_gl40_ARB_sample_shading },
    { GL_GENERATE_MIPMAP_HINT_SGIS, CONTEXT_ENUM(Hint.GenerateMipmap), NO_EXTRA },
    { GL_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_CLAMP_VERTEX_COLOR, CONTEXT_ENUM(Light.ClampVertexColor), extra_ARB_color_buffer_float },
    { GL_CLAMP_FRAGMENT_COLOR, CONTEXT_ENUM(Color.ClampFragmentColor), extra_ARB_color_buffer_float },
    { GL_CLAMP_READ_COLOR, CONTEXT_ENUM(Color.ClampReadColor), extra_ARB_color_buffer_float_or_glcore },
    { GL_COPY_READ_BUFFER, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COPY_WRITE_BUFFER, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_IMPLEMENTATION_COLOR_READ_TYPE_OES, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES, LOC_CUSTOM, TYPE_INT, 0, extra_new_buffers },
    { GL_FRAMEBUFFER_BINDING_EXT, BUFFER_INT(Name), NO_EXTRA },
    { GL_RENDERBUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_RENDERBUFFER_SIZE_EXT, CONTEXT_INT(Const.MaxRenderbufferSize), NO_EXTRA },
    { GL_MAX_CLIP_PLANES, CONTEXT_INT(Const.MaxClipPlanes), NO_EXTRA },
    { GL_VERTEX_ARRAY_BINDING_APPLE, ARRAY_INT(Name), NO_EXTRA },
    { GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, CONTEXT_FLOAT(Const.MaxTextureMaxAnisotropy), extra_EXT_texture_filter_anisotropic },
    { GL_DEBUG_OUTPUT, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_DEBUG_OUTPUT_SYNCHRONOUS, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_DEBUG_LOGGED_MESSAGES, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_DEBUG_LOGGED_MESSAGES, CONST(MAX_DEBUG_LOGGED_MESSAGES), NO_EXTRA },
    { GL_MAX_DEBUG_MESSAGE_LENGTH, CONST(MAX_DEBUG_MESSAGE_LENGTH), NO_EXTRA },
    { GL_MAX_LABEL_LENGTH, CONST(MAX_LABEL_LENGTH), NO_EXTRA },
    { GL_MAX_DEBUG_GROUP_STACK_DEPTH, CONST(MAX_DEBUG_GROUP_STACK_DEPTH), NO_EXTRA },
    { GL_DEBUG_GROUP_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_POLYGON_OFFSET_CLAMP_EXT, CONTEXT_FLOAT(Polygon.OffsetClamp), extra_EXT_polygon_offset_clamp },
    { GL_MAX_LIGHTS, CONTEXT_INT(Const.MaxLights), NO_EXTRA },
    { GL_LIGHT0, CONTEXT_BOOL(Light.Light[0].Enabled), NO_EXTRA },
    { GL_LIGHT1, CONTEXT_BOOL(Light.Light[1].Enabled), NO_EXTRA },
    { GL_LIGHT2, CONTEXT_BOOL(Light.Light[2].Enabled), NO_EXTRA },
    { GL_LIGHT3, CONTEXT_BOOL(Light.Light[3].Enabled), NO_EXTRA },
    { GL_LIGHT4, CONTEXT_BOOL(Light.Light[4].Enabled), NO_EXTRA },
    { GL_LIGHT5, CONTEXT_BOOL(Light.Light[5].Enabled), NO_EXTRA },
    { GL_LIGHT6, CONTEXT_BOOL(Light.Light[6].Enabled), NO_EXTRA },
    { GL_LIGHT7, CONTEXT_BOOL(Light.Light[7].Enabled), NO_EXTRA },
    { GL_LIGHTING, CONTEXT_BOOL(Light.Enabled), NO_EXTRA },
    { GL_LIGHT_MODEL_AMBIENT, CONTEXT_FIELD(Light.Model.Ambient[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_LIGHT_MODEL_TWO_SIDE, CONTEXT_BOOL(Light.Model.TwoSide), NO_EXTRA },
    { GL_ALPHA_TEST, CONTEXT_BOOL(Color.AlphaEnabled), NO_EXTRA },
    { GL_ALPHA_TEST_FUNC, CONTEXT_ENUM(Color.AlphaFunc), NO_EXTRA },
    { GL_ALPHA_TEST_REF, LOC_CUSTOM, TYPE_FLOATN, 0, extra_new_frag_clamp },
    { GL_BLEND_DST, CONTEXT_ENUM(Color.Blend[0].DstRGB), NO_EXTRA },
    { GL_CLIP_DISTANCE0, CONTEXT_BIT0(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE1, CONTEXT_BIT1(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE2, CONTEXT_BIT2(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE3, CONTEXT_BIT3(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE4, CONTEXT_BIT4(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE5, CONTEXT_BIT5(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE6, CONTEXT_BIT6(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_CLIP_DISTANCE7, CONTEXT_BIT7(Transform.ClipPlanesEnabled), extra_valid_clip_distance },
    { GL_COLOR_MATERIAL, CONTEXT_BOOL(Light.ColorMaterialEnabled), NO_EXTRA },
    { GL_CURRENT_COLOR, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_COLOR0][0], TYPE_FLOATN_4), extra_flush_current },
    { GL_CURRENT_NORMAL, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_NORMAL][0], TYPE_FLOATN_3), extra_flush_current },
    { GL_CURRENT_TEXTURE_COORDS, LOC_CUSTOM, TYPE_FLOAT_4, 0, extra_flush_current_valid_texture_unit },
    { GL_POINT_DISTANCE_ATTENUATION, CONTEXT_FLOAT3(Point.Params[0]), NO_EXTRA },
    { GL_FOG, CONTEXT_BOOL(Fog.Enabled), NO_EXTRA },
    { GL_FOG_COLOR, LOC_CUSTOM, TYPE_FLOATN_4, 0, extra_new_frag_clamp },
    { GL_FOG_DENSITY, CONTEXT_FLOAT(Fog.Density), NO_EXTRA },
    { GL_FOG_END, CONTEXT_FLOAT(Fog.End), NO_EXTRA },
    { GL_FOG_HINT, CONTEXT_ENUM(Hint.Fog), NO_EXTRA },
    { GL_FOG_MODE, CONTEXT_ENUM(Fog.Mode), NO_EXTRA },
    { GL_FOG_START, CONTEXT_FLOAT(Fog.Start), NO_EXTRA },
    { GL_LINE_SMOOTH, CONTEXT_BOOL(Line.SmoothFlag), NO_EXTRA },
    { GL_LINE_SMOOTH_HINT, CONTEXT_ENUM(Hint.LineSmooth), NO_EXTRA },
    { GL_LINE_WIDTH_RANGE, CONTEXT_FLOAT2(Const.MinLineWidthAA), NO_EXTRA },
    { GL_COLOR_LOGIC_OP, CONTEXT_BOOL(Color.ColorLogicOpEnabled), NO_EXTRA },
    { GL_LOGIC_OP_MODE, CONTEXT_ENUM(Color.LogicOp), NO_EXTRA },
    { GL_MATRIX_MODE, CONTEXT_ENUM(Transform.MatrixMode), NO_EXTRA },
    { GL_MAX_MODELVIEW_STACK_DEPTH, CONST(MAX_MODELVIEW_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_PROJECTION_STACK_DEPTH, CONST(MAX_PROJECTION_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_TEXTURE_STACK_DEPTH, CONST(MAX_TEXTURE_STACK_DEPTH), NO_EXTRA },
    { GL_MODELVIEW_MATRIX, CONTEXT_MATRIX(ModelviewMatrixStack.Top), NO_EXTRA },
    { GL_MODELVIEW_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, ModelviewMatrixStack.Depth), NO_EXTRA },
    { GL_NORMALIZE, CONTEXT_BOOL(Transform.Normalize), NO_EXTRA },
    { GL_PACK_SKIP_IMAGES, CONTEXT_INT(Pack.SkipImages), NO_EXTRA },
    { GL_PERSPECTIVE_CORRECTION_HINT, CONTEXT_ENUM(Hint.PerspectiveCorrection), NO_EXTRA },
    { GL_POINT_SIZE, CONTEXT_FLOAT(Point.Size), NO_EXTRA },
    { GL_POINT_SIZE_RANGE, CONTEXT_FLOAT2(Const.MinPointSizeAA), NO_EXTRA },
    { GL_POINT_SMOOTH, CONTEXT_BOOL(Point.SmoothFlag), NO_EXTRA },
    { GL_POINT_SMOOTH_HINT, CONTEXT_ENUM(Hint.PointSmooth), NO_EXTRA },
    { GL_POINT_SIZE_MIN_EXT, CONTEXT_FLOAT(Point.MinSize), NO_EXTRA },
    { GL_POINT_SIZE_MAX_EXT, CONTEXT_FLOAT(Point.MaxSize), NO_EXTRA },
    { GL_POINT_FADE_THRESHOLD_SIZE_EXT, CONTEXT_FLOAT(Point.Threshold), NO_EXTRA },
    { GL_PROJECTION_MATRIX, CONTEXT_MATRIX(ProjectionMatrixStack.Top), NO_EXTRA },
    { GL_PROJECTION_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, ProjectionMatrixStack.Depth), NO_EXTRA },
    { GL_RESCALE_NORMAL, CONTEXT_BOOL(Transform.RescaleNormals), NO_EXTRA },
    { GL_SHADE_MODEL, CONTEXT_ENUM(Light.ShadeModel), NO_EXTRA },
    { GL_TEXTURE_2D, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_TEXTURE_MATRIX, LOC_CUSTOM, TYPE_MATRIX, 0, extra_valid_texture_unit },
    { GL_TEXTURE_STACK_DEPTH, LOC_CUSTOM, TYPE_INT, 0, extra_valid_texture_unit },
    { GL_VERTEX_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_POS].Enabled), NO_EXTRA },
    { GL_VERTEX_ARRAY_SIZE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_POS].Size), NO_EXTRA },
    { GL_VERTEX_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_POS].Type), NO_EXTRA },
    { GL_VERTEX_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_POS].Stride), NO_EXTRA },
    { GL_NORMAL_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_NORMAL].Enabled), NO_EXTRA },
    { GL_NORMAL_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_NORMAL].Type), NO_EXTRA },
    { GL_NORMAL_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_NORMAL].Stride), NO_EXTRA },
    { GL_COLOR_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_COLOR0].Enabled), NO_EXTRA },
    { GL_COLOR_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_COLOR_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_COLOR0].Type), NO_EXTRA },
    { GL_COLOR_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_COLOR0].Stride), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY, LOC_CUSTOM, TYPE_BOOLEAN, offsetof(struct gl_vertex_attrib_array, Enabled), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_attrib_array, Size), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_TYPE, LOC_CUSTOM, TYPE_ENUM, offsetof(struct gl_vertex_attrib_array, Type), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_STRIDE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_attrib_array, Stride), NO_EXTRA },
    { GL_MAX_TEXTURE_UNITS, CONTEXT_INT(Const.MaxTextureUnits), NO_EXTRA },
    { GL_CLIENT_ACTIVE_TEXTURE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_TEXTURE_CUBE_MAP_ARB, LOC_CUSTOM, TYPE_BOOLEAN, 0, NO_EXTRA },
    { GL_TEXTURE_GEN_STR_OES, LOC_TEXUNIT, TYPE_BIT_0, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_MULTISAMPLE_ARB, CONTEXT_BOOL(Multisample.Enabled), NO_EXTRA },
    { GL_SAMPLE_ALPHA_TO_ONE_ARB, CONTEXT_BOOL(Multisample.SampleAlphaToOne), NO_EXTRA },
    { GL_VERTEX_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_POS].BufferObj), NO_EXTRA },
    { GL_NORMAL_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_NORMAL].BufferObj), NO_EXTRA },
    { GL_COLOR_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_COLOR0].BufferObj), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_POINT_SPRITE_NV, CONTEXT_BOOL(Point.PointSprite), extra_NV_point_sprite_ARB_point_sprite },
    { GL_POINT_SIZE_ARRAY_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Enabled, TYPE_BOOLEAN), NO_EXTRA },
    { GL_POINT_SIZE_ARRAY_TYPE_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Type, TYPE_ENUM), NO_EXTRA },
    { GL_POINT_SIZE_ARRAY_STRIDE_OES, ARRAY_FIELD(VertexAttrib[VERT_ATTRIB_POINT_SIZE].Stride, TYPE_INT), NO_EXTRA },
    { GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MAX_TEXTURE_COORDS_ARB, CONTEXT_INT(Const.MaxTextureCoordUnits), extra_ARB_fragment_program },
    { GL_PACK_IMAGE_HEIGHT, CONTEXT_INT(Pack.ImageHeight), NO_EXTRA },
    { GL_PACK_ROW_LENGTH, CONTEXT_INT(Pack.RowLength), NO_EXTRA },
    { GL_PACK_SKIP_PIXELS, CONTEXT_INT(Pack.SkipPixels), NO_EXTRA },
    { GL_PACK_SKIP_ROWS, CONTEXT_INT(Pack.SkipRows), NO_EXTRA },
    { GL_UNPACK_ROW_LENGTH, CONTEXT_INT(Unpack.RowLength), NO_EXTRA },
    { GL_UNPACK_SKIP_PIXELS, CONTEXT_INT(Unpack.SkipPixels), NO_EXTRA },
    { GL_UNPACK_SKIP_ROWS, CONTEXT_INT(Unpack.SkipRows), NO_EXTRA },
    { GL_UNPACK_SKIP_IMAGES, CONTEXT_INT(Unpack.SkipImages), NO_EXTRA },
    { GL_UNPACK_IMAGE_HEIGHT, CONTEXT_INT(Unpack.ImageHeight), NO_EXTRA },
    { GL_MAX_DRAW_BUFFERS_ARB, CONTEXT_INT(Const.MaxDrawBuffers), NO_EXTRA },
    { GL_MAX_COLOR_ATTACHMENTS, CONTEXT_INT(Const.MaxColorAttachments), NO_EXTRA },
    { GL_DRAW_BUFFER0_ARB, BUFFER_ENUM(ColorDrawBuffer[0]), NO_EXTRA },
    { GL_DRAW_BUFFER1_ARB, BUFFER_ENUM(ColorDrawBuffer[1]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER2_ARB, BUFFER_ENUM(ColorDrawBuffer[2]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER3_ARB, BUFFER_ENUM(ColorDrawBuffer[3]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER4_ARB, BUFFER_ENUM(ColorDrawBuffer[4]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER5_ARB, BUFFER_ENUM(ColorDrawBuffer[5]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER6_ARB, BUFFER_ENUM(ColorDrawBuffer[6]), extra_valid_draw_buffer },
    { GL_DRAW_BUFFER7_ARB, BUFFER_ENUM(ColorDrawBuffer[7]), extra_valid_draw_buffer },
    { GL_BLEND_COLOR_EXT, LOC_CUSTOM, TYPE_FLOATN_4, 0, extra_new_frag_clamp },
    { GL_MAX_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxTextureImageUnits), extra_ARB_fragment_program },
    { GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxTextureImageUnits), extra_ARB_vertex_shader },
    { GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB, CONTEXT_INT(Const.MaxCombinedTextureImageUnits), extra_ARB_vertex_shader },
    { GL_CURRENT_PROGRAM, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_STENCIL_BACK_FUNC, CONTEXT_ENUM(Stencil.Function[1]), NO_EXTRA },
    { GL_STENCIL_BACK_VALUE_MASK, CONTEXT_INT(Stencil.ValueMask[1]), NO_EXTRA },
    { GL_STENCIL_BACK_WRITEMASK, CONTEXT_INT(Stencil.WriteMask[1]), NO_EXTRA },
    { GL_STENCIL_BACK_REF, LOC_CUSTOM, TYPE_INT, NO_OFFSET, NO_EXTRA },
    { GL_STENCIL_BACK_FAIL, CONTEXT_ENUM(Stencil.FailFunc[1]), NO_EXTRA },
    { GL_STENCIL_BACK_PASS_DEPTH_FAIL, CONTEXT_ENUM(Stencil.ZFailFunc[1]), NO_EXTRA },
    { GL_STENCIL_BACK_PASS_DEPTH_PASS, CONTEXT_ENUM(Stencil.ZPassFunc[1]), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIBS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAttribs), extra_ARB_vertex_program_api_es2 },
    { GL_TEXTURE_BINDING_3D, LOC_CUSTOM, TYPE_INT, TEXTURE_3D_INDEX, NO_EXTRA },
    { GL_MAX_3D_TEXTURE_SIZE, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_context, Const.Max3DTextureLevels), NO_EXTRA },
    { GL_FRAGMENT_SHADER_DERIVATIVE_HINT, CONTEXT_ENUM(Hint.FragmentShaderDerivative), extra_ARB_fragment_shader },
    { GL_READ_BUFFER, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, extra_NV_read_buffer_api_gl },
    { GL_SHADER_COMPILER, CONST(1), extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_VARYING_VECTORS, CONTEXT_INT(Const.MaxVarying), extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_VERTEX_UNIFORM_VECTORS, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_MAX_FRAGMENT_UNIFORM_VECTORS, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_NUM_SHADER_BINARY_FORMATS, CONST(0), extra_ARB_ES2_compatibility_api_es2 },
    { GL_SHADER_BINARY_FORMATS, LOC_CUSTOM, TYPE_INVALID, 0, extra_ARB_ES2_compatibility_api_es2 },
    { GL_NUM_PROGRAM_BINARY_FORMATS, CONST(0), NO_EXTRA },
    { GL_PROGRAM_BINARY_FORMATS, LOC_CUSTOM, TYPE_INVALID, 0, NO_EXTRA },
    { GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_QUERY_NAME_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_COUNTER_NAME_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL, CONST(MAX_PERFQUERY_COUNTER_DESC_LENGTH), extra_INTEL_performance_query },
    { GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL, CONST(PERFQUERY_HAVE_GPA_EXTENDED_COUNTERS), extra_INTEL_performance_query },
    { GL_CONTEXT_RELEASE_BEHAVIOR, CONTEXT_ENUM(Const.ContextReleaseBehavior), NO_EXTRA },
    { GL_MAX_DUAL_SOURCE_DRAW_BUFFERS, CONTEXT_INT(Const.MaxDualSourceDrawBuffers), extra_ARB_blend_func_extended },
    { GL_MAX_TEXTURE_LOD_BIAS_EXT, CONTEXT_FLOAT(Const.MaxTextureLodBias), NO_EXTRA },
    { GL_NUM_EXTENSIONS, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MAJOR_VERSION, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MINOR_VERSION, LOC_CUSTOM, TYPE_INT, 0, extra_gl30_es3 },
    { GL_MAX_VERTEX_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxOutputComponents), extra_gl32_es3 },
    { GL_MAX_FRAGMENT_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxInputComponents), extra_gl32_es3 },
    { GL_MAX_ELEMENT_INDEX, CONTEXT_INT64(Const.MaxElementIndex), extra_ARB_ES3_compatibility_api_es3 },
    { GL_PRIMITIVE_RESTART_FIXED_INDEX, CONTEXT_BOOL(Array.PrimitiveRestartFixedIndex), extra_ARB_ES3_compatibility_api_es3 },
    { GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxUniformComponents), extra_ARB_fragment_shader },
    { GL_MAX_SAMPLES, CONTEXT_INT(Const.MaxSamples), extra_ARB_framebuffer_object_EXT_framebuffer_multisample },
    { GL_SAMPLER_BINDING, LOC_CUSTOM, TYPE_INT, GL_SAMPLER_BINDING, NO_EXTRA },
    { GL_MAX_SERVER_WAIT_TIMEOUT, CONTEXT_INT64(Const.MaxServerWaitTimeout), extra_ARB_sync },
    { GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_TRANSFORM_FEEDBACK_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_transform_feedback2_api_es3 },
    { GL_MAX_VERTEX_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_FRAGMENT_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_UNIFORM_BLOCKS, CONTEXT_INT(Const.MaxCombinedUniformBlocks), extra_ARB_uniform_buffer_object },
    { GL_MAX_UNIFORM_BLOCK_SIZE, CONTEXT_INT(Const.MaxUniformBlockSize), extra_ARB_uniform_buffer_object },
    { GL_MAX_UNIFORM_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxUniformBufferBindings), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object },
    { GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object },
    { GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.UniformBufferOffsetAlignment), extra_ARB_uniform_buffer_object },
    { GL_UNIFORM_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_uniform_buffer_object },
    { GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxUniformComponents), extra_ARB_vertex_shader },
    { GL_MAX_VARYING_FLOATS_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_vertex_shader },
    { GL_READ_FRAMEBUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_MIN_PROGRAM_TEXEL_OFFSET, CONTEXT_INT(Const.MinProgramTexelOffset), extra_GLSL_130_es3 },
    { GL_MAX_PROGRAM_TEXEL_OFFSET, CONTEXT_INT(Const.MaxProgramTexelOffset), extra_GLSL_130_es3 },
    { GL_PIXEL_PACK_BUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_pixel_buffer_object },
    { GL_PIXEL_UNPACK_BUFFER_BINDING_EXT, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_pixel_buffer_object },
    { GL_TEXTURE_BINDING_2D_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_ARRAY_INDEX, extra_EXT_texture_array_es3 },
    { GL_MAX_ARRAY_TEXTURE_LAYERS_EXT, CONTEXT_INT(Const.MaxArrayTextureLayers), extra_EXT_texture_array_es3 },
    { GL_TRANSFORM_FEEDBACK_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_EXT_transform_feedback },
    { GL_RASTERIZER_DISCARD, CONTEXT_BOOL(RasterDiscard), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS, CONTEXT_INT(Const.MaxTransformFeedbackInterleavedComponents), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS, CONTEXT_INT(Const.MaxTransformFeedbackBuffers), extra_EXT_transform_feedback },
    { GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS, CONTEXT_INT(Const.MaxTransformFeedbackSeparateComponents), extra_EXT_transform_feedback },
    { GL_TEXTURE_BINDING_EXTERNAL_OES, LOC_CUSTOM, TYPE_INT, TEXTURE_EXTERNAL_INDEX, extra_OES_EGL_image_external },
    { GL_TEXTURE_EXTERNAL_OES, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_OES_EGL_image_external },
    { GL_MAX_IMAGE_UNITS, CONTEXT_INT(Const.MaxImageUnits), extra_ARB_shader_image_load_store },
    { GL_MAX_VERTEX_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxImageUniforms), extra_ARB_shader_image_load_store },
    { GL_MAX_FRAGMENT_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxImageUniforms), extra_ARB_shader_image_load_store },
    { GL_MAX_COMBINED_IMAGE_UNIFORMS, CONTEXT_INT(Const.MaxCombinedImageUniforms), extra_ARB_shader_image_load_store },
    { GL_ATOMIC_COUNTER_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_shader_atomic_counters },
    { GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxAtomicBufferBindings), extra_ARB_shader_atomic_counters },
    { GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE, CONTEXT_INT(Const.MaxAtomicBufferSize), extra_ARB_shader_atomic_counters },
    { GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAtomicBuffers), extra_ARB_shader_atomic_counters },
    { GL_MAX_VERTEX_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxAtomicCounters), extra_ARB_shader_atomic_counters },
    { GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxAtomicBuffers), extra_ARB_shader_atomic_counters },
    { GL_MAX_FRAGMENT_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxAtomicCounters), extra_ARB_shader_atomic_counters },
    { GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.MaxCombinedAtomicBuffers), extra_ARB_shader_atomic_counters },
    { GL_MAX_COMBINED_ATOMIC_COUNTERS, CONTEXT_INT(Const.MaxCombinedAtomicCounters), extra_ARB_shader_atomic_counters },
    { GL_TEXTURE_BINDING_2D_MULTISAMPLE, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_MULTISAMPLE_INDEX, extra_ARB_texture_multisample },
    { GL_MAX_COLOR_TEXTURE_SAMPLES, CONTEXT_INT(Const.MaxColorTextureSamples), extra_ARB_texture_multisample },
    { GL_MAX_DEPTH_TEXTURE_SAMPLES, CONTEXT_INT(Const.MaxDepthTextureSamples), extra_ARB_texture_multisample },
    { GL_MAX_INTEGER_SAMPLES, CONTEXT_INT(Const.MaxIntegerSamples), extra_ARB_texture_multisample },
    { GL_SAMPLE_MASK, CONTEXT_BOOL(Multisample.SampleMask), extra_ARB_texture_multisample },
    { GL_MAX_SAMPLE_MASK_WORDS, CONST(1), extra_ARB_texture_multisample },
    { GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_2D_MULTISAMPLE_ARRAY_INDEX, extra_ARB_texture_multisample },
    { GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET, CONTEXT_INT(Const.MinProgramTextureGatherOffset), extra_ARB_texture_gather },
    { GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET, CONTEXT_INT(Const.MaxProgramTextureGatherOffset), extra_ARB_texture_gather },
    { GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS, CONTEXT_INT(Const.MaxComputeWorkGroupInvocations), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxUniformBlocks), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxTextureImageUnits), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxAtomicBuffers), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxAtomicCounters), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_SHARED_MEMORY_SIZE, CONTEXT_INT(Const.MaxComputeSharedMemorySize), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxUniformComponents), extra_ARB_compute_shader_es31 },
    { GL_MAX_COMPUTE_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxImageUniforms), extra_ARB_compute_shader_es31 },
    { GL_DISPATCH_INDIRECT_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_compute_shader_es31 },
    { GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxCombinedUniformComponents), extra_ARB_compute_shader_es31 },
    { GL_MAX_FRAMEBUFFER_WIDTH, CONTEXT_INT(Const.MaxFramebufferWidth), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_HEIGHT, CONTEXT_INT(Const.MaxFramebufferHeight), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_SAMPLES, CONTEXT_INT(Const.MaxFramebufferSamples), extra_ARB_framebuffer_no_attachments },
    { GL_MAX_FRAMEBUFFER_LAYERS, CONTEXT_INT(Const.MaxFramebufferLayers), extra_ARB_framebuffer_no_attachments_and_geometry_shader },
    { GL_MAX_UNIFORM_LOCATIONS, CONTEXT_INT(Const.MaxUserAssignableUniformLocations), extra_ARB_explicit_uniform_location },
    { GL_PROGRAM_PIPELINE_BINDING, LOC_CUSTOM, TYPE_INT, GL_PROGRAM_PIPELINE_BINDING, NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET, CONTEXT_ENUM(Const.MaxVertexAttribRelativeOffset), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIB_BINDINGS, CONTEXT_ENUM(Const.MaxVertexAttribBindings), NO_EXTRA },
    { GL_MAX_VERTEX_ATTRIB_STRIDE, CONTEXT_ENUM(Const.MaxVertexAttribStride), NO_EXTRA },
    { GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_VERTEX].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_FRAGMENT].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_COMPUTE].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.MaxCombinedShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_SHADER_STORAGE_BLOCK_SIZE, CONTEXT_INT(Const.MaxShaderStorageBlockSize), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS, CONTEXT_INT(Const.MaxShaderStorageBufferBindings), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.ShaderStorageBufferOffsetAlignment), extra_ARB_shader_storage_buffer_object_es31 },
    { GL_SHADER_STORAGE_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_shader_storage_buffer_object_es31 },
    { GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES, CONTEXT_INT(Const.MaxCombinedShaderOutputResources), extra_ARB_shader_image_load_store_shader_storage_buffer_object_es31 },
    { GL_MIN_FRAGMENT_INTERPOLATION_OFFSET, CONTEXT_FLOAT(Const.MinFragmentInterpolationOffset), extra_ARB_gpu_shader5_or_OES_sample_variables },
    { GL_MAX_FRAGMENT_INTERPOLATION_OFFSET, CONTEXT_FLOAT(Const.MaxFragmentInterpolationOffset), extra_ARB_gpu_shader5_or_OES_sample_variables },
    { GL_FRAGMENT_INTERPOLATION_OFFSET_BITS, CONST(FRAGMENT_INTERPOLATION_OFFSET_BITS), extra_ARB_gpu_shader5_or_OES_sample_variables },
    { GL_DRAW_INDIRECT_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_draw_indirect },
    { GL_MAX_GEOMETRY_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxInputComponents), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxOutputComponents), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxTextureImageUnits), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_OUTPUT_VERTICES, CONTEXT_INT(Const.MaxGeometryOutputVertices), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.MaxGeometryTotalOutputComponents), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxUniformComponents), extra_version_32_OES_geometry_shader },
    { GL_MAX_GEOMETRY_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxImageUniforms), extra_ARB_shader_image_load_store_and_geometry_shader },
    { GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_geometry_shader  },
    { GL_MAX_GEOMETRY_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_geometry_shader },
    { GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object_and_geometry_shader },
    { GL_MAX_GEOMETRY_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxUniformBlocks), extra_ARB_uniform_buffer_object_and_geometry_shader },
    { GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_GEOMETRY].MaxCombinedUniformComponents), extra_ARB_uniform_buffer_object_and_geometry_shader },
    { GL_LAYER_PROVOKING_VERTEX, CONTEXT_ENUM(Light.ProvokingVertex), extra_ARB_viewport_array_or_oes_geometry_shader },
    { GL_MAX_GEOMETRY_SHADER_INVOCATIONS, CONST(MAX_GEOMETRY_SHADER_INVOCATIONS), extra_ARB_gpu_shader5_or_oes_geometry_shader },
    { GL_MAX_TEXTURE_BUFFER_SIZE_ARB, CONTEXT_INT(Const.MaxTextureBufferSize), extra_texture_buffer_object },
    { GL_TEXTURE_BINDING_BUFFER_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_BUFFER_INDEX, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_FORMAT_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_texture_buffer_object },
    { GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT, CONTEXT_INT(Const.TextureBufferOffsetAlignment), extra_ARB_texture_buffer_range },
    { GL_ACCUM_RED_BITS, BUFFER_INT(Visual.accumRedBits), NO_EXTRA },
    { GL_ACCUM_GREEN_BITS, BUFFER_INT(Visual.accumGreenBits), NO_EXTRA },
    { GL_ACCUM_BLUE_BITS, BUFFER_INT(Visual.accumBlueBits), NO_EXTRA },
    { GL_ACCUM_ALPHA_BITS, BUFFER_INT(Visual.accumAlphaBits), NO_EXTRA },
    { GL_ACCUM_CLEAR_VALUE, CONTEXT_FIELD(Accum.ClearColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_ALPHA_BIAS, CONTEXT_FLOAT(Pixel.AlphaBias), NO_EXTRA },
    { GL_ALPHA_SCALE, CONTEXT_FLOAT(Pixel.AlphaScale), NO_EXTRA },
    { GL_ATTRIB_STACK_DEPTH, CONTEXT_INT(AttribStackDepth), NO_EXTRA },
    { GL_AUTO_NORMAL, CONTEXT_BOOL(Eval.AutoNormal), NO_EXTRA },
    { GL_AUX_BUFFERS, BUFFER_INT(Visual.numAuxBuffers), NO_EXTRA },
    { GL_BLUE_BIAS, CONTEXT_FLOAT(Pixel.BlueBias), NO_EXTRA },
    { GL_BLUE_SCALE, CONTEXT_FLOAT(Pixel.BlueScale), NO_EXTRA },
    { GL_CLIP_DEPTH_MODE, CONTEXT_ENUM(Transform.ClipDepthMode), extra_ARB_clip_control },
    { GL_CLIP_ORIGIN, CONTEXT_ENUM(Transform.ClipOrigin), extra_ARB_clip_control },
    { GL_CLIENT_ATTRIB_STACK_DEPTH, CONTEXT_INT(ClientAttribStackDepth), NO_EXTRA },
    { GL_COLOR_MATERIAL_FACE, CONTEXT_ENUM(Light.ColorMaterialFace), NO_EXTRA },
    { GL_COLOR_MATERIAL_PARAMETER, CONTEXT_ENUM(Light.ColorMaterialMode), NO_EXTRA },
    { GL_CURRENT_INDEX, CONTEXT_FLOAT(Current.Attrib[VERT_ATTRIB_COLOR_INDEX][0]), extra_flush_current },
    { GL_CURRENT_RASTER_COLOR, CONTEXT_FIELD(Current.RasterColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_CURRENT_RASTER_DISTANCE, CONTEXT_FLOAT(Current.RasterDistance), NO_EXTRA },
    { GL_CURRENT_RASTER_INDEX, CONST(1), NO_EXTRA },
    { GL_CURRENT_RASTER_POSITION, CONTEXT_FLOAT4(Current.RasterPos[0]), NO_EXTRA },
    { GL_CURRENT_RASTER_SECONDARY_COLOR, CONTEXT_FIELD(Current.RasterSecondaryColor[0], TYPE_FLOATN_4), NO_EXTRA },
    { GL_CURRENT_RASTER_TEXTURE_COORDS, LOC_CUSTOM, TYPE_FLOAT_4, 0, extra_valid_texture_unit },
    { GL_CURRENT_RASTER_POSITION_VALID, CONTEXT_BOOL(Current.RasterPosValid), NO_EXTRA },
    { GL_DEPTH_BIAS, CONTEXT_FLOAT(Pixel.DepthBias), NO_EXTRA },
    { GL_DEPTH_SCALE, CONTEXT_FLOAT(Pixel.DepthScale), NO_EXTRA },
    { GL_DOUBLEBUFFER, BUFFER_INT(Visual.doubleBufferMode), NO_EXTRA },
    { GL_DRAW_BUFFER, BUFFER_ENUM(ColorDrawBuffer[0]), NO_EXTRA },
    { GL_EDGE_FLAG, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_flush_current },
    { GL_FEEDBACK_BUFFER_SIZE, CONTEXT_INT(Feedback.BufferSize), NO_EXTRA },
    { GL_FEEDBACK_BUFFER_TYPE, CONTEXT_ENUM(Feedback.Type), NO_EXTRA },
    { GL_FOG_INDEX, CONTEXT_FLOAT(Fog.Index), NO_EXTRA },
    { GL_GREEN_BIAS, CONTEXT_FLOAT(Pixel.GreenBias), NO_EXTRA },
    { GL_GREEN_SCALE, CONTEXT_FLOAT(Pixel.GreenScale), NO_EXTRA },
    { GL_INDEX_BITS, BUFFER_INT(Visual.indexBits), extra_new_buffers },
    { GL_INDEX_CLEAR_VALUE, CONTEXT_INT(Color.ClearIndex), NO_EXTRA },
    { GL_INDEX_MODE, CONST(0) , NO_EXTRA },
    { GL_INDEX_OFFSET, CONTEXT_INT(Pixel.IndexOffset), NO_EXTRA },
    { GL_INDEX_SHIFT, CONTEXT_INT(Pixel.IndexShift), NO_EXTRA },
    { GL_INDEX_WRITEMASK, CONTEXT_INT(Color.IndexMask), NO_EXTRA },
    { GL_LIGHT_MODEL_COLOR_CONTROL, CONTEXT_ENUM(Light.Model.ColorControl), NO_EXTRA },
    { GL_LIGHT_MODEL_LOCAL_VIEWER, CONTEXT_BOOL(Light.Model.LocalViewer), NO_EXTRA },
    { GL_LINE_STIPPLE, CONTEXT_BOOL(Line.StippleFlag), NO_EXTRA },
    { GL_LINE_STIPPLE_PATTERN, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_LINE_STIPPLE_REPEAT, CONTEXT_INT(Line.StippleFactor), NO_EXTRA },
    { GL_LINE_WIDTH_GRANULARITY, CONTEXT_FLOAT(Const.LineWidthGranularity), NO_EXTRA },
    { GL_LIST_BASE, CONTEXT_INT(List.ListBase), NO_EXTRA },
    { GL_LIST_INDEX, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_LIST_MODE, LOC_CUSTOM, TYPE_ENUM, 0, NO_EXTRA },
    { GL_INDEX_LOGIC_OP, CONTEXT_BOOL(Color.IndexLogicOpEnabled), NO_EXTRA },
    { GL_MAP1_COLOR_4, CONTEXT_BOOL(Eval.Map1Color4), NO_EXTRA },
    { GL_MAP1_GRID_DOMAIN, CONTEXT_FLOAT2(Eval.MapGrid1u1), NO_EXTRA },
    { GL_MAP1_GRID_SEGMENTS, CONTEXT_INT(Eval.MapGrid1un), NO_EXTRA },
    { GL_MAP1_INDEX, CONTEXT_BOOL(Eval.Map1Index), NO_EXTRA },
    { GL_MAP1_NORMAL, CONTEXT_BOOL(Eval.Map1Normal), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_1, CONTEXT_BOOL(Eval.Map1TextureCoord1), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_2, CONTEXT_BOOL(Eval.Map1TextureCoord2), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_3, CONTEXT_BOOL(Eval.Map1TextureCoord3), NO_EXTRA },
    { GL_MAP1_TEXTURE_COORD_4, CONTEXT_BOOL(Eval.Map1TextureCoord4), NO_EXTRA },
    { GL_MAP1_VERTEX_3, CONTEXT_BOOL(Eval.Map1Vertex3), NO_EXTRA },
    { GL_MAP1_VERTEX_4, CONTEXT_BOOL(Eval.Map1Vertex4), NO_EXTRA },
    { GL_MAP2_COLOR_4, CONTEXT_BOOL(Eval.Map2Color4), NO_EXTRA },
    { GL_MAP2_GRID_DOMAIN, LOC_CUSTOM, TYPE_FLOAT_4, 0, NO_EXTRA },
    { GL_MAP2_GRID_SEGMENTS, CONTEXT_INT2(Eval.MapGrid2un), NO_EXTRA },
    { GL_MAP2_INDEX, CONTEXT_BOOL(Eval.Map2Index), NO_EXTRA },
    { GL_MAP2_NORMAL, CONTEXT_BOOL(Eval.Map2Normal), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_1, CONTEXT_BOOL(Eval.Map2TextureCoord1), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_2, CONTEXT_BOOL(Eval.Map2TextureCoord2), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_3, CONTEXT_BOOL(Eval.Map2TextureCoord3), NO_EXTRA },
    { GL_MAP2_TEXTURE_COORD_4, CONTEXT_BOOL(Eval.Map2TextureCoord4), NO_EXTRA },
    { GL_MAP2_VERTEX_3, CONTEXT_BOOL(Eval.Map2Vertex3), NO_EXTRA },
    { GL_MAP2_VERTEX_4, CONTEXT_BOOL(Eval.Map2Vertex4), NO_EXTRA },
    { GL_MAP_COLOR, CONTEXT_BOOL(Pixel.MapColorFlag), NO_EXTRA },
    { GL_MAP_STENCIL, CONTEXT_BOOL(Pixel.MapStencilFlag), NO_EXTRA },
    { GL_MAX_ATTRIB_STACK_DEPTH, CONST(MAX_ATTRIB_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_CLIENT_ATTRIB_STACK_DEPTH, CONST(MAX_CLIENT_ATTRIB_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_EVAL_ORDER, CONST(MAX_EVAL_ORDER), NO_EXTRA },
    { GL_MAX_LIST_NESTING, CONST(MAX_LIST_NESTING), NO_EXTRA },
    { GL_MAX_NAME_STACK_DEPTH, CONST(MAX_NAME_STACK_DEPTH), NO_EXTRA },
    { GL_MAX_PIXEL_MAP_TABLE, CONST(MAX_PIXEL_MAP_TABLE), NO_EXTRA },
    { GL_NAME_STACK_DEPTH, CONTEXT_INT(Select.NameStackDepth), NO_EXTRA },
    { GL_PACK_LSB_FIRST, CONTEXT_BOOL(Pack.LsbFirst), NO_EXTRA },
    { GL_PACK_SWAP_BYTES, CONTEXT_BOOL(Pack.SwapBytes), NO_EXTRA },
    { GL_PACK_INVERT_MESA, CONTEXT_BOOL(Pack.Invert), NO_EXTRA },
    { GL_PIXEL_MAP_A_TO_A_SIZE, CONTEXT_INT(PixelMaps.AtoA.Size), NO_EXTRA },
    { GL_PIXEL_MAP_B_TO_B_SIZE, CONTEXT_INT(PixelMaps.BtoB.Size), NO_EXTRA },
    { GL_PIXEL_MAP_G_TO_G_SIZE, CONTEXT_INT(PixelMaps.GtoG.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_A_SIZE, CONTEXT_INT(PixelMaps.ItoA.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_B_SIZE, CONTEXT_INT(PixelMaps.ItoB.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_G_SIZE, CONTEXT_INT(PixelMaps.ItoG.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_I_SIZE, CONTEXT_INT(PixelMaps.ItoI.Size), NO_EXTRA },
    { GL_PIXEL_MAP_I_TO_R_SIZE, CONTEXT_INT(PixelMaps.ItoR.Size), NO_EXTRA },
    { GL_PIXEL_MAP_R_TO_R_SIZE, CONTEXT_INT(PixelMaps.RtoR.Size), NO_EXTRA },
    { GL_PIXEL_MAP_S_TO_S_SIZE, CONTEXT_INT(PixelMaps.StoS.Size), NO_EXTRA },
    { GL_POINT_SIZE_GRANULARITY, CONTEXT_FLOAT(Const.PointSizeGranularity), NO_EXTRA },
    { GL_POLYGON_MODE, CONTEXT_ENUM2(Polygon.FrontMode), NO_EXTRA },
    { GL_POLYGON_OFFSET_BIAS_EXT, CONTEXT_FLOAT(Polygon.OffsetUnits), NO_EXTRA },
    { GL_POLYGON_OFFSET_POINT, CONTEXT_BOOL(Polygon.OffsetPoint), NO_EXTRA },
    { GL_POLYGON_OFFSET_LINE, CONTEXT_BOOL(Polygon.OffsetLine), NO_EXTRA },
    { GL_POLYGON_SMOOTH, CONTEXT_BOOL(Polygon.SmoothFlag), NO_EXTRA },
    { GL_POLYGON_SMOOTH_HINT, CONTEXT_ENUM(Hint.PolygonSmooth), NO_EXTRA },
    { GL_POLYGON_STIPPLE, CONTEXT_BOOL(Polygon.StippleFlag), NO_EXTRA },
    { GL_RED_BIAS, CONTEXT_FLOAT(Pixel.RedBias), NO_EXTRA },
    { GL_RED_SCALE, CONTEXT_FLOAT(Pixel.RedScale), NO_EXTRA },
    { GL_RENDER_MODE, CONTEXT_ENUM(RenderMode), NO_EXTRA },
    { GL_RGBA_MODE, CONST(1), NO_EXTRA },
    { GL_SELECTION_BUFFER_SIZE, CONTEXT_INT(Select.BufferSize), NO_EXTRA },
    { GL_STEREO, BUFFER_INT(Visual.stereoMode), NO_EXTRA },
    { GL_TEXTURE_1D, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_TEXTURE_3D, LOC_CUSTOM, TYPE_BOOLEAN, NO_OFFSET, NO_EXTRA },
    { GL_TEXTURE_BINDING_1D, LOC_CUSTOM, TYPE_INT, TEXTURE_1D_INDEX, NO_EXTRA },
    { GL_TEXTURE_BINDING_1D_ARRAY, LOC_CUSTOM, TYPE_INT, TEXTURE_1D_ARRAY_INDEX, extra_EXT_texture_array },
    { GL_TEXTURE_GEN_S, LOC_TEXUNIT, TYPE_BIT_0, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_T, LOC_TEXUNIT, TYPE_BIT_1, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_R, LOC_TEXUNIT, TYPE_BIT_2, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_TEXTURE_GEN_Q, LOC_TEXUNIT, TYPE_BIT_3, offsetof(struct gl_texture_unit, TexGenEnabled), NO_EXTRA },
    { GL_UNPACK_LSB_FIRST, CONTEXT_BOOL(Unpack.LsbFirst), NO_EXTRA },
    { GL_UNPACK_SWAP_BYTES, CONTEXT_BOOL(Unpack.SwapBytes), NO_EXTRA },
    { GL_ZOOM_X, CONTEXT_FLOAT(Pixel.ZoomX), NO_EXTRA },
    { GL_ZOOM_Y, CONTEXT_FLOAT(Pixel.ZoomY), NO_EXTRA },
    { GL_VERTEX_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_NORMAL_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_COLOR_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_INDEX_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Enabled), NO_EXTRA },
    { GL_INDEX_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Type), NO_EXTRA },
    { GL_INDEX_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_COLOR_INDEX].Stride), NO_EXTRA },
    { GL_INDEX_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_TEXTURE_COORD_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_EDGEFLAG].Enabled), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_EDGEFLAG].Stride), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_COUNT_EXT, CONST(0), NO_EXTRA },
    { GL_TEXTURE_COMPRESSION_HINT_ARB, CONTEXT_INT(Hint.TextureCompression), NO_EXTRA },
    { GL_ARRAY_ELEMENT_LOCK_FIRST_EXT, CONTEXT_INT(Array.LockFirst), NO_EXTRA },
    { GL_ARRAY_ELEMENT_LOCK_COUNT_EXT, CONTEXT_INT(Array.LockCount), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_WIDTH, CONTEXT_INT(Unpack.CompressedBlockWidth), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_HEIGHT, CONTEXT_INT(Unpack.CompressedBlockHeight), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_DEPTH, CONTEXT_INT(Unpack.CompressedBlockDepth), NO_EXTRA },
    { GL_UNPACK_COMPRESSED_BLOCK_SIZE, CONTEXT_INT(Unpack.CompressedBlockSize), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_WIDTH, CONTEXT_INT(Pack.CompressedBlockWidth), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_HEIGHT, CONTEXT_INT(Pack.CompressedBlockHeight), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_DEPTH, CONTEXT_INT(Pack.CompressedBlockDepth), NO_EXTRA },
    { GL_PACK_COMPRESSED_BLOCK_SIZE, CONTEXT_INT(Pack.CompressedBlockSize), NO_EXTRA },
    { GL_TRANSPOSE_MODELVIEW_MATRIX_ARB, CONTEXT_MATRIX_T(ModelviewMatrixStack), NO_EXTRA },
    { GL_TRANSPOSE_PROJECTION_MATRIX_ARB, CONTEXT_MATRIX_T(ProjectionMatrixStack.Top), NO_EXTRA },
    { GL_TRANSPOSE_TEXTURE_MATRIX_ARB, CONTEXT_MATRIX_T(TextureMatrixStack), NO_EXTRA },
    { GL_COLOR_SUM, CONTEXT_BOOL(Fog.ColorSumEnabled), NO_EXTRA },
    { GL_CURRENT_SECONDARY_COLOR, CONTEXT_FIELD(Current.Attrib[VERT_ATTRIB_COLOR1][0], TYPE_FLOATN_4), extra_flush_current },
    { GL_SECONDARY_COLOR_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_COLOR1].Enabled), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_COLOR1].Type), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_COLOR1].Stride), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_SIZE, LOC_CUSTOM, TYPE_INT, 0, NO_EXTRA },
    { GL_CURRENT_FOG_COORDINATE, CONTEXT_FLOAT(Current.Attrib[VERT_ATTRIB_FOG][0]), extra_flush_current },
    { GL_FOG_COORDINATE_ARRAY, ARRAY_BOOL(VertexAttrib[VERT_ATTRIB_FOG].Enabled), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_TYPE, ARRAY_ENUM(VertexAttrib[VERT_ATTRIB_FOG].Type), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_STRIDE, ARRAY_INT(VertexAttrib[VERT_ATTRIB_FOG].Stride), NO_EXTRA },
    { GL_FOG_COORDINATE_SOURCE, CONTEXT_ENUM(Fog.FogCoordinateSource), NO_EXTRA },
    { GL_FOG_DISTANCE_MODE_NV, CONTEXT_ENUM(Fog.FogDistanceMode), extra_NV_fog_distance },
    { GL_RASTER_POSITION_UNCLIPPED_IBM, CONTEXT_BOOL(Transform.RasterPositionUnclipped), NO_EXTRA },
    { GL_POINT_SPRITE_R_MODE_NV, CONTEXT_ENUM(Point.SpriteRMode), extra_NV_point_sprite },
    { GL_POINT_SPRITE_COORD_ORIGIN, CONTEXT_ENUM(Point.SpriteOrigin), extra_NV_point_sprite_ARB_point_sprite },
    { GL_TEXTURE_RECTANGLE_NV, LOC_CUSTOM, TYPE_BOOLEAN, 0, extra_NV_texture_rectangle },
    { GL_TEXTURE_BINDING_RECTANGLE_NV, LOC_CUSTOM, TYPE_INT, TEXTURE_RECT_INDEX, extra_NV_texture_rectangle },
    { GL_MAX_RECTANGLE_TEXTURE_SIZE_NV, CONTEXT_INT(Const.MaxTextureRectSize), extra_NV_texture_rectangle },
    { GL_STENCIL_TEST_TWO_SIDE_EXT, CONTEXT_BOOL(Stencil.TestTwoSide), extra_EXT_stencil_two_side },
    { GL_ACTIVE_STENCIL_FACE_EXT, LOC_CUSTOM, TYPE_ENUM, NO_OFFSET, NO_EXTRA },
    { GL_MAX_SHININESS_NV, CONTEXT_FLOAT(Const.MaxShininess), NO_EXTRA },
    { GL_MAX_SPOT_EXPONENT_NV, CONTEXT_FLOAT(Const.MaxSpotExponent), NO_EXTRA },
    { GL_PRIMITIVE_RESTART_NV, CONTEXT_BOOL(Array.PrimitiveRestart), extra_NV_primitive_restart },
    { GL_PRIMITIVE_RESTART_INDEX_NV, CONTEXT_INT(Array.RestartIndex), extra_NV_primitive_restart },
    { GL_INDEX_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_COLOR_INDEX].BufferObj), NO_EXTRA },
    { GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_EDGEFLAG].BufferObj), NO_EXTRA },
    { GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_COLOR1].BufferObj), NO_EXTRA },
    { GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, offsetof(struct gl_vertex_array_object, VertexBinding[VERT_ATTRIB_FOG].BufferObj), NO_EXTRA },
    { GL_VERTEX_PROGRAM_ARB, CONTEXT_BOOL(VertexProgram.Enabled), extra_ARB_vertex_program },
    { GL_VERTEX_PROGRAM_POINT_SIZE_ARB, CONTEXT_BOOL(VertexProgram.PointSizeEnabled), extra_ARB_vertex_program },
    { GL_VERTEX_PROGRAM_TWO_SIDE_ARB, CONTEXT_BOOL(VertexProgram.TwoSideEnabled), extra_ARB_vertex_program },
    { GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB, CONTEXT_INT(Const.MaxProgramMatrixStackDepth), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_MAX_PROGRAM_MATRICES_ARB, CONTEXT_INT(Const.MaxProgramMatrices), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_CURRENT_MATRIX_STACK_DEPTH_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_CURRENT_MATRIX_ARB, LOC_CUSTOM, TYPE_MATRIX, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_TRANSPOSE_CURRENT_MATRIX_ARB, LOC_CUSTOM, TYPE_MATRIX_T, 0, extra_ARB_vertex_program_ARB_fragment_program },
    { GL_PROGRAM_ERROR_POSITION_ARB, CONTEXT_INT(Program.ErrorPos), extra_ARB_vertex_program_ARB_fragment_program },
    { GL_FRAGMENT_PROGRAM_ARB, CONTEXT_BOOL(FragmentProgram.Enabled), extra_ARB_fragment_program },
    { GL_RGBA_SIGNED_COMPONENTS_EXT, LOC_CUSTOM, TYPE_INT_4, 0, extra_EXT_packed_float },
    { GL_DEPTH_BOUNDS_TEST_EXT, CONTEXT_BOOL(Depth.BoundsTest), extra_EXT_depth_bounds_test },
    { GL_DEPTH_BOUNDS_EXT, CONTEXT_FLOAT2(Depth.BoundsMin), extra_EXT_depth_bounds_test },
    { GL_DEPTH_CLAMP, CONTEXT_BOOL(Transform.DepthClamp), extra_ARB_depth_clamp },
    { GL_FRAGMENT_SHADER_ATI, CONTEXT_BOOL(ATIFragmentShader.Enabled), extra_ATI_fragment_shader },
    { GL_NUM_FRAGMENT_REGISTERS_ATI, CONST(6), extra_ATI_fragment_shader },
    { GL_NUM_FRAGMENT_CONSTANTS_ATI, CONST(8), extra_ATI_fragment_shader },
    { GL_NUM_PASSES_ATI, CONST(2), extra_ATI_fragment_shader },
    { GL_NUM_INSTRUCTIONS_PER_PASS_ATI, CONST(8), extra_ATI_fragment_shader },
    { GL_NUM_INSTRUCTIONS_TOTAL_ATI, CONST(16), extra_ATI_fragment_shader },
    { GL_COLOR_ALPHA_PAIRING_ATI, CONST(GL_TRUE), extra_ATI_fragment_shader },
    { GL_NUM_LOOPBACK_COMPONENTS_ATI, CONST(3), extra_ATI_fragment_shader },
    { GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI, CONST(3), extra_ATI_fragment_shader },
    { GL_PROVOKING_VERTEX_EXT, CONTEXT_ENUM(Light.ProvokingVertex), extra_EXT_provoking_vertex },
    { GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT, CONTEXT_BOOL(Const.QuadsFollowProvokingVertexConvention), extra_EXT_provoking_vertex },
    { GL_TEXTURE_CUBE_MAP_SEAMLESS, CONTEXT_BOOL(Texture.CubeMapSeamless), extra_ARB_seamless_cube_map },
    { GL_RGBA_INTEGER_MODE_EXT, BUFFER_BOOL(_IntegerColor), extra_EXT_texture_integer_and_new_buffers },
    { GL_MAX_TRANSFORM_FEEDBACK_BUFFERS, CONTEXT_INT(Const.MaxTransformFeedbackBuffers), extra_ARB_transform_feedback3 },
    { GL_MAX_VERTEX_STREAMS, CONTEXT_INT(Const.MaxVertexStreams), extra_ARB_transform_feedback3_ARB_gpu_shader5 },
    { GL_RGBA_FLOAT_MODE_ARB, BUFFER_FIELD(Visual.floatMode, TYPE_BOOLEAN), extra_core_ARB_color_buffer_float_and_new_buffers },
    { GL_CONTEXT_FLAGS, CONTEXT_INT(Const.ContextFlags), extra_version_30 },
    { GL_FRAMEBUFFER_SRGB_EXT, CONTEXT_BOOL(Color.sRGBEnabled), extra_EXT_framebuffer_sRGB },
    { GL_FRAMEBUFFER_SRGB_CAPABLE_EXT, BUFFER_INT(Visual.sRGBCapable), extra_EXT_framebuffer_sRGB_and_new_buffers },
    { GL_PRIMITIVE_RESTART, CONTEXT_BOOL(Array.PrimitiveRestart), extra_version_31 },
    { GL_PRIMITIVE_RESTART_INDEX, CONTEXT_INT(Array.RestartIndex), extra_version_31 },
    { GL_CONTEXT_PROFILE_MASK, CONTEXT_INT(Const.ProfileMask), extra_version_32 },
    { GL_RESET_NOTIFICATION_STRATEGY_ARB, CONTEXT_ENUM(Const.ResetStrategy), NO_EXTRA },
    { GL_TIMESTAMP, LOC_CUSTOM, TYPE_INT64, 0, extra_ARB_timer_query },
    { GL_MIN_MAP_BUFFER_ALIGNMENT, CONTEXT_INT(Const.MinMapBufferAlignment), NO_EXTRA },
    { GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB, LOC_CUSTOM, TYPE_INT, TEXTURE_CUBE_ARRAY_INDEX, extra_ARB_texture_cube_map_array },
    { GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB, CONTEXT_INT(Const.MaxProgramTextureGatherComponents), extra_ARB_texture_gather },
    { GL_MAX_IMAGE_SAMPLES, CONTEXT_INT(Const.MaxImageSamples), extra_ARB_shader_image_load_store },
    { GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object },
    { GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxShaderStorageBlocks), extra_ARB_shader_storage_buffer_object },
    { GL_QUERY_BUFFER_BINDING, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_query_buffer_object },
    { GL_VBO_FREE_MEMORY_ATI, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, extra_ATI_meminfo },
    { GL_TEXTURE_FREE_MEMORY_ATI, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, extra_ATI_meminfo },
    { GL_RENDERBUFFER_FREE_MEMORY_ATI, LOC_CUSTOM, TYPE_INT_4, NO_OFFSET, extra_ATI_meminfo },
    { GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX, LOC_CUSTOM, TYPE_INT, NO_OFFSET, extra_NVX_gpu_memory_info },
    { GL_MAX_CULL_DISTANCES, CONTEXT_INT(Const.MaxClipPlanes), extra_ARB_cull_distance },
    { GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES, CONTEXT_INT(Const.MaxClipPlanes), extra_ARB_cull_distance },
    { GL_MAX_VIEWPORTS, CONTEXT_INT(Const.MaxViewports), extra_ARB_viewport_array },
    { GL_VIEWPORT_SUBPIXEL_BITS, CONTEXT_INT(Const.ViewportSubpixelBits), extra_ARB_viewport_array },
    { GL_VIEWPORT_BOUNDS_RANGE, CONTEXT_FLOAT2(Const.ViewportBounds), extra_ARB_viewport_array },
    { GL_VIEWPORT_INDEX_PROVOKING_VERTEX, CONTEXT_ENUM(Const.LayerAndVPIndexProvokingVertex), extra_ARB_viewport_array },
    { GL_PATCH_VERTICES, CONTEXT_INT(TessCtrlProgram.patch_vertices), extra_ARB_tessellation_shader },
    { GL_PATCH_DEFAULT_OUTER_LEVEL, CONTEXT_FLOAT4(TessCtrlProgram.patch_default_outer_level), extra_ARB_tessellation_shader },
    { GL_PATCH_DEFAULT_INNER_LEVEL, CONTEXT_FLOAT2(TessCtrlProgram.patch_default_inner_level), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_GEN_LEVEL, CONTEXT_INT(Const.MaxTessGenLevel), extra_ARB_tessellation_shader },
    { GL_MAX_PATCH_VERTICES, CONTEXT_INT(Const.MaxPatchVertices), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxTextureImageUnits), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxTextureImageUnits), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_PATCH_COMPONENTS, CONTEXT_INT(Const.MaxTessPatchComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS, CONTEXT_INT(Const.MaxTessControlTotalOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxOutputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxInputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxInputComponents), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxUniformBlocks), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxUniformBlocks), extra_ARB_tessellation_shader },
    { GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxCombinedUniformComponents), extra_ARB_tessellation_shader },
    { GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxCombinedUniformComponents), extra_ARB_tessellation_shader },
    { GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED, CONTEXT_BOOL(Const.PrimitiveRestartForPatches), extra_ARB_tessellation_shader },
    { GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxAtomicBuffers), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxAtomicCounters), extra_ARB_shader_atomic_counters_and_tessellation },
    { GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_CTRL].MaxImageUniforms), extra_ARB_shader_image_load_store_and_tessellation },
    { GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS, CONTEXT_INT(Const.Program[MESA_SHADER_TESS_EVAL].MaxImageUniforms), extra_ARB_shader_image_load_store_and_tessellation },
    { GL_MAX_SUBROUTINES, CONST(MAX_SUBROUTINES), extra_ARB_shader_subroutine },
    { GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS, CONST(MAX_SUBROUTINE_UNIFORM_LOCATIONS), extra_ARB_shader_subroutine },
    { GL_PARAMETER_BUFFER_BINDING_ARB, LOC_CUSTOM, TYPE_INT, 0, extra_ARB_indirect_parameters },
};

static table_t table_API_OPENGL = {
      92,  486,  424,    0,
     149,  209,    0,    0,
       0,  428,    0,  118,
       0,    0,    0,    0,
       0,    0,  303,  532,
     258,  237,    0,  565,
       0,    0,    0,  406,
       0,    0,    0,  429,
     538,    0,  190,  319,
       0,    0,  176,  161,
     461,  144,  150,    6,
       0,    0,    0,    0,
     306,    0,    0,  262,
     151,    0,  395,    0,
      64,  553,    0,    0,
       0,    0,  312,    0,
     529,    0,    0,  224,
       0,    0,  420,    0,
       0,  542,  352,   86,
     490,  453,  231,    0,
       0,  391,    0,  272,
     155,    0,    0,    0,
     245,   93,  487,    0,
       0,  154,    0,    0,
     120,  244,  397,    0,
     359,    0,  286,    0,
       0,    0,    0,  304,
     277,    0,  554,    0,
       0,    0,    0,    0,
     407,    0,    0,    0,
     134,    0,    0,  192,
     238,    0,    0,  177,
     273,   43,  128,    0,
     195,    0,    0,    0,
       0,  364,   73,    0,
       0,  365,    0,    0,
     143,  577,    0,    0,
     527,    0,  289,    0,
       0,  530,    0,    0,
     223,  509,    0,  421,
       0,    0,  543,  353,
      85,  491,  469,   80,
      20,    0,    0,  213,
     480,  159,  498,  572,
     387,  518,   94,    0,
     388,    0,  136,    0,
     531,  382,  260,  398,
       0,  370,    0,  288,
       0,    0,  514,    0,
     301,    0,    0,    0,
       0,  380,    0,    0,
       0,  408,    0,    0,
      42,  135,  240,    0,
     191,  322,    0,    0,
     178,  163,  218,  405,
     534,  197,    0,    0,
     106,    0,    0,   74,
       0,    0,  366,    0,
       0,  141,  578,    0,
     283,    0,  356,  295,
     551,  294,   82,  251,
       0,  225,    0,    0,
     422,    0,    0,  546,
       0,   83,  492,  470,
     233,   21,    0,    0,
     211,  481,  162,  372,
     573,  456,  519,   95,
       0,  454,  236,  148,
      39,    0,  122,  261,
       0,    0,  373,    0,
     282,  107,    0,  515,
       0,  302,    0,    0,
     524,    0,  381,    0,
       0,    0,  409,    0,
       0,  385,   23,  508,
       0,   44,  321,    0,
     441,  520,  164,  139,
     124,   54,  198,    0,
       0,    3,    0,    0,
       0,    0,    0,  115,
     446,    0,  142,  234,
       0,    0,    0,    0,
       0,  357,  313,   84,
       0,    0,    0,    0,
     402,  555,    0,    0,
     545,    0,    0,    0,
     384,  432,    0,  324,
     562,  212,    0,  474,
     463,  574,  377,  507,
      96,    0,    0,    0,
     153,   33,  419,  126,
     207,    0,    0,  371,
       0,  314,  108,    0,
       0,    0,  307,  537,
       0,    0,    0,    0,
       0,  368,    0,  410,
     358,  243,   29,  426,
       0,  548,  512,  196,
      50,  444,  179,  165,
     186,  505,    0,  199,
      30,    0,    2,    0,
       0,  320,    0,    0,
     434,  450,  217,  445,
       0,  316,    0,    0,
       0,    0,  528,    0,
       0,  252,    0,    0,
       0,  403,  556,    0,
       0,  544,    0,  516,
     427,  246,  187,  298,
       0,    0,   75,  269,
     166,  180,  575,  458,
     462,   97,    0,    0,
     103,   77,   35,    0,
     123,  208,   71,    0,
     374,    0,  315,  109,
       0,    0,    0,    0,
       0,    0,  510,  270,
     457,    0,    0,    0,
     411,    0,    0,   17,
       0,  241,  290,    0,
      46,   49,  442,  521,
     473,   25,    0,    0,
     200,   31,    0,    0,
       0,    0,  558,    0,
      12,    0,  452,    0,
     451,    0,    0,    0,
       0,  557,    0,    0,
       0,    0,  253,    0,
      27,    0,  413,  299,
       0,    0,    0,    0,
     517,   91,   68,  189,
       0,    0,    0,   76,
     535,  479,  465,  576,
       0,  267,   98,    0,
       0,  104,  561,   40,
       0,  125,    0,   72,
     127,  369,  541,    0,
     110,    0,    0,    0,
       0,  293,    0,  248,
     271,    0,    0,    0,
     412,    0,  210,  242,
       4,    0,  145,  291,
     513,  171,   52,  440,
     522,  475,   19,  503,
     455,  201,    0,  569,
       0,    0,  511,  564,
       0,   13,    0,  379,
       0,  308,    0,    0,
     285,    0,   55,    0,
       0,    0,    0,  255,
       0,  448,    0,  414,
     300,    0,    0,    0,
     173,    0,   78,   69,
     188,  265,  317,    0,
      61,  536,  156,  466,
       0,    0,    0,   99,
     131,    0,  105,    0,
      34,    0,  121,    0,
     276,   18,    0,    0,
     281,  111,    0,    0,
       0,    0,    0,  435,
     249,  478,    0,    0,
       0,  415,    0,  214,
       0,    1,    0,  146,
     292,    0,  170,   51,
     439,  174,  476,  460,
     496,    0,  202,    0,
     570,    0,    0,    0,
     132,    0,   14,    0,
       7,    0,  309,    0,
      87,  287,    0,   56,
       0,    0,  296,    0,
     254,  568,  449,    0,
       0,  305,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,  157,
       0,    0,   63,    0,
     526,  400,  383,    0,
       0,   36,    0,    0,
     100,  325,  129,    0,
       0,    0,  112,    0,
       0,  232,    0,    0,
       0,  250,    0,    0,
     459,    0,  416,    0,
     215,    0,    9,    0,
     147,  247,    0,  493,
       0,  438,   57,  477,
       0,  497,    0,  203,
     547,  571,    0,    0,
       0,  138,    0,   10,
     363,    8,  193,  311,
     116,    0,  284,    0,
       0,    0,    0,  297,
       0,  256,    0,    0,
       0,  502,    0,    0,
     401,    0,    0,    0,
     430,  355,    0,  266,
     566,    0,   59,  506,
     158,    0,    0,   28,
     386,   53,  130,  361,
     525,    0,   37,    0,
       0,  392,    0,  396,
       0,    0,    0,  113,
       0,    0,  433,    0,
       0,    0,    0,    0,
     227,  152,    0,  417,
       0,  216,  539,   32,
       0,  119,  389,    0,
     494,    0,  443,  175,
     167,  185,  501,  280,
     204,    0,  228,  559,
      15,    0,   45,  220,
      11,  362,   16,  194,
     310,  367,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   90,
       0,    0,  504,    0,
     483,  404,    0,    0,
       0,  425,  376,    0,
     468,  567,    0,   60,
      66,  471,    0,  549,
      26,  390,  563,  482,
     360,  263,    0,   38,
     354,    0,  102,    0,
     393,    0,    0,    0,
     114,    0,    0,    0,
      88,    0,    0,    0,
       0,  226,    0,    0,
     418,    0,  533,  540,
     350,    0,  488,  172,
     235,  495,  278,  437,
      58,  168,  206,  499,
     378,    0,    0,  229,
     485,  423,    0,  137,
       0,    0,  523,    0,
     399,    0,  117,    0,
       0,    0,    0,    0,
       0,  323,    0,  257,
     239,    0,    0,    0,
       0,  484,   65,    0,
       0,    0,  133,  375,
       0,  467,  318,  472,
       0,   67,  160,    0,
     140,  447,    5,    0,
       0,   70,  264,    0,
      41,    0,    0,  101,
       0,  394,    0,  552,
      81,    0,    0,    0,
       0,   89,  560,    0,
     259,    0,  222,  464,
       0,   79,  550,  205,
     431,  351,  268,  489,
      47,  230,    0,  279,
     436,    0,  169,  219,
     500,  221,    0,    0,
};

static table_t table_API_OPENGLES = {
      92,    0,    0,    0,
     149,    0,    0,    0,
       0,    0,    0,  118,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  275,    0,    0,
       0,    0,    0,    0,
       0,    0,  176,  161,
       0,  144,  150,    6,
       0,    0,    0,    0,
       0,    0,    0,    0,
     151,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   86,
       0,    0,    0,    0,
       0,    0,    0,    0,
     155,    0,    0,    0,
       0,   93,    0,    0,
       0,  154,    0,    0,
     120,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     134,    0,    0,    0,
       0,    0,    0,  177,
       0,   43,  128,    0,
       0,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
     143,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      85,    0,    0,   80,
      20,    0,    0,    0,
       0,  159,    0,    0,
       0,    0,   94,    0,
       0,    0,  136,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  274,
      42,  135,    0,    0,
       0,    0,    0,    0,
     178,  163,    0,    0,
       0,    0,    0,    0,
     106,    0,    0,   74,
       0,    0,    0,    0,
       0,  141,    0,    0,
       0,    0,    0,    0,
       0,    0,   82,    0,
       0,    0,    0,    0,
       0,    0,  182,    0,
       0,   83,    0,    0,
       0,   21,    0,    0,
       0,    0,  162,    0,
       0,    0,    0,   95,
       0,    0,    0,  148,
      39,    0,  122,    0,
       0,    0,    0,    0,
       0,  107,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,    0,
       0,   44,    0,    0,
       0,    0,  164,  139,
     124,   54,    0,    0,
       0,    3,    0,    0,
     181,    0,    0,  115,
       0,    0,  142,    0,
       0,    0,    0,    0,
       0,    0,    0,   84,
       0,    0,    0,    0,
       0,    0,    0,  183,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      96,    0,    0,    0,
     153,   33,    0,  126,
       0,    0,    0,    0,
       0,    0,  108,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   29,    0,
       0,    0,    0,    0,
      50,    0,  179,  165,
       0,    0,    0,    0,
      30,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   75,    0,
     166,  180,    0,    0,
       0,   97,    0,    0,
     103,   77,   35,    0,
     123,    0,   71,    0,
       0,    0,    0,  109,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,    0,    0,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
       0,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      27,    0,    0,    0,
       0,    0,    0,    0,
       0,   91,   68,    0,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,    0,   98,    0,
       0,  104,    0,   40,
       0,  125,    0,   72,
     127,    0,    0,    0,
     110,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       4,    0,  145,    0,
       0,  171,   52,    0,
       0,    0,   19,    0,
       0,    0,    0,    0,
       0,    0,    0,  184,
       0,   13,    0,    0,
       0,    0,    0,    0,
       0,    0,   55,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     173,    0,   78,   69,
       0,    0,    0,    0,
      61,    0,  156,    0,
       0,    0,    0,   99,
     131,    0,  105,    0,
      34,    0,  121,    0,
       0,   18,    0,    0,
       0,  111,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    1,    0,  146,
       0,    0,  170,   51,
       0,  174,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     132,    0,   14,    0,
       7,    0,    0,    0,
      87,    0,    0,   56,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,  157,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
     100,    0,  129,    0,
       0,    0,  112,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    9,    0,
     147,    0,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  138,    0,   10,
       0,    8,    0,    0,
     116,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   59,    0,
     158,    0,    0,   28,
       0,   53,  130,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,  113,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  152,    0,    0,
       0,    0,    0,   32,
       0,  119,    0,    0,
       0,    0,    0,  175,
     167,    0,    0,    0,
       0,    0,    0,    0,
      15,    0,   45,    0,
      11,    0,   16,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   90,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
       0,    0,    0,   38,
       0,    0,  102,    0,
       0,    0,    0,    0,
     114,    0,    0,    0,
      88,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  172,
       0,    0,    0,    0,
      58,  168,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  137,
       0,    0,    0,    0,
       0,    0,  117,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,  133,    0,
       0,    0,    0,    0,
       0,   67,  160,    0,
     140,    0,    5,    0,
       0,   70,    0,    0,
      41,    0,    0,  101,
       0,    0,    0,    0,
      81,    0,    0,    0,
       0,   89,    0,    0,
       0,    0,    0,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  236,    0,    0,
       0,    0,  169,    0,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES2 = {
     210,    0,    0,    0,
       0,  209,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  275,    0,    0,
       0,    0,  190,    0,
       0,    0,    0,    0,
       0,    0,    0,    6,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  224,
       0,    0,    0,    0,
       0,    0,    0,   86,
       0,    0,  231,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  214,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  192,
       0,    0,    0,    0,
       0,   43,    0,    0,
     195,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     223,    0,    0,    0,
       0,    0,    0,    0,
      85,    0,    0,   80,
      20,    0,    0,  213,
       0,    0,    0,    0,
       0,    0,  215,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  274,
      42,    0,    0,    0,
     191,    0,    0,    0,
       0,    0,  218,    0,
       0,  197,    0,    0,
       0,    0,    0,   74,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   82,    0,
       0,  225,    0,    0,
       0,    0,    0,    0,
       0,   83,    0,    0,
     233,   21,    0,    0,
     211,    0,    0,    0,
       0,    0,    0,  216,
       0,    0,    0,    0,
      39,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,    0,
       0,   44,    0,    0,
       0,    0,    0,    0,
       0,   54,  198,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  234,
       0,    0,    0,    0,
       0,    0,    0,   84,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  212,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   33,    0,    0,
     207,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   29,    0,
       0,    0,    0,  196,
      50,    0,    0,    0,
     186,    0,    0,  199,
      30,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,  217,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  187,    0,
       0,    0,   75,    0,
       0,    0,    0,    0,
       0,  205,    0,    0,
     232,   77,   35,    0,
       0,  208,   71,    0,
       0,    0,    0,  221,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,    0,    0,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
     200,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      27,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   68,  189,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   40,
       0,    0,    0,   72,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       4,    0,    0,    0,
       0,    0,   52,    0,
       0,    0,   19,    0,
       0,  201,    0,    0,
       0,    0,    0,    0,
       0,   13,    0,    0,
       0,    0,    0,    0,
       0,    0,   55,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   78,   69,
     188,    0,    0,    0,
      61,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      34,    0,    0,    0,
       0,   18,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    1,    0,    0,
       0,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,  202,    0,
       0,    0,    0,    0,
       0,    0,   14,    0,
       7,    0,    0,    0,
      87,    0,    0,   56,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,    0,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    9,    0,
       0,    0,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,  203,
       0,    0,    0,    0,
       0,    0,    0,   10,
       0,    8,  193,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   59,    0,
       0,    0,    0,   28,
       0,   53,    0,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     227,    0,    0,    0,
       0,    0,    0,   32,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  185,    0,    0,
     204,    0,  228,    0,
      15,    0,   45,  220,
      11,    0,   16,  194,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   90,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
       0,    0,    0,   38,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      88,    0,    0,    0,
       0,  226,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     235,    0,    0,    0,
      58,    0,  206,    0,
       0,    0,    0,  229,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   67,    0,    0,
       0,    0,    5,    0,
       0,   70,    0,    0,
      41,    0,    0,    0,
       0,    0,    0,    0,
      81,    0,    0,    0,
       0,   89,    0,    0,
       0,    0,  222,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  230,    0,    0,
       0,    0,    0,  219,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES3 = {
     210,    0,    0,    0,
       0,  209,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     258,  237,    0,    0,
       0,    0,    0,    0,
       0,  275,    0,    0,
       0,    0,  190,    0,
       0,    0,    0,    0,
       0,    0,    0,    6,
       0,    0,    0,    0,
       0,    0,    0,  262,
       0,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  224,
       0,    0,    0,    0,
       0,    0,    0,   86,
       0,    0,  231,    0,
       0,    0,    0,  272,
       0,    0,    0,    0,
     245,  214,    0,    0,
       0,    0,    0,    0,
       0,  244,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  192,
     238,    0,    0,    0,
     273,   43,    0,    0,
     195,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     223,    0,    0,    0,
       0,    0,    0,    0,
      85,    0,    0,   80,
      20,    0,    0,  213,
       0,    0,    0,    0,
       0,    0,  215,    0,
       0,    0,    0,    0,
       0,    0,  260,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  274,
      42,    0,  240,    0,
     191,    0,    0,    0,
       0,    0,  218,    0,
       0,  197,    0,    0,
       0,    0,    0,   74,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   82,  251,
       0,  225,    0,    0,
       0,    0,    0,    0,
       0,   83,    0,    0,
     233,   21,    0,    0,
     211,    0,    0,    0,
       0,    0,    0,  216,
       0,    0,  236,    0,
      39,    0,    0,  261,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,    0,
       0,   44,    0,    0,
       0,    0,    0,    0,
       0,   54,  198,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  234,
       0,    0,    0,    0,
       0,    0,    0,   84,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  212,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   33,    0,    0,
     207,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  243,   29,    0,
       0,    0,    0,  196,
      50,    0,    0,    0,
     186,    0,    0,  199,
      30,    0,    2,    0,
       0,    0,    0,    0,
       0,    0,  217,    0,
       0,    0,    0,    0,
       0,    0,    0,  326,
       0,  252,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  246,  187,    0,
       0,    0,   75,  269,
       0,    0,    0,    0,
       0,  205,    0,    0,
     232,   77,   35,    0,
       0,  208,   71,    0,
       0,    0,    0,  221,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,  241,    0,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
     200,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     327,    0,  253,    0,
      27,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   68,  189,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,  267,    0,    0,
       0,    0,    0,   40,
       0,    0,    0,   72,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  248,
       0,    0,    0,    0,
       0,    0,    0,  242,
       4,    0,    0,    0,
       0,    0,   52,    0,
       0,    0,   19,    0,
       0,  201,    0,    0,
       0,    0,    0,    0,
       0,   13,    0,    0,
       0,    0,    0,    0,
       0,    0,   55,    0,
       0,  328,    0,  255,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   78,   69,
     188,  265,    0,    0,
      61,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      34,    0,    0,    0,
       0,   18,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     249,    0,    0,    0,
       0,    0,    0,    0,
       0,    1,    0,    0,
       0,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,  202,    0,
       0,    0,    0,    0,
       0,    0,   14,    0,
       7,    0,    0,    0,
      87,    0,    0,   56,
       0,    0,    0,    0,
     254,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,    0,
       0,   62,    0,    0,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  268,    0,    0,
       0,  250,    0,    0,
       0,    0,    0,    0,
       0,    0,    9,    0,
       0,  247,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,  203,
       0,    0,    0,    0,
       0,    0,    0,   10,
       0,    8,  193,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  256,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  266,
       0,    0,   59,    0,
       0,    0,    0,   28,
       0,   53,    0,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     227,    0,    0,    0,
       0,    0,    0,   32,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  185,    0,    0,
     204,    0,  228,    0,
      15,    0,   45,  220,
      11,    0,   16,  194,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   90,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
       0,  263,    0,   38,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      88,    0,    0,    0,
       0,  226,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     235,    0,    0,    0,
      58,  270,  206,    0,
       0,    0,    0,  229,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  257,
     239,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   67,    0,    0,
       0,    0,    5,    0,
       0,   70,  264,    0,
      41,    0,    0,    0,
       0,    0,    0,    0,
      81,    0,    0,    0,
       0,   89,    0,    0,
     259,    0,  222,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  230,    0,    0,
       0,    0,  271,  219,
       0,    0,    0,    0,
};

static table_t table_API_OPENGLES31 = {
     210,    0,    0,    0,
       0,  209,    0,    0,
       0,    0,    0,    0,
     344,  338,    0,    0,
       0,    0,  303,    0,
     258,  237,    0,    0,
       0,    0,    0,    0,
       0,  275,    0,    0,
       0,    0,  190,  319,
       0,    0,    0,    0,
       0,    0,    0,    6,
       0,    0,    0,    0,
     306,    0,    0,  262,
       0,    0,    0,    0,
      64,    0,    0,    0,
       0,    0,  312,    0,
       0,    0,    0,  224,
       0,    0,    0,  349,
       0,    0,    0,   86,
       0,    0,  231,    0,
       0,    0,    0,  272,
       0,    0,    0,    0,
     245,  214,    0,    0,
       0,    0,    0,    0,
       0,  244,    0,    0,
       0,  345,  286,    0,
       0,    0,    0,  304,
     277,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  192,
     238,    0,    0,    0,
     273,   43,    0,    0,
     195,    0,    0,    0,
       0,    0,   73,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,  289,    0,
       0,    0,    0,    0,
     223,    0,    0,    0,
       0,    0,    0,    0,
      85,    0,    0,   80,
      20,    0,    0,  213,
       0,    0,    0,    0,
       0,    0,  215,    0,
       0,    0,    0,    0,
       0,    0,  260,    0,
       0,    0,    0,  288,
       0,    0,    0,    0,
     301,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  274,
      42,    0,  240,    0,
     191,  322,    0,    0,
       0,    0,  218,    0,
       0,  197,    0,    0,
       0,    0,    0,   74,
       0,    0,    0,    0,
       0,    0,    0,    0,
     283,    0,    0,  295,
       0,  294,   82,  251,
       0,  225,    0,    0,
       0,    0,    0,    0,
       0,   83,    0,    0,
     233,   21,    0,    0,
     211,    0,    0,    0,
       0,    0,    0,  216,
       0,    0,  236,    0,
      39,    0,    0,  261,
       0,    0,    0,    0,
     282,  280,    0,    0,
       0,  302,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,   23,  330,
       0,   44,  321,    0,
       0,    0,    0,    0,
       0,   54,  198,    0,
       0,    3,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  234,
       0,    0,    0,    0,
       0,    0,  313,   84,
     340,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  324,
       0,  212,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,   33,    0,    0,
     207,    0,    0,    0,
       0,  314,    0,    0,
       0,    0,  307,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  243,   29,    0,
     331,    0,    0,  196,
      50,    0,    0,    0,
     186,    0,    0,  199,
      30,    0,    2,    0,
       0,  320,    0,    0,
       0,    0,  217,    0,
       0,  316,    0,    0,
       0,    0,    0,  326,
       0,  252,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  246,  187,  298,
       0,    0,   75,  269,
       0,    0,    0,    0,
       0,  205,    0,    0,
     232,   77,   35,    0,
       0,  208,   71,    0,
       0,    0,  315,  221,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   17,
       0,  241,  290,    0,
      46,   49,    0,    0,
       0,   25,    0,    0,
     200,   31,    0,    0,
       0,    0,    0,    0,
      12,    0,    0,    0,
       0,    0,    0,  337,
       0,    0,    0,    0,
     327,    0,  253,    0,
      27,    0,    0,  299,
       0,    0,    0,    0,
       0,    0,   68,  189,
       0,    0,    0,   76,
       0,    0,    0,    0,
       0,  267,    0,    0,
       0,    0,    0,   40,
       0,    0,    0,   72,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,  293,    0,  248,
       0,    0,    0,    0,
       0,    0,    0,  242,
       4,    0,    0,  291,
       0,    0,   52,    0,
       0,    0,   19,    0,
       0,  201,    0,    0,
       0,    0,    0,    0,
       0,   13,    0,  329,
       0,  308,    0,    0,
     285,    0,   55,    0,
       0,  328,    0,  255,
       0,    0,    0,    0,
     300,    0,    0,    0,
       0,    0,   78,   69,
     188,  265,  317,    0,
      61,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      34,    0,    0,    0,
     276,   18,    0,    0,
     281,    0,    0,    0,
       0,    0,    0,    0,
     249,    0,    0,  335,
       0,    0,    0,    0,
       0,    1,    0,    0,
     292,    0,    0,   51,
       0,    0,    0,    0,
       0,    0,  202,    0,
       0,    0,    0,    0,
     323,    0,   14,    0,
       7,    0,  309,    0,
      87,  287,    0,   56,
       0,    0,  296,    0,
     254,    0,    0,    0,
       0,  305,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,  339,
       0,   62,    0,    0,
       0,    0,   63,    0,
       0,    0,    0,    0,
       0,   36,    0,    0,
       0,  325,    0,    0,
       0,    0,    0,    0,
       0,  268,    0,    0,
       0,  250,    0,    0,
     333,    0,    0,    0,
       0,    0,    9,    0,
       0,  247,    0,    0,
       0,    0,   57,    0,
       0,    0,    0,  203,
       0,    0,    0,    0,
       0,    0,    0,   10,
       0,    8,  193,  311,
       0,    0,  284,    0,
       0,    0,    0,  297,
       0,  256,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  266,
       0,    0,   59,    0,
       0,    0,    0,   28,
       0,   53,    0,    0,
       0,    0,   37,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     227,  334,    0,    0,
       0,    0,    0,   32,
       0,    0,    0,    0,
       0,  336,    0,    0,
       0,  185,    0,    0,
     204,    0,  228,    0,
      15,    0,   45,  220,
      11,    0,   16,  194,
     310,    0,  332,    0,
       0,    0,    0,    0,
       0,    0,  341,   90,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,   60,
      66,    0,    0,    0,
      26,    0,    0,    0,
     343,  263,    0,   38,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
      88,    0,    0,    0,
       0,  226,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,    0,
     235,    0,  278,    0,
      58,  270,  206,    0,
       0,  346,    0,  229,
       0,    0,    0,    0,
       0,    0,    0,    0,
       0,    0,    0,  348,
       0,    0,    0,    0,
       0,    0,    0,  257,
     239,    0,    0,    0,
       0,    0,   65,    0,
       0,    0,    0,  342,
       0,    0,  318,    0,
       0,   67,    0,    0,
       0,    0,    5,    0,
       0,   70,  264,    0,
      41,    0,    0,    0,
       0,    0,    0,    0,
      81,    0,    0,    0,
       0,   89,    0,    0,
     259,    0,  222,    0,
       0,   79,    0,    0,
       0,    0,    0,    0,
      47,  230,    0,  279,
       0,    0,  271,  219,
       0,    0,  347,    0,
};

static table_t table_API_OPENGL_CORE = {
      92,  486,  424,    0,
     149,  209,    0,    0,
       0,  428,    0,  118,
     344,  338,    0,    0,
       0,    0,  303,  532,
     258,  237,    0,  565,
       0,    0,    0,  406,
       0,    0,    0,  429,
     538,    0,  190,  319,
       0,    0,  176,  161,
     461,  144,  150,    6,
       0,    0,  580,    0,
     306,    0,    0,  262,
     151,    0,  395,    0,
      64,  553,    0,    0,
       0,  594,  312,    0,
     529,    0,    0,  224,
       0,    0,  420,  349,
       0,  542,  352,   86,
     490,  453,  231,    0,
       0,  391,  334,  272,
     155,    0,  590,    0,
     245,   93,  487,    0,
       0,  154,    0,    0,
     120,  244,  397,    0,
     359,  345,  286,    0,
       0,    0,    0,  304,
     277,    0,  554,    0,
       0,    0,    0,    0,
     407,    0,    0,    0,
     134,    0,    0,  192,
     238,    0,    0,  177,
     273,   43,  128,    0,
     195,    0,    0,  581,
       0,  364,   73,    0,
       0,  365,    0,    0,
     143,  577,    0,    0,
     527,  360,  289,    0,
       0,  530,    0,    0,
     223,  509,    0,  421,
       0,    0,  543,  353,
      85,  491,  469,   80,
      20,    0,    0,  213,
     480,  159,  498,  572,
     387,  518,   94,    0,
     388,    0,  136,    0,
     531,  382,  260,  398,
       0,  370,    0,  288,
       0,    0,  514,    0,
     301,    0,    0,  601,
       0,  380,    0,    0,
       0,  408,    0,    0,
      42,  135,  240,    0,
     191,  322,    0,    0,
     178,  163,  218,  405,
     534,  197,    0,    0,
     106,    0,    0,   74,
       0,    0,  366,    0,
       0,  141,  578,    0,
     283,    0,  356,  295,
     551,  294,   82,  251,
       0,  225,    0,    0,
     422,    0,    0,  546,
       0,   83,  492,  470,
     233,   21,    0,    0,
     211,  481,  162,  372,
     573,  456,  519,   95,
       0,  454,  236,  148,
      39,    0,  122,  261,
       0,    0,  373,    0,
     282,  107,    0,  515,
       0,  302,    0,    0,
     524,    0,  381,    0,
       0,    0,  409,    0,
       0,  385,   23,  330,
       0,   44,  321,    0,
     441,  520,  164,  139,
     124,   54,  198,    0,
       0,    3,    0,    0,
       0,    0,    0,  115,
     446,    0,  142,  234,
       0,  603,    0,    0,
       0,  357,  313,   84,
     340,    0,    0,  609,
     402,  555,    0,    0,
     545,    0,    0,    0,
     384,  432,    0,  324,
     562,  212,    0,  474,
     463,  574,  377,  507,
      96,    0,    0,    0,
     153,   33,  419,  126,
     207,    0,    0,  371,
       0,  314,  108,    0,
       0,  587,  307,  537,
       0,  602,    0,    0,
       0,  368,    0,  410,
     358,  243,   29,  426,
     331,  548,  512,  196,
      50,  444,  179,  165,
     186,  505,    0,  199,
      30,    0,    2,    0,
     597,  320,    0,    0,
     434,  450,  217,  445,
       0,  316,  605,    0,
       0,  598,  528,  326,
       0,  252,    0,    0,
     610,  403,  556,    0,
       0,  544,    0,  516,
     427,  246,  187,  298,
       0,    0,   75,  269,
     166,  180,  575,  458,
     462,   97,    0,    0,
     103,   77,   35,    0,
     123,  208,   71,    0,
     374,    0,  315,  109,
       0,    0,  586,    0,
       0,    0,  510,  270,
     457,    0,    0,    0,
     411,    0,    0,   17,
       0,  241,  290,    0,
      46,   49,  442,  521,
     473,   25,    0,    0,
     200,   31,    0,  600,
       0,    0,  558,    0,
      12,    0,  452,    0,
     451,    0,    0,  337,
       0,  375,  599,  585,
     327,    0,  253,    0,
      27,    0,  413,  299,
       0,    0,    0,  579,
     517,   91,   68,  189,
       0,    0,    0,   76,
     535,  479,  465,  576,
       0,  267,   98,    0,
       0,  104,  561,   40,
       0,  125,    0,   72,
     127,  369,  541,    0,
     110,    0,    0,  588,
       0,  293,    0,  248,
     271,    0,    0,    0,
     412,    0,  210,  242,
       4,    0,  145,  291,
     513,  171,   52,  440,
     522,  475,   19,  503,
     455,  201,    0,  569,
     508,    0,  511,  564,
       0,   13,    0,  329,
       0,  308,    0,    0,
     285,    0,   55,    0,
     584,  328,    0,  255,
       0,  448,    0,  414,
     300,    0,    0,    0,
     173,    0,   78,   69,
     188,  265,  317,    0,
      61,  536,  156,  466,
       0,    0,    0,   99,
     131,    0,  105,    0,
      34,    0,  121,    0,
     276,   18,    0,    0,
     281,  111,    0,    0,
     589,    0,    0,  435,
     249,  478,    0,  335,
       0,  415,    0,  214,
       0,    1,    0,  146,
     292,    0,  170,   51,
     439,  174,  476,  460,
     496,    0,  202,    0,
     570,    0,    0,    0,
     132,    0,   14,    0,
       7,  596,  309,    0,
      87,  287,    0,   56,
       0,    0,  296,    0,
     254,  568,  449,    0,
       0,  305,    0,    0,
       0,    0,    0,   22,
      48,   24,    0,  339,
       0,   62,    0,  157,
       0,    0,   63,    0,
     526,  400,  383,    0,
       0,   36,    0,    0,
     100,  325,  129,    0,
       0,    0,  112,    0,
       0,  232,    0,    0,
       0,  250,    0,    0,
     333,  591,  416,    0,
     215,    0,    9,    0,
     147,  247,    0,  493,
     608,  438,   57,  477,
       0,  497,    0,  203,
     547,  571,    0,    0,
       0,  138,    0,   10,
     363,    8,  193,  311,
     116,    0,  284,    0,
       0,    0,    0,  297,
       0,  256,    0,    0,
       0,  502,    0,    0,
     401,    0,  557,    0,
     430,  355,    0,  266,
     566,    0,   59,  506,
     158,    0,    0,   28,
     386,   53,  130,  361,
     525,    0,   37,    0,
       0,  392,  611,  396,
       0,    0,    0,  113,
       0,    0,  433,    0,
       0,    0,    0,    0,
     227,  152,    0,  417,
       0,  216,  539,   32,
       0,  119,  389,    0,
     494,  336,  443,  175,
     167,  185,  501,  280,
     204,    0,  228,  559,
      15,    0,   45,  220,
      11,  362,   16,  194,
     310,  367,  332,  604,
       0,    0,    0,    0,
       0,    0,  341,   90,
     379,    0,  504,    0,
     483,  404,    0,  582,
       0,  425,  376,    0,
     468,  567,    0,   60,
      66,  471,    0,  549,
      26,  390,  563,  482,
     343,  263,    0,   38,
     354,    0,  102,    0,
     393,    0,    0,    0,
     114,    0,    0,  592,
      88,    0,    0,    0,
       0,  226,    0,    0,
     418,    0,  533,  540,
     350,    0,  488,  172,
     235,  495,  278,  437,
      58,  168,  206,  499,
     378,  346,    0,  229,
     485,  423,    0,  137,
     607,    0,  523,    0,
     399,    0,  117,  348,
     606,    0,    0,    0,
       0,  323,    0,  257,
     239,    0,    0,    0,
       0,  484,   65,    0,
       0,    0,  133,  342,
       0,  467,  318,  472,
       0,   67,  160,    0,
     140,  447,    5,    0,
     583,   70,  264,    0,
      41,    0,    0,  101,
       0,  394,    0,  552,
      81,  595,    0,    0,
     593,   89,  560,    0,
     259,    0,  222,  464,
       0,   79,  550,  205,
     431,  351,  268,  489,
      47,  230,    0,  279,
     436,  459,  169,  219,
     500,  221,  347,    0,
};

static table_t *table_set[] = {
   &table_API_OPENGL,
   &table_API_OPENGLES,
   &table_API_OPENGLES2,
   &table_API_OPENGL_CORE,
   &table_API_OPENGLES3,
   &table_API_OPENGLES31,
};

#define table(api) (*table_set[api])
