
template = """\
/*
 * Copyright (c) 2018 Valve Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 * This file was generated by aco_opcodes_cpp.py
 */

#include "aco_ir.h"

namespace aco {

<%
opcode_names = sorted(instructions.keys())
can_use_input_modifiers = "".join([instructions[name].input_mod for name in reversed(opcode_names)])
can_use_output_modifiers = "".join([instructions[name].output_mod for name in reversed(opcode_names)])
is_atomic = "".join([instructions[name].is_atomic for name in reversed(opcode_names)])
%>

extern const aco::Info instr_info = {
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx7},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx9},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx10},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx11},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].op.gfx12},
      % endfor
   },
   std::bitset<${len(opcode_names)}>("${can_use_input_modifiers}"),
   std::bitset<${len(opcode_names)}>("${can_use_output_modifiers}"),
   std::bitset<${len(opcode_names)}>("${is_atomic}"),
   {
      % for name in opcode_names:
      "${name}",
      % endfor
   },
   {
      % for name in opcode_names:
      aco::Format::${str(instructions[name].format.name)},
      % endfor
   },
   {
      % for name in opcode_names:
      ${instructions[name].operand_size},
      % endfor
   },
   {
      % for name in opcode_names:
      instr_class::${instructions[name].cls.value},
      % endfor
   },
   {
      % for name in opcode_names:
      ${hex(instructions[name].definitions)},
      % endfor
   },
   {
      % for name in opcode_names:
      ${hex(instructions[name].operands)},
      % endfor
   },
};

}
"""

from aco_opcodes import instructions
from mako.template import Template

print(Template(template).render(instructions=instructions))
