/*
 * Copyright 2023 Google LLC
 * SPDX-License-Identifier: MIT
 */

#include "amdgpu_devices.h"
#include "util/macros.h"

const struct amdgpu_device amdgpu_devices[] = {
   {
      .name = "renoir",
      .radeon_family = CHIP_RENOIR,
      .hw_ip_gfx = {
         .hw_ip_version_major = 9,
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x90300,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 9,
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0x90300,
      },
      .fw_gfx_me = {
         .ver = 166,
         .feature = 53,
      },
      .fw_gfx_pfp = {
         .ver = 194,
         .feature = 53,
      },
      .fw_gfx_mec = {
         .ver = 464,
         .feature = 53,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x26010042,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x15e7,
         .external_rev = 0xa1,
         .pci_rev = 0xe9,
         .family = AMDGPU_FAMILY_RV,
         .num_shader_engines = 1,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 100000,
         .max_engine_clock = 1800000,
         .max_memory_clock = 1333000,
         .cu_active_number = 7,
         .cu_ao_mask = 0xfe,
         .cu_bitmap[0][0] = 0xfe,
         .enabled_rb_pipes_mask = 0x3,
         .num_rb_pipes = 2,
         .num_hw_gfx_contexts = 8,
         .ids_flags = 0x5,
         .virtual_address_offset = 0x200000,
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 11,
         .vram_bit_width = 128,
         .gc_double_offchip_lds_buf = 1,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 8,
         .num_tcc_blocks = 4,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .cu_ao_bitmap[0][0] = 0xfe,
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(64) << 20,
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(64) << 20,
         },
         .gtt = {
            .total_heap_size = UINT64_C(4096) << 20,
         },
      },
   },
   {
      .name = "raven",
      .radeon_family = CHIP_RAVEN,
      .hw_ip_gfx = {
         .hw_ip_version_major = 9,
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 9,
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
      },
      .fw_gfx_me = {
         .ver = 162,
         .feature = 47,
      },
      .fw_gfx_pfp = {
         .ver = 185,
         .feature = 47,
      },
      .fw_gfx_mec = {
         .ver = 427,
         .feature = 47,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x24000042,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x15d8,
         .chip_rev = 0x01,
         .external_rev = 0x42,
         .pci_rev = 0xc1,
         .family = AMDGPU_FAMILY_RV,
         .num_shader_engines = 1,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 25000,
         .max_engine_clock = 1400000,
         .max_memory_clock = 1200000,
         .cu_active_number = 10,
         .cu_ao_mask = 0x3ff,
         .cu_bitmap[0][0] = 0x3ff,
         .enabled_rb_pipes_mask = 0x3,
         .num_rb_pipes = 2,
         .num_hw_gfx_contexts = 8,
         .ids_flags = 0x1,
         .virtual_address_offset = 0x200000,
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 8,
         .vram_bit_width = 128,
         .gc_double_offchip_lds_buf = 1,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 11,
         .num_tcc_blocks = 4,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .cu_ao_bitmap[0][0] = 0x3ff,
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(64) << 20,
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(64) << 20,
         },
         .gtt = {
            .total_heap_size = UINT64_C(3072) << 20,
         },
      },
   },
   {
      .name = "raven2",
      .radeon_family = CHIP_RAVEN2,
      .hw_ip_gfx = {
         .hw_ip_version_major = 9,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x0000,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 9,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0x0000,
      },
      .fw_gfx_me = {
         .ver = 166,
         .feature = 53,
      },
      .fw_gfx_pfp = {
         .ver = 194,
         .feature = 53,
      },
      .fw_gfx_mec = {
         .ver = 464,
         .feature = 53,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x26013041,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x15d8,
         .chip_rev = 0x09,
         .external_rev = 0x82,
         .pci_rev = 0xea,
         .family = AMDGPU_FAMILY_RV,
         .num_shader_engines = 1,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 100000,
         .max_engine_clock = UINT64_C(600000),
         .max_memory_clock = UINT64_C(800000),
         .cu_active_number = 3,
         .cu_ao_mask = 0x7,
         .cu_bitmap = {
            { 0x7, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0x1,
         .num_rb_pipes = 1,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 0,
         .ids_flags = UINT64_C(0x1),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 8,
         .vram_bit_width = 64,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 3,
         .num_tcc_blocks = 2,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 0,
         .cu_ao_bitmap = {
            { 0x7, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(0),
         .min_memory_clock = UINT64_C(0),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(67108864),
            .usable_heap_size = UINT64_C(50491392),
            .heap_usage = UINT64_C(51437568),
            .max_allocation = UINT64_C(37868544),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(67108864),
            .usable_heap_size = UINT64_C(50491392),
            .heap_usage = UINT64_C(51437568),
            .max_allocation = UINT64_C(37868544),
         },
         .gtt = {
            .total_heap_size = UINT64_C(3057070080),
            .usable_heap_size = UINT64_C(3052445696),
            .heap_usage = UINT64_C(62390272),
            .max_allocation = UINT64_C(2289334272),
         },
      },
   },
   {
      .name = "stoney",
      .radeon_family = CHIP_STONEY,
      .hw_ip_gfx = {
         .hw_ip_version_major = 8,
         .hw_ip_version_minor = 1,
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 8,
         .hw_ip_version_minor = 1,
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
      },
      .fw_gfx_me = {
         .ver = 52,
         .feature = 35,
      },
      .fw_gfx_pfp = {
         .ver = 77,
         .feature = 35,
      },
      .fw_gfx_mec = {
         .ver = 134,
         .feature = 35,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x02010001,
         0x263d, 0x0000ff00, 0x00000000,
         0xa0d4, 0x0000ff00, 0x00000000,
         0xa0d5, 0x0000ff00, 0x00000000,
         0x09d8, 0xffffffff, 0x00007111,
         0x2644, 0xffffffff, 0x00800010,
         0x2645, 0xffffffff, 0x00800810,
         0x2646, 0xffffffff, 0x00801010,
         0x2647, 0xffffffff, 0x00801810,
         0x2648, 0xffffffff, 0x00802810,
         0x2649, 0xffffffff, 0x00802808,
         0x264a, 0xffffffff, 0x00802814,
         0x264b, 0xffffffff, 0x00000000,
         0x264c, 0xffffffff, 0x00000004,
         0x264d, 0xffffffff, 0x02000008,
         0x264e, 0xffffffff, 0x02000010,
         0x264f, 0xffffffff, 0x06000014,
         0x2650, 0xffffffff, 0x00000000,
         0x2651, 0xffffffff, 0x02400008,
         0x2652, 0xffffffff, 0x02400010,
         0x2653, 0xffffffff, 0x02400030,
         0x2654, 0xffffffff, 0x06400014,
         0x2655, 0xffffffff, 0x00000000,
         0x2656, 0xffffffff, 0x0040000c,
         0x2657, 0xffffffff, 0x0100000c,
         0x2658, 0xffffffff, 0x0100001c,
         0x2659, 0xffffffff, 0x01000034,
         0x265a, 0xffffffff, 0x01000024,
         0x265b, 0xffffffff, 0x00000000,
         0x265c, 0xffffffff, 0x0040001c,
         0x265d, 0xffffffff, 0x01000020,
         0x265e, 0xffffffff, 0x01000038,
         0x265f, 0xffffffff, 0x02c00008,
         0x2660, 0xffffffff, 0x02c00010,
         0x2661, 0xffffffff, 0x06c00014,
         0x2662, 0xffffffff, 0x00000000,
         0x2663, 0xffffffff, 0x00000000,
         0x2664, 0xffffffff, 0x000000a8,
         0x2665, 0xffffffff, 0x000000a4,
         0x2666, 0xffffffff, 0x00000090,
         0x2667, 0xffffffff, 0x00000090,
         0x2668, 0xffffffff, 0x00000090,
         0x2669, 0xffffffff, 0x00000090,
         0x266a, 0xffffffff, 0x00000090,
         0x266b, 0xffffffff, 0x00000000,
         0x266c, 0xffffffff, 0x000000ee,
         0x266d, 0xffffffff, 0x000000ea,
         0x266e, 0xffffffff, 0x000000e9,
         0x266f, 0xffffffff, 0x000000e5,
         0x2670, 0xffffffff, 0x000000e4,
         0x2671, 0xffffffff, 0x000000e0,
         0x2672, 0xffffffff, 0x00000090,
         0x2673, 0xffffffff, 0x00000000,
      },
      .mmr_reg_count = 53,
      .dev = {
         .device_id = 0x98e4,
         .external_rev = 0x61,
         .pci_rev = 0xeb,
         .family = AMDGPU_FAMILY_CZ,
         .num_shader_engines = 1,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 48000,
         .max_engine_clock = 600000,
         .max_memory_clock = 933000,
         .cu_active_number = 3,
         .cu_ao_mask = 0x3,
         .cu_bitmap[0][0] = 0x7,
         .enabled_rb_pipes_mask = 0x1,
         .num_rb_pipes = 1,
         .num_hw_gfx_contexts = 8,
         .ids_flags = 0x1,
         .virtual_address_offset = 0x200000,
         .virtual_address_max = UINT64_C(0xfffe00000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_bit_width = 64,
         .vce_harvest_config = 2,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 3,
         .num_tcc_blocks = 2,
         .max_gs_waves_per_vgt = 16,
         .cu_ao_bitmap[0][0] = 0x3,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(16) << 20,
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(16) << 20,
         },
         .gtt = {
            .total_heap_size = UINT64_C(3072) << 20,
         },
      },
   },
   {
      .name = "vangogh",
      .radeon_family = CHIP_VANGOGH,
      .hw_ip_gfx = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x0000,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0x0000,
      },
      .fw_gfx_me = {
         .ver = 64,
         .feature = 41,
      },
      .fw_gfx_pfp = {
         .ver = 95,
         .feature = 41,
      },
      .fw_gfx_mec = {
         .ver = 98,
         .feature = 41,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x00000142,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x163f,
         .chip_rev = 0x00,
         .external_rev = 0x01,
         .pci_rev = 0xae,
         .family = AMDGPU_FAMILY_VGH,
         .num_shader_engines = 1,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 100000,
         .max_engine_clock = UINT64_C(0),
         .max_memory_clock = UINT64_C(0),
         .cu_active_number = 8,
         .cu_ao_mask = 0xff,
         .cu_bitmap = {
            { 0xff, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0x3,
         .num_rb_pipes = 2,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 0,
         .ids_flags = UINT64_C(0x1),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 65536,
         .vram_type = 10,
         .vram_bit_width = 256,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 32,
         .num_shader_visible_vgprs = 1024,
         .num_cu_per_sh = 8,
         .num_tcc_blocks = 4,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 0,
         .cu_ao_bitmap = {
            { 0xff, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(0),
         .min_memory_clock = UINT64_C(0),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(1073741824),
            .usable_heap_size = UINT64_C(1040584704),
            .heap_usage = UINT64_C(344141824),
            .max_allocation = UINT64_C(780438528),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(1073741824),
            .usable_heap_size = UINT64_C(1040584704),
            .heap_usage = UINT64_C(344141824),
            .max_allocation = UINT64_C(780438528),
         },
         .gtt = {
            .total_heap_size = UINT64_C(8522825728),
            .usable_heap_size = UINT64_C(8511004672),
            .heap_usage = UINT64_C(79179776),
            .max_allocation = UINT64_C(6383253504),
         },
      },
   },
   {
      .name = "raphael_mendocino",
      .radeon_family = CHIP_RAPHAEL_MENDOCINO,
      .hw_ip_gfx = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0xa0306,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0xa0306,
      },
      .fw_gfx_me = {
         .ver = 13,
         .feature = 38,
      },
      .fw_gfx_pfp = {
         .ver = 13,
         .feature = 38,
      },
      .fw_gfx_mec = {
         .ver = 18,
         .feature = 38,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x00000042,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x164e,
         .chip_rev = 0x01,
         .external_rev = 0x02,
         .pci_rev = 0xc1,
         .family = AMDGPU_FAMILY_GC_10_3_6,
         .num_shader_engines = 1,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 100000,
         .max_engine_clock = UINT64_C(200000),
         .max_memory_clock = UINT64_C(2400000),
         .cu_active_number = 2,
         .cu_ao_mask = 0x3,
         .cu_bitmap = {
            { 0x3, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0x1,
         .num_rb_pipes = 1,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 4,
         .ids_flags = UINT64_C(0x1),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 65536,
         .vram_type = 10,
         .vram_bit_width = 128,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 32,
         .num_shader_visible_vgprs = 1024,
         .num_cu_per_sh = 2,
         .num_tcc_blocks = 2,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 16,
         .cu_ao_bitmap = {
            { 0x3, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(200000),
         .min_memory_clock = UINT64_C(2400000),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(536870912),
            .usable_heap_size = UINT64_C(512081920),
            .heap_usage = UINT64_C(30093312),
            .max_allocation = UINT64_C(384061440),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(536870912),
            .usable_heap_size = UINT64_C(512081920),
            .heap_usage = UINT64_C(30093312),
            .max_allocation = UINT64_C(384061440),
         },
         .gtt = {
            .total_heap_size = UINT64_C(33254252544),
            .usable_heap_size = UINT64_C(33241997312),
            .heap_usage = UINT64_C(14360576),
            .max_allocation = UINT64_C(24931497984),
         },
      },
   },
   {
      .name = "polaris10",
      .radeon_family = CHIP_POLARIS10,
      .hw_ip_gfx = {
         .hw_ip_version_major = 8,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x0000,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 8,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0x0000,
      },
      .fw_gfx_me = {
         .ver = 167,
         .feature = 49,
      },
      .fw_gfx_pfp = {
         .ver = 254,
         .feature = 49,
      },
      .fw_gfx_mec = {
         .ver = 730,
         .feature = 49,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x22011003,
         0x263d, 0x0000ff00, 0x00000000,
         0xa0d4, 0x0000ff00, 0x16000012,
         0xa0d5, 0x0000ff00, 0x0000002a,
         0x263d, 0x0000ff01, 0x00000000,
         0xa0d4, 0x0000ff01, 0x16000012,
         0xa0d5, 0x0000ff01, 0x0000002a,
         0x263d, 0x0000ff02, 0x00000000,
         0xa0d4, 0x0000ff02, 0x16000012,
         0xa0d5, 0x0000ff02, 0x0000002a,
         0x263d, 0x0000ff03, 0x00000000,
         0xa0d4, 0x0000ff03, 0x16000012,
         0xa0d5, 0x0000ff03, 0x0000002a,
         0x09d8, 0xffffffff, 0x000060a2,
         0x2644, 0xffffffff, 0x00800310,
         0x2645, 0xffffffff, 0x00800b10,
         0x2646, 0xffffffff, 0x00801310,
         0x2647, 0xffffffff, 0x00801b10,
         0x2648, 0xffffffff, 0x00802b10,
         0x2649, 0xffffffff, 0x00802b08,
         0x264a, 0xffffffff, 0x00802b14,
         0x264b, 0xffffffff, 0x00802954,
         0x264c, 0xffffffff, 0x00000304,
         0x264d, 0xffffffff, 0x02000308,
         0x264e, 0xffffffff, 0x02000310,
         0x264f, 0xffffffff, 0x06000314,
         0x2650, 0xffffffff, 0x06000154,
         0x2651, 0xffffffff, 0x02400308,
         0x2652, 0xffffffff, 0x02400310,
         0x2653, 0xffffffff, 0x02400330,
         0x2654, 0xffffffff, 0x06400314,
         0x2655, 0xffffffff, 0x06400154,
         0x2656, 0xffffffff, 0x0040030c,
         0x2657, 0xffffffff, 0x0100030c,
         0x2658, 0xffffffff, 0x0100031c,
         0x2659, 0xffffffff, 0x01000334,
         0x265a, 0xffffffff, 0x01000324,
         0x265b, 0xffffffff, 0x01000164,
         0x265c, 0xffffffff, 0x0040031c,
         0x265d, 0xffffffff, 0x01000320,
         0x265e, 0xffffffff, 0x01000338,
         0x265f, 0xffffffff, 0x02c00308,
         0x2660, 0xffffffff, 0x02c00310,
         0x2661, 0xffffffff, 0x06c00314,
         0x2662, 0xffffffff, 0x06c00154,
         0x2663, 0xffffffff, 0x00000000,
         0x2664, 0xffffffff, 0x000000e8,
         0x2665, 0xffffffff, 0x000000e8,
         0x2666, 0xffffffff, 0x000000e8,
         0x2667, 0xffffffff, 0x000000e8,
         0x2668, 0xffffffff, 0x000000d4,
         0x2669, 0xffffffff, 0x000000c0,
         0x266a, 0xffffffff, 0x000000c0,
         0x266b, 0xffffffff, 0x00000000,
         0x266c, 0xffffffff, 0x000000ec,
         0x266d, 0xffffffff, 0x000000e8,
         0x266e, 0xffffffff, 0x000000d4,
         0x266f, 0xffffffff, 0x000000d0,
         0x2670, 0xffffffff, 0x00000080,
         0x2671, 0xffffffff, 0x00000040,
         0x2672, 0xffffffff, 0x00000040,
         0x2673, 0xffffffff, 0x00000000,
      },
      .mmr_reg_count = 62,
      .dev = {
         .device_id = 0x67df,
         .chip_rev = 0x01,
         .external_rev = 0x51,
         .pci_rev = 0xe7,
         .family = AMDGPU_FAMILY_VI,
         .num_shader_engines = 4,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 25000,
         .max_engine_clock = UINT64_C(1360000),
         .max_memory_clock = UINT64_C(2000000),
         .cu_active_number = 36,
         .cu_ao_mask = 0x1ff01ff,
         .cu_bitmap = {
            { 0x1ff, 0x0, 0x0, 0x0, },
            { 0x1ff, 0x0, 0x0, 0x0, },
            { 0x1ff, 0x0, 0x0, 0x0, },
            { 0x1ff, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xff,
         .num_rb_pipes = 8,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 0,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x1fffe00000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 5,
         .vram_bit_width = 256,
         .vce_harvest_config = 2,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 9,
         .num_tcc_blocks = 8,
         .gs_vgt_table_depth = 0,
         .gs_prim_buffer_depth = 0,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 0,
         .cu_ao_bitmap = {
            { 0x1ff, 0x0, 0x0, 0x0, },
            { 0x1ff, 0x0, 0x0, 0x0, },
            { 0x1ff, 0x0, 0x0, 0x0, },
            { 0x1ff, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0x0),
         .high_va_max = UINT64_C(0x0),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(0),
         .min_memory_clock = UINT64_C(0),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(8589934592),
            .usable_heap_size = UINT64_C(8576106496),
            .heap_usage = UINT64_C(267620352),
            .max_allocation = UINT64_C(6432079872),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(268435456),
            .usable_heap_size = UINT64_C(262995968),
            .heap_usage = UINT64_C(17641472),
            .max_allocation = UINT64_C(197246976),
         },
         .gtt = {
            .total_heap_size = UINT64_C(16776243200),
            .usable_heap_size = UINT64_C(16766920704),
            .heap_usage = UINT64_C(80318464),
            .max_allocation = UINT64_C(12575190528),
         },
      },
   },
   {
      .name = "polaris12",
      .radeon_family = CHIP_POLARIS12,
      .hw_ip_gfx = {
         .hw_ip_version_major = 8,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x0000,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 8,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0x0000,
      },
      .fw_gfx_me = {
         .ver = 167,
         .feature = 49,
      },
      .fw_gfx_pfp = {
         .ver = 254,
         .feature = 49,
      },
      .fw_gfx_mec = {
         .ver = 730,
         .feature = 49,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x22011002,
         0x263d, 0x0000ff00, 0x00000001,
         0xa0d4, 0x0000ff00, 0x16000012,
         0xa0d5, 0x0000ff00, 0x00000000,
         0x263d, 0x0000ff01, 0x00000001,
         0xa0d4, 0x0000ff01, 0x16000012,
         0xa0d5, 0x0000ff01, 0x00000000,
         0x09d8, 0xffffffff, 0x000060a2,
         0x2644, 0xffffffff, 0x00800150,
         0x2645, 0xffffffff, 0x00800950,
         0x2646, 0xffffffff, 0x00801150,
         0x2647, 0xffffffff, 0x00801950,
         0x2648, 0xffffffff, 0x00802950,
         0x2649, 0xffffffff, 0x00802948,
         0x264a, 0xffffffff, 0x00802954,
         0x264b, 0xffffffff, 0x00802954,
         0x264c, 0xffffffff, 0x00000144,
         0x264d, 0xffffffff, 0x02000148,
         0x264e, 0xffffffff, 0x02000150,
         0x264f, 0xffffffff, 0x06000154,
         0x2650, 0xffffffff, 0x06000154,
         0x2651, 0xffffffff, 0x02400148,
         0x2652, 0xffffffff, 0x02400150,
         0x2653, 0xffffffff, 0x02400170,
         0x2654, 0xffffffff, 0x06400154,
         0x2655, 0xffffffff, 0x06400154,
         0x2656, 0xffffffff, 0x0040014c,
         0x2657, 0xffffffff, 0x0100014c,
         0x2658, 0xffffffff, 0x0100015c,
         0x2659, 0xffffffff, 0x01000174,
         0x265a, 0xffffffff, 0x01000164,
         0x265b, 0xffffffff, 0x01000164,
         0x265c, 0xffffffff, 0x0040015c,
         0x265d, 0xffffffff, 0x01000160,
         0x265e, 0xffffffff, 0x01000178,
         0x265f, 0xffffffff, 0x02c00148,
         0x2660, 0xffffffff, 0x02c00150,
         0x2661, 0xffffffff, 0x06c00154,
         0x2662, 0xffffffff, 0x06c00154,
         0x2663, 0xffffffff, 0x00000000,
         0x2664, 0xffffffff, 0x000000e8,
         0x2665, 0xffffffff, 0x000000e8,
         0x2666, 0xffffffff, 0x000000e8,
         0x2667, 0xffffffff, 0x000000e4,
         0x2668, 0xffffffff, 0x000000d0,
         0x2669, 0xffffffff, 0x000000d0,
         0x266a, 0xffffffff, 0x000000d0,
         0x266b, 0xffffffff, 0x00000000,
         0x266c, 0xffffffff, 0x000000ed,
         0x266d, 0xffffffff, 0x000000e9,
         0x266e, 0xffffffff, 0x000000e8,
         0x266f, 0xffffffff, 0x000000e4,
         0x2670, 0xffffffff, 0x000000d0,
         0x2671, 0xffffffff, 0x00000090,
         0x2672, 0xffffffff, 0x00000040,
         0x2673, 0xffffffff, 0x00000000,
      },
      .mmr_reg_count = 56,
      .dev = {
         .device_id = 0x699f,
         .chip_rev = 0x00,
         .external_rev = 0x64,
         .pci_rev = 0xc7,
         .family = AMDGPU_FAMILY_VI,
         .num_shader_engines = 2,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 25000,
         .max_engine_clock = UINT64_C(1183000),
         .max_memory_clock = UINT64_C(1750000),
         .cu_active_number = 8,
         .cu_ao_mask = 0x1e001e,
         .cu_bitmap = {
            { 0x1e, 0x0, 0x0, 0x0, },
            { 0x1e, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xf,
         .num_rb_pipes = 4,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 3,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x3fffe00000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 5,
         .vram_bit_width = 128,
         .vce_harvest_config = 2,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 5,
         .num_tcc_blocks = 4,
         .gs_vgt_table_depth = 0,
         .gs_prim_buffer_depth = 0,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 1,
         .cu_ao_bitmap = {
            { 0x1e, 0x0, 0x0, 0x0, },
            { 0x1e, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0x0),
         .high_va_max = UINT64_C(0x0),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(214000),
         .min_memory_clock = UINT64_C(300000),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(4294967296),
            .usable_heap_size = UINT64_C(4281139200),
            .heap_usage = UINT64_C(5963776),
            .max_allocation = UINT64_C(3210854400),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(4294967296),
            .usable_heap_size = UINT64_C(4281139200),
            .heap_usage = UINT64_C(5963776),
            .max_allocation = UINT64_C(3210854400),
         },
         .gtt = {
            .total_heap_size = UINT64_C(33254252544),
            .usable_heap_size = UINT64_C(33249120256),
            .heap_usage = UINT64_C(17903616),
            .max_allocation = UINT64_C(24936840192),
         },
      },
   },
   {
      .name = "vega10",
      .radeon_family = CHIP_VEGA10,
      .hw_ip_gfx = {
         .hw_ip_version_major = 9,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x90001,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 9,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0x90001,
      },
      .fw_gfx_me = {
         .ver = 166,
         .feature = 53,
      },
      .fw_gfx_pfp = {
         .ver = 194,
         .feature = 53,
      },
      .fw_gfx_mec = {
         .ver = 33236,
         .feature = 53,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x2a114042,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x687f,
         .chip_rev = 0x01,
         .external_rev = 0x01,
         .pci_rev = 0xc1,
         .family = AMDGPU_FAMILY_AI,
         .num_shader_engines = 4,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 27000,
         .max_engine_clock = UINT64_C(1630000),
         .max_memory_clock = UINT64_C(945000),
         .cu_active_number = 64,
         .cu_ao_mask = 0xffffffff,
         .cu_bitmap = {
            { 0xffff, 0x0, 0x0, 0x0, },
            { 0xffff, 0x0, 0x0, 0x0, },
            { 0xffff, 0x0, 0x0, 0x0, },
            { 0xffff, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xffff,
         .num_rb_pipes = 16,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 0,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 6,
         .vram_bit_width = 2048,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 16,
         .num_tcc_blocks = 16,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 0,
         .cu_ao_bitmap = {
            { 0xffff, 0x0, 0x0, 0x0, },
            { 0xffff, 0x0, 0x0, 0x0, },
            { 0xffff, 0x0, 0x0, 0x0, },
            { 0xffff, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(0),
         .min_memory_clock = UINT64_C(0),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(8573157376),
            .usable_heap_size = UINT64_C(8556453888),
            .heap_usage = UINT64_C(39575552),
            .max_allocation = UINT64_C(6417340416),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(268435456),
            .usable_heap_size = UINT64_C(260120576),
            .heap_usage = UINT64_C(30138368),
            .max_allocation = UINT64_C(195090432),
         },
         .gtt = {
            .total_heap_size = UINT64_C(8359135232),
            .usable_heap_size = UINT64_C(8346802176),
            .heap_usage = UINT64_C(22892544),
            .max_allocation = UINT64_C(6260101632),
         },
      },
   },
   {
      .name = "navi10",
      .radeon_family = CHIP_NAVI10,
      .hw_ip_gfx = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0xa010a,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0xa010a,
      },
      .fw_gfx_me = {
         .ver = 100,
         .feature = 34,
      },
      .fw_gfx_pfp = {
         .ver = 155,
         .feature = 34,
      },
      .fw_gfx_mec = {
         .ver = 146,
         .feature = 34,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x00100044,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x731f,
         .chip_rev = 0x02,
         .external_rev = 0x03,
         .pci_rev = 0xc1,
         .family = AMDGPU_FAMILY_NV,
         .num_shader_engines = 2,
         .num_shader_arrays_per_engine = 2,
         .gpu_counter_freq = 100000,
         .max_engine_clock = UINT64_C(2100000),
         .max_memory_clock = UINT64_C(875000),
         .cu_active_number = 40,
         .cu_ao_mask = 0xffffffff,
         .cu_bitmap = {
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xffff,
         .num_rb_pipes = 16,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 0,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 65536,
         .vram_type = 9,
         .vram_bit_width = 256,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 32,
         .num_shader_visible_vgprs = 1024,
         .num_cu_per_sh = 10,
         .num_tcc_blocks = 16,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 0,
         .cu_ao_bitmap = {
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
         .pa_sc_tile_steering_override = 1187840,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(0),
         .min_memory_clock = UINT64_C(0),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(8573157376),
            .usable_heap_size = UINT64_C(8553127936),
            .heap_usage = UINT64_C(11644928),
            .max_allocation = UINT64_C(6414845952),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(268435456),
            .usable_heap_size = UINT64_C(256860160),
            .heap_usage = UINT64_C(11579392),
            .max_allocation = UINT64_C(192645120),
         },
         .gtt = {
            .total_heap_size = UINT64_C(8359135232),
            .usable_heap_size = UINT64_C(8347318272),
            .heap_usage = UINT64_C(22102016),
            .max_allocation = UINT64_C(6260488704),
         },
      },
   },
   {
      .name = "gfx1100",
      .radeon_family = CHIP_GFX1100,
      .hw_ip_gfx = {
         .hw_ip_version_major = 11,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0xb0000,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 11,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0xb0000,
      },
      .fw_gfx_me = {
         .ver = 1486,
         .feature = 29,
      },
      .fw_gfx_pfp = {
         .ver = 1525,
         .feature = 29,
      },
      .fw_gfx_mec = {
         .ver = 494,
         .feature = 29,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x00000545,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x744c,
         .chip_rev = 0x00,
         .external_rev = 0x01,
         .pci_rev = 0xc8,
         .family = AMDGPU_FAMILY_GC_11_0_0,
         .num_shader_engines = 6,
         .num_shader_arrays_per_engine = 2,
         .gpu_counter_freq = 100000,
         .max_engine_clock = UINT64_C(2371000),
         .max_memory_clock = UINT64_C(1249000),
         .cu_active_number = 96,
         .cu_ao_mask = 0x0,
         .cu_bitmap = {
            { 0xff, 0xff, 0xff, 0xff, },
            { 0xff, 0xff, 0xff, 0xff, },
            { 0xff, 0xff, 0x0, 0x0, },
            { 0xff, 0xff, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xffffff,
         .num_rb_pipes = 24,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 4,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 0,
         .vram_type = 9,
         .vram_bit_width = 384,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 0,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 32,
         .num_shader_visible_vgprs = 1536,
         .num_cu_per_sh = 8,
         .num_tcc_blocks = 24,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 16,
         .cu_ao_bitmap = {
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(500000),
         .min_memory_clock = UINT64_C(96000),
         .tcp_cache_size = 32,
         .num_sqc_per_wgp = 1,
         .sqc_data_cache_size = 16,
         .sqc_inst_cache_size = 32,
         .gl1c_cache_size = 256,
         .gl2c_cache_size = 6144,
         .mall_size = UINT64_C(100663296),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(25753026560),
            .usable_heap_size = UINT64_C(25681096704),
            .heap_usage = UINT64_C(7515435008),
            .max_allocation = UINT64_C(19260822528),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(25753026560),
            .usable_heap_size = UINT64_C(25681096704),
            .heap_usage = UINT64_C(7515435008),
            .max_allocation = UINT64_C(19260822528),
         },
         .gtt = {
            .total_heap_size = UINT64_C(33254252544),
            .usable_heap_size = UINT64_C(33240895488),
            .heap_usage = UINT64_C(142462976),
            .max_allocation = UINT64_C(24930671616),
         },
      },
   },
   {
      .name = "navi21",
      .radeon_family = CHIP_NAVI21,
      .hw_ip_gfx = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0xa0300,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 10,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0xa0300,
      },
      .fw_gfx_me = {
         .ver = 64,
         .feature = 42,
      },
      .fw_gfx_pfp = {
         .ver = 95,
         .feature = 42,
      },
      .fw_gfx_mec = {
         .ver = 104,
         .feature = 42,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x00000444,
      },
      .mmr_reg_count = 1,
      .dev = {
         .device_id = 0x73bf,
         .chip_rev = 0x01,
         .external_rev = 0x29,
         .pci_rev = 0xc3,
         .family = AMDGPU_FAMILY_NV,
         .num_shader_engines = 4,
         .num_shader_arrays_per_engine = 2,
         .gpu_counter_freq = 100000,
         .max_engine_clock = UINT64_C(2475000),
         .max_memory_clock = UINT64_C(1000000),
         .cu_active_number = 60,
         .cu_ao_mask = 0x3ffff,
         .cu_bitmap = {
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x3ff, 0x3ff, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xff0f,
         .num_rb_pipes = 16,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 3,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x800000000000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 65536,
         .vram_type = 9,
         .vram_bit_width = 256,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 32,
         .num_shader_visible_vgprs = 1024,
         .num_cu_per_sh = 10,
         .num_tcc_blocks = 16,
         .gs_vgt_table_depth = 32,
         .gs_prim_buffer_depth = 1792,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 16,
         .cu_ao_bitmap = {
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x3ff, 0x3ff, 0x0, 0x0, },
            { 0x3ff, 0x3ff, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0xffff800000000000),
         .high_va_max = UINT64_C(0xffffffffffe00000),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(500000),
         .min_memory_clock = UINT64_C(96000),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(134217728),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(17163091968),
            .usable_heap_size = UINT64_C(17128448000),
            .heap_usage = UINT64_C(817770496),
            .max_allocation = UINT64_C(12846336000),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(268435456),
            .usable_heap_size = UINT64_C(273055744),
            .heap_usage = UINT64_C(246521856),
            .max_allocation = UINT64_C(204791808),
         },
         .gtt = {
            .total_heap_size = UINT64_C(16746784768),
            .usable_heap_size = UINT64_C(16733624320),
            .heap_usage = UINT64_C(499445760),
            .max_allocation = UINT64_C(12550218240),
         },
      },
   },
   {
      .name = "pitcairn",
      .radeon_family = CHIP_PITCAIRN,
      .hw_ip_gfx = {
         .hw_ip_version_major = 6,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x0000,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 6,
         .hw_ip_version_minor = 0,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x3,
         .ip_discovery_version = 0x0000,
      },
      .fw_gfx_me = {
         .ver = 145,
         .feature = 29,
      },
      .fw_gfx_pfp = {
         .ver = 84,
         .feature = 29,
      },
      .fw_gfx_mec = {
         .ver = 0,
         .feature = 0,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x12011003,
         0x263d, 0x0000ff00, 0x00000001,
         0xa0d4, 0x0000ff00, 0x2a001260,
         0x263d, 0x0000ff01, 0x00000001,
         0xa0d4, 0x0000ff01, 0x2a001260,
         0x09d8, 0xffffffff, 0x0000025a,
         0x2644, 0xffffffff, 0x00360292,
         0x2645, 0xffffffff, 0x00360a92,
         0x2646, 0xffffffff, 0x00361292,
         0x2647, 0xffffffff, 0x00122a92,
         0x2648, 0xffffffff, 0x0000028a,
         0x2649, 0xffffffff, 0x00021a92,
         0x264a, 0xffffffff, 0x00031292,
         0x264b, 0xffffffff, 0x00022112,
         0x264c, 0xffffffff, 0x00000004,
         0x264d, 0xffffffff, 0x00000288,
         0x264e, 0xffffffff, 0x00361290,
         0x264f, 0xffffffff, 0x00351290,
         0x2650, 0xffffffff, 0x00301a90,
         0x2651, 0xffffffff, 0x00000289,
         0x2652, 0xffffffff, 0x00321291,
         0x2653, 0xffffffff, 0x00311291,
         0x2654, 0xffffffff, 0x00301a91,
         0x2655, 0xffffffff, 0x00302a91,
         0x2656, 0xffffffff, 0x0000028d,
         0x2657, 0xffffffff, 0x00302aa1,
         0x2658, 0xffffffff, 0x00302a9d,
         0x2659, 0xffffffff, 0x00131291,
         0x265a, 0xffffffff, 0x00121291,
         0x265b, 0xffffffff, 0x00031291,
         0x265c, 0xffffffff, 0x00021a91,
         0x265d, 0xffffffff, 0x00022111,
         0x265e, 0xffffffff, 0x00022111,
         0x265f, 0xffffffff, 0x00022111,
         0x2660, 0xffffffff, 0x00022111,
         0x2661, 0xffffffff, 0x00022111,
         0x2662, 0xffffffff, 0x00012911,
         0x2663, 0xffffffff, 0x00000000,
      },
      .mmr_reg_count = 38,
      .dev = {
         .device_id = 0x6818,
         .chip_rev = 0x01,
         .external_rev = 0x15,
         .pci_rev = 0x00,
         .family = AMDGPU_FAMILY_SI,
         .num_shader_engines = 2,
         .num_shader_arrays_per_engine = 2,
         .gpu_counter_freq = 27000,
         .max_engine_clock = UINT64_C(1100000),
         .max_memory_clock = UINT64_C(1250000),
         .cu_active_number = 20,
         .cu_ao_mask = 0x1f1f1f1f,
         .cu_bitmap = {
            { 0x1f, 0x1f, 0x0, 0x0, },
            { 0x1f, 0x1f, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xff,
         .num_rb_pipes = 8,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 3,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0xfffe00000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 5,
         .vram_bit_width = 256,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 0,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 0,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 5,
         .num_tcc_blocks = 8,
         .gs_vgt_table_depth = 0,
         .gs_prim_buffer_depth = 0,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 8,
         .cu_ao_bitmap = {
            { 0x1f, 0x1f, 0x0, 0x0, },
            { 0x1f, 0x1f, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0x0),
         .high_va_max = UINT64_C(0x0),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(300000),
         .min_memory_clock = UINT64_C(150000),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(2147483648),
            .usable_heap_size = UINT64_C(2134118400),
            .heap_usage = UINT64_C(5238784),
            .max_allocation = UINT64_C(1600588800),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(268435456),
            .usable_heap_size = UINT64_C(263458816),
            .heap_usage = UINT64_C(4976640),
            .max_allocation = UINT64_C(197594112),
         },
         .gtt = {
            .total_heap_size = UINT64_C(8363028480),
            .usable_heap_size = UINT64_C(8359759872),
            .heap_usage = UINT64_C(3530752),
            .max_allocation = UINT64_C(6269819904),
         },
      },
   },
   {
      .name = "bonaire",
      .radeon_family = CHIP_BONAIRE,
      .hw_ip_gfx = {
         .hw_ip_version_major = 7,
         .hw_ip_version_minor = 2,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0x1,
         .ip_discovery_version = 0x0000,
      },
      .hw_ip_compute = {
         .hw_ip_version_major = 7,
         .hw_ip_version_minor = 2,
         .capabilities_flags = UINT64_C(0),
         .ib_start_alignment = 32,
         .ib_size_alignment = 32,
         .available_rings = 0xf,
         .ip_discovery_version = 0x0000,
      },
      .fw_gfx_me = {
         .ver = 187,
         .feature = 29,
      },
      .fw_gfx_pfp = {
         .ver = 229,
         .feature = 29,
      },
      .fw_gfx_mec = {
         .ver = 421,
         .feature = 29,
      },
      .mmr_regs = {
         0x263e, 0xffffffff, 0x12010001,
         0x263d, 0x0000ff00, 0x00000001,
         0xa0d4, 0x0000ff00, 0x16000012,
         0xa0d5, 0x0000ff00, 0x00000000,
         0x263d, 0x0000ff01, 0x00000001,
         0xa0d4, 0x0000ff01, 0x16000012,
         0xa0d5, 0x0000ff01, 0x00000000,
         0x09d8, 0xffffffff, 0x00006262,
         0x2644, 0xffffffff, 0x00800150,
         0x2645, 0xffffffff, 0x00800950,
         0x2646, 0xffffffff, 0x00801150,
         0x2647, 0xffffffff, 0x00801950,
         0x2648, 0xffffffff, 0x00802950,
         0x2649, 0xffffffff, 0x00800148,
         0x264a, 0xffffffff, 0x00802954,
         0x264b, 0xffffffff, 0x00002800,
         0x264c, 0xffffffff, 0x00000144,
         0x264d, 0xffffffff, 0x00000148,
         0x264e, 0xffffffff, 0x02000150,
         0x264f, 0xffffffff, 0x06000154,
         0x2650, 0xffffffff, 0x00002800,
         0x2651, 0xffffffff, 0x00400148,
         0x2652, 0xffffffff, 0x02400150,
         0x2653, 0xffffffff, 0x02400170,
         0x2654, 0xffffffff, 0x06400154,
         0x2655, 0xffffffff, 0x00002800,
         0x2656, 0xffffffff, 0x0040014c,
         0x2657, 0xffffffff, 0x0040014c,
         0x2658, 0xffffffff, 0x0040015c,
         0x2659, 0xffffffff, 0x00400174,
         0x265a, 0xffffffff, 0x00400164,
         0x265b, 0xffffffff, 0x00002800,
         0x265c, 0xffffffff, 0x0040015c,
         0x265d, 0xffffffff, 0x00400160,
         0x265e, 0xffffffff, 0x00400178,
         0x265f, 0xffffffff, 0x00c00148,
         0x2660, 0xffffffff, 0x02c00150,
         0x2661, 0xffffffff, 0x06c00154,
         0x2662, 0xffffffff, 0x00002800,
         0x2663, 0xffffffff, 0x00000000,
         0x2664, 0xffffffff, 0x000000e8,
         0x2665, 0xffffffff, 0x000000e4,
         0x2666, 0xffffffff, 0x000000d0,
         0x2667, 0xffffffff, 0x000000d0,
         0x2668, 0xffffffff, 0x000000d0,
         0x2669, 0xffffffff, 0x00000090,
         0x266a, 0xffffffff, 0x00000040,
         0x266b, 0xffffffff, 0x00000000,
         0x266c, 0xffffffff, 0x000000ed,
         0x266d, 0xffffffff, 0x000000e9,
         0x266e, 0xffffffff, 0x000000e8,
         0x266f, 0xffffffff, 0x000000e4,
         0x2670, 0xffffffff, 0x000000d0,
         0x2671, 0xffffffff, 0x00000090,
         0x2672, 0xffffffff, 0x00000040,
         0x2673, 0xffffffff, 0x00000000,
      },
      .mmr_reg_count = 56,
      .dev = {
         .device_id = 0x6658,
         .chip_rev = 0x01,
         .external_rev = 0x15,
         .pci_rev = 0x00,
         .family = AMDGPU_FAMILY_CI,
         .num_shader_engines = 2,
         .num_shader_arrays_per_engine = 1,
         .gpu_counter_freq = 27000,
         .max_engine_clock = UINT64_C(1075000),
         .max_memory_clock = UINT64_C(1600000),
         .cu_active_number = 14,
         .cu_ao_mask = 0x7f007f,
         .cu_bitmap = {
            { 0x7f, 0x0, 0x0, 0x0, },
            { 0x7f, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .enabled_rb_pipes_mask = 0xf,
         .num_rb_pipes = 4,
         .num_hw_gfx_contexts = 8,
         .pcie_gen = 3,
         .ids_flags = UINT64_C(0x0),
         .virtual_address_offset = UINT64_C(0x200000),
         .virtual_address_max = UINT64_C(0x1fffe00000),
         .virtual_address_alignment = 4096,
         .pte_fragment_size = 2097152,
         .gart_page_size = 4096,
         .ce_ram_size = 32768,
         .vram_type = 5,
         .vram_bit_width = 128,
         .vce_harvest_config = 0,
         .gc_double_offchip_lds_buf = 1,
         .prim_buf_gpu_addr = UINT64_C(0),
         .pos_buf_gpu_addr = UINT64_C(0),
         .cntl_sb_buf_gpu_addr = UINT64_C(0),
         .param_buf_gpu_addr = UINT64_C(0),
         .prim_buf_size = 0,
         .pos_buf_size = 0,
         .cntl_sb_buf_size = 0,
         .param_buf_size = 0,
         .wave_front_size = 64,
         .num_shader_visible_vgprs = 256,
         .num_cu_per_sh = 7,
         .num_tcc_blocks = 4,
         .gs_vgt_table_depth = 0,
         .gs_prim_buffer_depth = 0,
         .max_gs_waves_per_vgt = 32,
         .pcie_num_lanes = 16,
         .cu_ao_bitmap = {
            { 0x7f, 0x0, 0x0, 0x0, },
            { 0x7f, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
            { 0x0, 0x0, 0x0, 0x0, },
         },
         .high_va_offset = UINT64_C(0x0),
         .high_va_max = UINT64_C(0x0),
         .pa_sc_tile_steering_override = 0,
         .tcc_disabled_mask = UINT64_C(0),
         .min_engine_clock = UINT64_C(300000),
         .min_memory_clock = UINT64_C(150000),
         .tcp_cache_size = 0,
         .num_sqc_per_wgp = 0,
         .sqc_data_cache_size = 0,
         .sqc_inst_cache_size = 0,
         .gl1c_cache_size = 0,
         .gl2c_cache_size = 0,
         .mall_size = UINT64_C(0),
         .enabled_rb_pipes_mask_hi = 0,
      },
      .mem = {
         .vram = {
            .total_heap_size = UINT64_C(2147483648),
            .usable_heap_size = UINT64_C(2118266880),
            .heap_usage = UINT64_C(21352448),
            .max_allocation = UINT64_C(1588700160),
         },
         .cpu_accessible_vram = {
            .total_heap_size = UINT64_C(268435456),
            .usable_heap_size = UINT64_C(255901696),
            .heap_usage = UINT64_C(20828160),
            .max_allocation = UINT64_C(191926272),
         },
         .gtt = {
            .total_heap_size = UINT64_C(16746776576),
            .usable_heap_size = UINT64_C(16743417856),
            .heap_usage = UINT64_C(3883008),
            .max_allocation = UINT64_C(12557563392),
         },
      },
   }
};

const size_t num_amdgpu_devices = ARRAY_SIZE(amdgpu_devices);
