/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XtSetWMColormapWindows()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;


#define T_XtSetWMColormapWindows	1
char    *TestName = "XtSetWMColormapWindows";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Widget rowcolw_good;
Widget labelw_good;
Widget list[2];
Display *display;
Window window, *colormap_windows[2];
int count_return;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtSetWMColormapWindows-1.(A)");
	report_assertion("A successful call to void XtSetWMColormapWindows(widget,");
	report_assertion("list, count) when the widget widget is realized and count is");
	report_assertion("not zero shall set the WM_COLORMAP_WINDOWS property on the");
	report_assertion("window of the specified widget to a list of windows that are");
	report_assertion("the windows of those widgets on the list list which are");
	report_assertion("realized and have unique colormap resources.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_xt_hier("Tstwmcmw1", "XtSetWMColormapWindows");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good in rowcolw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello",rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Set WM_COLORMAP_WINDOWS property for rowcolw_good widget");
	list[0] = rowcolw_good;
	list[1] = labelw_good;
	XtSetWMColormapWindows(rowcolw_good, &list[0], 2);
	tet_infoline("TEST: WM_COLORMAP_WINDOWS property for rowcolw_good widget");
	display = XtDisplay(rowcolw_good);
	window = XtWindow(rowcolw_good);
	status = XGetWMColormapWindows(display, window, colormap_windows, &count_return);
	check_dec(True, status, "XGetWMColormapWindows return value");
	check_dec(window, *colormap_windows[0], "window id");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12087 */
/* End of included file Mdefcode.tmc.12087 */

static void t002(){

Widget rowcolw_good;
Widget labelw_good;
Widget list[2];
Display *display;
Window window, *colormap_windows[2];
int count_return;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtSetWMColormapWindows-2.(A)");
	report_assertion("A call to void XtSetWMColormapWindows(widget, list, count)");
	report_assertion("when the widget widget is not realized shall return");
	report_assertion("immediately.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	/*verify nothing catastrophic happens*/
	avs_xt_hier("Tstwmcmw1", "XtSetWMColormapWindows");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good in rowcolw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello",rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	list[0] = labelw_good;
	tet_infoline("PREP: Unrealize widget");
	XtUnrealizeWidget(rowcolw_good);
	tet_infoline("TEST: Set WM_COLORMAP_WINDOWS property for rowcolw_good widget");
	XtSetWMColormapWindows(rowcolw_good, &list[0], 1);
	tet_infoline("PREP: Realize widget");
	XtRealizeWidget(rowcolw_good);
	tet_infoline("TEST: WM_COLORMAP_WINDOWS property for rowcolw_good widget");
	display = XtDisplay(rowcolw_good);
	window = XtWindow(rowcolw_good);
	status = XGetWMColormapWindows(display, window, colormap_windows, &count_return);
	check_dec(False, status, "XGetWMColormapWindows return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12087 */
/* End of included file Mdefcode.tmc.12087 */

static void t003(){

Widget rowcolw_good;
Widget labelw_good;
Widget list[2];
Display *display;
Window window, *colormap_windows[2];
int count_return;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtSetWMColormapWindows-3.(A)");
	report_assertion("A call to void XtSetWMColormapWindows(widget, list, count)");
	report_assertion("when count is zero shall return immediately.");
	FORK(pid);
	initconfig();

	FORK(pid2);
	/*verify nothing catastrophic happens*/
	avs_xt_hier("Tstwmcmw1", "XtSetWMColormapWindows");
	tet_infoline("PREP: Create rowcolw_good widget in boxw1 widget");
	rowcolw_good = (Widget) CreateRowColWidget(boxw1);
	tet_infoline("PREP: Create labelw_good in rowcolw_good widget");
	labelw_good = (Widget) CreateLabelWidget("Hello",rowcolw_good);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Set WM_COLORMAP_WINDOWS property for rowcolw_good widget");
	list[0] = rowcolw_good;
	list[1] = labelw_good;
	XtSetWMColormapWindows(rowcolw_good, &list[0], 0);
	tet_infoline("TEST: WM_COLORMAP_WINDOWS property for rowcolw_good widget");
	display = XtDisplay(rowcolw_good);
	window = XtWindow(rowcolw_good);
	status = XGetWMColormapWindows(display, window, colormap_windows, &count_return);
	check_dec(False, status, "XGetWMColormapWindows return value");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
}

/* Including from file Mdefcode.tmc.12087 */
/* End of included file Mdefcode.tmc.12087 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
