/*
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   Boolean
 *   XtConvertAndStore()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <XtTest.h>

/*error messages created here*/
char	ebuf[4096];
/*allows a test to extend how long it runs*/
int	xt_tomultiple = 1;

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>
#include <X11/CoreP.h>

XtAppContext app_ctext;
Widget topLevel, panedw, boxw1, boxw2;
Widget labelw, rowcolw, click_quit;

unsigned char tchar[2] = {0,0};

#ifndef XavsRChar
#define XavsRChar "Char"
#endif
Boolean XtCVT_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	char *str = (char *) (from_val->addr);
	static unsigned char i;
	to_val->size = sizeof (unsigned char);
	to_val->addr = (XtPointer) &i;
	i = *str;
	avs_set_event(1, avs_get_event(1)+1);
	return True;
}
Boolean XtCVT2_StringToChar(display, args, num_args, from_val, to_val, converter_data)
Display *display;
XrmValuePtr args;
Cardinal *num_args;
XrmValue *from_val;
XrmValue *to_val;
XtPointer *converter_data;
{
	avs_set_event(1, avs_get_event(1)+1);
	return False;
}


#define T_XtConvertAndStore	1
char    *TestName = "XtConvertAndStore";



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(1);

	report_assertion("Assertion XtConvertAndStore-1.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with the conversion cache type specified as");
	report_assertion("XtCacheNone a successful call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall compute the additional arguments needed,");
	report_assertion("call the converter, store the converted value returned into");
	report_assertion("the location specified by to_in_out->addr, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheNone,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t002(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(2);

	report_assertion("Assertion XtConvertAndStore-2.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with the conversion cache type specified as");
	report_assertion("XtCacheNone a call to Boolean XtConvertAndStore(object,");
	report_assertion("from_type, from, to_type, to_in_out) shall not reuse the");
	report_assertion("results of a previous conversion.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheNone,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Call XtConvertAnd Store again");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked again");
	invoked = avs_get_event(1);
	check_dec(2, invoked, "XtCVT_StringToChar invocation count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t003(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(3);

	report_assertion("Assertion XtConvertAndStore-3.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with the conversion cache type specified as");
	report_assertion("XtCacheNone a call to Boolean XtConvertAndStore(object,");
	report_assertion("from_type, from, to_type, to_in_out) shall return False if");
	report_assertion("the conversion fails.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast2", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT2_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT2_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheNone,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT2_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t004(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(4);

	report_assertion("Assertion XtConvertAndStore-4.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheAll and the converter has not been previously called");
	report_assertion("with the specified arguments a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall compute the additional arguments needed,");
	report_assertion("call the converter, enter the result into the conversion");
	report_assertion("cache, store the converted value into the location specified");
	report_assertion("by to_in_out->addr, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t005(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(5);

	report_assertion("Assertion XtConvertAndStore-5.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheAll and the converter has been previously called with");
	report_assertion("the specified arguments a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall reuse the results of the previous");
	report_assertion("conversion.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Invoke resource converter again");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t006(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(6);

	report_assertion("Assertion XtConvertAndStore-6.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheAll and the converter has not been previously called");
	report_assertion("with the specified arguments a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall return False if the conversion fails.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast2", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT2_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT2_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT2_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t007(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(7);

	report_assertion("Assertion XtConvertAndStore-7.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheAll, the converter has been previously called with");
	report_assertion("the specified arguments, and the conversion failed a call to");
	report_assertion("Boolean XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall not perform the conversion and shall return");
	report_assertion("False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast2", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT2_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT2_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT2_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	tet_infoline("TEST: Invoke resource converter again");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT2_StringToChar was not invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t008(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(8);

	report_assertion("Assertion XtConvertAndStore-8.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheAll, the converter has been previously called with");
	report_assertion("the specified arguments, the conversion succeeded, and the");
	report_assertion("size specified by to_in_out is greater than or equal to the");
	report_assertion("size stored in the conversion cache a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall copy the information stored in the");
	report_assertion("conversion cache into the location specified by");
	report_assertion("to_in_out->addr, copy the size specified in the conversion");
	report_assertion("cache into to_in_out->size, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Call XtConvertAnd Store again with larger size");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char)+1;
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked again");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t009(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(9);

	report_assertion("Assertion XtConvertAndStore-9.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheAll, the converter has been previously called with");
	report_assertion("the specified arguments, the conversion succeeded, and the");
	report_assertion("size specified by the to_in_out argument is less than the");
	report_assertion("size stored in the conversion cache a call to Boolean");
	report_assertion("XtCallConverter(display, converter, args, num_args, from,");
	report_assertion("to_in_out, cache_ref_return) shall copy the size specified");
	report_assertion("in the conversion cache into to_in_out->size and shall");
	report_assertion("return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Call XtConvertAnd Store again with short size");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char)-1;
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was not invoked again");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t010(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(10);

	report_assertion("Assertion XtConvertAndStore-10.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheByDisplay and the converter has not been previously");
	report_assertion("called with the specified arguments a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall compute the additional arguments, call the");
	report_assertion("converter, enter the result into the conversion cache, store");
	report_assertion("the converted value into the location specified by");
	report_assertion("to_in_out->addr, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t011(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(11);

	report_assertion("Assertion XtConvertAndStore-11.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheByDisplay and the converter has been previously");
	report_assertion("called with the specified arguments a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall reuse the the previous conversion.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Invoke resource conversion again");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was not invoked again");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t012(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(12);

	report_assertion("Assertion XtConvertAndStore-12.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheByDisplay and the converter has not been previously");
	report_assertion("called with the specified arguments a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall return False if the conversion fails.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast2", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT2_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT2_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT2_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t013(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(13);

	report_assertion("Assertion XtConvertAndStore-13.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheByDisplay, the converter has been previously called");
	report_assertion("with the specified arguments, and the conversion failed a");
	report_assertion("call to Boolean XtConvertAndStore(object, from_type, from,");
	report_assertion("to_type, to_in_out) shall not perform the conversion and");
	report_assertion("shall return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast2", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT2_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT2_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT2_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	tet_infoline("TEST: Call XtConvertAnd Store again");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT2_StringToChar was not invoked again");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t014(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(14);

	report_assertion("Assertion XtConvertAndStore-14.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheByDisplay, the converter has been previously called");
	report_assertion("with the specified arguments, the conversion succeeded, and");
	report_assertion("the size specified by the to_in_out argument is greater than");
	report_assertion("or equal to the size stored in the conversion cache a call");
	report_assertion("to Boolean XtConvertAndStore(object, from_type, from,");
	report_assertion("to_type, to_in_out) shall copy the information stored in the");
	report_assertion("conversion cache into the location specified by");
	report_assertion("to_in_out->addr, copy the size specified in the conversion");
	report_assertion("cache into to_in_out->size, and return True.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Call XtConvertAnd Store again with larger size");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char)+1;
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was not invoked again");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t015(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(15);

	report_assertion("Assertion XtConvertAndStore-15.(A)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with conversion cache type specified as");
	report_assertion("XtCacheByDisplay, the converter has been previously called");
	report_assertion("with the specified arguments, the conversion succeeded, and");
	report_assertion("the size specified by the to_in_out argument is less than");
	report_assertion("the size stored in the conversion cache a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) shall copy the size specified in the conversion");
	report_assertion("cache into to_in_out->size and shall return False.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast1", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheByDisplay,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char);
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was invoked");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invoked status");
	tet_infoline("TEST: Result returned");
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Call XtConvertAnd Store again with shorter size");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	to_in_out.addr = (XtPointer) tchar;
	to_in_out.size = sizeof(unsigned char)-1;
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(False, status, "return value");
	tet_infoline("TEST: XtCVT_StringToChar was not invoked again");
	invoked = avs_get_event(1);
	check_dec(1, invoked, "XtCVT_StringToChar invocation count");
	tet_infoline("TEST: Size returned");
	check_dec((long)sizeof(unsigned char), (long)to_in_out.size, "to_in_out.size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

static void t016(){

Display *display_good;
XrmValue from;
XrmValue to_in_out;
XtCacheRef cache_ref_return;
int invoked = 0;
int status;
pid_t pid2;
pid_t	pid;

 	report_purpose(16);

	report_assertion("Assertion XtConvertAndStore-16.(A)");
	report_assertion("A successful call to Boolean XtConvertAndStore(object,");
	report_assertion("from_type, from, to_type, to_in_out) when to_in_out.addr is");
	report_assertion("NULL shall replace it with a pointer to a private storage in");
	report_assertion("which the conversion results are stored and return the size");
	report_assertion("in to_in_out->size.");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	FORK(pid2);
	avs_set_event(1, 0);
	avs_set_event(2, 0);
	avs_xt_hier("Tcnvrtast4", "XtConvertAndStore");
	ConfigureDimension(topLevel, boxw2);
	tet_infoline("PREP: Create windows for widgets and map them");
	XtRealizeWidget(topLevel);
	tet_infoline("TEST: Register resource converter XtCVT_StringToChar");
	XtAppSetTypeConverter(app_ctext,
		 XtRString,
		 XavsRChar,
		 XtCVT_StringToChar,
		 (XtConvertArgList)NULL,
		 (Cardinal)0,
		 XtCacheAll|XtCacheRefCount,
		 (XtDestructor)NULL);
	tet_infoline("TEST: Call XtConvertAnd Store to invoke resource converter");
	from.addr = (XtPointer) "Hello";
	from.size = sizeof(unsigned char);
	tchar[0] = 0;
	to_in_out.addr = NULL;
	to_in_out.size = 0;
	status = XtConvertAndStore(topLevel,
		 XtRString,
		 &from,
		 XavsRChar,
		 &to_in_out
		 );
	tet_infoline("TEST: Return status");
	check_dec(True, status, "return value");
	tet_infoline("TEST: Result returned");
	if (to_in_out.addr == NULL) {
		tet_infoline("ERROR: to_in_out.addr remained NULL");
		tet_result(TET_FAIL);
		exit(1);
	}
	check_char('H', *(char *)to_in_out.addr, "conversion result");
	tet_infoline("TEST: Size returned");
	check_dec(sizeof(unsigned char), to_in_out.size, "size");
	LKROF(pid2, AVSXTTIMEOUT-2);
	tet_result(TET_PASS);

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* Including from file Mdefcode.tmc.11626 */
/* End of included file Mdefcode.tmc.11626 */

/* Including from file Mdefcode.tmc.11626 */
static void t017(){

pid_t	pid;

 	report_purpose(17);

	report_assertion("Assertion XtConvertAndStore-17.(B)");
	report_assertion("When a converter has been registered for a conversion from");
	report_assertion("from_type to to_type for the application context associated");
	report_assertion("with object with the cache type set to XtCacheRefCount and");
	report_assertion("XtCacheAll or XtCacheByDisplay and a XtCacheRef value is");
	report_assertion("returned from the converter on a call to Boolean");
	report_assertion("XtConvertAndStore(object, from_type, from, to_type,");
	report_assertion("to_in_out) the XtCallbackReleaseCacheRef function shall be");
	report_assertion("added to the destroyCallback list of the specified object.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11626 */

/* Including from file Mdefcode.tmc.11626 */
static void t018(){

pid_t	pid;

 	report_purpose(18);

	report_assertion("Assertion XtConvertAndStore-18.(B)");
	report_assertion("The behavior of a call to Boolean XtConvertAndStore(object,");
	report_assertion("from_type, from, to_type, to_in_out) when object is not of");
	report_assertion("class Object or any subclass thereof.");
	report_assertion("Reason for omission: The statement in the X11 specification is not specific enough to write a test");

	avs_alloc_sem();
	FORK(pid);
	initconfig();

	UNTESTED;

	LKROF(pid, AVSXTTIMEOUT*xt_tomultiple);
	avs_free_sem();
}

/* End of included file Mdefcode.tmc.11626 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ t007, 7 },
	{ t008, 8 },
	{ t009, 9 },
	{ t010, 10 },
	{ t011, 11 },
	{ t012, 12 },
	{ t013, 13 },
	{ t014, 14 },
	{ t015, 15 },
	{ t016, 16 },
	{ t017, 17 },
	{ t018, 18 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = NULL;
void	(*tet_cleanup)() = NULL;
