/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
* Copyright (c) 2005 X.Org Foundation LLC
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Portions of this software are based on Xlib and X Protocol Test Suite.
* We have used this material under the terms of its copyright, which grants
* free use, subject to the conditions below.  Note however that those
* portions of this software that are based on the original Test Suite have
* been significantly revised and that all such revisions are copyright (c)
* 1995 Applied Testing and Technology, Inc.  Insomuch as the proprietary
* revisions cannot be separated from the freely copyable material, the net
* result is that use of this software is governed by the ApTest copyright.
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1990, 1991 by UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the name of UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  UniSoft
* makes no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot)
 *   Display *display;
 *   char *filename;
 *   Pixmap bitmap;
 *   unsigned int width;
 *   unsigned int height;
 *   int x_hot;
 *   int y_hot;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XWriteBitmapFile	1
char    *TestName = "XWriteBitmapFile";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display
#define A_PIXMAP bitmap
#define A_DRAWABLE bitmap


/*
 * Arguments to the XWriteBitmapFile function
 */
static Display *display;
static char *filename;
static Pixmap bitmap;
static unsigned int width;
static unsigned int height;
static int x_hot;
static int y_hot;


static int 	ValueReturn;


#include <sys/types.h>
#include <errno.h>
#include <sys/stat.h>

#ifndef S_IRUSR
#define XWBF_MODE 0x600
#else
#define XWBF_MODE (S_IRUSR|S_IXUSR)
#endif

#define XWBF_DIR "xwbf_dir"
#define XWBF_FILE "xwbf_dir/xwbf_file"

static char *xwbf_name = "xwbf_temp";

static Pixmap xwbf_bm = (Pixmap)0;

static unsigned char xwbf_data[]= {
	0x80, 0x00, 0x3f, 0xfe, 0x04, 0x07, 0x88, 0x41,
	0xfc, 0x09, 0x00, 0x80, 0x40, 0x20, 0x08, 0x04};
static unsigned int xwbf_width=16;
static unsigned int xwbf_height=8;

static void
xwbf_start()
{
	tpstartup();

	xwbf_bm = XCreateBitmapFromData(Dsp, DefaultRootWindow(Dsp),
		(char*)xwbf_data, xwbf_width, xwbf_height);
	regid(Dsp, (union regtypes *)&xwbf_bm, REG_PIXMAP);

	(void)unlink(xwbf_name);
}

static void
xwbf_clean()
{
	(void)unlink(filename);
	tpcleanup();
}


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	filename = xwbf_name;
	bitmap = xwbf_bm;
	width = xwbf_width;
	height = xwbf_height;
	x_hot = -1;
	y_hot = -1;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

	int ret;
	unsigned int w_ret, h_ret;
	Pixmap pm_ret;
	int x_h_ret, y_h_ret;
	XImage *good;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XWriteBitmapFile-1.(A)");
	report_assertion("A call to XWriteBitmapFile writes a bitmap to the file");
	report_assertion("filename in the X version 11 format and returns");
	report_assertion("BitmapSuccess.");

	report_strategy("Create a suitable bitmap.");
	report_strategy("Call XWriteBitmapFile to write the bitmap to file.");
	report_strategy("Verify that BitmapSucess was returned.");
	report_strategy("Read back bitmap with XReadBitmapFile.");
	report_strategy("Verify the bitmap was read back, and the details were correct.");

	xwbf_start();
	setargs();
/* Create a suitable bitmap. */
/* Call xname to write the bitmap to file. */
	startcall(display);
	if (isdeleted())
		return;
	ret=XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that BitmapSucess was returned. */
	if (ret != BitmapSuccess) {
		FAIL;
		report("%s did not return expected value.",
			TestName);
		report("Expected: %d (BitmapSuccess)", BitmapSuccess);
		report("Returned: %d", ret); 
	} else
		CHECK;

/* Read back bitmap with XReadBitmapFile. */
	ret=XReadBitmapFile(display, DefaultRootWindow(display),
		xwbf_name, &w_ret, &h_ret, &pm_ret, &x_h_ret, &y_h_ret);

/* Verify the bitmap was read back, and the details were correct. */
	if (ret != BitmapSuccess) {
		FAIL;
		report("XReadBitmapFile could not read back the bitmap file.");
	} else
		CHECK;

	if (w_ret != 16 || h_ret !=8) {
		FAIL;
		report("Read pixmap had incorrect width/height.");
		report("Expected width:16, height:8");
		report("Returned width:%d, height:%d", w_ret, h_ret);
	} else
		CHECK;

	if (x_h_ret != -1 || y_h_ret != -1) {
		FAIL;
		report("Read pixmap had incorrect hot spot.");
		report("Expected hotspot (x,y): -1,-1");
		report("Returned hotspot (x,y): %d,%d", x_h_ret, y_h_ret);
	} else
		CHECK;

	good=savimage(display, xwbf_bm);
	trace("savimage");
	if (!compsavimage(display, pm_ret, good)) {
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);

	xwbf_clean();
	pfcount(pass, fail);
}

static void t002(){

	int ret;
	unsigned int w_ret, h_ret;
	Pixmap pm_ret;
	int x_h_ret, y_h_ret;
	XImage *good;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XWriteBitmapFile-2.(A)");
	report_assertion("When x_hot and y_hot are not -1, then a call to");
	report_assertion("XWriteBitmapFile writes x_hot and y_hot as the hotspot");
	report_assertion("coordinates for the bitmap.");

	report_strategy("Create a suitable bitmap.");
	report_strategy("Call XWriteBitmapFile to write the bitmap to file, with non -1 x_hot and y_hot.");
	report_strategy("Verify that BitmapSucess was returned.");
	report_strategy("Read back bitmap with XReadBitmapFile.");
	report_strategy("Verify the bitmap was read back, and the details were correct.");

	xwbf_start();
	setargs();
/* Create a suitable bitmap. */
/* Call xname to write the bitmap to file, with non -1 x_hoy and y_hot. */
	x_hot = 6;
	y_hot = 3;
	startcall(display);
	if (isdeleted())
		return;
	ret=XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that BitmapSucess was returned. */
	if (ret != BitmapSuccess) {
		FAIL;
		report("%s did not return expected value.",
			TestName);
		report("Expected: %d (BitmapSuccess)", BitmapSuccess);
		report("Returned: %d", ret); 
	} else
		CHECK;

/* Read back bitmap with XReadBitmapFile. */
	ret=XReadBitmapFile(display, DefaultRootWindow(display),
		xwbf_name, &w_ret, &h_ret, &pm_ret, &x_h_ret, &y_h_ret);

/* Verify the bitmap was read back, and the details were correct. */
	if (ret != BitmapSuccess) {
		FAIL;
		report("XReadBitmapFile could not read back the bitmap file.");
	} else
		CHECK;

	if (w_ret != 16 || h_ret !=8) {
		FAIL;
		report("Read pixmap had incorrect width/height.");
		report("Expected width:16, height:8");
		report("Returned width:%d, height:%d", w_ret, h_ret);
	} else
		CHECK;

	if (x_h_ret != 6 || y_h_ret != 3) {
		FAIL;
		report("Read pixmap had incorrect hot spot.");
		report("Expected hotspot (x,y): 6,3");
		report("Returned hotspot (x,y): %d,%d", x_h_ret, y_h_ret);
	} else
		CHECK;

	good=savimage(display, xwbf_bm);
	trace("savimage");
	if (!compsavimage(display, pm_ret, good)) {
		FAIL;
	} else
		CHECK;

	CHECKPASS(5);

	xwbf_clean();
	pfcount(pass, fail);
}

static void t003(){

int ret;
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XWriteBitmapFile-3.(A)");
	report_assertion("When the file filename cannot be opened for writing, then a");
	report_assertion("call to XWriteBitmapFile returns BitmapOpenFailed.");

	report_strategy("Create a suitable bitmap.");
	report_strategy("Create an unwritable directory.");
	report_strategy("Call XWriteBitmapFile to write the bitmap file.");
	report_strategy("Verify that a BitmapOpenFailed error occurred.");

	xwbf_start();
	setargs();
/* Writing won't fail even if the permissions say it should if we're root. */
	if(geteuid() == 0) {
	    report("File permissions cannot be tested as root.");
	    UNTESTED;
	    return;
	}

/* Create a suitable bitmap. */
/* Create an unwritable directory. */
	if(mkdir(XWBF_DIR, XWBF_MODE)) {
		int en = errno;
		delete("Could not create the test subdirectory.");
		report("errno %d", en);
		return;
	} else
		CHECK;

/* Call xname to write the bitmap file. */
	filename = XWBF_FILE;
	startcall(display);
	if (isdeleted())
		return;
	ret = XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

/* Verify that a BitmapOpenFailed error occurred. */
	if (ret != BitmapOpenFailed) {
		FAIL;
		report("%s did not return expected value.",
		       TestName);
		report("Expected %d (BitmapOpenFailed)", BitmapOpenFailed);
		report("Returned %d", ret);
	} else
		CHECK;

	CHECKPASS(2);

	unlink(XWBF_FILE);
	rmdir(XWBF_DIR);

	xwbf_clean();
	pfcount(pass, fail);
}

/* Including from file Mdefcode.tmc.10164 */
static void t004(){

int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XWriteBitmapFile-4.(B)");
	report_assertion("When insufficient memory is allocated, then a call to");
	report_assertion("XWriteBitmapFile returns BitmapNoMemory.");
	report_assertion("Reason for omission: There is no known portable test method for this assertion");

	report_strategy("Report UNTESTED");

	xwbf_start();
	setargs();
	UNTESTED;
	xwbf_clean();
	pfcount(pass, fail);
}

/* End of included file Mdefcode.tmc.10164 */

static void t005(){

int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XWriteBitmapFile-5.(A)");
	report_assertion("When width and height are greater than the corresponding");
	report_assertion("dimensions of the bitmap, then on a call to");
	report_assertion("XWriteBitmapFile a BadMatch error occurs.");

	report_strategy("Create a suitable bitmap.");
	report_strategy("Call XWriteBitmapFile to write the bitmap to file, with the width and height");
	report_strategy("	bigger than the bitmap.");
	report_strategy("Verify that BadMatch occurred.");

	xwbf_start();
	setargs();
/* Create a suitable bitmap. */
/* Call xname to write the bitmap to file, with the width and height */
/* 	bigger than the bitmap. */
	width=256;
	height=512;
	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

/* Verify that BadMatch occurred. */
	if (geterr() != BadMatch) {
		FAIL;
	} else
		CHECK;
	
	CHECKPASS(1);

	xwbf_clean();
	pfcount(pass, fail);
}

/* Including from file error/EDra.mc */
/* End of included file error/EDra.mc */

/* Including from file error/EDra.mc */
static void t006(){

int 	pass = 0, fail = 0;

 	report_purpose(6);

	report_assertion("Assertion XWriteBitmapFile-6.(A)");
	report_assertion("When a drawable argument does not name a valid Drawable,");
	report_assertion("then a BadDrawable error occurs.");

	report_strategy("Create a bad drawable by creating and destroying a window.");
	report_strategy("Call test function using bad drawable as the drawable argument.");
	report_strategy("Verify that a BadDrawable error occurs.");

	xwbf_start();
	setargs();
	seterrdef();

	A_DRAWABLE = (Drawable)badwin(A_DISPLAY);

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XWriteBitmapFile(display, filename, bitmap, width, height, x_hot, y_hot);
	endcall(display);
	if (geterr() != BadDrawable) {
		report("Got %s, Expecting BadDrawable", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadDrawable)
		PASS;
	else
		FAIL;
	xwbf_clean();
	pfcount(pass, fail);
}

/* End of included file error/EDra.mc */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ t006, 6 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
