/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) 2002 The Open Group
* Copyright (c) Applied Testing and Technology, Inc. 1993, 1994, 1995
* Copyright (c) 88open Consortium, Ltd. 1990, 1991, 1992, 1993
* All Rights Reserved.
* 
*/
/*
 * SYNOPSIS:
 *   void
 *   XrmEnumerateDatabase()
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <locale.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Xresource.h>
#include <X11/Xproto.h>
#include <X11/Xcms.h>
#include <xtestlib.h>
#include <tet_api.h>
#include <r5structs.h>
#include <r5decl.h>
/*error messages created here*/
char	ebuf[4096];

#define T_XrmEnumerateDatabase	1
char    *TestName = "XrmEnumerateDatabase";




char	*file_name_good = "xtestinfo.dat";
XrmDatabase	database_id_good = NULL;
XrmDatabase gfd_return, gfd_return2;

char		*contents_name_good = "test.Quark:happy\n";
XrmNameList 	quark_name;

char *exec_file_name;
int x_init, y_init, h_init, w_init;

typedef struct _SampleData {
    char *name;
    XrmRepresentation type;
    XrmValuePtr value;
} SampleData;

/*ARGSUSED*/
static Bool 
SearchFunc(db, bindings, quarks, type, value, data)
XrmDatabase         *db;
XrmBindingList      bindings;
XrmQuarkList        quarks;
XrmRepresentation   *type;
XrmValuePtr         value;
XPointer            data;
{
    SampleData *gd = (SampleData *)data;

    /* may as well return True */
    if ((*type == gd->type) && (value->size == gd->value->size) &&
        !strncmp((char *)value->addr, (char *)gd->value->addr, value->size))
    {
        gd->name = XrmQuarkToString(*quarks); /* XXX */
    }

    return True;
}

/*ARGSUSED*/
static Bool 
FalseFunc(db, bindings, quarks, type, value, data)
XrmDatabase         *db;
XrmBindingList      bindings;
XrmQuarkList        quarks;
XrmRepresentation   *type;
XrmValuePtr         value;
XPointer            data;
{
    return False;
}



int 	tet_thistest;

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

#if XT_X_RELEASE > 4
	extern int  signal_status();
	extern int  unexp_err();
	extern char *strcpy();
        Bool      svc_ret_value;
	char buf[9];
	XrmValue resval;
	XrmQuark empty = NULLQUARK;
	SampleData data;
	XrmDatabase  database ;
#endif

 	report_purpose(1);

	report_assertion("Assertion XrmEnumerateDatabase-1.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmEnumerateDatabase shall invoke the procedure proc for");
	report_assertion("each resource in the database that would match given");
	report_assertion("name/class resource prefix and return True.");

#if XT_X_RELEASE > 4
	display_arg = Dsp;

	/*
 	* Create a GC to save environmental data in
 	*/
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

        XrmInitialize();

	sprintf(buf, "%s", "test");
	resval.addr = (XPointer)buf;
	resval.size = strlen(buf) + 1;
	data.name = (char *)NULL;
	data.type = XrmPermStringToQuark("String");
	data.value = &resval;

	tet_infoline("PREP: Create a database");
	database = XrmGetStringDatabase(contents_name_good);
	XrmPutStringResource(&database, "test.Quark", "happy");

	tet_infoline("PREP: Associate the database with display");
	XrmSetDatabase(display_arg, database);

/*
	XrmStringToNameList("test*Quark", quark_name);
*/

	tet_infoline("TEST: XrmEnumerateDatabase calls the procedure");
	XSync(display_arg, 0);

	XSetErrorHandler(signal_status);
	svc_ret_value = XrmEnumerateDatabase(
		   database, (XrmNameList)&empty,
		   (XrmClassList)&empty, XrmEnumAllLevels,
		   SearchFunc, (XPointer)&data );
	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          

	if (svc_ret_value != True)
	{
		tet_infoline("ERROR: xname did not return correct value");
		sprintf(ebuf, "      Expected: %d(True) Got: %d", True, svc_ret_value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9910 */
/* End of included file Mdefcode.tmc.9910 */

static void t002(){

#if XT_X_RELEASE > 4
	extern int  signal_status();
	extern int  unexp_err();
	extern char *strcpy();
        Bool      svc_ret_value;
	char buf[9];
	XrmValue resval;
	XrmQuark empty = NULLQUARK;
	SampleData data;
	XrmDatabase  database ;
#endif

 	report_purpose(2);

	report_assertion("Assertion XrmEnumerateDatabase-2.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmEnumerateDatabase when the called procedure returns True");
	report_assertion("shall return True.");

#if XT_X_RELEASE > 4
	display_arg = Dsp;

	/*
 	* Create a GC to save environmental data in
 	*/
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

        XrmInitialize();

	sprintf(buf, "%s", "test");
	resval.addr = (XPointer)buf;
	resval.size = strlen(buf) + 1;
	data.name = (char *)NULL;
	data.type = XrmPermStringToQuark("String");
	data.value = &resval;

	tet_infoline("PREP: Create a database");
	database = XrmGetStringDatabase(contents_name_good);
	XrmPutStringResource(&database, "test.Quark", "happy");

	tet_infoline("PREP: Associate the database with display");
	XrmSetDatabase(display_arg, database);

	tet_infoline("TEST: XrmEnumerateDatabase returns True.");
	XSync(display_arg, 0);

	XSetErrorHandler(signal_status);
	svc_ret_value = XrmEnumerateDatabase(
		   database, (XrmNameList)&empty,
		   (XrmClassList)&empty, XrmEnumAllLevels,
		   SearchFunc, (XPointer)&data );
	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          

	if (svc_ret_value != True)
	{
		tet_infoline("ERROR: xname did not return correct value");
		sprintf(ebuf, "      Expected: %d(True) Got: %d", True, svc_ret_value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9910 */
/* End of included file Mdefcode.tmc.9910 */

static void t003(){

#if XT_X_RELEASE > 4
	extern int  signal_status();
	extern int  unexp_err();
	extern char *strcpy();
        Bool      svc_ret_value;
	char buf[9];
	XrmValue resval;
	XrmQuark empty = NULLQUARK;
	SampleData data;
	XrmDatabase  database ;
#endif

 	report_purpose(3);

	report_assertion("Assertion XrmEnumerateDatabase-3.(C)");
	report_assertion("If the implementation is X11R5 or later: A call to");
	report_assertion("XrmEnumerateDatabase when the called procedure returns False");
	report_assertion("shall terminate the enumeration and return False.");

#if XT_X_RELEASE > 4
	display_arg = Dsp;

	/*
 	* Create a GC to save environmental data in
 	*/
	gc_save = XCreateGC(display_arg,XRootWindow(display_arg,XDefaultScreen(display_arg)),(unsigned long)0,(XGCValues *)0);

        XrmInitialize();

	sprintf(buf, "%s", "test");
	resval.addr = (XPointer)buf;
	resval.size = strlen(buf) + 1;
	data.name = (char *)NULL;
	data.type = XrmPermStringToQuark("String");
	data.value = &resval;

	tet_infoline("PREP: Create a database");
	database = XrmGetStringDatabase(contents_name_good);
	XrmPutStringResource(&database, "test.Quark", "happy");

	tet_infoline("PREP: Associate the database with display");
	XrmSetDatabase(display_arg, database);

	tet_infoline("TEST: XrmEnumerateDatabase returns False.");
	XSync(display_arg, 0);

	XSetErrorHandler(signal_status);
	svc_ret_value = XrmEnumerateDatabase(
		   database, (XrmNameList)&empty,
		   (XrmClassList)&empty, XrmEnumAllLevels,
		   FalseFunc, (XPointer)&data );
	XSync(display_arg, 0);
	XSetErrorHandler(unexp_err);          

	if (svc_ret_value != False)
	{
		tet_infoline("ERROR: xname did not return correct value");
		sprintf(ebuf, "      Expected: %d(False) Got: %d", False, svc_ret_value);
		tet_infoline(ebuf);
		tet_result(TET_FAIL);
	}

	tet_result(TET_PASS);
#else
	tet_infoline("INFO: Implementation not X11R5 or greater");
	tet_result(TET_UNSUPPORTED);
#endif
}

/* Including from file Mdefcode.tmc.9910 */
/* End of included file Mdefcode.tmc.9910 */

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = r5_startup;
void	(*tet_cleanup)() = r5_cleanup;
