/*
* Copyright (c) 2005 X.Org Foundation L.L.C.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy of
* this software and associated documentation files (the "Software"), to deal in
* the Software without restriction, including without limitation the rights to
* use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
* of the Software, and to permit persons to whom the Software is furnished to do
* so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
* 
* Copyright (c) Applied Testing and Technology, Inc. 1995
* All Rights Reserved.
* 
* 
* Copyright (c) 1990, 1991  X Consortium
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
* X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
* AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
* CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
* 
* Except as contained in this notice, the name of the X Consortium shall not be
* used in advertising or otherwise to promote the sale, use or other dealings
* in this Software without prior written authorization from the X Consortium.
* 
* Copyright 1993 by the Hewlett-Packard Company.
* 
* Copyright 1990, 1991 UniSoft Group Limited.
* 
* Permission to use, copy, modify, distribute, and sell this software and
* its documentation for any purpose is hereby granted without fee,
* provided that the above copyright notice appear in all copies and that
* both that copyright notice and this permission notice appear in
* supporting documentation, and that the names of HP, and UniSoft not be
* used in advertising or publicity pertaining to distribution of the
* software without specific, written prior permission.  HP, and UniSoft
* make no representations about the suitability of this software for any
* purpose.  It is provided "as is" without express or implied warranty.
* 
*/
/*
 * SYNOPSIS:
 *   int
 *   XGetDeviceButtonMapping(display, device, map_return, nmap)
 *   Display	*display;
 *   XDevice	*device;
 *   unsigned char	*map_return;
 *   int 	nmap;
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>
#include	"xtest.h"
#include	"X11/Xlib.h"
#include	"X11/Xutil.h"
#include	"X11/Xresource.h"
#include	"X11/keysym.h"
#include	"tet_api.h"
#include	"xtestlib.h"
#include	"pixval.h"
#ifdef INPUTEXTENSION
#include        "X11/extensions/XInput.h"
#include        "XItest.h"
#endif

extern	Display	*Dsp;
extern	Window	Win;

extern	Window	ErrdefWindow;
extern	Drawable ErrdefDrawable;
extern	GC		ErrdefGC;
extern	Colormap ErrdefColormap;
extern	Pixmap	ErrdefPixmap;
extern	Atom	ErrdefAtom;
extern	Cursor	ErrdefCursor;
extern	Font	ErrdefFont;


#define T_XGetDeviceButtonMapping	1
char    *TestName = "XGetDeviceButtonMapping";

/*
 * Defines for different argument types
 */
#define A_DISPLAY display


/*
 * Arguments to the XGetDeviceButtonMapping function
 */
static Display	*display;
static XDevice	*device;
static unsigned char	*map_return;
static int 	nmap;


static int 	ValueReturn;

extern ExtDeviceInfo Devs;

/*
 * The number of buttons should be between 1 and 255
 */
#define	MAPSIZE	255
static	unsigned char	Map[MAPSIZE];


int 	tet_thistest;

/*
 * Called at the beginning of each test purpose to reset the
 * arguments to their initial values
 */
static void
setargs()
{
	display = Dsp;
	device = 0;
	map_return = Map;
	nmap = MAPSIZE;
}

/*
 * Set the arguments to default values for error tests
 */
static void
seterrdef()
{
}

static void t001(){

int 	nbuttons;
int 	pass = 0, fail = 0;

 	report_purpose(1);

	report_assertion("Assertion XGetDeviceButtonMapping-1.(B)");
	report_assertion("A call to XGetDeviceButtonMapping returns in map_return[i]");
	report_assertion("the logical button numbers of the physical buttons i+1.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Call XGetDeviceButtonMapping to get pointer mapping.");
	report_strategy("UNTESTED touch test only.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetDeviceButtonMapping(display, device, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	report("This assertion is tested elsewhere.");
	UNTESTED;


	tpcleanup();
	pfcount(pass, fail);
}

static void t002(){

int 	i, j, nbuttons, ndevices;
XDeviceInfo *list;
XAnyClassPtr any;
int 	pass = 0, fail = 0;

 	report_purpose(2);

	report_assertion("Assertion XGetDeviceButtonMapping-2.(B)");
	report_assertion("A call to XGetDeviceButtonMapping returns the number of");
	report_assertion("physical buttons actually on the pointer.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Compare the number of buttons returned by XGetDeviceButtonMapping and XListInputDevices.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetDeviceButtonMapping(display, device, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}
	list = XListInputDevices(display, &ndevices);
	for (i=0; i<ndevices; i++,list++)
	    {
	    if (list->id==Devs.Button->device_id)
		{
		any = (XAnyClassPtr) (list->inputclassinfo);
		for (j=0; j<list->num_classes; j++)
		    {
		    if (any->class == ButtonClass)
			{
			if (((XButtonInfo *) any)->num_buttons == nbuttons)
			    PASS;
			else
			    {
			    report("# buttons returned doesn't match XListInputDevices.");
			    FAIL;
			    }
			break;
			}
	    	    any = (XAnyClassPtr) ((char *) any + any->length);
		    }
		break;
		}
	    }

	tpcleanup();
	pfcount(pass, fail);
}

static void t003(){

int 	nbuttons;
int 	i;
#define	TEST_VAL	((unsigned char)255)
int 	pass = 0, fail = 0;

 	report_purpose(3);

	report_assertion("Assertion XGetDeviceButtonMapping-3.(B)");
	report_assertion("When the nmap argument is less than the number of elements");
	report_assertion("in the pointer mapping, then only the first nmap elements");
	report_assertion("are returned in map_return.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Set all elements of map_return to 255.");
	report_strategy("Set nmap to a value less than number of elements in the pointer mapping.");
	report_strategy("Call XGetDeviceButtonMapping.");
	report_strategy("Verify that elements of map_return beyond nmap-1 are still 255.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	device = Devs.Button;
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetDeviceButtonMapping(display, device, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = 0; i < MAPSIZE; i++)
		Map[i] = TEST_VAL;

	/*
	 * Its not clear that asking for 0 elements is really sensible so we
	 * only do it when there is only one button.
	 */
	if (nbuttons == 1)
		nmap = 0;
	else
		nmap = 1;

	startcall(display);
	if (isdeleted())
		return;
	ValueReturn = XGetDeviceButtonMapping(display, device, map_return, nmap);
	endcall(display);
	if (geterr() != Success) {
		report("Got %s, Expecting Success", errorname(geterr()));
		FAIL;
	}

	for (i = nmap; i < MAPSIZE; i++) {
		if (Map[i] != TEST_VAL) {
			report("An element beyond the first nmap was returned");
			report(" element %d was %u, expecting %u", i, (unsigned)Map[i],
				(unsigned)TEST_VAL);
			FAIL;
		} else
			CHECK;
	}

	CHECKPASS(MAPSIZE-nmap);
	tpcleanup();
	pfcount(pass, fail);
}

static void t004(){

int 	nbuttons;
int 	pass = 0, fail = 0;

 	report_purpose(4);

	report_assertion("Assertion XGetDeviceButtonMapping-4.(B)");
	report_assertion("If the specified device does not have any buttons, a");
	report_assertion("BadMatch error is returned.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify a device that is known to have no buttons.  Verify that a BadMatch");
	report_strategy("error is returned.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(NBtnsMask))
	    {
	    untested("%s: No input device without buttons.\n", TestName);
	    return;
	    }
	device = Devs.NoButtons;
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetDeviceButtonMapping(display, device, map_return, nmap);
	endcall(display);
	if (geterr() != BadMatch) {
		report("Got %s, Expecting BadMatch", errorname(geterr()));
		FAIL;
	}

	if (geterr() == BadMatch)
		PASS;
	else {
		report("No BadMatch for device with no buttons");
		FAIL;
		}
	tpcleanup();
	pfcount(pass, fail);
}

static void t005(){

XDevice bogus;
int 	nbuttons, baddevice;
int 	pass = 0, fail = 0;

 	report_purpose(5);

	report_assertion("Assertion XGetDeviceButtonMapping-5.(B)");
	report_assertion("If the specified device is invalid a BadDevice error is");
	report_assertion("returned.");
	report_assertion("Reason for omission: There is no known reliable test method for this assertion");

	report_strategy("Specify the X pointer device.  Verify that a BadDevice error is returned.");

	tpstartup();
	setargs();
	if (!Setup_Extension_DeviceInfo(BtnMask))
	    {
	    untested("%s: No input extension button device.\n", TestName);
	    return;
	    }
	BadDevice(display,baddevice);
	device = &bogus;
	device->device_id = -1;
	startcall(display);
	if (isdeleted())
		return;
	nbuttons = XGetDeviceButtonMapping(display, device, map_return, nmap);
	endcall(display);
	if (geterr() != baddevice) {
		report("Got %s, Expecting baddevice", errorname(geterr()));
		FAIL;
	}

	if (geterr() == baddevice)
		PASS;
	else {
		report("No BadDevice for x pointer device");
		FAIL;
		}
	tpcleanup();
	pfcount(pass, fail);
}

/* End of Test Cases */


struct tet_testlist tet_testlist[] = {
	{ t001, 1 },
	{ t002, 2 },
	{ t003, 3 },
	{ t004, 4 },
	{ t005, 5 },
	{ NULL, 0 }
};

int 	ntests = sizeof(tet_testlist)/sizeof(struct tet_testlist)-1;

void	(*tet_startup)() = startup;
void	(*tet_cleanup)() = cleanup;
