'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbSetDebuggingFlags __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbSetDebuggingFlags \- Change the values of any of the debug controls
.SH SYNOPSIS
.HP
.B Bool XkbSetDebuggingFlags
.BI "(\^Display *" "display" "\^,"
.BI "unsigned int " "mask" "\^,"
.BI "unsigned int " "flags" "\^,"
.BI "char *" "msg" "\^,"
.BI "unsigned int " "ctrls_mask" "\^,"
.BI "unsigned int " "ctrls" "\^,"
.BI "unsigned int *" "ret_flags" "\^,"
.BI "unsigned int *" "ret_ctrls" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- display
connection to X server
.TP
.I \- mask
mask selecting debug output flags to change
.TP
.I \- flags
values for debug output flags selected by mask
.TP
.I \- msg
message to print right now
.TP
.I \- ctrls_mask
mask selecting debug controls to change 
.TP
.I \- ctrls
values for debug controls selected by ctrls_mask
.TP
.I \- ret_flags
resulting state of all debug output flags
.TP
.I \- ret_ctrls
resulting state of all debug controls
.SH DESCRIPTION
.LP
The debugging aids are intended for use primarily by Xkb implementors and are 
optional in any implementation.

There are two bitmasks that may be used to control debugging. One bitmask 
controls the output of debugging information, and the other controls behavior. 
Both bitmasks are initially all zeros.

To change the values of any of the debug controls, use 
.I XkbSetDebuggingFlags.

.I XkbSetDebuggingFlags 
modifies the debug output flags as specified by 
.I mask 
and 
flags, 
modifies the debug controls flags as specified by 
.I ctrls_mask 
and 
ctrls, 
prints the message 
.I msg, 
and backfills 
.I ret_flags 
and 
.I ret_ctrls 
with the resulting debug output and debug controls flags. 

When bits are set in the debug output masks, 
.I mask 
and 
.I flags, 
Xkb prints debug information corresponding to each bit at appropriate points 
during its processing. The device to which the output is written is 
implementation-dependent, but is normally the same device to which X server 
error messages are directed; thus the bits that can be set in 
.I mask 
and 
.I flags 
is implementation-specific. To turn on a debug output selection, set the bit for 
the output in the 
.I mask 
parameter and set the corresponding bit in the 
.I flags 
parameter. To turn off event selection for an event, set the bit for the output 
in the 
.I mask 
parameter and do not set the corresponding bit in the 
.I flags 
parameter.

When bits are set in the debug controls masks, 
.I ctrls_mask 
and 
.I ctrls, 
Xkb modifies its behavior according to each controls bit. 
.I ctrls_mask 
and 
ctrls 
are related in the same way that 
.I mask 
and 
.I flags 
are. The valid controls bits are defined in Table 1.

.TS
c s s
l l l.
Table 1 Debug Control Masks
_
Debug Control Mask	Value	Meaning
_
XkbDF_DisableLocks	(1 << 0)	Disable actions that lock modifiers
.TE

.I XkbSetDebuggingFlags 
returns True if successful and False otherwise. The only protocol error it may 
generate is BadAlloc, if for some reason it is unable to allocate storage. 

.I XkbSetDebuggingFlags 
is intended for developer use and may be disabled in production X servers. If it 
is disabled, 
.I XkbSetDebuggingFlags 
has no effect and does not generate any protocol errors.

The message in 
.I msg 
is written immediately. The device to which it is written is implementation 
dependent but is normally the same device where X server error messages are 
directed. 
.SH "RETURN VALUES"
.TP 15
True
The 
.I XkbSetDebuggingFlags 
function returns True when successful.
.TP 15
False
The 
.I XkbSetDebuggingFlags 
function returns False when not successful.
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
