.\" radeonhd.man based on formatting used in the xf86-video-{ati,nv} radeon.man, nv.man
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.\"
.\"
.TH RADEONHD __drivermansuffix__ __vendorversion__
.\"
.\"
.SH NAME
radeonhd \- AMD GPG (ATI) R5xx/R6xx/R7xx video driver
.\"
.\"
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qradeonhd\*q"
\ \ ...
.B EndSection
.fi
.\"
.\"
.SH DESCRIPTION
.B radeonhd
is an __xservername__ driver for AMD GPG (ATI) R5xx/R6xx/R7xx based video cards.

At the time of this writing,
.B radeonhd
has the following limitations:
.\".TP "\w'\fB\(bu\fR'u+1n"
.TP 2
\(bu
Support for hardware-based 2D acceleration and Xvideo needs more testing on
R6xx and R7xx based cards.
.TP
\(bu
No TV and Component connector support so far.
.TP
\(bu
After using the
.I fglrx
driver,
.B radeonhd
might fail to work properly. This combination is not and probably will never be
supported.  A reboot fixes problems in most cases, sometimes a powercycle is
necessary.  Unloading the kernel module is typically not enough.
.PP
A more up-to-date list can be found on the wiki page.
.PP
.\"
.SH SUPPORTED HARDWARE
The
.B radeonhd
driver supports video cards based on the following ATI chips:
.PP
.PD 0
.\" This list is generated from the RHDIdentify() function in src/rhd_id.c.
.\" START_DEVICE_LIST marker - do not delete
.TP 8
.B RV505
Radeon X1550, X1550 64bit
.TP 8
.B RV515
Radeon X1300, X1550, X1600; FireGL V3300, V3350
.TP 8
.B RV516
Radeon X1300, X1550, X1550 64-bit, X1600; FireMV 2250
.TP 8
.B R520
Radeon X1800; FireGL V5300, V7200, V7300, V7350
.TP 8
.B RV530
Radeon X1300 XT, X1600, X1600 Pro, X1650; FireGL V3400, V5200
.TP 8
.B RV535
Radeon X1300, X1650
.TP 8
.B RV550
Radeon X2300 HD
.TP 8
.B RV560
Radeon X1650
.TP 8
.B RV570
Radeon X1950, X1950 GT; FireGL V7400
.TP 8
.B R580
Radeon X1900, X1950; AMD Stream Processor
.TP 8
.B R600
Radeon HD 2900 GT/Pro/XT; FireGL V7600/V8600/V8650
.TP 8
.B RV610
Radeon HD 2350, HD 2400 Pro/XT, HD 2400 Pro AGP; FireGL V4000
.TP 8
.B RV620
Radeon HD 3450, HD 3470
.TP 8
.B RV630
Radeon HD 2600 LE/Pro/XT, HD 2600 Pro/XT AGP; Gemini RV630;
FireGL V3600/V5600
.TP 8
.B RV635
Radeon HD 3650, HD 3670
.TP 8
.B RV670
Radeon HD 3690, 3850, HD 3870, FireGL V7700, FireStream 9170
.TP 8
.B R680
Radeon HD 3870 X2
.TP 8
.B M52
Mobility Radeon X1300
.TP 8
.B M54
Mobility Radeon X1400; M54-GL
.TP 8
.B M56
Mobility Radeon X1600; Mobility FireGL V5200
.TP 8
.B M58
Mobility Radeon X1800, X1800 XT; Mobility FireGL V7100, V7200
.TP 8
.B M62
Mobility Radeon X1350
.TP 8
.B M64
Mobility Radeon X1450, X2300
.TP 8
.B M66
Mobility Radeon X1700, X1700 XT; FireGL V5250
.TP 8
.B M68
Mobility Radeon X1900
.TP 8
.B M71
Mobility Radeon HD 2300
.TP 8
.B M72
Mobility Radeon HD 2400; Radeon E2400
.TP 8
.B M74
Mobility Radeon HD 2400 XT
.TP 8
.B M76
Mobility Radeon HD 2600;
(Gemini ATI) Mobility Radeon HD 2600 XT
.TP 8
.B M82
Mobility Radeon HD 3400
.TP 8
.B M86
Mobility Radeon HD 3650, HD 3670, Mobility FireGL V5700
.TP 8
.B M88
Mobility Radeon HD 3850, HD 3850 X2, HD 3870, HD3870 X2
.TP 8
.B RS600
Radeon Xpress 1200, Xpress 1250
.TP 8
.B RS690
Radeon X1200, X1250, X1270
.TP 8
.B RS740
RS740, RS740M
.TP 8
.B RS780
Radeon HD 3100/3200/3300 Series
.TP 8
.B R700
Radeon R700
.TP 8
.B RV710
Radeon HD4570, HD4350
.TP 8
.B RV730
Radeon HD4670, HD4650
.TP 8
.B RV740
Radeon HD4770. EXPERIMENTAL AND UNTESTED
.TP 8
.B RV770
Radeon HD 4800 Series; Everest, K2, Denali ATI FirePro
.TP 8
.B RV790
Radeon HD 4890
.TP 8
.B M92
Mobility Radeon HD4330, HD4530, HD4570. EXPERIMENTAL
.TP 8
.B M93
Mobility Radeon M93. EXPERIMENTAL AND UNTESTED
.TP 8
.B M96
Mobility Radeon HD4600
.TP 8
.B M97
Mobility Radeon HD4860. EXPERIMENTAL AND UNTESTED
.TP 8
.B M98
Mobility Radeon HD4850, HD4870
.\" END_DEVICE_LIST marker - do not delete
.PD
.\"
.\"
.PP
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general
configuration details.
.P
This section only covers configuration options
specific to this driver, for
.BR "Section \*qDevice\*q" .
Some options may be deprecated and considered to be
removed or replaced by better implementations soon.
.\"
.TP
.BI "Option \*qAccelMethod\*q \*q" none|default|shadowfb|xaa|exa \*q
Use the indicated accleration method.
.RS
.TP 9
.PD 0
.B none
does not accelerate anything at all. Discouraged.
.TP
.B shadowfb
is a software-only acceleration technique. Does not work together with
DRI at the moment.
.TP
.B xaa
is the older but stable hardware-based acceleration technique.
.TP
.B exa
is the newer but more experimental hardware-based acceleration technique.
.RE
.RS
.PD
.PP
Default value
.B depends on the chipset
and the acceleration techniques available for that chipset, and is chosen to
give the best user experience.
.PP
Note that R600 and above require
.BR DRI
to be enabled for "exa".
.PP
Rotation isn't supported for the AccelMethods \*qnone\*q and \*qshadowfb\*q.
.RE
.TP
.BI "Option \*qDRI\*q"
Use this option to enable 3D and Xv acceleration using DRI.
Default is
.B on.
.TP
.BI "Option \*qOffscreenSize\*q \*q" <integer>M|<integer>% \*q
Specify the amount of framebuffer memory used for offscreen pixmaps, in
megabytes or percent of available memory. This amount of memory is not
available for DRI. Certain hardware and software limits apply. The default
is
.BR 10% .
.TP
.BI "Option \*qScaleType\*q \*q" none|center|scale|scale_keep_aspect_ratio|default \*q
Sets the scaling mode for laptop flat panels when used together with an external
screen. The scaling engine is capable of scaling both up and down.
.RS
.TP 9
.PD 0
.B none
means to not scale at all, i.e. the image will be displayed in the top left
corner of the panel if the resolution of the external display is lower than
the panel resolution.
.TP
.B center
means not to scale but center the image on the panel i.e. apply a black frame
around the image on the panel if the resolution of the external display is
lower than the panel resolution.
.TP
.B scale
means to always scale to the resolution of the external display filling
the entire panel.
.TP
.B scale_keep_aspect_ratio
scales the panel display but keeps the aspect ratio of the external display,
which means if the external display has a different aspect ratio than the
panel it black borders will be added to the top and bottom or left and right.
.TP
.B default
keeps the aspect ratio, but does not to scale otherwise.
.RE
.RS
.PD
.PP
The
.B default
is to keep the aspect ratio.
.RE
.TP
.BI "Option \*qNoRandr\*q
Disable RandR 1.2 support. This turns the driver back to use standard
modesetting behavior. The default is to
.B enable
RandR 1.2 support.
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Enable or disable the software cursor. The hardware cursor is inactive
when the software cursor is enabled. The default is
.BR off .
.TP
.BI "Option \*qForceReduced\*q \*q" boolean \*q
Force the use of reduced blanking modes. Use this if your LCD monitor does not
provide correct EDID data and you need a reduced blanking mode to drive a high
resolution mode over a single link DVI connection. The default is
.BR off .
.TP
.BI "Option \*qUnverifiedFeatures\*q \*q" boolean \*q
The
.B radeonhd
driver sometimes relies on unverified graphics card features. You can add
.B "Option \*qUnverifiedFeatures\*q \*qoff\*q"
to disable those when you run into difficulties.
.TP
.BI "Option \*qRROutputOrder\*q \*q" "list-of-outputs" \*q
.IR "RandR modesetting only" .
.br
Several legacy application rely on the Xinerama extension to determine the
primary screen. RandR returns the viewport displayed on the first attached
output of the internal table as the first Xinerama screen.
If your outputs are ordered in the wrong way, you can reorder them by adding
their names (separated by spaces or commas) to the
.IR list-of-outputs .
Typically only the first (primary) output has to be listed, remaining
outputs are added automatically. The default is
.BR none .
.TP
.BI "Option \*qIgnoreConnector\*q \*q" string \*q
.IR "Standard (non-RandR) modesetting only" .
.br
Connector to be ignored during non-RandR modesetting. The default is
.BR none .
.TP
.BI "Option \*qUseConfiguredMonitor\*q \*q" boolean \*q
.IR "Standard (non-RandR) modesetting only" .
.br
Use or ignore the monitor section in
.IR xorg.conf .
In standard modesetting
.B radeonhd
ignores the EDID data if a monitor section is configured.  This is different
to what most drivers behave like and a common source of configuration problems.
Thus the default is
.B off
(i.e. ignore).
.TP
.BI "Option \*qNoAccel\*q
Disable all hardware acceleration. The default is to
.B enable
hardware acceleration.
.PP
.RS
.B NOTE:
Use of this option is considered deprecated. The
.B AccelMethod
option is considered to be more flexible.
.RE
.TP
.BI "Option \*qHPD\*q \*q" "auto|off|normal|swap" \*q
Change the use of the hot plug detection (HPD) pins. On R5xx the according
connector tables are often broken and have to be worked around.
.RS
.TP 8
.PD 0
.B Auto
Select method depending on chipset and board
.TP
.B Off
Don't use HPD pins. Some connectors might not be able to detect connections
at all
.TP
.B Normal
Use connector table information as-is
.TP
.B Swap
Swap HPD pin 1 and 2 in connector table
.RE
.RS
.PD
.PP
.B NOTE:
Use of this option is discouraged. Whenever this option is needed to detect
connected monitors correctly, please report to the mailing list.
The default is
.BR Auto .
.RE
.TP
.BI "Option \*qForceDPI\*q \*q" integer \*q
Force the use of the specified pixel density in Dots Per Inch.
The default is
.BR "to use the monitor supplied values" .
.PP
.RS
.B NOTE:
Use of this option is discouraged. Monitors should return valid DPI values,
and the Xserver should honour them correctly.
.RE
.TP
.BI "Option \*qUseAtomBIOS\*q \*q" boolean \*q
Selects the mode setting path. The default is
.BR "chipset dependent" .
.PP
.RS
.B NOTE:
Use of this option is discouraged. The driver should select the right path. If
this option is needed to get your card working correctly, please report to the
mailing list.
.RE
.TP
.BI "Option \*qAudio\*q \*q" boolean \*q
This option enables the audio hardware, which is responsible for delivering audio data
to the different HDMI capable connectors and used to communicate with the audio
driver of the operation system. The default is
.BR off .
.TP
.BI "Option \*qHDMI\*q \*q" string \*q
Possible values are "DVI-I_0", "DVI-I_1"..,"DVI-D_0","DVI-I_1",.., "all".
This option enables HDMI-Audio and HDMI-Info packets on the specified connector.
This is the only way enabling HDMI at the moment, since decoding E-EDID data
to check if monitor supports HDMI is not implemented (yet).
.TP
.BI "Option \*qCoherent\*q \*q" string \*q
There are two different ways to program the TMDS encoder in an output
for best signal quality for the transmitter chip used inside a digital
monitor. This option may be used to set the programming for each output
individually. The string is a space separated list of
.B <output_transmitter>=on|off.
Possible  values for
.B <output_transmitter>
are:
.B TMDS_A,
.B TMDS_B,
.B UNIPHY_A,
.B UNIPHY_B,
.B AtomOutputTMDSA,
.B AtomOutputLVTMA,
.B AtomOutputKldskpLvtma,
.B AtomOutputUniphyA,
.B  AtomOutputUniphyB.
The log file should be consulted
on which ones to use. The line:
.B "Option \*qCoherent\*q \*qTMDS_A=off TMDS_B=on\*q"
will set coherent mode to
.B off
for TMDS A and to
.B on
for TMDS B.
The default for all outputs is
.BR off .
.TP
.BI "Option \*qTVMode\*q \*q" tv-mode \*q
The TV standard to use on the TV output.
.RS
.TP 8
.PD 0
.B NTSC
.TP
.B NTSCJ
.TP
.B PAL
.TP
.B PALM
.TP
.B PALCN
.TP
.B PALN
.TP
.B PAL60
.TP
.B SECAM
.TP
.B CV
Composite Video
.RE
.RS
.PD
.PP
.B NOTE:
This option isn't implemented yet and has no effect.
.RE
.PP
.PD
.TP
.BI "Option \*qForceLowPowerMode\*q \*q" boolean \*q
Enable to statically set GPU engine clock to a lower than default value. This
can help reduce power consumption. The default is
.B off.
.TP
.BI "Option \*qLowPowerModeEngineClock\*q \*q" integer \*q
Engine clock frequency to use when ForceLowPowerMode is enabled, in Hz. If not
set, the minimum known working frequency is used.  If integer is negative,
validation is skipped, and the absolute value is used for the engine clock.
.\"
.\"
.SH RANDR OUTPUT PROPERTIES
The following properties can be queried with
.B xrandr --prop
and some of them can be set with
.BR "xrandr --output" " <output> " --set " <property> <value> ."
Those not starting with an underscore '_' are RandR 1.3 standard properties.
See the RandR 1.3 protocol description for more details.   Properties marked
Read-Only are provided by the driver for informational purpose only, those
marked Static won't change during runtime.
.TP
.BR SignalFormat "   Read-Only"
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Range/List :
unknown VGA TMDS LVDS DisplayPort
.RE
.RS
.PD
.PP
Signal format / physical protocol format that is used for the specified
output.
.RE
.TP
.BR ConnectorType "   Read-Only Static"
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Range/List :
unknown VGA DVI DVI-I DVI-A DVI-D HDMI Panel DisplayPort
.RE
.RS
.PD
.PP
Connector type, as far as known to the driver.
.I Panel
describes laptop-internal (normally LVDS) displays.
.RE
.TP
.BR ConnectorNumber "   Read-Only Static"
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-
.RE
.RS
.PD
.PP
Outputs that route their signal to the same connector MUST have the same
connector number. Outputs with the same connector number MUST route their
signal to the same connector, except if it is 0, which indicates unknown
connectivity.
.RE
.TP
.BR _OutputNumber "   Read-Only Static"
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-
.RE
.RS
.PD
.PP
A card may route one internal output to several connectors.  Connectors that
are driven by the same output cannot be driven by different Crtcs and are thus
only allowed to be used in clone mode. The driver SHOULD emit an error message
and continue as gracefully as possible if using different Crtcs for the same
internal output is requested.
.br
Internal outputs are numbered from 1, 0 indicates that output routing is
unknown.
.RE
.TP
.B _PanningArea
.RS
.TP 16
.PD 0
.IR Type :
string
.TP
.IR Format :
.RB <width> x <height>[ + <xoffset> + <yoffset>]
.RE
.RS
.PD
.PP
Specifies the panning area in RandR mode per output.
.br
It actually is a Crtc-specific property, but RandR doesn't support that yet.
As the
.B xrandr
application typically always resets the framebuffer size with every action,
.BR --fb " <width>" x <height>
has to be added on every invocation, unless there is an additional output
configured that is using this size as its resolution.
.br
This property cannot be changed when in a rotated mode.
.PP
.B NOTE:
Use of this option is considered deprecated.  The driver supports
.B RandR 1.3
panning, which is included in Xserver 1.6.  It is considerable more flexible,
and should support rotated pans.
.RE
.TP
.B Backlight
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-255
.RE
.RS
.PD
.PP
Specifies the backlight intensity on laptop panels, if controllable by the driver.
.RE
.TP
.B _Coherent
.RS
.TP 16
.PD 0
.IR Type :
int32
.TP
.IR Range/List :
0-1
.RE
.RS
.PD
.PP
Sets the coherent flag for TMDS signals. See also
.I Option
.IR "Coherent" .
.\"
.\"
.SH XVIDEO ATTRIBUTES
On R600 and above, the following XVideo attributes are supported.
Use
.B xvattr
to query and set these values at runtime.
.TP
.B XV_COLORSPACE
Select the Y'CbCr color space of the source video.  Accepted values
are 'auto-detect'(0), 'Rec.601'(1), and 'Rec.709'(2).
.RS
.PP
Rec.709 is the standard which applies to high-definition television
broadcasting and "HD" digital video in general; Rec.601 applies to all
other digital video.
When 'auto-detect' is selected, Rec.709 is used for videos encoded
at least 928px wide, and Rec.601 is used otherwise.
This cut-off is lower than 720p so that the correct color space can be
applied to some media with non-standard resolutions that have high-probability
of having originated from Rec.709 encoded content.
.PP
Default is
.B 'auto-detect'(0).
.RE
.\"
.\"
.SH KNOWN BUGS
As the
.B radeonhd
driver is still in development, some non-obvious things might not work yet. A
list of major known bugs is maintained on the wiki.  Other places to check for
known bugs and solutions are the bugtracker at
.br
.nf
\%https://bugs.freedesktop.org/query.cgi?product=xorg&component=Driver/radeonhd
.br
.fi
and the mailing list archives at
\%http://lists.opensuse.org/radeonhd/
.PP
radeonhd development caused a few bugs in __xservername__ and a number
of bugs in xrandr(__appmansuffix__) to be discovered. If you are using
xrandr(__appmansuffix__) versions older than 2007-11-10, you should try
updating xrandr(__appmansuffix__).
.br
Alternatively, you can try to always specify different CRTCs for
all monitors by explicitly selecting them with
.I --crtc [0|1]
on the xrandr(__appmansuffix__) command line.
.\"
.\"
.SH SEE ALSO
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.IP " 1." 4
The official radeonhd wiki
.RS 4
\%http://wiki.x.org/wiki/radeonhd
.RE
.IP " 2." 4
The radeonhd mailing list
.RS 4
\%http://lists.opensuse.org/radeonhd/
.RE
.IP " 3." 4
Overview about radeonhd development code
.RS 4
\%http://cgit.freedesktop.org/xorg/driver/xf86-video-radeonhd/
.RE
.IP " 4." 4
Query the bugtracker for radeonhd bugs
.RS 4
.nf
\%https://bugs.freedesktop.org/query.cgi?\:product=\:xorg&\:component=\:Driver/radeonhd
.fi
.RE
.\"
.\"
.SH AUTHORS
Egbert Eich, Luc Verhaegen, Matthias Hopf, Hans Ulrich Niedermann,
Christian Koenig, Alexander Deucher, and others.
.\" vim: syntax=nroff
