/**
 * @file xinerama.h
 **/

/**
 * @defgroup XCB_Xinerama_API XCB Xinerama API
 * @brief Xinerama XCB Protocol Implementation.
 * @{
 **/
/*
 * This file generated automatically from xinerama.xml by c-client.xsl using XSLT.
 * Edit at your peril.
 */

#ifndef __XINERAMA_H
#define __XINERAMA_H

#include "xcb.h"
#include "xproto.h"

#define XCB_XINERAMA_MAJOR_VERSION 1
#define XCB_XINERAMA_MINOR_VERSION 1
  
extern xcb_extension_t xcb_xinerama_id;

/**
 * @brief xcb_xinerama_screen_info_t
 **/
typedef struct xcb_xinerama_screen_info_t {
    int16_t  x_org; /**<  */
    int16_t  y_org; /**<  */
    uint16_t width; /**<  */
    uint16_t height; /**<  */
} xcb_xinerama_screen_info_t;

/**
 * @brief xcb_xinerama_screen_info_iterator_t
 **/
typedef struct xcb_xinerama_screen_info_iterator_t {
    xcb_xinerama_screen_info_t *data; /**<  */
    int                         rem; /**<  */
    int                         index; /**<  */
} xcb_xinerama_screen_info_iterator_t;

/**
 * @brief xcb_xinerama_query_version_cookie_t
 **/
typedef struct xcb_xinerama_query_version_cookie_t {
    unsigned int sequence; /**<  */
} xcb_xinerama_query_version_cookie_t;

/** Opcode for xcb_xinerama_query_version. */
#define XCB_XINERAMA_QUERY_VERSION 0

/**
 * @brief xcb_xinerama_query_version_request_t
 **/
typedef struct xcb_xinerama_query_version_request_t {
    uint8_t  major_opcode; /**<  */
    uint8_t  minor_opcode; /**<  */
    uint16_t length; /**<  */
    uint8_t  major; /**<  */
    uint8_t  minor; /**<  */
} xcb_xinerama_query_version_request_t;

/**
 * @brief xcb_xinerama_query_version_reply_t
 **/
typedef struct xcb_xinerama_query_version_reply_t {
    uint8_t  response_type; /**<  */
    uint8_t  pad0; /**<  */
    uint16_t sequence; /**<  */
    uint32_t length; /**<  */
    uint16_t major; /**<  */
    uint16_t minor; /**<  */
} xcb_xinerama_query_version_reply_t;

/**
 * @brief xcb_xinerama_get_state_cookie_t
 **/
typedef struct xcb_xinerama_get_state_cookie_t {
    unsigned int sequence; /**<  */
} xcb_xinerama_get_state_cookie_t;

/** Opcode for xcb_xinerama_get_state. */
#define XCB_XINERAMA_GET_STATE 1

/**
 * @brief xcb_xinerama_get_state_request_t
 **/
typedef struct xcb_xinerama_get_state_request_t {
    uint8_t      major_opcode; /**<  */
    uint8_t      minor_opcode; /**<  */
    uint16_t     length; /**<  */
    xcb_window_t window; /**<  */
} xcb_xinerama_get_state_request_t;

/**
 * @brief xcb_xinerama_get_state_reply_t
 **/
typedef struct xcb_xinerama_get_state_reply_t {
    uint8_t      response_type; /**<  */
    uint8_t      state; /**<  */
    uint16_t     sequence; /**<  */
    uint32_t     length; /**<  */
    xcb_window_t window; /**<  */
} xcb_xinerama_get_state_reply_t;

/**
 * @brief xcb_xinerama_get_screen_count_cookie_t
 **/
typedef struct xcb_xinerama_get_screen_count_cookie_t {
    unsigned int sequence; /**<  */
} xcb_xinerama_get_screen_count_cookie_t;

/** Opcode for xcb_xinerama_get_screen_count. */
#define XCB_XINERAMA_GET_SCREEN_COUNT 2

/**
 * @brief xcb_xinerama_get_screen_count_request_t
 **/
typedef struct xcb_xinerama_get_screen_count_request_t {
    uint8_t      major_opcode; /**<  */
    uint8_t      minor_opcode; /**<  */
    uint16_t     length; /**<  */
    xcb_window_t window; /**<  */
} xcb_xinerama_get_screen_count_request_t;

/**
 * @brief xcb_xinerama_get_screen_count_reply_t
 **/
typedef struct xcb_xinerama_get_screen_count_reply_t {
    uint8_t      response_type; /**<  */
    uint8_t      screen_count; /**<  */
    uint16_t     sequence; /**<  */
    uint32_t     length; /**<  */
    xcb_window_t window; /**<  */
} xcb_xinerama_get_screen_count_reply_t;

/**
 * @brief xcb_xinerama_get_screen_size_cookie_t
 **/
typedef struct xcb_xinerama_get_screen_size_cookie_t {
    unsigned int sequence; /**<  */
} xcb_xinerama_get_screen_size_cookie_t;

/** Opcode for xcb_xinerama_get_screen_size. */
#define XCB_XINERAMA_GET_SCREEN_SIZE 3

/**
 * @brief xcb_xinerama_get_screen_size_request_t
 **/
typedef struct xcb_xinerama_get_screen_size_request_t {
    uint8_t      major_opcode; /**<  */
    uint8_t      minor_opcode; /**<  */
    uint16_t     length; /**<  */
    xcb_window_t window; /**<  */
    xcb_screen_t screen; /**<  */
} xcb_xinerama_get_screen_size_request_t;

/**
 * @brief xcb_xinerama_get_screen_size_reply_t
 **/
typedef struct xcb_xinerama_get_screen_size_reply_t {
    uint8_t      response_type; /**<  */
    uint8_t      pad0; /**<  */
    uint16_t     sequence; /**<  */
    uint32_t     length; /**<  */
    uint32_t     width; /**<  */
    uint32_t     height; /**<  */
    xcb_window_t window; /**<  */
    xcb_screen_t screen; /**<  */
} xcb_xinerama_get_screen_size_reply_t;

/**
 * @brief xcb_xinerama_is_active_cookie_t
 **/
typedef struct xcb_xinerama_is_active_cookie_t {
    unsigned int sequence; /**<  */
} xcb_xinerama_is_active_cookie_t;

/** Opcode for xcb_xinerama_is_active. */
#define XCB_XINERAMA_IS_ACTIVE 4

/**
 * @brief xcb_xinerama_is_active_request_t
 **/
typedef struct xcb_xinerama_is_active_request_t {
    uint8_t  major_opcode; /**<  */
    uint8_t  minor_opcode; /**<  */
    uint16_t length; /**<  */
} xcb_xinerama_is_active_request_t;

/**
 * @brief xcb_xinerama_is_active_reply_t
 **/
typedef struct xcb_xinerama_is_active_reply_t {
    uint8_t  response_type; /**<  */
    uint8_t  pad0; /**<  */
    uint16_t sequence; /**<  */
    uint32_t length; /**<  */
    uint32_t state; /**<  */
} xcb_xinerama_is_active_reply_t;

/**
 * @brief xcb_xinerama_query_screens_cookie_t
 **/
typedef struct xcb_xinerama_query_screens_cookie_t {
    unsigned int sequence; /**<  */
} xcb_xinerama_query_screens_cookie_t;

/** Opcode for xcb_xinerama_query_screens. */
#define XCB_XINERAMA_QUERY_SCREENS 5

/**
 * @brief xcb_xinerama_query_screens_request_t
 **/
typedef struct xcb_xinerama_query_screens_request_t {
    uint8_t  major_opcode; /**<  */
    uint8_t  minor_opcode; /**<  */
    uint16_t length; /**<  */
} xcb_xinerama_query_screens_request_t;

/**
 * @brief xcb_xinerama_query_screens_reply_t
 **/
typedef struct xcb_xinerama_query_screens_reply_t {
    uint8_t  response_type; /**<  */
    uint8_t  pad0; /**<  */
    uint16_t sequence; /**<  */
    uint32_t length; /**<  */
    uint32_t number; /**<  */
    uint8_t  pad1[20]; /**<  */
} xcb_xinerama_query_screens_reply_t;


/*****************************************************************************
 **
 ** void xcb_xinerama_screen_info_next
 ** 
 ** @param xcb_xinerama_screen_info_iterator_t *i
 ** @returns void
 **
 *****************************************************************************/
 
void
xcb_xinerama_screen_info_next (xcb_xinerama_screen_info_iterator_t *i  /**< */);


/*****************************************************************************
 **
 ** xcb_generic_iterator_t xcb_xinerama_screen_info_end
 ** 
 ** @param xcb_xinerama_screen_info_iterator_t i
 ** @returns xcb_generic_iterator_t
 **
 *****************************************************************************/
 
xcb_generic_iterator_t
xcb_xinerama_screen_info_end (xcb_xinerama_screen_info_iterator_t i  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_query_version_cookie_t xcb_xinerama_query_version
 ** 
 ** @param xcb_connection_t *c
 ** @param uint8_t           major
 ** @param uint8_t           minor
 ** @returns xcb_xinerama_query_version_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_query_version_cookie_t
xcb_xinerama_query_version (xcb_connection_t *c  /**< */,
                            uint8_t           major  /**< */,
                            uint8_t           minor  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_query_version_cookie_t xcb_xinerama_query_version_unchecked
 ** 
 ** @param xcb_connection_t *c
 ** @param uint8_t           major
 ** @param uint8_t           minor
 ** @returns xcb_xinerama_query_version_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_query_version_cookie_t
xcb_xinerama_query_version_unchecked (xcb_connection_t *c  /**< */,
                                      uint8_t           major  /**< */,
                                      uint8_t           minor  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_query_version_reply_t * xcb_xinerama_query_version_reply
 ** 
 ** @param xcb_connection_t                     *c
 ** @param xcb_xinerama_query_version_cookie_t   cookie
 ** @param xcb_generic_error_t                 **e
 ** @returns xcb_xinerama_query_version_reply_t *
 **
 *****************************************************************************/
 
xcb_xinerama_query_version_reply_t *
xcb_xinerama_query_version_reply (xcb_connection_t                     *c  /**< */,
                                  xcb_xinerama_query_version_cookie_t   cookie  /**< */,
                                  xcb_generic_error_t                 **e  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_state_cookie_t xcb_xinerama_get_state
 ** 
 ** @param xcb_connection_t *c
 ** @param xcb_window_t      window
 ** @returns xcb_xinerama_get_state_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_get_state_cookie_t
xcb_xinerama_get_state (xcb_connection_t *c  /**< */,
                        xcb_window_t      window  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_state_cookie_t xcb_xinerama_get_state_unchecked
 ** 
 ** @param xcb_connection_t *c
 ** @param xcb_window_t      window
 ** @returns xcb_xinerama_get_state_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_get_state_cookie_t
xcb_xinerama_get_state_unchecked (xcb_connection_t *c  /**< */,
                                  xcb_window_t      window  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_state_reply_t * xcb_xinerama_get_state_reply
 ** 
 ** @param xcb_connection_t                 *c
 ** @param xcb_xinerama_get_state_cookie_t   cookie
 ** @param xcb_generic_error_t             **e
 ** @returns xcb_xinerama_get_state_reply_t *
 **
 *****************************************************************************/
 
xcb_xinerama_get_state_reply_t *
xcb_xinerama_get_state_reply (xcb_connection_t                 *c  /**< */,
                              xcb_xinerama_get_state_cookie_t   cookie  /**< */,
                              xcb_generic_error_t             **e  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_screen_count_cookie_t xcb_xinerama_get_screen_count
 ** 
 ** @param xcb_connection_t *c
 ** @param xcb_window_t      window
 ** @returns xcb_xinerama_get_screen_count_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_get_screen_count_cookie_t
xcb_xinerama_get_screen_count (xcb_connection_t *c  /**< */,
                               xcb_window_t      window  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_screen_count_cookie_t xcb_xinerama_get_screen_count_unchecked
 ** 
 ** @param xcb_connection_t *c
 ** @param xcb_window_t      window
 ** @returns xcb_xinerama_get_screen_count_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_get_screen_count_cookie_t
xcb_xinerama_get_screen_count_unchecked (xcb_connection_t *c  /**< */,
                                         xcb_window_t      window  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_screen_count_reply_t * xcb_xinerama_get_screen_count_reply
 ** 
 ** @param xcb_connection_t                        *c
 ** @param xcb_xinerama_get_screen_count_cookie_t   cookie
 ** @param xcb_generic_error_t                    **e
 ** @returns xcb_xinerama_get_screen_count_reply_t *
 **
 *****************************************************************************/
 
xcb_xinerama_get_screen_count_reply_t *
xcb_xinerama_get_screen_count_reply (xcb_connection_t                        *c  /**< */,
                                     xcb_xinerama_get_screen_count_cookie_t   cookie  /**< */,
                                     xcb_generic_error_t                    **e  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_screen_size_cookie_t xcb_xinerama_get_screen_size
 ** 
 ** @param xcb_connection_t *c
 ** @param xcb_window_t      window
 ** @param xcb_screen_t      screen
 ** @returns xcb_xinerama_get_screen_size_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_get_screen_size_cookie_t
xcb_xinerama_get_screen_size (xcb_connection_t *c  /**< */,
                              xcb_window_t      window  /**< */,
                              xcb_screen_t      screen  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_screen_size_cookie_t xcb_xinerama_get_screen_size_unchecked
 ** 
 ** @param xcb_connection_t *c
 ** @param xcb_window_t      window
 ** @param xcb_screen_t      screen
 ** @returns xcb_xinerama_get_screen_size_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_get_screen_size_cookie_t
xcb_xinerama_get_screen_size_unchecked (xcb_connection_t *c  /**< */,
                                        xcb_window_t      window  /**< */,
                                        xcb_screen_t      screen  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_get_screen_size_reply_t * xcb_xinerama_get_screen_size_reply
 ** 
 ** @param xcb_connection_t                       *c
 ** @param xcb_xinerama_get_screen_size_cookie_t   cookie
 ** @param xcb_generic_error_t                   **e
 ** @returns xcb_xinerama_get_screen_size_reply_t *
 **
 *****************************************************************************/
 
xcb_xinerama_get_screen_size_reply_t *
xcb_xinerama_get_screen_size_reply (xcb_connection_t                       *c  /**< */,
                                    xcb_xinerama_get_screen_size_cookie_t   cookie  /**< */,
                                    xcb_generic_error_t                   **e  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_is_active_cookie_t xcb_xinerama_is_active
 ** 
 ** @param xcb_connection_t *c
 ** @returns xcb_xinerama_is_active_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_is_active_cookie_t
xcb_xinerama_is_active (xcb_connection_t *c  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_is_active_cookie_t xcb_xinerama_is_active_unchecked
 ** 
 ** @param xcb_connection_t *c
 ** @returns xcb_xinerama_is_active_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_is_active_cookie_t
xcb_xinerama_is_active_unchecked (xcb_connection_t *c  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_is_active_reply_t * xcb_xinerama_is_active_reply
 ** 
 ** @param xcb_connection_t                 *c
 ** @param xcb_xinerama_is_active_cookie_t   cookie
 ** @param xcb_generic_error_t             **e
 ** @returns xcb_xinerama_is_active_reply_t *
 **
 *****************************************************************************/
 
xcb_xinerama_is_active_reply_t *
xcb_xinerama_is_active_reply (xcb_connection_t                 *c  /**< */,
                              xcb_xinerama_is_active_cookie_t   cookie  /**< */,
                              xcb_generic_error_t             **e  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_query_screens_cookie_t xcb_xinerama_query_screens
 ** 
 ** @param xcb_connection_t *c
 ** @returns xcb_xinerama_query_screens_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_query_screens_cookie_t
xcb_xinerama_query_screens (xcb_connection_t *c  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_query_screens_cookie_t xcb_xinerama_query_screens_unchecked
 ** 
 ** @param xcb_connection_t *c
 ** @returns xcb_xinerama_query_screens_cookie_t
 **
 *****************************************************************************/
 
xcb_xinerama_query_screens_cookie_t
xcb_xinerama_query_screens_unchecked (xcb_connection_t *c  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_screen_info_t * xcb_xinerama_query_screens_screen_info
 ** 
 ** @param const xcb_xinerama_query_screens_reply_t *R
 ** @returns xcb_xinerama_screen_info_t *
 **
 *****************************************************************************/
 
xcb_xinerama_screen_info_t *
xcb_xinerama_query_screens_screen_info (const xcb_xinerama_query_screens_reply_t *R  /**< */);


/*****************************************************************************
 **
 ** int xcb_xinerama_query_screens_screen_info_length
 ** 
 ** @param const xcb_xinerama_query_screens_reply_t *R
 ** @returns int
 **
 *****************************************************************************/
 
int
xcb_xinerama_query_screens_screen_info_length (const xcb_xinerama_query_screens_reply_t *R  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_screen_info_iterator_t xcb_xinerama_query_screens_screen_info_iterator
 ** 
 ** @param const xcb_xinerama_query_screens_reply_t *R
 ** @returns xcb_xinerama_screen_info_iterator_t
 **
 *****************************************************************************/
 
xcb_xinerama_screen_info_iterator_t
xcb_xinerama_query_screens_screen_info_iterator (const xcb_xinerama_query_screens_reply_t *R  /**< */);


/*****************************************************************************
 **
 ** xcb_xinerama_query_screens_reply_t * xcb_xinerama_query_screens_reply
 ** 
 ** @param xcb_connection_t                     *c
 ** @param xcb_xinerama_query_screens_cookie_t   cookie
 ** @param xcb_generic_error_t                 **e
 ** @returns xcb_xinerama_query_screens_reply_t *
 **
 *****************************************************************************/
 
xcb_xinerama_query_screens_reply_t *
xcb_xinerama_query_screens_reply (xcb_connection_t                     *c  /**< */,
                                  xcb_xinerama_query_screens_cookie_t   cookie  /**< */,
                                  xcb_generic_error_t                 **e  /**< */);


/**
 * @}
 */
#endif
