.\" Copyright \(co 2006 Josh Triplett
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.TH XGetXCBConnection 3X11 __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XGetXCBConnection \- get the XCB connection for an Xlib Display
.SH SYNTAX
.HP
 #include <X11/Xlib-xcb.h>
.HP
xcb_connection_t *XGetXCBConnection(Display *\fIdpy\fP); 
.SH ARGUMENTS
.IP \fIdpy\fP 1i
Specifies the connection to the X server.
.IN "Environment" "DISPLAY"
.SH DESCRIPTION
The \fIXGetXCBConnection\fP function returns the XCB connection associated with
an Xlib Display.  Clients can use this XCB connection with functions from the
XCB library, just as they would with an XCB connection created with XCB.
Callers of this function must link to libX11-xcb and a version of Xlib built
with XCB support.
.SH "SEE ALSO"
XOpenDisplay(3X11),
XSetEventQueueOwner(3X11),
.br
\fIXlib \- C Language X Interface\fP
