.\" Copyright (c) 1993, 1994  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"), 
.\" to deal in the Software without restriction, including without limitation 
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense, 
.\" and/or sell copies of the Software, and to permit persons to whom the 
.\" Software furnished to do so, subject to the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
.\" SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall not 
.\" be used in advertising or otherwise to promote the sale, use or other 
.\" dealing in this Software without prior written authorization from the 
.\" X Consortium.
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtFind-File wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XtFindFile 3Xt "Release 6" "X Version 11" "XT FUNCTIONS"
.SH NAME
XtFindFile \- search for a file using substitutions in the path list
.SH SYNTAX
String XtFindFile(\fIpath\fP, \fIsubstitutions\fP, \fInum_substitutions\fP,\
\fIpredicate\fP)
.br
      String \fIpath\fP;
.br
      Substitution \fIsubstitutions\fP;
.br
      Cardinal \fInum_substitutions\fP;
.br
      XtFilePredicate \fIpredicate\fP;
.SH ARGUMENTS
.IP \fIpath\fP 1i
Specifies a path of file names, including substitution characters.
.IP \fIsubstitutions\fP 1i
Specifies a list of substitutions to make into a path.
.IP \fInum_substitutions\fP 1i
Specifies the number of substitutions passed in.
.IP \fIpredicate\fP 1i
Specifies a procedure to call to judge a potential file name, or NULL.
.SH DESCRIPTION
The \fIpath\fP parameter specifies a string that consists of a series of
potential file names delimited by colons.  Within each name, the
percent character specifies a string substitution selected by the
following character.  The character sequence ``%:'' specifies an
embedded colon that is not a delimiter; the sequence is replaced by a
single colon.  The character sequence ``%%'' specifies a percent
character that does not introduce a substitution; the sequence is
replaced by a single percent character.  If a percent character is
followed by any other character,
.PN XtFindFile
looks through the
specified \fIsubstitutions\fP for that character in the \fImatch\fP field and if
found replaces the percent and match characters with the string in the
corresponding \fIsubstitution\fP field.  A \fIsubstitution\fP field entry of NULL
is equivalent to a pointer to an empty string.  If the operating
system does not interpret multiple embedded name separators in the
path (i.e., ``/'' in POSIX) the same way as a single separator,
.PN XtFindFile
will collapse multiple separators into a single one after performing
all string substitutions.  Except for collapsing embedded separators,
the contents of the string substitutions are not interpreted by
.PN XtFindFile
and may therefore contain any operating-system-dependent
characters, including additional name separators.  Each resulting
string is passed to the predicate procedure until a string is found for
which the procedure returns
.PN True ;
this string is the return value for
.PN XtFindFile .
If no string yields a
.PN True
return from the predicate,
.PN XtFindFile
returns NULL.
.LP
If the \fIpredicate\fP parameter is NULL, an internal procedure that checks
if the file exists, is readable, and is not a directory will be used.
.LP
It is the responsibility of the caller to free the returned string using
.PN XtFree
when it is no longer needed.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
