.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $TOG: XChProp.man /main/9 1997/11/04 20:46:33 kaleb $
.ds xL Programming With Xlib
.TH XChangeDeviceDontPropagateList 3X11 "Release 6.4" "X Version 11" "X FUNCTIONS"
.SH NAME
XChangeDeviceDontPropagateList, XGetDeviceDontPropagateList \- query or change the dont-propagate-list for extension devices
.SH SYNTAX
XChangeDeviceDontPropagateList\^(\^\fIdisplay\fP, \fIwindow\fP\^,
\fIcount\fP\^, \fIevent_list\fP\^, \fImode\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window *\fIwindow\fP\^; 
.br
      int *\fIcount\fP\^; 
.br
      XEventClass *\fIevent_list\fP\^; 
.br
      int \fImode\fP\^; 
.br
XEventClass *XGetDeviceDontPropagateList\^(\^\fIdisplay\fP, \fIwindow\fP\^, 
\fIcount\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window *\fIwindow\fP\^; 
.br
      int *\fIcount\fP\^; 
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I window
Specifies the window whose dont-propagate-list is to be queried or modified.
.TP 12
.I event_list
Specifies a pointer to a list of event classes.
.TP 12
.I mode
Specifies the mode.
You can pass 
\fIAddToList\fP , 
or
\fIDeleteFromList\fP.
.TP 12
.I count
Specifies the number of event classes in the list.
.SH DESCRIPTION
The \fIXChangeDeviceDontPropagateList\fP request modifies the list
of events that should not be propagated to ancestors of the event window.
This request allows extension events to be added to or deleted from
that list.  By default, all events are propagated to ancestor windows.
Once modified, the list remains modified for the life of the window.
Events are not removed from the list because the client that added them
has terminated.
.LP
Suppression of event propagation is not allowed for all input extension
events.  If a specified event class is one that cannot be suppressed,
a \fIBadClass\fP error will result.  Events that can be suppressed
include \fIDeviceKeyPress\fP, \fIDeviceKeyRelease\fP, \fIDeviceButtonPress\fP,
\fIDeviceButtonRelease\fP, \fIDeviceMotionNotify\fP, \fIProximityIn\fP, 
and \fIProximityOut\fP.
.LP
\fIXChangeDeviceDontPropagateList\fP
can generate a \fIBadDevice\fP, \fIBadClass\fP, or \fIBadValue\fP error.
.LP
The \fIXGetDeviceDontPropagateList\fP request queries the list
of events that should not be propagated to ancestors of the event window.
.LP
\fIXGetDeviceDontPropagateList\fP
can generate a \fIBadClass\fP  or \fIBadWindow\fP error.
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if some other client has caused the specified device to become
the X keyboard or X pointer device via the \fIXChangeKeyboardDevice\fP or
\fIXChangePointerDevice\fP requests.
.TP 12
\fIBadValue\fP
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 12
\fIBadWindow\fP
An invalid window id was specified.
.TP 12
\fIBadClass\fP
An invalid event class was specified.
.SH "SEE ALSO"
.br
\fI\*(xL\fP
