/* $XConsortium: xkbmaptest.c /main/2 1996/02/05 11:45:12 kaleb $ */
/************************************************************
Copyright (c) 1996 by Silicon Graphics Computer Systems, Inc.

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation, and that the name of Silicon Graphics not be 
used in advertising or publicity pertaining to distribution 
of the software without specific prior written permission.
Silicon Graphics makes no representation about the suitability 
of this software for any purpose. It is provided "as is"
without any express or implied warranty.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
THE USE OR PERFORMANCE OF THIS SOFTWARE.

********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKBfile.h>
#include <X11/Xfuncs.h>

void
#if NeedFunctionPrototypes
printSyms(XkbKeyTypePtr map,KeySym *sym,int num)
#else
printSyms(map,sym,num)
    XkbKeyTypePtr	map;
    KeySym *		sym;
    int 		num;
#endif
{
int	i,nsPending;
char	*name;

    nsPending= 0;
    for (i=0;i<num;i++) {
	if ( sym[i]==NoSymbol )
	    nsPending++;
	else {
	    while (nsPending>0) {
		printf("NoSymbol ");
		nsPending--;
	    }
	    name = XKeysymToString(sym[i]);
	    if ( name )	printf("%s ",name);
	    else	printf("unknown (0x%x) ",sym[i]);
	}
    }
    while (nsPending>0) {
	printf("NoSymbol ");
	nsPending--;
    }
    return;
}

/***====================================================================***/

void
#if NeedFunctionPrototypes
showKey(Display *dpy,XkbDescPtr xkb,KeyCode key)
#else
showKey(dpy,xkb,key)
    Display *	dpy;
    XkbDescPtr	xkb;
    KeyCode 	key;
#endif
{
int		i,nSyms,nGroups,tmp;
XkbServerMapPtr	srv;
XkbClientMapPtr	map;
int 		nActs;
XkbAction *	acts;
XkbBehavior *	b;

    map= xkb->map;
    srv= xkb->server;
    nSyms = XkbKeyNumSyms(xkb,key);
    nGroups= XkbKeyNumGroups(xkb,key);
    printf("Key %d",key);
    if (map && map->types) {
	Atom 	name;
	Bool	multiType;
	int		g,ndx;

	ndx= XkbKeyKeyTypeIndex(xkb,key,0);
	for (multiType=False,g=1;g<nGroups;g++) {
	    if (XkbKeyKeyTypeIndex(xkb,key,g)!=ndx)
		multiType= True;
	}
	if (!multiType) {
	    name= XkbKeyKeyType(xkb,key,0)->name;
	    if (name==None)
		 printf(" type=%d",XkbKeyKeyTypeIndex(xkb,key,0));
	    else printf(" %s",XkbAtomText(dpy,name,XkbMessage));
	}
	else {
	    for (g=0;g<nGroups;g++) {
		if (g==0)	printf(" ");
		else		printf("/");
		name= XkbKeyKeyType(xkb,key,g)->name;
		if (name==None)
		     printf("%d",XkbKeyKeyTypeIndex(xkb,key,0));
		else printf("%s",XkbAtomText(dpy,name,XkbMessage));
	    }
	}
	if (xkb->names && xkb->names->keys) {
	    char buf[5];
	    memcpy(buf,xkb->names->keys[key].name,4);
	    buf[4]= '\0';
	    printf(" <%s>",buf);
	}
    }
    if ((xkb->ctrls->per_key_repeat[key/8]&(1<<(key&0x7)))==0) {
	printf(", non-repeating");
	if (xkb->server->explicit[key]&XkbExplicitAutoRepeatMask)
	    printf("(explicit)");
    }
    i= XkbKeyNumGroups(xkb,key);
    printf(", %d group%s:\n",i,(i>1?"s":""));
    if ((map->modmap)&&(map->modmap[key]!=0)) {
	printf("    Affects real modifiers: %s\n",
				XkbModMaskText(map->modmap[key],XkbMessage));
    }
    if ((srv->vmodmap)&&(srv->vmodmap[key]!=0)) {
	printf("    Affects virtual modifiers: %s\n",
	XkbVModMaskText(dpy,xkb,0,srv->vmodmap[key],XkbMessage));
    }
    switch (XkbOutOfRangeGroupAction(XkbKeyGroupInfo(xkb,key))) {
	default:
	case XkbWrapIntoRange:
	    printf("    Groups wrap into range\n");
	    break;
	case XkbClampIntoRange:
	    printf("    Groups clamp into range\n");
	    break;
	case XkbRedirectIntoRange:
	    printf("    Out of range groups redirected to Group%d\n",
	    XkbOutOfRangeGroupNumber(XkbKeyGroupInfo(xkb,key))+1);
	    break;
    }
    for (tmp=0;tmp<nGroups;tmp++) {
	if (tmp==0)
	     printf("    Symbols: [ ");
	else printf("             [ ");
	printSyms(XkbKeyKeyType(xkb,key,tmp),
			XkbKeySymsPtr(xkb,key)+(tmp*nSyms/nGroups),
			XkbKeyGroupWidth(xkb,key,tmp));
	printf("]\n");
    }
    nActs = XkbKeyNumActions(xkb,key);
    acts=XkbKeyActionsPtr(xkb,key);
    if ((nActs>1)||(acts[0].type!=XkbSA_NoAction)) {
	int nLevels= nActs/nGroups;
	int g,l;
	for (g=0;g<nGroups;g++) {
	    if (g==0)
		 printf("    Actions: [ ");
	    else printf("             [ ");
	    for (l=0;l<nLevels;l++) {
		printf("%s ",XkbActionText(dpy,xkb,&acts[(g*nLevels)+l],
								XkbMessage));
	    }
	    if (xkb->server->explicit[key]&XkbExplicitInterpretMask)
		 printf("] (explicit)\n");
	    else printf("]\n");
	}
    }
    b= &xkb->server->behaviors[key];
    if (b->type!=XkbKB_Default) {
	printf("    Behavior: %s%s\n",XkbBehaviorText(xkb,b,XkbMessage),
			(xkb->server->explicit[key]&XkbExplicitBehaviorMask?
							" (explicit)":""));
    }
    if (srv->explicit[key]&XkbExplicitKeyTypesMask) {
	int g;
	for (g=0;g<nGroups;g++) {
	    if (srv->explicit[key]&(1<<g)) {
		Atom name;
		name= XkbKeyKeyType(xkb,key,g)->name;
		printf("    Type[Group%d]: %s (explicit)\n",g+1,
					XkbAtomText(dpy,name,XkbMessage));
	    }
	}
    }
    return;
}

void
#if NeedFunctionPrototypes
showKeyTypes(Display *dpy,XkbDescPtr	xkb)
#else
showKeyTypes(dpy,xkb)
    Display *	dpy;
    XkbDescPtr	xkb;
#endif
{
XkbClientMapRec *map = xkb->map;
int	i,m;

    for (i=0;i<map->num_types;i++) {
	XkbKeyTypeRec *type= &map->types[i];
	printf("Key Type %d (%s):\n",i,XkbAtomText(dpy,type->name,XkbMessage));
	printf("    mask:         %s\n",
			XkbModMaskText(type->mods.mask,XkbMessage));
	printf("    real mods:    %s\n",
			XkbModMaskText(type->mods.real_mods,XkbMessage));
	printf("    virtual mods: %s\n",
			XkbVModMaskText(dpy,xkb,0,type->mods.vmods,XkbMessage));
	printf("    group width:  %d\n",type->num_levels);
	if (type->map_count>0) {
	    XkbKTMapEntryPtr	me;
	    printf("    map:          ");
	    for (m=0,me=&type->map[0];m<type->map_count;m++,me++) {
		if (m!=0)
		    printf("                  ");
		printf("%s= %d",
		       XkbVModMaskText(dpy,xkb,
					me->mods.real_mods,me->mods.vmods,
					XkbMessage),
		       me->level);
		if (!type->map[m].active)
		    printf("(disabled)");
		if (type->preserve) {
		    unsigned rmods= type->preserve[m].real_mods;
		    unsigned vmods= type->preserve[m].vmods;
		    unsigned mask=  type->preserve[m].mask;
		    if (rmods!=0) {
			printf("\n                  [preserve %s (%s",
					XkbModMaskText(mask,XkbMessage),
					XkbModMaskText(rmods,XkbMessage));
			if (type->preserve[m].vmods!=0) {
			     printf("+%s)]",
				XkbVModMaskText(dpy,xkb,0,vmods,XkbMessage));
			}
			else printf(")]");
		    }
		    else if (vmods!=0) {
			printf(" [preserve %s (%s)]",
				XkbModMaskText(mask,XkbMessage),
				XkbVModMaskText(dpy,xkb,0,vmods,XkbMessage));
		    }
		}
		printf("\n");
	    }
	}
	if (type->level_names!=NULL) {
	    for (m=0;m<type->num_levels;m++) {
		printf("        level %d:  %s\n",m,
			XkbAtomText(dpy,type->level_names[m],XkbMessage));
	    }
	}
	else printf("     level names: none\n");
    }
    return;
}

/***====================================================================***/

static	char		*dpyName = NULL;
static	int		 synch = 0;
static	int		 debug = 0;

int
#if NeedFunctionPrototypes
parseArgs(int argc,char *argv[])
#else
parseArgs(argc,argv)
    int argc;
    char *argv[];
#endif
{
int i;

    for (i=1;i<argc;i++) {
	 if ( strcmp(argv[i],"-display")==0 ) {
	    if ( ++i<argc )	dpyName= argv[i];
	    else {
		fprintf(stderr,"Must specify a display with -display option\n");
		return 0;
	    }
	}
	else if ( strcmp(argv[i],"-synch")==0 ) {
	    synch= 1;
	}
	else if ( strcmp(argv[i],"-debug")==0 ) {
	    debug= 1;
	}
	else {
	    fprintf(stderr,"Unknown option %s\n",argv[i]);
	    return 0;
	}
    }
    return 1;
}

#define	RPT(s,f,n)	printf("%s for keys %d..%d changed\n",s,f,f+n-1)

int
#if NeedFunctionPrototypes
main(int argc,char *argv[])
#else
main(argc,argv)
    int argc;
    char *argv[];
#endif
{
Display	*	 dpy;
int		 major,minor,why,i;
XkbDescPtr	 xkb;
XkbServerMapPtr	 srv;
XkbStateRec	 state;
XkbControlsPtr	 ctrls;
XkbNamesPtr	 nm;
XKeyboardState	 coreKbdState;
unsigned	 istate;
char		 line[256],name[8];
KeySym *	 core_syms,*new_syms;
int		 map_width;
XkbChangesRec	 changes;
  
    if (!parseArgs(argc,argv)) {
	fprintf(stderr,"Usage: %s <options>\n",argv[0]);
	fprintf(stderr,"Where legal options are:\n");
	fprintf(stderr,"-display <dpy>     specifies display to use\n");
	fprintf(stderr,"-debug             turn on extra debugging\n");
	fprintf(stderr,"-s                 report keyboard state\n");
	return 1;
    }
    major= XkbMajorVersion;
    minor= XkbMinorVersion;
    dpy = XkbOpenDisplay(dpyName,NULL,NULL,&major,&minor,&why);
    if (dpy==NULL) {
	if (dpyName==NULL)
	    dpyName= "default display";
        switch (why) {
            case XkbOD_BadLibraryVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Xlib supports incompatible version %d.%02d\n",
                                major,minor);
                break;
            case XkbOD_ConnectionRefused:
                fprintf(stderr,"Cannot open display \"%s\"\n",dpyName);
                break;
            case XkbOD_NonXkbServer:
                fprintf(stderr,"XKB extension not present on %s\n",dpyName);
                break;
            case XkbOD_BadServerVersion:
                fprintf(stderr,"%s was compiled with XKB version %d.%02d\n",
                                argv[0],XkbMajorVersion,XkbMinorVersion);
                fprintf(stderr,"Server %s uses incompatible version %d.%02d\n",
                                dpyName,major,minor);
                break;
            default:
                fprintf(stderr,
		    "Internal Error! Unknown error %d from XkbOpenDisplay\n",
		    why);
        }
	return 1;
    }
    if (synch)
	XSynchronize(dpy,1);

    xkb= XkbGetMap(dpy,0,XkbUseCoreKbd);
    if ( XkbGetUpdatedMap(dpy,XkbAllMapComponentsMask,xkb)!=Success ) {
	fprintf(stderr,"get keyboard desc request failed\n");
	goto BAIL;
    }
    srv= xkb->server;

    if (XkbGetCompatMap(dpy,XkbAllCompatMask,xkb)!=Success) {
	fprintf(stderr,"XkbGetCompatMap failed\n");
	goto BAIL;
    }
    if (XkbGetControls(dpy,XkbAllControlsMask,xkb)!=Success) {
	fprintf(stderr,"XkbGetControls failed\n");
	goto BAIL;
    }
    if (XkbGetNames(dpy,XkbAllNamesMask,xkb)!=Success) {
	fprintf(stderr,"XkbGetNames failed\n");
	goto BAIL;
    }
    if (XkbGetIndicatorMap(dpy,XkbAllIndicatorsMask,xkb)!=Success) {
	fprintf(stderr,"XkbGetIndicatorMap failed\n");
	goto BAIL;
    }
    if (XkbGetIndicatorState(dpy,XkbUseCoreKbd,&istate)!=Success) {
	fprintf(stderr,"XkbGetIndicatorState failed\n");
	goto BAIL;
    }
    ctrls= xkb->ctrls;
    nm= xkb->names;
    printf("Device ID:     %d\n",xkb->device_spec);
    printf("keycodes type: %s\n",XkbAtomText(dpy,nm->keycodes,XkbMessage));
    printf("geometry type: %s\n",XkbAtomText(dpy,nm->geometry,XkbMessage));
    printf("symbols type:  %s ",XkbAtomText(dpy,nm->symbols,XkbMessage));
    printf("phys=%s\n",XkbAtomText(dpy,nm->phys_symbols,XkbMessage));
    printf("types:         %s\n",XkbAtomText(dpy,nm->types,XkbMessage));
    printf("compat:        %s\n",XkbAtomText(dpy,nm->compat,XkbMessage));
    printf("keycode range: %d-%d\n",xkb->min_key_code,xkb->max_key_code);
    printf("repeat keys:       %s (%d/%d -- %s)\n",
		(coreKbdState.global_auto_repeat?"on":"off"),
		ctrls->repeat_delay,ctrls->repeat_interval,
		((ctrls->enabled_ctrls&XkbRepeatKeysMask)?"sw":"hw"));
    printf("virtual modifier names:\n");
    for (i=0;i<XkbNumVirtualMods;i++) {
	if (nm->vmods[i]!=None)
	     printf("%2d: %-12s",i,XkbAtomText(dpy,nm->vmods[i],XkbMessage));
	else if (srv->vmods[i]!=XkbNoModifierMask)
	     printf("%2d: %-12s",i,"(no name)");
	else continue;
	printf(" = %s\n",XkbModMaskText(srv->vmods[i],XkbMessage));
    }
    for (i=0;i<XkbNumKbdGroups;i++) {
	if (nm->groups[i]!=None) {
	    static int been_here=0;
	    if (!been_here) {
		been_here=1;
		printf("group names:\n");
	    }
	    printf("%2d: %s\n",i+1,
	    XkbAtomText(dpy,nm->groups[i],XkbMessage));
	}
    }
    for (i=0;i<XkbNumIndicators;i++) {
	Atom n;
	if ((n=nm->indicators[i])!=None) {
	    static int been_here=0;
	    char *type;
	    if (!been_here) {
		been_here=1;
		printf("indicators:\n");
	    }
	    if (xkb->indicators==NULL)
		 type= "unknown";
	    else if (xkb->indicators->phys_indicators&(1<<i))
		 type= "real   ";
	    else type= "virtual";
	    printf("%s indicator %2d: %s (%s)\n",type,i+1,
					XkbAtomText(dpy,n,XkbMessage),
					((istate&(1<<i))?"on":"off"));
	}
    }
    if (nm->key_aliases) {
	register int nKeys= nm->num_key_aliases;
	printf("Alias      Real\n");
	printf("----------------\n");
	for (i=0;i<nKeys;i++) {
	    printf("%-6s    %-6s\n",
	    		XkbKeyNameText(nm->key_aliases[i].alias,XkbMessage),
			XkbKeyNameText(nm->key_aliases[i].real,XkbMessage));
	}
	printf("----------------\n");
    }
    else {
	printf("No key aliases defined\n");
    }
    if (nm->keys) {
	register int nKeys= xkb->max_key_code-xkb->min_key_code+1;
	char buf[5];
	buf[4]= '\0';
	printf("keys:\n");
	for (i=0;i<nKeys;i++) {
	    memcpy(buf,nm->keys[i+xkb->min_key_code].name,4);
	    printf("%-4s ",buf);
	    if ((i&0x7)==7)
		printf("\n");
	}
	if ((i&0x7)!=0)
	    printf("\n");
    }
    printf("%d keyboard groups\n",ctrls->num_groups);
    printf("keyboard groups %s\n",
		(ctrls->enabled_ctrls&XkbGroupsWrapMask)?"wrap":"don't wrap");
    core_syms= XGetKeyboardMapping(dpy, xkb->min_key_code,XkbNumKeys(xkb),
    								&map_width);
    bzero((char *)&changes,sizeof(XkbChangesRec));
    printf("Choose a key: ");
    while  (fgets(line,256,stdin)) {
	if (sscanf(line,"%s",name)==1) {
	    KeyCode kc;
	    int	k;
	    kc= XkbFindKeycodeByName(xkb,name,True);
	    if (!kc) {
		printf("No key named %s\n",name);
		printf("Choose a key: ");
		continue;
	    }
	    if (core_syms) {
		int offset;
		offset= (kc-xkb->min_key_code)*map_width;
		printf("core symbols:");
		for (i=0;i<map_width;i++) {
		    printf(" %s",XkbKeysymText(core_syms[offset+i],XkbMessage));
		}
		printf("\n");
	    }
	    showKey(dpy,xkb,kc);
	    printf("Enter %d symbols\n",map_width);
	    new_syms= &core_syms[(kc-xkb->min_key_code)*map_width];
	    bzero((char *)new_syms,map_width*sizeof(KeySym));
	    for (k=0;k<map_width;k++) {
		printf(" symbol %d: ",k+1);
		if (scanf("%s",name)<1) {
		    printf("never mind\n");
		    break;
		}
		if ((strcmp(name,"NoSymbol")==0)||(strcmp(name,"-")==0))
		    new_syms[k]= NoSymbol;
		else if (strcmp(name,".")==0) {
		    if (k==0)
			 printf("key unchanged.\n");
		    else k= map_width;
		    break;
		}
		else {
		    new_syms[k]= XStringToKeysym(name);
		    if (new_syms[k]==NoSymbol) {
			printf("Unknown keysym.  Try again.\n");
			k--;
			continue;
		    }
		}
	    }
	    if (k>=map_width) {
		printf("Updating key with core symbols...");
		if (XkbUpdateMapFromCore(xkb,kc,1,map_width,core_syms,&changes))
		     printf("ok\n");
		else printf("failed\n");
		showKey(dpy,xkb,kc);
	    }
	    fgets(line,256,stdin);
	}
	printf("Choose a key: ");
    }
    XCloseDisplay(dpy);
    if (changes.map.changed&XkbKeySymsMask)
	RPT("symbols",changes.map.first_key_sym,changes.map.num_key_syms);
    if (changes.map.changed&XkbKeyActionsMask)
	RPT("actions",changes.map.first_key_act,changes.map.num_key_acts);
    if (changes.map.changed&XkbKeyBehaviorsMask) {
	RPT("behaviors",changes.map.first_key_behavior,
					changes.map.num_key_behaviors);
    }
    if (changes.map.changed&XkbExplicitComponentsMask) {
	RPT("explicit components",changes.map.first_key_explicit,
					changes.map.num_key_explicit);
    }
    if (changes.map.changed&XkbModifierMapMask) {
	RPT("modifier map",changes.map.first_modmap_key,
					changes.map.num_modmap_keys);
    }
    if (changes.map.changed&XkbVirtualModMapMask) {
	RPT("virtual modifier map",changes.map.first_vmodmap_key,
					changes.map.num_vmodmap_keys);
    }
    if (changes.map.changed&XkbVirtualModsMask) 
	printf("virtual modifiers (0x%04x) changed\n",changes.map.vmods);
    return 0;
BAIL:
    XCloseDisplay(dpy);
    return 0;
}
