/* $XConsortium: testmaprules.c /main/1 1996/02/02 09:48:12 kaleb $ */
/************************************************************
 Copyright (c) 1996 by Silicon Graphics Computer Systems, Inc.

 Permission to use, copy, modify, and distribute this
 software and its documentation for any purpose and without
 fee is hereby granted, provided that the above copyright
 notice appear in all copies and that both that copyright
 notice and this permission notice appear in supporting
 documentation, and that the name of Silicon Graphics not be 
 used in advertising or publicity pertaining to distribution 
 of the software without specific prior written permission.
 Silicon Graphics makes no representation about the suitability 
 of this software for any purpose. It is provided "as is"
 without any express or implied warranty.
 
 SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS 
 SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY 
 AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SILICON
 GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL 
 DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE 
 OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
 THE USE OR PERFORMANCE OF THIS SOFTWARE.

 ********************************************************/

#include <stdio.h>
#include <ctype.h>
#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#endif

#include <X11/Xos.h>
#include <X11/Xfuncs.h>

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/XKBlib.h>
#include <X11/extensions/XKBgeom.h>
#include <X11/extensions/XKMformat.h>
#include <X11/extensions/XKBfile.h>

int
main(int argc,char *argv[])
{
XkbComponentNamesRec	names;
FILE			*file;
char			model[100],language[100];

    if (argc<2) {
	XkbComponentNamesFromMapFile(stdin,"model","language",&names);
	return 0;
    }
    file= fopen(argv[1],"r");
    if (!file) {
	fprintf(stderr,"can't open %s\n",argv[1]);
	return 1;
    }
    printf("Enter model: ");
    scanf("%s",model);
    printf("Enter language: ");
    scanf("%s",language);
    if (XkbComponentNamesFromMapFile(file,model,language,&names))
	printf("Got a complete keymap!!\n");
    if (names.keymap)
	printf("[%s,%s]= keymap: %s\n",model,language,names.keymap);
    else {
	printf("[%s,%s]= ",model,language);
	printf("%s:",(names.keycodes?names.keycodes:""));
	printf("%s:",(names.symbols?names.symbols:""));
	printf("%s:",(names.types?names.types:""));
	printf("%s:",(names.compat?names.compat:""));
	printf("%s\n",(names.geometry?names.geometry:""));
    }
    fclose(file);
}
