/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.videolan.vlma.Data;
import org.videolan.vlma.exception.InvalidServerNameException;

/**
 * A servlet which aims at providing a secure and robust way to access to the
 * RRD graphs generated by the VLMa daemon.
 *
 * @author Adrien Grand <jpountz at videolan.org>
 */
public class RrdGraphServlet extends HttpServlet {

    private static final long serialVersionUID = -6858802870444005861L;
    private final static int bufsize = 1024;

    @Override
    protected void doGet(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException {

        WebApplicationContext webApplicationContext = WebApplicationContextUtils
                .getWebApplicationContext(getServletContext());
        Data data = (Data) webApplicationContext.getBean("dataImporter");

        String serverName = request.getParameter("server");
        if (serverName.contains(File.separator)) {
            throw new InvalidServerNameException("Server name musn't contain '"
                    + File.separator + "'.");
        }

        String what = request.getParameter("what");
        Assert.isTrue("vlc".equals(what) || "cpu_load".equals(what)
                || "traffic_out".equals(what));

        String basePath = data.getString("vlma.data");
        File rrdDir = new File(basePath, "rrd");
        File file = new File(rrdDir, serverName + "-" + what + ".png");

        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        byte[] image = new byte[bufsize];

        FileInputStream in = new FileInputStream(file.getAbsolutePath());
        try {
            while (in.read(image) != -1) {
                out.write(image);
            }
        } finally {
            in.close();
        }
        out.close();
    }

}
