/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;
import org.videolan.vlma.Data;
import org.videolan.vlma.model.StreamingStrategy;

public class ConfigurationEditController extends SimpleFormController {

    private Data data;

    public void setData(Data data) {
        this.data = data;
    }

    @Override
    public ModelAndView onSubmit(Object command) throws Exception {
        ConfigurationEdit form = (ConfigurationEdit) command;
        data.setProperty("vlc.telnet.port", form.getVlc_telnet_port());
        data.setProperty("vlc.telnet.password", form.getVlc_telnet_password());
        data.setProperty("vlc.snmp.community", form.getVlc_snmp_community());
        data.setProperty("vlc.snmp.oid.cpu_load", form.getVlc_snmp_oid_cpu_load());
        data.setProperty("vlc.snmp.oid.vlc_cpu", form.getVlc_snmp_oid_vlc_cpu());
        data.setProperty("vlc.snmp.oid.vlc_mem", form.getVlc_snmp_oid_vlc_mem());
        data.setProperty("vlc.snmp.oid.traffic_in", form.getVlc_snmp_oid_traffic_in());
        data.setProperty("vlc.snmp.oid.traffic_out", form.getVlc_snmp_oid_traffic_out());
        data.setProperty("vlma.streaming", form.getVlma_streaming());
        data.setProperty("vlma.encapsulation", form.getVlma_encapsulation());
        data.setProperty("vlma.streaming.http.port", form.getVlma_streaming_http_port());
        data.setProperty("vlma.streaming.udp.ipbank.min", form.getVlma_streaming_udp_ipbank_min());
        data.setProperty("vlma.streaming.udp.ipbank.max", form.getVlma_streaming_udp_ipbank_max());
        data.setProperty("vlc.stream.ttl", form.getVlc_stream_ttl().toString());
        data.setProperty("vlc.stream.dvb-bandwidth", form.getVlc_stream_dvb_bandwidth());
        data.setProperty("vlma.notification.mail.host", form.getVlma_notification_mail_host());
        data.setProperty("vlma.notification.mail.sender", form.getVlma_notification_mail_sender());
        String mailRecipients = form.getVlma_notification_mail_recipients();
        if (!"".equals(mailRecipients.trim()))
            data.setProperty("vlma.notification.mail.recipients", mailRecipients.split(","));
        else
            data.clearProperty("vlma.notification.mail.recipients");
        data.setProperty("vlma.notification.irc.host", form.getVlma_notification_irc_host());
        data.setProperty("vlma.notification.irc.port", form.getVlma_notification_irc_port().toString());
        data.setProperty("vlma.notification.irc.nick", form.getVlma_notification_irc_nick());
        data.setProperty("vlma.notification.irc.pass", form.getVlma_notification_irc_pass());
        String chans = form.getVlma_notification_irc_chan();
        if (!"".equals(chans.trim()))
            data.setProperty("vlma.notification.irc.chan", chans.split(","));
        else
            data.clearProperty("vlma.notification.irc.chan");
        data.setProperty("vlma.notification.msn.login", form.getVlma_notification_msn_login());
        data.setProperty("vlma.notification.msn.pass", form.getVlma_notification_msn_pass());
        String msnRecipients =  form.getVlma_notification_msn_recipients();
        if (!"".equals(msnRecipients.trim()))
            data.setProperty("vlma.notification.msn.recipients", msnRecipients.split(","));
        else
            data.clearProperty("vlma.notification.msn.recipients");
        return new ModelAndView(new RedirectView(getSuccessView()));
    }

    private static String listToString(List list) {
        StringBuilder result = new StringBuilder();
        for(Object o : list) {
            if(!"".equals(o.toString()))
                result.append(",").append(o.toString());
        }
        return result.length() > 0 ? result.substring(1) : "";
    }

    @Override
    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        ConfigurationEdit form = new ConfigurationEdit();
        form.setVlc_telnet_port(data.getInt("vlc.telnet.port"));
        form.setVlc_telnet_password(data.getString("vlc.telnet.password"));
        form.setVlc_snmp_community(data.getString("vlc.snmp.community"));
        form.setVlc_snmp_oid_cpu_load(data.getString("vlc.snmp.oid.cpu_load"));
        form.setVlc_snmp_oid_vlc_cpu(data.getString("vlc.snmp.oid.vlc_cpu"));
        form.setVlc_snmp_oid_vlc_mem(data.getString("vlc.snmp.oid.vlc_mem"));
        form.setVlc_snmp_oid_traffic_in(data.getString("vlc.snmp.oid.traffic_in"));
        form.setVlc_snmp_oid_traffic_out(data.getString("vlc.snmp.oid.traffic_out"));
        form.setVlma_streaming(data.getString("vlma.streaming"));
        form.setVlma_encapsulation(data.getString("vlma.encapsulation"));
        form.setVlma_streaming_http_port(data.getInt("vlma.streaming.http.port"));
        form.setVlma_streaming_udp_ipbank_min(data.getString("vlma.streaming.udp.ipbank.min"));
        form.setVlma_streaming_udp_ipbank_max(data.getString("vlma.streaming.udp.ipbank.max"));
        form.setVlc_stream_ttl(Integer.valueOf(data.getInt("vlc.stream.ttl")));
        form.setVlc_stream_dvb_bandwidth(data.getInt("vlc.stream.dvb-bandwidth"));
        form.setVlma_notification_mail_host(data.getString("vlma.notification.mail.host"));
        form.setVlma_notification_mail_sender(data.getString("vlma.notification.mail.sender"));
        form.setVlma_notification_mail_recipients(listToString(data.getList("vlma.notification.mail.recipients")));
        form.setVlma_notification_irc_host(data.getString("vlma.notification.irc.host"));
        form.setVlma_notification_irc_port(data.getInt("vlma.notification.irc.port"));
        form.setVlma_notification_irc_nick(data.getString("vlma.notification.irc.nick"));
        form.setVlma_notification_irc_pass(data.getString("vlma.notification.irc.pass"));
        form.setVlma_notification_irc_chan(listToString(data.getList("vlma.notification.irc.chan")));
        form.setVlma_notification_msn_login(data.getString("vlma.notification.msn.login"));
        form.setVlma_notification_msn_pass(data.getString("vlma.notification.msn.pass"));
        form.setVlma_notification_msn_recipients(listToString(data.getList("vlma.notification.msn.recipients")));
        return form;
    }

    @Override
    protected ModelAndView showForm(HttpServletRequest arg0, HttpServletResponse arg1, BindException arg2, Map arg3) throws Exception {
        Map<String, Object> m = new HashMap<String, Object>();
        m.put("encapsulations", StreamingStrategy.Encapsulation.values());
        m.put("protocols", StreamingStrategy.Protocol.values());
        return super.showForm(arg0, arg1, arg2, m);
    }
}
