/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.order;

import java.io.IOException;

import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.StreamingStrategy;
import org.videolan.vlma.model.DTTChannel;

public class DTTOrderSender extends OrderSender {

    @Override
    public void start(Order o) throws IOException {
        telnetConnect(o.getAdapter().getServer());
        init(getVLMCommandName(o), o.getAdapter());
        if (!o.getMedias().isEmpty()) {
            DTTChannel ch = (DTTChannel) o.getMedias().get(0);
            telnetCommand("setup " + getVLMCommandName(o) + " input dvb://",
                    o.getAdapter());
            telnetCommand("setup " + getVLMCommandName(o) + " option dvb-frequency="
                    + Integer.toString(ch.getFrequency()), o.getAdapter());
            telnetCommand("setup " + getVLMCommandName(o) + " option dvb-adapter="
                    + o.getAdapter().getName(), o.getAdapter());
            telnetCommand("setup " + getVLMCommandName(o)  + " option dvb-bandwidth="
                    + Integer.toString(configuration.getInt("vlc.stream.dvb-bandwidth")),
                    o.getAdapter());
            StringBuilder ids = new StringBuilder();
            StringBuilder command = new StringBuilder();
            command.append("setup ")
                .append(getVLMCommandName(o))
                .append(" output #duplicate{");
            boolean firstLoop = true;
            for (Media m : o.getMedias()) {
                ch = (DTTChannel) m;
                if (!firstLoop) {
                    ids.append(",");
                }
                ids.append(ch.getSid());
                if (!firstLoop) {
                    command.append(",");
                }
                command.append(String.format("dst=standard{mux=%s,access=%s,dst=%s",
                        getMux(ch.getProgram()), getAccess(ch.getProgram()), getDst(ch.getProgram())));
                if (ch.getProgram().getStreamingStrategy().isEnabled(StreamingStrategy.Announcement.SAP)) {
                    command.append(String.format(",sap,name=\"%s\",group=\"%s\"",
                            ch.getProgram().getSapName(), ch.getProgram().getSapGroup()));
                }
                command.append(String.format("},select=\"program=%d\"", ch.getSid()));
                firstLoop = false;
            }
            // Orders to stream the channels
            telnetCommand("setup " + getVLMCommandName(o)
                    + " option programs=" + ids, o.getAdapter());
            command.append("}");
            telnetCommand(command.toString(), o.getAdapter());
            telnetCommand("setup " + getVLMCommandName(o) + " enabled", o.getAdapter());
            telnetCommand("control " + getVLMCommandName(o) + " play", o.getAdapter());
        }
        telnetClose();
    }

}
