/*
 * Copyright (C) 2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.model;

import static org.junit.Assert.*;

import java.net.InetAddress;

import org.junit.Test;

public class OrderTest {

    private Order order;
    
    @Test
    public void testEquals() throws Exception {
        FilesChannel media1 = new FilesChannel();
        media1.setName("media1");
        FilesChannel media2 = new FilesChannel();
        media2.setName("media2");
        MediaGroup group = new MediaGroup();
        group.add(media1);
        group.add(media2);
        MediaGroup group2 = new MediaGroup();
        group2.add(media2);
        group2.add(media1);
        Adapter adapter = new FilesAdapter();
        Server server = new Server();
        server.setIp(InetAddress.getLocalHost());
        adapter.setName("adapter");
        adapter.setServer(server);
        Adapter adapter2 = new FilesAdapter();
        adapter2.setName("adapter");
        adapter2.setServer(server);
        order = new Order(adapter, group);
        Order order2 = new Order(adapter2, group2);
        assertEquals(order, order2);
        assertEquals(order.hashCode(), order2.hashCode());
    }

}
