/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.Util;

class Source {
    protected static final int AGG_MINIMUM = 0;
    protected static final int AGG_MAXIMUM = 1;
    protected static final int AGG_AVERAGE = 2;
    protected static final int AGG_FIRST = 3;
    protected static final int AGG_LAST = 4;
    protected static final int AGG_TOTAL = 5;
    protected static final String[] aggregates = new String[]{"MINIMUM", "MAXIMUM", "AVERAGE", "FIRST", "LAST", "TOTAL"};
    private String name;
    protected int aggregatePoints;
    protected double[] values;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private double lastValue = Double.NaN;
    private double totalValue = 0.0;
    private double nextValue = Double.POSITIVE_INFINITY;
    protected long step = 0L;
    private long lastPreciseTime = 0L;
    private long lastTime = 0L;
    private long totalTime = 0L;
    private int stPos = 0;
    private int lastStPos = 0;

    Source(String string) {
        this.name = string;
    }

    void set(int n, long l, double d) {
        if (n > 0 && n < this.aggregatePoints) {
            this.aggregate(l, d);
        }
    }

    void setFetchedStep(long l) {
        this.step = l;
    }

    long getStep() {
        return this.step;
    }

    double get(int n) {
        if (n < 0) {
            return Double.NaN;
        }
        if (n > this.values.length) {
            return Double.NaN;
        }
        double d = this.values[n];
        if (Double.isInfinite(d)) {
            if (!Double.isInfinite(this.nextValue) && n >= this.lastStPos) {
                return this.nextValue;
            }
            this.lastStPos = n;
            for (int i = n + 1; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i])) continue;
                this.nextValue = this.values[i];
                return this.nextValue;
            }
            this.nextValue = Double.NaN;
            return this.nextValue;
        }
        this.nextValue = Double.POSITIVE_INFINITY;
        this.lastStPos = n;
        return this.values[n];
    }

    double get(long l, long[] lArray) {
        long l2 = Util.normalize(l, this.step);
        long l3 = l2 = l2 < l ? l2 + this.step : l2;
        if (l < this.lastPreciseTime) {
            this.stPos = 0;
        }
        this.lastPreciseTime = l;
        while (this.stPos < lArray.length - 1) {
            if (lArray[this.stPos + 1] <= l2) {
                ++this.stPos;
                continue;
            }
            return this.get(this.stPos);
        }
        if (l2 <= lArray[this.stPos]) {
            return this.get(this.stPos);
        }
        return Double.NaN;
    }

    double getAggregate(int n) {
        switch (n) {
            case 0: {
                return this.min;
            }
            case 1: {
                return this.max;
            }
            case 2: {
                if (this.totalTime <= 0L) break;
                return this.totalValue / (double)this.totalTime;
            }
            case 3: {
                if (this.values == null || this.values.length <= 0) break;
                return this.values[0];
            }
            case 4: {
                if (this.values == null || this.values.length <= 0) break;
                return this.values[this.values.length - 1];
            }
            case 5: {
                return this.totalValue;
            }
        }
        return Double.NaN;
    }

    String getName() {
        return this.name;
    }

    double[] getValues() {
        return this.values;
    }

    long getSampleCount() {
        return this.values != null ? this.values.length : 0;
    }

    private void aggregate(long l, double d) {
        if (Double.isInfinite(d)) {
            return;
        }
        this.min = Util.min(this.min, d);
        this.max = Util.max(this.max, d);
        if (!Double.isNaN(this.lastValue) && !Double.isNaN(d)) {
            long l2 = l - this.lastTime;
            this.totalValue += (double)l2 * (d + this.lastValue) / 2.0;
            this.totalTime += l2;
        }
        this.lastTime = l;
        this.lastValue = d;
    }
}

