/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.ArrayList;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Source;

class RpnCalculator {
    public static final byte TKN_CONSTANT = 0;
    public static final byte TKN_DATASOURCE = 1;
    public static final byte TKN_PLUS = 2;
    public static final byte TKN_MINUS = 3;
    public static final byte TKN_MULTIPLY = 4;
    public static final byte TKN_DIVIDE = 5;
    public static final byte TKN_MOD = 6;
    public static final byte TKN_SIN = 7;
    public static final byte TKN_COS = 8;
    public static final byte TKN_LOG = 9;
    public static final byte TKN_EXP = 10;
    public static final byte TKN_FLOOR = 11;
    public static final byte TKN_CEIL = 12;
    public static final byte TKN_ROUND = 13;
    public static final byte TKN_POW = 14;
    public static final byte TKN_ABS = 15;
    public static final byte TKN_SQRT = 16;
    public static final byte TKN_RANDOM = 17;
    public static final byte TKN_LT = 18;
    public static final byte TKN_LE = 19;
    public static final byte TKN_GT = 20;
    public static final byte TKN_GE = 21;
    public static final byte TKN_EQ = 22;
    public static final byte TKN_IF = 23;
    public static final byte TKN_MIN = 24;
    public static final byte TKN_MAX = 25;
    public static final byte TKN_LIMIT = 26;
    public static final byte TKN_DUP = 27;
    public static final byte TKN_EXC = 28;
    public static final byte TKN_POP = 29;
    public static final byte TKN_UN = 30;
    public static final byte TKN_UNKN = 31;
    public static final byte TKN_NOW = 32;
    public static final byte TKN_TIME = 33;
    public static final byte TKN_PI = 34;
    public static final byte TKN_E = 35;
    public static final byte TKN_AND = 36;
    public static final byte TKN_OR = 37;
    public static final byte TKN_XOR = 38;
    public static final byte TKN_SAMPLES = 39;
    public static final byte TKN_STEP = 40;
    private double step;
    private Source[] sources;
    private ArrayList stack = new ArrayList();

    RpnCalculator(Source[] sourceArray, double d) {
        this.sources = sourceArray;
        this.step = d;
    }

    public double evaluate(Cdef cdef, int n, long l) throws RrdException {
        this.stack.clear();
        byte[] byArray = cdef.getTokens();
        int[] nArray = cdef.getDsIndices();
        double[] dArray = cdef.getConstants();
        block43: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 0: {
                    this.push(dArray[i]);
                    continue block43;
                }
                case 1: {
                    this.push(this.sources[nArray[i]].get(n));
                    continue block43;
                }
                case 2: {
                    this.push(this.pop() + this.pop());
                    continue block43;
                }
                case 3: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 - d3);
                    continue block43;
                }
                case 4: {
                    this.push(this.pop() * this.pop());
                    continue block43;
                }
                case 5: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 / d3);
                    continue block43;
                }
                case 6: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 % d3);
                    continue block43;
                }
                case 7: {
                    this.push(Math.sin(this.pop()));
                    continue block43;
                }
                case 8: {
                    this.push(Math.cos(this.pop()));
                    continue block43;
                }
                case 9: {
                    this.push(Math.log(this.pop()));
                    continue block43;
                }
                case 10: {
                    this.push(Math.exp(this.pop()));
                    continue block43;
                }
                case 11: {
                    this.push(Math.floor(this.pop()));
                    continue block43;
                }
                case 12: {
                    this.push(Math.ceil(this.pop()));
                    continue block43;
                }
                case 13: {
                    this.push(Math.round(this.pop()));
                    continue block43;
                }
                case 14: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(Math.pow(d2, d3));
                    continue block43;
                }
                case 15: {
                    this.push(Math.abs(this.pop()));
                    continue block43;
                }
                case 16: {
                    this.push(Math.sqrt(this.pop()));
                    continue block43;
                }
                case 17: {
                    this.push(Math.random());
                    continue block43;
                }
                case 18: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 < d3 ? 1.0 : 0.0);
                    continue block43;
                }
                case 19: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 <= d3 ? 1.0 : 0.0);
                    continue block43;
                }
                case 20: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 > d3 ? 1.0 : 0.0);
                    continue block43;
                }
                case 21: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 >= d3 ? 1.0 : 0.0);
                    continue block43;
                }
                case 22: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 == d3 ? 1.0 : 0.0);
                    continue block43;
                }
                case 23: {
                    double d = this.pop();
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 ? d3 : d);
                    continue block43;
                }
                case 24: {
                    this.push(Math.min(this.pop(), this.pop()));
                    continue block43;
                }
                case 25: {
                    this.push(Math.max(this.pop(), this.pop()));
                    continue block43;
                }
                case 26: {
                    double d = this.pop();
                    double d4 = this.pop();
                    double d5 = this.pop();
                    this.push(d5 < d4 || d5 > d ? Double.NaN : d5);
                    continue block43;
                }
                case 27: {
                    double d = this.pop();
                    this.push(d);
                    this.push(d);
                    continue block43;
                }
                case 28: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d3);
                    this.push(d2);
                    continue block43;
                }
                case 29: {
                    this.pop();
                    continue block43;
                }
                case 30: {
                    this.push(Double.isNaN(this.pop()) ? 1.0 : 0.0);
                    continue block43;
                }
                case 31: {
                    this.push(Double.NaN);
                    continue block43;
                }
                case 32: {
                    this.push(Util.getTime());
                    continue block43;
                }
                case 33: {
                    this.push(l);
                    continue block43;
                }
                case 34: {
                    this.push(Math.PI);
                    continue block43;
                }
                case 35: {
                    this.push(Math.E);
                    continue block43;
                }
                case 36: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 && d3 != 0.0 ? 1.0 : 0.0);
                    continue block43;
                }
                case 37: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 || d3 != 0.0 ? 1.0 : 0.0);
                    continue block43;
                }
                case 38: {
                    double d3 = this.pop();
                    double d2 = this.pop();
                    this.push(d2 != 0.0 && d3 == 0.0 || d2 == 0.0 && d3 != 0.0 ? 1.0 : 0.0);
                    continue block43;
                }
                case 39: {
                    this.push(cdef.getSampleCount());
                    continue block43;
                }
                case 40: {
                    this.push(this.step);
                }
            }
        }
        if (this.stack.size() != 1) {
            throw new RrdException("RPN error, invalid stack length");
        }
        return this.pop();
    }

    private void push(double d) {
        this.stack.add(new Double(d));
    }

    private double pop() throws RrdException {
        int n = this.stack.size() - 1;
        if (n < 0) {
            throw new RrdException("POP failed, stack empty");
        }
        Double d = (Double)this.stack.remove(n);
        return d;
    }
}

