/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPObject;

public class SNMPObjectIdentifier
extends SNMPObject {
    private int[] digits;
    protected byte tag = (byte)6;

    public SNMPObjectIdentifier() {
        this.digits = new int[0];
    }

    public SNMPObjectIdentifier(String string) throws SNMPBadValueException {
        this.convertDigitString(string);
    }

    public SNMPObjectIdentifier(int[] nArray) throws SNMPBadValueException {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 0) continue;
            throw new SNMPBadValueException("Negative value supplied for SNMPObjectIdentifier.");
        }
        this.digits = nArray;
    }

    protected SNMPObjectIdentifier(byte[] byArray) throws SNMPBadValueException {
        this.extractFromBEREncoding(byArray);
    }

    public Object getValue() {
        return this.digits;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof int[]) {
            for (int i = 0; i < ((int[])object).length; ++i) {
                if (((int[])object)[i] >= 0) continue;
                throw new SNMPBadValueException("Negative value supplied for SNMPObjectIdentifier.");
            }
            this.digits = (int[])object;
        } else if (object instanceof String) {
            this.convertDigitString((String)object);
        } else {
            throw new SNMPBadValueException(" Object Identifier: bad object supplied to set value ");
        }
    }

    protected byte[] getBEREncoding() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 6;
        byte[] byArray = this.encodeArray();
        byte[] byArray2 = SNMPBERCodec.encodeLength(byArray.length);
        byteArrayOutputStream.write(n);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] encodeArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.digits.length;
        if (n >= 2) {
            byteArrayOutputStream.write((byte)(40 * this.digits[0] + this.digits[1]));
        } else if (n == 1) {
            byteArrayOutputStream.write((byte)(40 * this.digits[0]));
        }
        for (int i = 2; i < n; ++i) {
            byte[] byArray = this.encodeValue(this.digits[i]);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] encodeValue(int n) {
        int n2 = 0;
        int n3 = n;
        do {
            ++n2;
        } while ((n3 = (int)Math.floor(n3 / 128)) > 0);
        byte[] byArray = new byte[n2];
        byArray[n2 - 1] = (byte)(n % 128);
        n = (int)Math.floor(n / 128);
        for (int i = n2 - 2; i >= 0; --i) {
            byArray[i] = (byte)(n % 128 + 128);
            n = (int)Math.floor(n / 128);
        }
        return byArray;
    }

    private void convertDigitString(String string) throws SNMPBadValueException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " .");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                stringTokenizer.nextToken();
            }
            int[] nArray = new int[n];
            stringTokenizer = new StringTokenizer(string, " .");
            for (int i = 0; i < n; ++i) {
                nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                if (nArray[i] >= 0) continue;
                throw new SNMPBadValueException(" Object Identifier: bad string supplied to set value ");
            }
            this.digits = nArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SNMPBadValueException(" Object Identifier: bad string supplied for object identifier value ");
        }
    }

    private void extractFromBEREncoding(byte[] byArray) throws SNMPBadValueException {
        int n;
        int n2 = 128;
        int n3 = 127;
        int n4 = 0;
        for (n = 0; n < byArray.length; ++n) {
            if ((byArray[n] & n2) != 0) continue;
            ++n4;
        }
        if (n4 > 0) {
            this.digits = new int[n4 + 1];
            n = -1;
            int n5 = 0;
            do {
                n5 = n5 * 128 + (byArray[++n] & n3);
            } while ((byArray[n] & n2) > 0);
            this.digits[0] = (int)Math.floor(n5 / 40);
            this.digits[1] = n5 % 40;
            for (int i = 2; i < n4 + 1; ++i) {
                n5 = 0;
                do {
                    n5 = n5 * 128 + (byArray[++n] & n3);
                } while ((byArray[n] & n2) > 0);
                this.digits[i] = n5;
            }
        } else {
            this.digits = new int[0];
        }
    }

    public boolean equals(SNMPObjectIdentifier sNMPObjectIdentifier) {
        int[] nArray = (int[])sNMPObjectIdentifier.getValue();
        boolean bl = true;
        if (this.digits.length != nArray.length) {
            bl = false;
        } else {
            for (int i = 0; i < this.digits.length; ++i) {
                if (this.digits[i] == nArray[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public String toString() {
        String string = new String();
        if (this.digits.length > 0) {
            string = string + this.digits[0];
            for (int i = 1; i < this.digits.length; ++i) {
                string = string + "." + this.digits[i];
            }
        }
        return string;
    }
}

