/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.core.XmlTemplate;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RrdDefTemplate
extends XmlTemplate {
    public RrdDefTemplate(InputSource inputSource) throws IOException, RrdException {
        super(inputSource);
    }

    public RrdDefTemplate(String string) throws IOException, RrdException {
        super(string);
    }

    public RrdDefTemplate(File file) throws IOException, RrdException {
        super(file);
    }

    public RrdDef getRrdDef() throws RrdException {
        String string;
        if (!this.root.getTagName().equals("rrd_def")) {
            throw new RrdException("XML definition must start with <rrd_def>");
        }
        this.validateTagsOnlyOnce(this.root, new String[]{"path", "start", "step", "datasource*", "archive*"});
        String string2 = this.getChildValue(this.root, "path");
        RrdDef rrdDef = new RrdDef(string2);
        try {
            String string3 = this.getChildValue(this.root, "start");
            GregorianCalendar gregorianCalendar = Util.getGregorianCalendar(string3);
            rrdDef.setStartTime(gregorianCalendar);
        }
        catch (RrdException rrdException) {
            // empty catch block
        }
        try {
            long l = this.getChildValueAsLong(this.root, "step");
            rrdDef.setStep(l);
        }
        catch (RrdException rrdException) {
            // empty catch block
        }
        Node[] nodeArray = RrdDefTemplate.getChildNodes(this.root, "datasource");
        for (int i = 0; i < nodeArray.length; ++i) {
            this.validateTagsOnlyOnce(nodeArray[i], new String[]{"name", "type", "heartbeat", "min", "max"});
            String string4 = this.getChildValue(nodeArray[i], "name");
            string = this.getChildValue(nodeArray[i], "type");
            long l = this.getChildValueAsLong(nodeArray[i], "heartbeat");
            double d = this.getChildValueAsDouble(nodeArray[i], "min");
            double d2 = this.getChildValueAsDouble(nodeArray[i], "max");
            rrdDef.addDatasource(string4, string, l, d, d2);
        }
        Node[] nodeArray2 = RrdDefTemplate.getChildNodes(this.root, "archive");
        for (int i = 0; i < nodeArray2.length; ++i) {
            this.validateTagsOnlyOnce(nodeArray2[i], new String[]{"cf", "xff", "steps", "rows"});
            string = this.getChildValue(nodeArray2[i], "cf");
            double d = this.getChildValueAsDouble(nodeArray2[i], "xff");
            int n = this.getChildValueAsInt(nodeArray2[i], "steps");
            int n2 = this.getChildValueAsInt(nodeArray2[i], "rows");
            rrdDef.addArchive(string, d, n, n2);
        }
        return rrdDef;
    }
}

