/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TransactionInProgressException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class JmsResourceHolder
extends ResourceHolderSupport {
    private static final Log logger = LogFactory.getLog((Class)JmsResourceHolder.class);
    private ConnectionFactory connectionFactory;
    private boolean frozen = false;
    private final List connections = new LinkedList();
    private final List sessions = new LinkedList();
    private final Map sessionsPerConnection = new HashMap();

    public JmsResourceHolder() {
    }

    public JmsResourceHolder(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public JmsResourceHolder(Session session) {
        this.addSession(session);
        this.frozen = true;
    }

    public JmsResourceHolder(Connection connection, Session session) {
        this.addConnection(connection);
        this.addSession(session, connection);
        this.frozen = true;
    }

    public JmsResourceHolder(ConnectionFactory connectionFactory, Connection connection, Session session) {
        this.connectionFactory = connectionFactory;
        this.addConnection(connection);
        this.addSession(session, connection);
        this.frozen = true;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public final void addConnection(Connection connection) {
        Assert.isTrue(!this.frozen, "Cannot add Connection because JmsResourceHolder is frozen");
        Assert.notNull(connection, "Connection must not be null");
        if (!this.connections.contains(connection)) {
            this.connections.add(connection);
        }
    }

    public final void addSession(Session session) {
        this.addSession(session, null);
    }

    public final void addSession(Session session, Connection connection) {
        Assert.isTrue(!this.frozen, "Cannot add Session because JmsResourceHolder is frozen");
        Assert.notNull(session, "Session must not be null");
        if (!this.sessions.contains(session)) {
            this.sessions.add(session);
            if (connection != null) {
                LinkedList<Session> sessions = (LinkedList<Session>)this.sessionsPerConnection.get(connection);
                if (sessions == null) {
                    sessions = new LinkedList<Session>();
                    this.sessionsPerConnection.put(connection, sessions);
                }
                sessions.add(session);
            }
        }
    }

    public boolean containsSession(Session session) {
        return this.sessions.contains(session);
    }

    public Connection getConnection() {
        return !this.connections.isEmpty() ? (Connection)this.connections.get(0) : null;
    }

    public Connection getConnection(Class connectionType) {
        return (Connection)CollectionUtils.findValueOfType((Collection)this.connections, connectionType);
    }

    public Session getSession() {
        return !this.sessions.isEmpty() ? (Session)this.sessions.get(0) : null;
    }

    public Session getSession(Class sessionType) {
        return this.getSession(sessionType, null);
    }

    public Session getSession(Class sessionType, Connection connection) {
        List sessions = this.sessions;
        if (connection != null) {
            sessions = (List)this.sessionsPerConnection.get(connection);
        }
        return (Session)CollectionUtils.findValueOfType((Collection)sessions, sessionType);
    }

    public void commitAll() throws JMSException {
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            try {
                ((Session)it.next()).commit();
            }
            catch (TransactionInProgressException ex) {
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    public void closeAll() {
        Iterator it = this.sessions.iterator();
        while (it.hasNext()) {
            try {
                ((Session)it.next()).close();
            }
            catch (Throwable ex) {
                logger.debug((Object)"Could not close synchronized JMS Session after transaction", ex);
            }
        }
        it = this.connections.iterator();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ConnectionFactoryUtils.releaseConnection(con, this.connectionFactory, true);
        }
    }
}

