/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.notifier;

import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.videolan.vlma.notifier.Notifier;

public class MailNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(MailNotifier.class);
    private Configuration configuration;
    private JavaMailSenderImpl mailSender;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    private boolean isMailEnabled() {
        List tmp = this.configuration.getList("vlma.notification.mail.recipients");
        return tmp != null && tmp.size() > 0;
    }

    public void sendNotification(String message) {
        if (this.isMailEnabled()) {
            SimpleMailMessage msg = new SimpleMailMessage();
            String from = this.configuration.getString("vlma.notification.mail.sender");
            List recipients = this.configuration.getList("vlma.notification.mail.recipients");
            this.mailSender.setHost(this.configuration.getString("vlma.notification.mail.host"));
            msg.setFrom(from);
            String[] recipientsArray = new String[recipients.size()];
            int i = 0;
            for (String recipient : recipients) {
                recipientsArray[i++] = recipient;
            }
            msg.setTo(recipientsArray);
            msg.setSubject(message);
            msg.setText(message);
            try {
                this.mailSender.send(msg);
            }
            catch (MailException e) {
                logger.error((Object)"Mail could not be sent.", (Throwable)e);
            }
        }
    }
}

