/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BDFontMetrics;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import org.videolan.Logger;
import org.videolan.StrUtil;

public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    protected String name;
    protected int style;
    protected int size;
    transient FontMetrics metrics = null;
    private transient String family = null;
    protected transient File fontFile = null;
    public static final int TRUETYPE_FONT = 0;
    private static final long serialVersionUID = -4206021311591459213L;

    public Font(String name, int style, int size) {
        this(name, style, size, null, null);
    }

    public Font(Map attributes) {
        this.name = "Default";
        this.style = 0;
        this.size = 12;
        Logger.unimplemented((String)"Font", (String)"Font(Map)");
        this.setFamily();
    }

    public static Font decode(String str) {
        if (str == null) {
            return new Font("Dialog", 0, 12);
        }
        Logger.unimplemented((String)"Font", (String)"decode");
        return new Font("Dialog", 0, 12);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Font)) {
            return false;
        }
        Font font = (Font)obj;
        if (this.size != font.size || this.style != font.style || !this.name.equals(font.name)) {
            return false;
        }
        return this.fontFile == null || font.fontFile == null || this.fontFile.equals(font.fontFile);
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attributes = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SIZE};
        return attributes;
    }

    public Map getAttributes() {
        Hashtable<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, this.name);
        map.put(TextAttribute.SIZE, new Float(this.size));
        map.put(TextAttribute.WEIGHT, (this.style & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        map.put(TextAttribute.POSTURE, (this.style & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        return map;
    }

    public String getFamily() {
        return this.family;
    }

    public static Font getFont(Map attributes) {
        Font font = (Font)attributes.get(TextAttribute.FONT);
        if (font != null) {
            return font;
        }
        return new Font(attributes);
    }

    public static Font getFont(String nm) {
        return Font.getFont(nm, null);
    }

    public static Font getFont(String nm, Font font) {
        String str = System.getProperty(nm);
        if (str == null) {
            return font;
        }
        return Font.decode(str);
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public String toString() {
        String[] strStyle = new String[]{"plain", "bold", "italic", "bolditalic"};
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + strStyle[this.style] + ",size=" + this.size + "]";
    }

    public static Font createFont(int type, File fontFile) throws FontFormatException {
        if (type != 0) {
            throw new FontFormatException("unsupported font format");
        }
        if (fontFile == null) {
            throw new NullPointerException("fontFile is null");
        }
        String[] data = BDFontMetrics.getFontFamilyAndStyle(fontFile.getPath());
        if (data == null || data.length < 2) {
            throw new FontFormatException("error loading font " + fontFile.getPath());
        }
        String family = data[0];
        int style = Font.parseStyle(data[1]);
        return new Font(family, style, 1, fontFile, family);
    }

    public Font deriveFont(int style, int size) {
        return new Font(this.name, style, size, this.fontFile, this.family);
    }

    public Font deriveFont(int style, float size) {
        return new Font(this.name, style, (int)size, this.fontFile, this.family);
    }

    private Font(String name, int style, int size, File fontFile, String family) {
        this.name = name != null ? name : "Default";
        this.style = (style & 0xFFFFFFFC) == 0 ? style : 0;
        this.size = size;
        this.fontFile = fontFile;
        this.family = family;
        if (family == null) {
            this.setFamily();
        }
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.setFamily();
    }

    private static int parseStyle(String styleName) {
        int style = 0;
        if (styleName != null && styleName.length() > 0) {
            String[] styles = StrUtil.split((String)styleName, (char)' ');
            if (styles.length == 1) {
                styles = StrUtil.split((String)styles[0], (char)',');
            }
            for (int i = 0; i < styles.length; ++i) {
                styleName = styles[i].toLowerCase();
                if (styleName.equals("bolditalic")) {
                    style |= 3;
                    continue;
                }
                if (styleName.equals("italic")) {
                    style |= 2;
                    continue;
                }
                if (styleName.equals("bold")) {
                    style |= 1;
                    continue;
                }
                if (styleName.equals("plain") || styleName.equals("serif") || styleName.equals("regular") || styleName.equals("roman")) continue;
                Logger.getLogger((String)"Font").info("unregonized style: " + styleName);
            }
        }
        return style;
    }

    private void setFamily() {
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (names.length == 0) {
            this.family = "Default";
            return;
        }
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equalsIgnoreCase(this.name)) {
                this.family = names[i];
                return;
            }
            if (!names[i].equalsIgnoreCase("Dialog")) continue;
            this.family = names[i];
        }
        if (this.family == null) {
            this.family = names[0];
        }
    }
}

