/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.internal.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.LruCache;
import android.support.v7.appcompat.R;
import android.support.v7.internal.widget.TintDrawableWrapper;
import android.support.v7.internal.widget.TintResources;
import android.util.TypedValue;

public class TintManager {
    private static final String TAG = TintManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    static final PorterDuff.Mode DEFAULT_MODE = PorterDuff.Mode.SRC_IN;
    private static final ColorFilterLruCache COLOR_FILTER_CACHE = new ColorFilterLruCache(6);
    private static final int[] TINT_COLOR_CONTROL_NORMAL = new int[]{R.drawable.abc_ic_ab_back_mtrl_am_alpha, R.drawable.abc_ic_go_search_api_mtrl_alpha, R.drawable.abc_ic_search_api_mtrl_alpha, R.drawable.abc_ic_commit_search_api_mtrl_alpha, R.drawable.abc_ic_clear_mtrl_alpha, R.drawable.abc_ic_menu_share_mtrl_alpha, R.drawable.abc_ic_menu_copy_mtrl_am_alpha, R.drawable.abc_ic_menu_cut_mtrl_alpha, R.drawable.abc_ic_menu_selectall_mtrl_alpha, R.drawable.abc_ic_menu_paste_mtrl_am_alpha, R.drawable.abc_ic_menu_moreoverflow_mtrl_alpha, R.drawable.abc_ic_voice_search_api_mtrl_alpha, R.drawable.abc_textfield_search_default_mtrl_alpha, R.drawable.abc_textfield_default_mtrl_alpha};
    private static final int[] TINT_COLOR_CONTROL_ACTIVATED = new int[]{R.drawable.abc_textfield_activated_mtrl_alpha, R.drawable.abc_textfield_search_activated_mtrl_alpha, R.drawable.abc_cab_background_top_mtrl_alpha};
    private static final int[] TINT_COLOR_BACKGROUND_MULTIPLY = new int[]{R.drawable.abc_popup_background_mtrl_mult, R.drawable.abc_cab_background_internal_bg, R.drawable.abc_menu_hardkey_panel_mtrl_mult};
    private static final int[] TINT_COLOR_CONTROL_STATE_LIST = new int[]{R.drawable.abc_edit_text_material, R.drawable.abc_tab_indicator_material, R.drawable.abc_textfield_search_material, R.drawable.abc_spinner_mtrl_am_alpha, R.drawable.abc_btn_check_material, R.drawable.abc_btn_radio_material};
    private static final int[] CONTAINERS_WITH_TINT_CHILDREN = new int[]{R.drawable.abc_cab_background_top_material};
    private final Context mContext;
    private final Resources mResources;
    private final TypedValue mTypedValue;
    private ColorStateList mDefaultColorStateList;
    private ColorStateList mSwitchThumbStateList;
    private ColorStateList mSwitchTrackStateList;

    public static Drawable getDrawable(Context context, int resId) {
        if (TintManager.isInTintList(resId)) {
            return new TintManager(context).getDrawable(resId);
        }
        return ContextCompat.getDrawable((Context)context, (int)resId);
    }

    public TintManager(Context context) {
        this.mContext = context;
        this.mResources = new TintResources(context.getResources(), this);
        this.mTypedValue = new TypedValue();
    }

    public Drawable getDrawable(int resId) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)resId);
        if (drawable2 != null) {
            if (TintManager.arrayContains(TINT_COLOR_CONTROL_STATE_LIST, resId)) {
                drawable2 = new TintDrawableWrapper(drawable2, this.getDefaultColorStateList());
            } else if (resId == R.drawable.abc_switch_track_mtrl_alpha) {
                drawable2 = new TintDrawableWrapper(drawable2, this.getSwitchTrackColorStateList());
            } else if (resId == R.drawable.abc_switch_thumb_material) {
                drawable2 = new TintDrawableWrapper(drawable2, this.getSwitchThumbColorStateList(), PorterDuff.Mode.MULTIPLY);
            } else if (TintManager.arrayContains(CONTAINERS_WITH_TINT_CHILDREN, resId)) {
                drawable2 = this.mResources.getDrawable(resId);
            } else {
                this.tintDrawable(resId, drawable2);
            }
        }
        return drawable2;
    }

    void tintDrawable(int resId, Drawable drawable2) {
        PorterDuff.Mode tintMode = null;
        boolean colorAttrSet = false;
        int colorAttr = 0;
        int alpha = -1;
        if (TintManager.arrayContains(TINT_COLOR_CONTROL_NORMAL, resId)) {
            colorAttr = R.attr.colorControlNormal;
            colorAttrSet = true;
        } else if (TintManager.arrayContains(TINT_COLOR_CONTROL_ACTIVATED, resId)) {
            colorAttr = R.attr.colorControlActivated;
            colorAttrSet = true;
        } else if (TintManager.arrayContains(TINT_COLOR_BACKGROUND_MULTIPLY, resId)) {
            colorAttr = 0x1010031;
            colorAttrSet = true;
            tintMode = PorterDuff.Mode.MULTIPLY;
        } else if (resId == R.drawable.abc_list_divider_mtrl_alpha) {
            colorAttr = 0x1010030;
            colorAttrSet = true;
            alpha = Math.round(40.8f);
        }
        if (colorAttrSet) {
            int color2;
            PorterDuffColorFilter filter;
            if (tintMode == null) {
                tintMode = DEFAULT_MODE;
            }
            if ((filter = COLOR_FILTER_CACHE.get(color2 = this.getThemeAttrColor(colorAttr), tintMode)) == null) {
                filter = new PorterDuffColorFilter(color2, tintMode);
                COLOR_FILTER_CACHE.put(color2, tintMode, filter);
            }
            drawable2.setColorFilter((ColorFilter)filter);
            if (alpha != -1) {
                drawable2.setAlpha(alpha);
            }
        }
    }

    private static boolean arrayContains(int[] array, int value) {
        for (int id2 : array) {
            if (id2 != value) continue;
            return true;
        }
        return false;
    }

    private static boolean isInTintList(int drawableId) {
        return TintManager.arrayContains(TINT_COLOR_BACKGROUND_MULTIPLY, drawableId) || TintManager.arrayContains(TINT_COLOR_CONTROL_NORMAL, drawableId) || TintManager.arrayContains(TINT_COLOR_CONTROL_ACTIVATED, drawableId) || TintManager.arrayContains(TINT_COLOR_CONTROL_STATE_LIST, drawableId) || TintManager.arrayContains(CONTAINERS_WITH_TINT_CHILDREN, drawableId);
    }

    private ColorStateList getDefaultColorStateList() {
        if (this.mDefaultColorStateList == null) {
            int colorControlNormal = this.getThemeAttrColor(R.attr.colorControlNormal);
            int colorControlActivated = this.getThemeAttrColor(R.attr.colorControlActivated);
            int[][] states = new int[7][];
            int[] colors = new int[7];
            int i = 0;
            states[i] = new int[]{-16842910};
            colors[i] = this.getDisabledThemeAttrColor(R.attr.colorControlNormal);
            states[++i] = new int[]{16842908};
            colors[i] = colorControlActivated;
            states[++i] = new int[]{16843518};
            colors[i] = colorControlActivated;
            states[++i] = new int[]{16842919};
            colors[i] = colorControlActivated;
            states[++i] = new int[]{0x10100A0};
            colors[i] = colorControlActivated;
            states[++i] = new int[]{0x10100A1};
            colors[i] = colorControlActivated;
            states[++i] = new int[0];
            colors[i] = colorControlNormal;
            ++i;
            this.mDefaultColorStateList = new ColorStateList((int[][])states, colors);
        }
        return this.mDefaultColorStateList;
    }

    private ColorStateList getSwitchTrackColorStateList() {
        if (this.mSwitchTrackStateList == null) {
            int[][] states = new int[3][];
            int[] colors = new int[3];
            int i = 0;
            states[i] = new int[]{-16842910};
            colors[i] = this.getThemeAttrColor(0x1010030, 0.1f);
            states[++i] = new int[]{0x10100A0};
            colors[i] = this.getThemeAttrColor(R.attr.colorControlActivated, 0.3f);
            states[++i] = new int[0];
            colors[i] = this.getThemeAttrColor(0x1010030, 0.3f);
            ++i;
            this.mSwitchTrackStateList = new ColorStateList((int[][])states, colors);
        }
        return this.mSwitchTrackStateList;
    }

    private ColorStateList getSwitchThumbColorStateList() {
        if (this.mSwitchThumbStateList == null) {
            int[][] states = new int[3][];
            int[] colors = new int[3];
            int i = 0;
            states[i] = new int[]{-16842910};
            colors[i] = this.getDisabledThemeAttrColor(R.attr.colorSwitchThumbNormal);
            states[++i] = new int[]{0x10100A0};
            colors[i] = this.getThemeAttrColor(R.attr.colorControlActivated);
            states[++i] = new int[0];
            colors[i] = this.getThemeAttrColor(R.attr.colorSwitchThumbNormal);
            ++i;
            this.mSwitchThumbStateList = new ColorStateList((int[][])states, colors);
        }
        return this.mSwitchThumbStateList;
    }

    int getThemeAttrColor(int attr2) {
        if (this.mContext.getTheme().resolveAttribute(attr2, this.mTypedValue, true)) {
            if (this.mTypedValue.type >= 16 && this.mTypedValue.type <= 31) {
                return this.mTypedValue.data;
            }
            if (this.mTypedValue.type == 3) {
                return this.mResources.getColor(this.mTypedValue.resourceId);
            }
        }
        return 0;
    }

    int getThemeAttrColor(int attr2, float alpha) {
        int color2 = this.getThemeAttrColor(attr2);
        int originalAlpha = Color.alpha((int)color2);
        return color2 & 0xFFFFFF | Math.round((float)originalAlpha * alpha) << 24;
    }

    int getDisabledThemeAttrColor(int attr2) {
        this.mContext.getTheme().resolveAttribute(0x1010033, this.mTypedValue, true);
        float disabledAlpha = this.mTypedValue.getFloat();
        return this.getThemeAttrColor(attr2, disabledAlpha);
    }

    private static class ColorFilterLruCache
    extends LruCache<Integer, PorterDuffColorFilter> {
        public ColorFilterLruCache(int maxSize) {
            super(maxSize);
        }

        PorterDuffColorFilter get(int color2, PorterDuff.Mode mode) {
            return (PorterDuffColorFilter)this.get(ColorFilterLruCache.generateCacheKey(color2, mode));
        }

        PorterDuffColorFilter put(int color2, PorterDuff.Mode mode, PorterDuffColorFilter filter) {
            return (PorterDuffColorFilter)this.put(ColorFilterLruCache.generateCacheKey(color2, mode), filter);
        }

        private static int generateCacheKey(int color2, PorterDuff.Mode mode) {
            int hashCode = 1;
            hashCode = 31 * hashCode + color2;
            hashCode = 31 * hashCode + mode.hashCode();
            return hashCode;
        }
    }
}

