/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef TRISTATELABEL_H
#define TRISTATELABEL_H

#include <QLabel>
#include <QMouseEvent>
#include <QPushButton>
#include <QGSettings/QGSettings>

#define THEME_QT_SCHEMA  "org.ukui.style"
#define MODE_QT_KEY      "style-name"

class TristateLabel : public QLabel
{
    Q_OBJECT

public:
    TristateLabel(const QString &text, QWidget *parent);
    ~TristateLabel();

    QString abridge(QString text); // 简写英文多长的应用名称
    void enterEvent(QEvent *e);
    void leaveEvent(QEvent *e);

protected:
    void mousePressEvent(QMouseEvent * event);
    void mouseReleaseEvent(QMouseEvent *event);

private:
    bool mMoved = false;
    bool mClicked = false;

signals:
    void clicked();
};

#endif // TRISTATELABEL_H
