Welcome to SurgeScript!
=======================

<img src="img/surge.png" alt="Surge" align="right" width="256">

Unleash your creativity!
------------------------

SurgeScript is a scripting language for games. It lets you unleash your creativity and build your own amazing interactive content! It's such a joy to use SurgeScript! You will love it!

[![Download](img/download.png)](/download)

[![Support the project](https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif)](https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=3WAZYYTB22KFG)

How do I learn SurgeScript?
---------------------------

Check out the [SurgeScript Crash Course](/tutorials/hello)! Also take a look on the [video tutorials](https://youtube.com/alemart88) and on the examples folder that comes with the software.

SurgeScript in a nutshell
-------------------------

SurgeScript is:

* A scripting language for games
* Easy for beginners, powerful for experts
* Object-oriented, dynamically typed and based on state machines
* Free and open source software
* Built in C, which is nearly universal
* Named after a really charismatic character: [Surge](http://opensurge2d.org)!
* The only programming language in the world that natively allows you to tag objects with emoticons ;)

Why use SurgeScript?
--------------------

Unlike other programming languages, SurgeScript has been designed with the specific needs of games in mind. Its features include:

- The state-machine pattern: objects are state machines
- The composition approach: you may design complex objects and behaviors by means of composition
- The hierarchy system: objects have a parent and may have children, in a tree-like structure
- The game loop: it's defined implicitly

Other benefits include:

- Small footprint, easy to integrate
- C-like syntax, including plenty of features
- Automatic garbage collection
- Easy to extend via Plugins
- It's free and open source software

These features come from the experience of the developer dealing with game engines, applications related to computer graphics and so on. Some of the best practices have been incorporated into the language itself, making things really easy for developers and modders.

Who created SurgeScript?
------------------------

SurgeScript has been created by [Alexandre Martins](https://github.com/alemart), a computer scientist from Brazil. He has also created the [Open Surge game engine](http://opensurge2d.org), hence the name SurgeScript.
