/*
 *                            COPYRIGHT
 *
 *  sch-rnd - modular/flexible schematics editor - netlist export helpers
 *  Copyright (C) 2023,2025 Tibor 'Igor2' Palinkas
 *
 *  (Supported by NLnet NGI0 Entrust in 2023 and 2025)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 31 Milk Street, # 960789 Boston, MA 02196 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/sch-rnd
 *    contact lead developer: http://www.repo.hu/projects/sch-rnd/contact.html
 *    mailing list: http://www.repo.hu/projects/sch-rnd/contact.html
 */

#include <libcschem/abstract.h>

/* Get the output refdes/pinnum/netname from abstract attributes */
const char *sch_nle_get_refdes(const csch_acomp_t *comp);
const char *sch_nle_get_pinnum(const csch_aport_t *port);
const char *sch_nle_get_netname(const csch_anet_t *net);

/* Pass a NULL terminated list of attribute const char *keys in the order
   of preference; returns the first attribute value that exists or NULL
   if none found. */
const char *sch_nle_get_alt_attr(const csch_attribs_t *attribs, ...);

/* Default alternative names for commonly used attributes; feed these in
   sch_nle_get_alt_attr, replacing the "..." part. These are our conventions
   and heuristics on selecting vital attribute values, independent of the
   output file format  */
#define SCH_NLE_ALTATTR_FOOTPRINT    "display/footprint", "footprint", NULL
#define SCH_NLE_ALTATTR_VALUE        "display/value", "value", NULL
#define SCH_NLE_ALTATTR_DEVICE       "display/device", "device", NULL
#define SCH_NLE_ALTATTR_PINNAME      "display/pinname", "name", NULL

/* Execute stmt on each pin number in pinnums, making a local const char *my_num
   varliable that holds a single pin number. This is required because
   pinnums (usually the terminal's pinnum attriubte) might be a space
   separated list of pin numbers */
#define SCH_NLE_FOREACH_PINNUM(pinnums, my_num, stmt) \
do { \
	if (strpbrk(pinnums, " \t") != NULL) { \
		const char *my_num; \
		char *s, *next, *tmp = rnd_strdup(pinnums); \
		for(s = tmp; s != NULL; s = next) { \
			next = strpbrk(s, " \t"); \
			if (next != NULL) { \
				*next = '\0'; \
				next++; \
			} \
			while(isspace(*s)) s++; \
			if (*s == '\0') break; \
			my_num = s; \
			stmt; \
		} \
		free(tmp); \
	} \
	else { \
		const char *my_num = pinnums; \
		stmt; \
	} \
} while(0)
